/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.django.lang.template.ref;

import com.google.common.collect.Lists;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.lookup.LookupElementBuilder;
import com.intellij.lang.ASTNode;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.io.FileUtilRt;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.TokenSet;
import com.intellij.psi.util.QualifiedName;
import com.intellij.util.ArrayUtilRt;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.Processor;
import com.jetbrains.django.codeInsight.DjangoSettingsPy;
import com.jetbrains.django.lang.template.DjangoTemplateElementGenerator;
import com.jetbrains.django.lang.template.psi.DjangoTemplateElementTypes;
import com.jetbrains.django.lang.template.tags.DjangoLoadTag;
import com.jetbrains.python.BaseReference;
import com.jetbrains.python.psi.PyFile;
import com.jetbrains.python.psi.resolve.ResolveImportUtil;
import com.jetbrains.python.pyi.PyiFile;
import com.jetbrains.python.pyi.PyiUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class DjangoLoadTagsReference
extends BaseReference {
    private static final TokenSet MEMBER_NAMES = TokenSet.create((IElementType[])new IElementType[]{DjangoTemplateElementTypes.MEMBER_NAME});
    private static final String TEMPLATE_TAGS = "templatetags";
    private final DjangoLoadTag myLoadTag;
    private final ASTNode myMemberNode;

    public DjangoLoadTagsReference(DjangoLoadTag element, ASTNode memberNode) {
        super((PsiElement)element);
        this.myLoadTag = element;
        this.myMemberNode = memberNode;
    }

    public ASTNode getMemberNode() {
        return this.myMemberNode;
    }

    @Override
    public PsiElement handleElementRename(@NotNull String newElementName) throws IncorrectOperationException {
        PsiElement psi;
        if (newElementName == null) {
            DjangoLoadTagsReference.$$$reportNull$$$0(0);
        }
        if ((psi = this.myMemberNode.getPsi()) != null) {
            return psi.replace((PsiElement)DjangoTemplateElementGenerator.getInstance(psi.getProject()).createLoadTagReference(newElementName));
        }
        return null;
    }

    @Override
    @NotNull
    public TextRange getRangeInElement() {
        TextRange textRange = this.myMemberNode.getTextRange().shiftLeft(this.myLoadTag.getTextOffset());
        if (textRange == null) {
            DjangoLoadTagsReference.$$$reportNull$$$0(1);
        }
        return textRange;
    }

    public PsiElement resolve() {
        ASTNode[] memberNameTags = this.myMemberNode.getChildren(MEMBER_NAMES);
        ResolveTagsProcessor processor2 = new ResolveTagsProcessor(memberNameTags);
        DjangoLoadTagsReference.processCustomTagsModules(processor2, (PsiElement)this.myLoadTag);
        PsiElement result = processor2.myResult;
        if (result instanceof PyiFile) {
            return PyiUtil.getOriginalElement((PyiFile)result);
        }
        return processor2.myResult;
    }

    private static void processCustomTagsModules(Processor<List<String>> processor2, PsiElement foothold) {
        Module module = ModuleUtilCore.findModuleForPsiElement((PsiElement)foothold);
        if (!processor2.process(Arrays.asList("django", TEMPLATE_TAGS))) {
            return;
        }
        if (module != null) {
            List<String> installedApps = DjangoSettingsPy.getInstalledApps(module);
            for (String installedApp : installedApps) {
                ArrayList installedAppComponents = Lists.newArrayList((Iterable)StringUtil.split((String)installedApp, (String)"."));
                installedAppComponents.add(TEMPLATE_TAGS);
                if (processor2.process((Object)installedAppComponents)) continue;
                return;
            }
        }
    }

    public Object @NotNull [] getVariants() {
        List<LookupElement> results = DjangoLoadTagsReference.getTagsCompletionVariants((PsiElement)this.myLoadTag);
        Object[] objectArray = results.toArray();
        if (objectArray == null) {
            DjangoLoadTagsReference.$$$reportNull$$$0(2);
        }
        return objectArray;
    }

    public static List<LookupElement> getTagsCompletionVariants(PsiElement foothold) {
        CollectTagsProcessor processor2 = new CollectTagsProcessor(foothold);
        DjangoLoadTagsReference.processCustomTagsModules(processor2, foothold);
        return processor2.myResults;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newElementName";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/django/lang/template/ref/DjangoLoadTagsReference";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/django/lang/template/ref/DjangoLoadTagsReference";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getRangeInElement";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getVariants";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "handleElementRename";
                break;
            }
            case 1: 
            case 2: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class CollectTagsProcessor
    implements Processor<List<String>> {
        private final List<LookupElement> myResults = new ArrayList<LookupElement>();
        private final PsiElement myFoothold;

        CollectTagsProcessor(PsiElement foothold) {
            this.myFoothold = foothold;
        }

        public boolean process(List<String> strings) {
            QualifiedName qName = QualifiedName.fromComponents((String[])ArrayUtilRt.toStringArray(strings));
            PsiElement dir = ResolveImportUtil.resolveModuleInRoots(qName, this.myFoothold);
            if (dir instanceof PsiDirectory) {
                this.collectTagFiles((PsiDirectory)dir, "");
            }
            return true;
        }

        private void collectTagFiles(PsiDirectory dir, String prefix) {
            PsiDirectory[] directories;
            PsiFile[] files;
            for (PsiFile file2 : files = dir.getFiles()) {
                if (!(file2 instanceof PyFile) || file2.getName().equals("__init__.py")) continue;
                LookupElementBuilder element = LookupElementBuilder.create((Object)file2, (String)(prefix + FileUtilRt.getNameWithoutExtension((String)file2.getName())));
                this.myResults.add((LookupElement)element);
            }
            for (PsiDirectory childDir : directories = dir.getSubdirectories()) {
                this.collectTagFiles(childDir, prefix + dir.getName() + ".");
            }
        }
    }

    private class ResolveTagsProcessor
    implements Processor<List<String>> {
        private PsiElement myResult;
        private final ASTNode[] myMemberNameTags;

        ResolveTagsProcessor(ASTNode[] memberNameTags) {
            this.myMemberNameTags = memberNameTags;
        }

        public boolean process(List<String> strings) {
            ArrayList components = Lists.newArrayList(strings);
            for (ASTNode tag : this.myMemberNameTags) {
                components.add(tag.getText());
            }
            QualifiedName qName = QualifiedName.fromComponents((String[])ArrayUtilRt.toStringArray((Collection)components));
            this.myResult = ResolveImportUtil.resolveModuleInRoots(qName, (PsiElement)DjangoLoadTagsReference.this.myLoadTag);
            return this.myResult == null;
        }
    }
}

