/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.django.lang.template.inspection;

import com.google.common.collect.Lists;
import com.intellij.codeInspection.InspectionManager;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiPolyVariantReference;
import com.intellij.psi.PsiReference;
import com.intellij.util.Consumer;
import com.jetbrains.django.lang.template.inspection.DjangoInspectionVisitorAdapter;
import com.jetbrains.django.lang.template.inspection.DjangoUnresolvedReferenceInspection;
import com.jetbrains.django.lang.template.psi.impl.DjangoStringLiteralImpl;
import com.jetbrains.django.ui.DjangoBundle;
import com.jetbrains.python.inspections.PyUnresolvedReferenceQuickFixProvider;
import com.jetbrains.python.templateLanguages.TemplateFileReference;
import java.util.ArrayList;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;

public class DjangoTemplateUnresolvedReferenceInspection
extends DjangoUnresolvedReferenceInspection {
    @Nls
    @NotNull
    public String getGroupDisplayName() {
        String string = DjangoBundle.message("django", new Object[0]);
        if (string == null) {
            DjangoTemplateUnresolvedReferenceInspection.$$$reportNull$$$0(0);
        }
        return string;
    }

    @NotNull
    public String getShortName() {
        return "DjangoUnresolvedTemplateReferenceInspection";
    }

    public boolean isEnabledByDefault() {
        return true;
    }

    @Override
    protected DjangoInspectionVisitorAdapter createVisitor(InspectionManager manager) {
        return new UnresolvedTemplateReferenceVisitor(manager);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/django/lang/template/inspection/DjangoTemplateUnresolvedReferenceInspection", "getGroupDisplayName"));
    }

    private static class UnresolvedTemplateReferenceVisitor
    extends DjangoInspectionVisitorAdapter {
        private UnresolvedTemplateReferenceVisitor(@NotNull InspectionManager manager) {
            if (manager == null) {
                UnresolvedTemplateReferenceVisitor.$$$reportNull$$$0(0);
            }
            super(manager);
        }

        @Override
        public void visitStringLiteral(DjangoStringLiteralImpl stringLiteral) {
            PsiReference[] references2;
            super.visitStringLiteral(stringLiteral);
            for (PsiReference ref : references2 = stringLiteral.getReferences()) {
                if (!(ref instanceof TemplateFileReference) || ref.isSoft() || UnresolvedTemplateReferenceVisitor.isResolved(ref)) continue;
                this.reportUnresolvedTemplateReference(ref, stringLiteral);
            }
        }

        private static boolean isResolved(@NotNull PsiReference ref) {
            if (ref == null) {
                UnresolvedTemplateReferenceVisitor.$$$reportNull$$$0(1);
            }
            if (ref.resolve() != null) {
                return true;
            }
            if (ref instanceof PsiPolyVariantReference) {
                return ((PsiPolyVariantReference)ref).multiResolve(false).length != 0;
            }
            return false;
        }

        private void reportUnresolvedTemplateReference(PsiReference ref, DjangoStringLiteralImpl stringLiteral) {
            this.reportProblem(ref, stringLiteral, DjangoBundle.message("inspection.unresolved-template-reference.error-msg", stringLiteral.getText()));
        }

        private void reportProblem(PsiReference ref, PsiElement elem, String msg) {
            ProblemDescriptor d = this.myManager.createProblemDescriptor(elem, ref.getRangeInElement(), msg, ProblemHighlightType.GENERIC_ERROR_OR_WARNING, false, this.getQuickFixActions(ref));
            this.myProblems.add(d);
        }

        public LocalQuickFix[] getQuickFixActions(PsiReference reference) {
            ArrayList actions = Lists.newArrayList();
            for (PyUnresolvedReferenceQuickFixProvider provider : PyUnresolvedReferenceQuickFixProvider.EP_NAME.getExtensionList()) {
                provider.registerQuickFixes(reference, (Consumer<LocalQuickFix>)((Consumer)localQuickFix -> actions.add(localQuickFix)));
            }
            return actions.toArray(LocalQuickFix.EMPTY_ARRAY);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "manager";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "ref";
                    break;
                }
            }
            objectArray2[1] = "com/jetbrains/django/lang/template/inspection/DjangoTemplateUnresolvedReferenceInspection$UnresolvedTemplateReferenceVisitor";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "isResolved";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

