/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.django.lang.template.editor;

import com.intellij.codeInsight.editorActions.TypedHandlerDelegate;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorModificationUtil;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiFile;
import com.jetbrains.django.lang.template.DjangoTemplateFileViewProvider;
import com.jetbrains.python.codeInsight.PyCodeInsightSettings;
import java.util.Arrays;
import org.jetbrains.annotations.NotNull;

public class DjangoBracesInterpolationTypedHandler
extends TypedHandlerDelegate {
    private static final char[] ourInterestingChars = new char[]{'{', '%', '#'};

    private static boolean isInteresting(char c) {
        return Arrays.binarySearch(ourInterestingChars, c) >= 0;
    }

    static void typeInStringAndMoveCaret(Editor editor2, String str, int caretShift) {
        EditorModificationUtil.insertStringAtCaret((Editor)editor2, (String)str, (boolean)true, (int)caretShift);
    }

    @NotNull
    public TypedHandlerDelegate.Result beforeCharTyped(char c, @NotNull Project project, @NotNull Editor editor2, @NotNull PsiFile file2, @NotNull FileType fileType) {
        if (project == null) {
            DjangoBracesInterpolationTypedHandler.$$$reportNull$$$0(0);
        }
        if (editor2 == null) {
            DjangoBracesInterpolationTypedHandler.$$$reportNull$$$0(1);
        }
        if (file2 == null) {
            DjangoBracesInterpolationTypedHandler.$$$reportNull$$$0(2);
        }
        if (fileType == null) {
            DjangoBracesInterpolationTypedHandler.$$$reportNull$$$0(3);
        }
        if (file2.getViewProvider() instanceof DjangoTemplateFileViewProvider && PyCodeInsightSettings.getInstance().DJANGO_AUTOINSERT_TAG_CLOSE && DjangoBracesInterpolationTypedHandler.isInteresting(c)) {
            Document document = editor2.getDocument();
            int offset = editor2.getCaretModel().getOffset();
            CharSequence chars = document.getCharsSequence();
            if (offset > 0 && chars.charAt(offset - 1) == '{') {
                if (DjangoBracesInterpolationTypedHandler.interpolateCommentBetweenBraces(editor2, chars, c, offset)) {
                    TypedHandlerDelegate.Result result = TypedHandlerDelegate.Result.STOP;
                    if (result == null) {
                        DjangoBracesInterpolationTypedHandler.$$$reportNull$$$0(4);
                    }
                    return result;
                }
                if (offset < 2 || chars.charAt(offset - 2) != '{') {
                    if (DjangoBracesInterpolationTypedHandler.alreadyHasEnding(chars, c, offset)) {
                        TypedHandlerDelegate.Result result = TypedHandlerDelegate.Result.CONTINUE;
                        if (result == null) {
                            DjangoBracesInterpolationTypedHandler.$$$reportNull$$$0(5);
                        }
                        return result;
                    }
                    String interpolation = null;
                    if (c == '{') {
                        interpolation = "{  }";
                    } else if (c == '%') {
                        interpolation = "%  %";
                    } else if (c == '#') {
                        interpolation = "#  #";
                    }
                    if (interpolation != null) {
                        if (offset == chars.length() || offset < chars.length() && chars.charAt(offset) != '}') {
                            interpolation = interpolation + "}";
                        }
                        DjangoBracesInterpolationTypedHandler.typeInStringAndMoveCaret(editor2, interpolation, 2);
                        TypedHandlerDelegate.Result result = TypedHandlerDelegate.Result.STOP;
                        if (result == null) {
                            DjangoBracesInterpolationTypedHandler.$$$reportNull$$$0(6);
                        }
                        return result;
                    }
                }
            }
        }
        TypedHandlerDelegate.Result result = TypedHandlerDelegate.Result.CONTINUE;
        if (result == null) {
            DjangoBracesInterpolationTypedHandler.$$$reportNull$$$0(7);
        }
        return result;
    }

    private static boolean alreadyHasEnding(CharSequence chars, char c, int offset) {
        int i;
        char endChar = c == '{' ? (char)'}' : (char)c;
        for (i = offset; i < chars.length() && chars.charAt(i) != '{' && chars.charAt(i) != endChar && chars.charAt(i) != '\n'; ++i) {
        }
        return i + 1 < chars.length() && chars.charAt(i) == endChar && chars.charAt(i + 1) == '}';
    }

    private static boolean interpolateCommentBetweenBraces(Editor editor2, CharSequence chars, char c, int offset) {
        if (chars.length() <= offset) {
            return false;
        }
        char cc = chars.charAt(offset);
        if (c != '#' || cc != '%') {
            return false;
        }
        for (int i = offset; i < chars.length() && chars.charAt(i) != '\n'; ++i) {
            if (chars.charAt(i) != '}' || i - 1 <= offset || chars.charAt(i - 1) != chars.charAt(offset)) continue;
            DjangoBracesInterpolationTypedHandler.typeInStringAndMoveCaret(editor2, "#", i + 1 - offset);
            DjangoBracesInterpolationTypedHandler.typeInStringAndMoveCaret(editor2, "#", offset - i - 1);
            return true;
        }
        return false;
    }

    static {
        Arrays.sort(ourInterestingChars);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileType";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/django/lang/template/editor/DjangoBracesInterpolationTypedHandler";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/django/lang/template/editor/DjangoBracesInterpolationTypedHandler";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "beforeCharTyped";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "beforeCharTyped";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

