/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.django.facet;

import com.intellij.facet.FacetType;
import com.intellij.framework.detection.FacetBasedFrameworkDetector;
import com.intellij.framework.detection.FileContentPattern;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.roots.ModifiableRootModel;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.patterns.ElementPattern;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.indexing.FileContent;
import com.jetbrains.django.facet.DjangoFacet;
import com.jetbrains.django.facet.DjangoFacetConfiguration;
import com.jetbrains.django.facet.DjangoFacetType;
import com.jetbrains.django.util.DjangoUtil;
import com.jetbrains.django.util.VirtualFileUtil;
import com.jetbrains.python.PythonFileType;
import com.jetbrains.python.templateLanguages.TemplatesService;
import java.util.Collection;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class DjangoFrameworkDetector
extends FacetBasedFrameworkDetector<DjangoFacet, DjangoFacetConfiguration> {
    public DjangoFrameworkDetector() {
        super("django-python");
    }

    @NotNull
    public FacetType<DjangoFacet, DjangoFacetConfiguration> getFacetType() {
        DjangoFacetType djangoFacetType = DjangoFacetType.getInstance();
        if (djangoFacetType == null) {
            DjangoFrameworkDetector.$$$reportNull$$$0(0);
        }
        return djangoFacetType;
    }

    @NotNull
    public ElementPattern<FileContent> createSuitableFilePattern() {
        FileContentPattern fileContentPattern = FileContentPattern.fileContent().withName(DjangoUtil.createDjangoStandardProjectFileNamePattern());
        if (fileContentPattern == null) {
            DjangoFrameworkDetector.$$$reportNull$$$0(1);
        }
        return fileContentPattern;
    }

    protected DjangoFacetConfiguration createConfiguration(Collection<VirtualFile> files) {
        VirtualFile script = (VirtualFile)ContainerUtil.getFirstItem(files);
        VirtualFile projectRoot = script.getParent();
        if (DjangoUtil.isInsideDjango(projectRoot, null) || projectRoot.getName().equals("djangorecipe")) {
            return null;
        }
        DjangoFacetConfiguration config = new DjangoFacetConfiguration();
        config.setProjectRootFolderFile(projectRoot);
        return config;
    }

    public void setupFacet(@NotNull DjangoFacet facet, ModifiableRootModel model) {
        VirtualFile root;
        TemplatesService service;
        if (facet == null) {
            DjangoFrameworkDetector.$$$reportNull$$$0(2);
        }
        if ((service = TemplatesService.getInstance(model.getModule())).getTemplateFolders().size() == 0 && (root = ((DjangoFacetConfiguration)facet.getConfiguration()).getProjectRootFolderFile()) != null) {
            VirtualFile contentRoot = root.getParent();
            if (!VfsUtilCore.isAncestor((VirtualFile)model.getProject().getBaseDir(), (VirtualFile)contentRoot, (boolean)false)) {
                return;
            }
            List<VirtualFile> htmlFolders = VirtualFileUtil.getHtmlFolders(contentRoot);
            service.setTemplateFolders(htmlFolders.toArray(VirtualFile.EMPTY_ARRAY));
            service.setTemplateLanguage("Django");
        }
    }

    @NotNull
    public FileType getFileType() {
        PythonFileType pythonFileType = PythonFileType.INSTANCE;
        if (pythonFileType == null) {
            DjangoFrameworkDetector.$$$reportNull$$$0(3);
        }
        return pythonFileType;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 2: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 2: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/django/facet/DjangoFrameworkDetector";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "facet";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getFacetType";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "createSuitableFilePattern";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/django/facet/DjangoFrameworkDetector";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getFileType";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "setupFacet";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 2: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

