/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.django.codeInsight;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.refactoring.BaseRefactoringProcessor;
import com.intellij.usageView.UsageInfo;
import com.intellij.usageView.UsageViewBundle;
import com.intellij.usageView.UsageViewDescriptor;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.django.lang.template.DjangoTemplateElementGenerator;
import com.jetbrains.django.lang.template.DjangoTemplateRecursiveVisitor;
import com.jetbrains.django.lang.template.psi.impl.DjangoMemberExpressionImpl;
import com.jetbrains.django.lang.template.psi.impl.DjangoTemplateFileImpl;
import com.jetbrains.django.lang.template.psi.impl.DjangoVariableReferenceImpl;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;

public class DjangoTemplateVariablesMigrateProcessor
extends BaseRefactoringProcessor {
    private static final Logger LOG = Logger.getInstance((String)DjangoTemplateVariablesMigrateProcessor.class.getName());
    private static final Map<String, String> VARIABLES_TO_RENAME = Maps.newHashMap();
    @NotNull
    private DjangoTemplateFileImpl myTemplateFile;
    private UsageInfo[] myUsagesCache;

    public DjangoTemplateVariablesMigrateProcessor(Project project, @NotNull DjangoTemplateFileImpl templateFile) {
        if (templateFile == null) {
            DjangoTemplateVariablesMigrateProcessor.$$$reportNull$$$0(0);
        }
        super(project);
        this.myUsagesCache = null;
        this.myTemplateFile = templateFile;
        this.setPreviewUsages(true);
    }

    @NotNull
    protected UsageViewDescriptor createUsageViewDescriptor(UsageInfo @NotNull [] usages) {
        if (usages == null) {
            DjangoTemplateVariablesMigrateProcessor.$$$reportNull$$$0(1);
        }
        return new DjangoTemplateVariablesMigrateUsageViewDescriptor(this.myTemplateFile, usages);
    }

    protected void doRun() {
        UsageInfo[] usages = this.findUsages();
        if (usages.length > 0) {
            super.doRun();
        }
    }

    protected UsageInfo @NotNull [] findUsages() {
        if (this.myUsagesCache == null) {
            this.myUsagesCache = this.doFindUsages();
        }
        if (this.myUsagesCache == null) {
            DjangoTemplateVariablesMigrateProcessor.$$$reportNull$$$0(2);
        }
        return this.myUsagesCache;
    }

    private UsageInfo[] doFindUsages() {
        DjangoTemplateVariableReferenceVisitor visitor2 = new DjangoTemplateVariableReferenceVisitor();
        this.myTemplateFile.accept(visitor2);
        Object[] result = new UsageInfo[visitor2.myVariableReferences.size()];
        ContainerUtil.map2Array((Collection)visitor2.myVariableReferences, (Object[])result, var -> new UsageInfo((PsiElement)var));
        return result;
    }

    protected void refreshElements(PsiElement @NotNull [] elements) {
        if (elements == null) {
            DjangoTemplateVariablesMigrateProcessor.$$$reportNull$$$0(3);
        }
        if (elements.length == 1 && elements[0] instanceof DjangoTemplateFileImpl) {
            this.myTemplateFile = (DjangoTemplateFileImpl)elements[0];
        }
    }

    protected void performRefactoring(UsageInfo @NotNull [] usages) {
        if (usages == null) {
            DjangoTemplateVariablesMigrateProcessor.$$$reportNull$$$0(4);
        }
        for (UsageInfo usage : usages) {
            DjangoVariableReferenceImpl var = (DjangoVariableReferenceImpl)usage.getElement();
            var.replace((PsiElement)DjangoTemplateElementGenerator.getInstance(this.myProject).createMemberExpression(VARIABLES_TO_RENAME.get(var.getName())));
        }
    }

    @NotNull
    protected String getCommandName() {
        return "Migrate variables in django template file";
    }

    static {
        VARIABLES_TO_RENAME.put("first_on_page", "page_obj.start_index");
        VARIABLES_TO_RENAME.put("has_next", "page_obj.has_next");
        VARIABLES_TO_RENAME.put("has_previous", "page_obj.has_previous");
        VARIABLES_TO_RENAME.put("last_on_page", "page_obj.end_index");
        VARIABLES_TO_RENAME.put("next", "page_obj.next_page_number");
        VARIABLES_TO_RENAME.put("page_range", "paginator.page_range");
        VARIABLES_TO_RENAME.put("page", "page.number");
        VARIABLES_TO_RENAME.put("pages", "paginator.num_pages");
        VARIABLES_TO_RENAME.put("previous", "page.previous_page_number");
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "templateFile";
                break;
            }
            case 1: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "usages";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/django/codeInsight/DjangoTemplateVariablesMigrateProcessor";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elements";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/django/codeInsight/DjangoTemplateVariablesMigrateProcessor";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "findUsages";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "createUsageViewDescriptor";
                break;
            }
            case 2: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "refreshElements";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "performRefactoring";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static class DjangoTemplateVariablesMigrateUsageViewDescriptor
    implements UsageViewDescriptor {
        private final DjangoTemplateFileImpl myTemplateFile;
        private final UsageInfo[] myUsageInfos;

        public DjangoTemplateVariablesMigrateUsageViewDescriptor(DjangoTemplateFileImpl templateFile, UsageInfo[] usageInfos) {
            this.myTemplateFile = templateFile;
            this.myUsageInfos = usageInfos;
        }

        public PsiElement @NotNull [] getElements() {
            PsiElement[] psiElementArray = new PsiElement[]{this.myTemplateFile};
            if (psiElementArray == null) {
                DjangoTemplateVariablesMigrateUsageViewDescriptor.$$$reportNull$$$0(0);
            }
            return psiElementArray;
        }

        public String getProcessedElementsHeader() {
            return "Variable reference";
        }

        @NotNull
        public String getCodeReferencesText(int usagesCount, int filesCount) {
            String string = UsageViewBundle.getReferencesString((int)usagesCount, (int)filesCount);
            if (string == null) {
                DjangoTemplateVariablesMigrateUsageViewDescriptor.$$$reportNull$$$0(1);
            }
            return string;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[2];
            objectArray2[0] = "com/jetbrains/django/codeInsight/DjangoTemplateVariablesMigrateProcessor$DjangoTemplateVariablesMigrateUsageViewDescriptor";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getElements";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getCodeReferencesText";
                    break;
                }
            }
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
        }
    }

    private static class DjangoTemplateVariableReferenceVisitor
    extends DjangoTemplateRecursiveVisitor {
        private final List<DjangoVariableReferenceImpl> myVariableReferences = Lists.newArrayList();

        private DjangoTemplateVariableReferenceVisitor() {
        }

        @Override
        public void visitVariableReference(DjangoVariableReferenceImpl variableReference) {
            if (variableReference.getParent() instanceof DjangoMemberExpressionImpl) {
                return;
            }
            if (VARIABLES_TO_RENAME.containsKey(variableReference.getName())) {
                this.myVariableReferences.add(variableReference);
            }
        }
    }
}

