/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.commandInterface.command;

import com.google.common.base.Preconditions;
import com.intellij.openapi.util.Pair;
import com.jetbrains.commandInterface.command.Argument;
import com.jetbrains.commandInterface.command.Help;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class Option {
    @NotNull
    private final List<String> myLongNames;
    @NotNull
    private final List<String> myShortNames;
    @Nullable
    private final Pair<Integer, Argument> myArgumentAndQuantity;
    @NotNull
    private final Help myHelp;

    public Option(@Nullable Pair<Integer, Argument> argumentAndQuantity, @NotNull Help help, @NotNull Collection<String> shortNames, @NotNull Collection<String> longNames) {
        if (help == null) {
            Option.$$$reportNull$$$0(0);
        }
        if (shortNames == null) {
            Option.$$$reportNull$$$0(1);
        }
        if (longNames == null) {
            Option.$$$reportNull$$$0(2);
        }
        this.myLongNames = new ArrayList<String>();
        this.myShortNames = new ArrayList<String>();
        Preconditions.checkArgument((argumentAndQuantity == null || (Integer)argumentAndQuantity.first > 0 ? 1 : 0) != 0, (Object)("Illegal args and quantity: " + argumentAndQuantity));
        this.myArgumentAndQuantity = argumentAndQuantity;
        this.myShortNames.addAll(shortNames);
        this.myLongNames.addAll(longNames);
        this.myHelp = help;
    }

    @NotNull
    public List<String> getLongNames() {
        List<String> list = Collections.unmodifiableList(this.myLongNames);
        if (list == null) {
            Option.$$$reportNull$$$0(3);
        }
        return list;
    }

    @NotNull
    public List<String> getAllNames() {
        ArrayList<String> result = new ArrayList<String>(this.myLongNames);
        result.addAll(this.myShortNames);
        ArrayList<String> arrayList = result;
        if (arrayList == null) {
            Option.$$$reportNull$$$0(4);
        }
        return arrayList;
    }

    @NotNull
    public List<String> getShortNames() {
        List<String> list = Collections.unmodifiableList(this.myShortNames);
        if (list == null) {
            Option.$$$reportNull$$$0(5);
        }
        return list;
    }

    @Nullable
    public Pair<Integer, Argument> getArgumentAndQuantity() {
        return this.myArgumentAndQuantity;
    }

    @NotNull
    public Help getHelp() {
        Help help = this.myHelp;
        if (help == null) {
            Option.$$$reportNull$$$0(6);
        }
        return help;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "help";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "shortNames";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "longNames";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/commandInterface/command/Option";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/commandInterface/command/Option";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getLongNames";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getAllNames";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getShortNames";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getHelp";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

