/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.appengine.lang.gql.psi.impl;

import com.intellij.extapi.psi.ASTWrapperPsiElement;
import com.intellij.lang.ASTNode;
import com.intellij.psi.PsiElement;
import com.intellij.psi.tree.IElementType;
import com.jetbrains.appengine.lang.gql.psi.GqlElementTypes;
import com.jetbrains.appengine.lang.gql.psi.impl.GqlAncestorImpl;
import com.jetbrains.appengine.lang.gql.psi.impl.GqlAndImpl;
import com.jetbrains.appengine.lang.gql.psi.impl.GqlAscDescImpl;
import com.jetbrains.appengine.lang.gql.psi.impl.GqlBindingImpl;
import com.jetbrains.appengine.lang.gql.psi.impl.GqlBooleanLiteralImpl;
import com.jetbrains.appengine.lang.gql.psi.impl.GqlCompareImpl;
import com.jetbrains.appengine.lang.gql.psi.impl.GqlCompareOperationImpl;
import com.jetbrains.appengine.lang.gql.psi.impl.GqlEntityClassNameImpl;
import com.jetbrains.appengine.lang.gql.psi.impl.GqlFloatLiteralImpl;
import com.jetbrains.appengine.lang.gql.psi.impl.GqlFromImpl;
import com.jetbrains.appengine.lang.gql.psi.impl.GqlInImpl;
import com.jetbrains.appengine.lang.gql.psi.impl.GqlIntegerLiteralImpl;
import com.jetbrains.appengine.lang.gql.psi.impl.GqlLimitImpl;
import com.jetbrains.appengine.lang.gql.psi.impl.GqlNullLiteralImpl;
import com.jetbrains.appengine.lang.gql.psi.impl.GqlObjectLiteralImpl;
import com.jetbrains.appengine.lang.gql.psi.impl.GqlObjectLiteralTypeImpl;
import com.jetbrains.appengine.lang.gql.psi.impl.GqlOffsetImpl;
import com.jetbrains.appengine.lang.gql.psi.impl.GqlOrderImpl;
import com.jetbrains.appengine.lang.gql.psi.impl.GqlParamNameImpl;
import com.jetbrains.appengine.lang.gql.psi.impl.GqlPropertyImpl;
import com.jetbrains.appengine.lang.gql.psi.impl.GqlQueryImpl;
import com.jetbrains.appengine.lang.gql.psi.impl.GqlSelectFieldsImpl;
import com.jetbrains.appengine.lang.gql.psi.impl.GqlSelectImpl;
import com.jetbrains.appengine.lang.gql.psi.impl.GqlStringLiteralImpl;
import com.jetbrains.appengine.lang.gql.psi.impl.GqlWhereImpl;

public class GqlAstFactory
implements GqlElementTypes {
    public static PsiElement create(ASTNode node) {
        IElementType type = node.getElementType();
        if (type == QUERY) {
            return new GqlQueryImpl(node);
        }
        if (type == SELECT) {
            return new GqlSelectImpl(node);
        }
        if (type == FROM) {
            return new GqlFromImpl(node);
        }
        if (type == WHERE) {
            return new GqlWhereImpl(node);
        }
        if (type == ORDER) {
            return new GqlOrderImpl(node);
        }
        if (type == ASC || type == DESC) {
            return new GqlAscDescImpl(node);
        }
        if (type == LIMIT) {
            return new GqlLimitImpl(node);
        }
        if (type == OFFSET) {
            return new GqlOffsetImpl(node);
        }
        if (type == SELECT_FIELDS) {
            return new GqlSelectFieldsImpl(node);
        }
        if (type == CLASS_NAME) {
            return new GqlEntityClassNameImpl(node);
        }
        if (type == PROPERTY) {
            return new GqlPropertyImpl(node);
        }
        if (type == AND) {
            return new GqlAndImpl(node);
        }
        if (type == COMPARE) {
            return new GqlCompareImpl(node);
        }
        if (type == EQ || type == NEQ) {
            return new GqlCompareOperationImpl(node);
        }
        if (type == IN) {
            return new GqlInImpl(node);
        }
        if (type == ANCESTOR) {
            return new GqlAncestorImpl(node);
        }
        if (type == BINDING) {
            return new GqlBindingImpl(node);
        }
        if (type == PARAM_NAME) {
            return new GqlParamNameImpl(node);
        }
        return GqlAstFactory.createLiteral(node);
    }

    private static PsiElement createLiteral(ASTNode node) {
        IElementType type = node.getElementType();
        if (type == INT_LITERAL) {
            return new GqlIntegerLiteralImpl(node);
        }
        if (type == FLOAT_LITERAL) {
            return new GqlFloatLiteralImpl(node);
        }
        if (type == STRING_LITERAL) {
            return new GqlStringLiteralImpl(node);
        }
        if (type == BOOLEAN_LITERAL) {
            return new GqlBooleanLiteralImpl(node);
        }
        if (type == NULL_LITERAL) {
            return new GqlNullLiteralImpl(node);
        }
        if (type == OBJECT_LITERAL) {
            return new GqlObjectLiteralImpl(node);
        }
        if (type == OBJECT_LITERAL_TYPE) {
            return new GqlObjectLiteralTypeImpl(node);
        }
        return new ASTWrapperPsiElement(node);
    }
}

