/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.appengine.inspection;

import com.intellij.lang.injection.InjectedLanguageManager;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.PsiTreeUtil;
import com.jetbrains.appengine.lang.gql.psi.GqlEntityClassName;
import com.jetbrains.appengine.lang.gql.psi.impl.GqlFileImpl;
import com.jetbrains.appengine.model.ModelManager;
import com.jetbrains.appengine.util.AppEngineUtil;
import com.jetbrains.python.inspections.PyInspectionExtension;
import com.jetbrains.python.psi.PyImportedNameDefiner;
import com.jetbrains.python.psi.PyRecursiveElementVisitor;
import com.jetbrains.python.psi.PyStringLiteralExpression;
import com.jetbrains.python.psi.impl.PyImportElementImpl;
import java.util.Collection;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class AppEngineUnresolvedReferenceSkipper
extends PyInspectionExtension {
    @Override
    public boolean ignoreUnusedImports(@NotNull PyImportedNameDefiner importNameDefiner) {
        if (importNameDefiner == null) {
            AppEngineUnresolvedReferenceSkipper.$$$reportNull$$$0(0);
        }
        if (AppEngineUtil.getAppEngineModule(importNameDefiner.getProject()) == null) {
            return false;
        }
        if (importNameDefiner instanceof PyImportElementImpl) {
            String visibleName = ((PyImportElementImpl)importNameDefiner).getVisibleName();
            if (visibleName == null) {
                return false;
            }
            ModelManager manager = AppEngineUnresolvedReferenceSkipper.getManager((PsiElement)importNameDefiner);
            if (manager == null || manager.findModel(visibleName) == null) {
                return false;
            }
            PsiFile containingFile = importNameDefiner.getContainingFile();
            if (containingFile == null) {
                return false;
            }
            AppEngineKindSearcher stringLiteralsVisitor = new AppEngineKindSearcher(visibleName);
            containingFile.accept((PsiElementVisitor)stringLiteralsVisitor);
            return stringLiteralsVisitor.myShouldSkip;
        }
        return false;
    }

    @Nullable
    private static ModelManager getManager(@NotNull PsiElement element) {
        Module module;
        if (element == null) {
            AppEngineUnresolvedReferenceSkipper.$$$reportNull$$$0(1);
        }
        return (module = ModuleUtilCore.findModuleForPsiElement((PsiElement)element)) != null ? ModelManager.getInstance(module) : null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "importNameDefiner";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
        }
        objectArray2[1] = "com/jetbrains/appengine/inspection/AppEngineUnresolvedReferenceSkipper";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "ignoreUnusedImports";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "getManager";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private static class AppEngineKindSearcher
    extends PyRecursiveElementVisitor {
        boolean myShouldSkip;
        String myKindName;

        AppEngineKindSearcher(@NotNull String kindName) {
            if (kindName == null) {
                AppEngineKindSearcher.$$$reportNull$$$0(0);
            }
            this.myKindName = kindName;
        }

        @Override
        public void visitPyStringLiteralExpression(PyStringLiteralExpression stringLiteral) {
            if (this.myShouldSkip) {
                return;
            }
            if (!AppEngineUtil.isGql(stringLiteral)) {
                return;
            }
            List injectedPsiFiles = InjectedLanguageManager.getInstance((Project)stringLiteral.getProject()).getInjectedPsiFiles((PsiElement)stringLiteral);
            if (injectedPsiFiles == null) {
                return;
            }
            for (Pair pair : injectedPsiFiles) {
                PsiElement injectedPsiFile = (PsiElement)pair.getFirst();
                if (!(injectedPsiFile instanceof GqlFileImpl)) continue;
                Collection kinds = PsiTreeUtil.findChildrenOfType((PsiElement)injectedPsiFile, GqlEntityClassName.class);
                for (GqlEntityClassName kind : kinds) {
                    String name = kind.getText();
                    if (!this.myKindName.equals(name)) continue;
                    this.myShouldSkip = true;
                    return;
                }
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "kindName", "com/jetbrains/appengine/inspection/AppEngineUnresolvedReferenceSkipper$AppEngineKindSearcher", "<init>"));
        }
    }
}

