/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.appengine.index;

import com.intellij.openapi.module.Module;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.text.StringUtil;
import com.jetbrains.appengine.index.QueryIndex;
import com.jetbrains.appengine.lang.gql.psi.GqlCompare;
import com.jetbrains.appengine.lang.gql.psi.GqlQuery;
import com.jetbrains.appengine.lang.gql.psi.SortOrder;
import com.jetbrains.appengine.util.AppEngineUtil;
import com.jetbrains.appengine.util.YamlUtil;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.yaml.psi.YAMLDocument;
import org.jetbrains.yaml.psi.YAMLFile;
import org.jetbrains.yaml.psi.YAMLKeyValue;
import org.jetbrains.yaml.psi.YAMLMapping;
import org.jetbrains.yaml.psi.YAMLSequence;
import org.jetbrains.yaml.psi.YAMLSequenceItem;
import org.jetbrains.yaml.psi.YAMLValue;

public class GqlQueryIndexManager {
    private static final String KEY_PROPERTY = "__key__";
    private static final String KIND = "kind";
    private static final String ANCESTOR = "ancestor";
    private static final String PROPERTIES = "properties";
    private static final String DIRECTION_DESC = "desc";
    private static final String ANCESTOR_YES = "yes";
    private static final String NAME = "name";
    private static final String DIRECTION = "direction";
    private static final String INDENT = "  ";
    private static final String SEQUENCE = "- ";

    private GqlQueryIndexManager() {
    }

    @Nullable
    public static QueryIndex getIndex(GqlQuery query) {
        String kind = query.getKind();
        List<GqlCompare> conditions = query.getConditions();
        List<Pair<String, SortOrder>> orders = query.getOrders();
        boolean result = true;
        if (kind == null) {
            result = false;
        }
        Set<String> inequalityProperties = GqlQueryIndexManager.filter(conditions, false);
        Set<String> equalityProperties = GqlQueryIndexManager.filter(conditions, true);
        HashSet<String> existsProperties = new HashSet<String>();
        orders = GqlQueryIndexManager.normalizeOrders(orders, equalityProperties);
        GqlQueryIndexManager.removeNativelySupportedComponents(orders, equalityProperties, inequalityProperties);
        if (kind != null && inequalityProperties.isEmpty() && existsProperties.isEmpty() && orders.isEmpty() && !equalityProperties.contains(KEY_PROPERTY)) {
            result = false;
        }
        List<Pair<String, SortOrder>> properties = GqlQueryIndexManager.getProperties(equalityProperties, inequalityProperties, existsProperties, orders);
        if (kind != null && !query.hasAncestor() && properties.size() <= 1) {
            Pair<String, SortOrder> prop;
            result = false;
            if (properties.size() > 0 && KEY_PROPERTY.equals((prop = properties.get(0)).getFirst()) && prop.getSecond() == SortOrder.DESC) {
                result = true;
            }
        }
        Set<String> uniqueNames = GqlQueryIndexManager.getUniqueNames(properties);
        if (properties.size() > 1 && uniqueNames.size() == 1) {
            result = false;
        }
        return result ? GqlQueryIndexManager.create(kind, properties, query.hasAncestor()) : null;
    }

    @NotNull
    private static List<Pair<String, SortOrder>> normalizeOrders(List<Pair<String, SortOrder>> orders, Set<String> equalityProperties) {
        orders = GqlQueryIndexManager.filterOrdersByEquality(orders, equalityProperties);
        if (equalityProperties.contains(KEY_PROPERTY)) {
            orders = Collections.emptyList();
        }
        ArrayList<Pair<String, SortOrder>> result = new ArrayList<Pair<String, SortOrder>>();
        for (Pair pair : orders) {
            String property = (String)pair.getFirst();
            if (KEY_PROPERTY.equals(property)) {
                result.add((Pair<String, SortOrder>)pair);
                break;
            }
            result.add((Pair<String, SortOrder>)pair);
        }
        ArrayList<Pair<String, SortOrder>> arrayList = result;
        if (arrayList == null) {
            GqlQueryIndexManager.$$$reportNull$$$0(0);
        }
        return arrayList;
    }

    private static void removeNativelySupportedComponents(List<Pair<String, SortOrder>> orders, Set<String> equalityProperties, Set<String> inequalityProperties) {
        boolean hasKeyDescOrder = false;
        if (orders.size() > 0 && ((String)orders.get((int)(orders.size() - 1)).first).equals(KEY_PROPERTY)) {
            if (orders.get((int)(orders.size() - 1)).second == SortOrder.DESC) {
                hasKeyDescOrder = true;
            } else {
                orders.remove(orders.size() - 1);
            }
        }
        if (!hasKeyDescOrder) {
            for (String prop : inequalityProperties) {
                if (prop.equals(KEY_PROPERTY)) continue;
                return;
            }
            equalityProperties.remove(KEY_PROPERTY);
            inequalityProperties.remove(KEY_PROPERTY);
        }
    }

    private static List<Pair<String, SortOrder>> filterOrdersByEquality(List<Pair<String, SortOrder>> orders, Set<String> equalityProperties) {
        ArrayList<Pair<String, SortOrder>> result = new ArrayList<Pair<String, SortOrder>>();
        HashSet<String> filtered = new HashSet<String>(equalityProperties);
        for (Pair<String, SortOrder> order : orders) {
            String property = (String)order.getFirst();
            if (filtered.contains(property)) continue;
            filtered.add(property);
            result.add(order);
        }
        return result;
    }

    private static QueryIndex create(String kind, List<Pair<String, SortOrder>> properties, boolean hasAncestor) {
        QueryIndex index = new QueryIndex();
        index.setKind(kind);
        index.setProperties(properties);
        index.setHasAncestor(hasAncestor);
        return index;
    }

    private static List<Pair<String, SortOrder>> getProperties(Set<String> equalityProperties, Set<String> inequalityProperties, Set<String> existsProperties, List<Pair<String, SortOrder>> orders) {
        ArrayList<Pair<String, SortOrder>> properties = new ArrayList<Pair<String, SortOrder>>();
        for (String p : equalityProperties) {
            properties.add(Pair.create((Object)p, (Object)((Object)SortOrder.ASC)));
        }
        Collections.sort(properties, new PropertiesComparator());
        if (!inequalityProperties.isEmpty()) {
            String inequalityProperty = inequalityProperties.iterator().next();
            if (orders.isEmpty()) {
                properties.add((Pair<String, SortOrder>)Pair.create((Object)inequalityProperty, (Object)((Object)SortOrder.ASC)));
            }
        }
        properties.addAll(orders);
        for (String p : existsProperties) {
            if (GqlQueryIndexManager.contains(properties, p)) continue;
            properties.add((Pair<String, SortOrder>)Pair.create((Object)p, (Object)((Object)SortOrder.ASC)));
        }
        return properties;
    }

    private static Set<String> getUniqueNames(List<Pair<String, SortOrder>> properties) {
        HashSet<String> names = new HashSet<String>();
        for (Pair<String, SortOrder> p : properties) {
            names.add((String)p.getFirst());
        }
        return names;
    }

    private static boolean contains(List<Pair<String, SortOrder>> properties, String propertyName) {
        for (Pair<String, SortOrder> p : properties) {
            if (!propertyName.equals(p.getFirst())) continue;
            return true;
        }
        return false;
    }

    private static Set<String> filter(Collection<GqlCompare> conditions, boolean equal) {
        HashSet<String> result = new HashSet<String>();
        for (GqlCompare cond : conditions) {
            String propertyName = cond.getProperty();
            if (StringUtil.isEmpty((String)propertyName) || cond.isEqual() != equal) continue;
            result.add(cond.getProperty());
        }
        return result;
    }

    public static Set<QueryIndex> getIndexes(@NotNull Module module) {
        YAMLFile index;
        if (module == null) {
            GqlQueryIndexManager.$$$reportNull$$$0(1);
        }
        if ((index = AppEngineUtil.getIndex(module, false)) != null) {
            return GqlQueryIndexManager.getIndexes(index);
        }
        return Collections.emptySet();
    }

    private static Set<QueryIndex> getIndexes(@NotNull YAMLFile file2) {
        if (file2 == null) {
            GqlQueryIndexManager.$$$reportNull$$$0(2);
        }
        HashSet<QueryIndex> result = new HashSet<QueryIndex>();
        for (YAMLDocument doc : file2.getDocuments()) {
            YAMLValue child = doc.getTopLevelValue();
            if (child instanceof YAMLMapping) {
                for (YAMLKeyValue keyValue : ((YAMLMapping)child).getKeyValues()) {
                    if (!"indexes".equals(keyValue.getKeyText())) continue;
                    GqlQueryIndexManager.addIndexes(YamlUtil.getSequenceValue(keyValue), result);
                }
                continue;
            }
            if (!(child instanceof YAMLSequence)) continue;
            for (YAMLSequenceItem item : ((YAMLSequence)child).getItems()) {
                GqlQueryIndexManager.addIndex(item, result);
            }
        }
        return result;
    }

    private static void addIndexes(List<YAMLSequenceItem> sequences, Set<QueryIndex> result) {
        for (YAMLSequenceItem seq : sequences) {
            GqlQueryIndexManager.addIndex(seq, result);
        }
    }

    private static void addIndex(YAMLSequenceItem seq, Set<QueryIndex> result) {
        QueryIndex index = new QueryIndex();
        for (YAMLKeyValue keyValue : seq.getKeysValues()) {
            String key = keyValue.getKeyText();
            if (KIND.equals(key)) {
                index.setKind(keyValue.getValueText());
            }
            if (ANCESTOR.equals(key)) {
                String val = keyValue.getValueText();
                index.setHasAncestor(ANCESTOR_YES.equals(val));
            }
            if (!PROPERTIES.equals(key)) continue;
            for (YAMLSequenceItem prop : YamlUtil.getSequenceValue(keyValue)) {
                GqlQueryIndexManager.addProperty(index, prop);
            }
        }
        if (index.getKind() != null) {
            result.add(index);
        }
    }

    private static void addProperty(QueryIndex index, YAMLSequenceItem prop) {
        String name = null;
        boolean asc = true;
        for (YAMLKeyValue attrKeyValue : prop.getKeysValues()) {
            String direction;
            if (NAME.equals(attrKeyValue.getKeyText())) {
                name = attrKeyValue.getValueText();
            }
            if (!DIRECTION.equals(attrKeyValue.getKeyText()) || !DIRECTION_DESC.equals((direction = attrKeyValue.getValueText()).trim())) continue;
            asc = false;
        }
        if (name != null) {
            index.addProperty(name, asc);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getDefinition(QueryIndex index) {
        StringWriter writer = new StringWriter();
        try (PrintWriter out = new PrintWriter(writer);){
            out.println();
            out.print(SEQUENCE);
            out.print(KIND);
            out.print(": ");
            out.println(index.getKind());
            int indent = 1;
            if (index.isHasAncestor()) {
                GqlQueryIndexManager.indent(out, indent);
                out.print(ANCESTOR);
                out.print(": ");
                out.println(ANCESTOR_YES);
            }
            GqlQueryIndexManager.indent(out, indent);
            out.print(PROPERTIES);
            out.println(":");
            for (Pair<String, SortOrder> prop : index.getProperties()) {
                GqlQueryIndexManager.indent(out, indent);
                out.print(SEQUENCE);
                out.print(NAME);
                out.print(": ");
                out.println((String)prop.getFirst());
                if (prop.getSecond() != SortOrder.DESC) continue;
                GqlQueryIndexManager.indent(out, indent + 1);
                out.print(DIRECTION);
                out.print(": ");
                out.println(DIRECTION_DESC);
            }
            out.println();
        }
        return StringUtil.convertLineSeparators((String)writer.toString());
    }

    private static void indent(PrintWriter out, int indent) {
        for (int i = 0; i < indent; ++i) {
            out.print(INDENT);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 2: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 2: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/appengine/index/GqlQueryIndexManager";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "normalizeOrders";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/appengine/index/GqlQueryIndexManager";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getIndexes";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 2: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class PropertiesComparator
    implements Comparator<Pair<String, SortOrder>> {
        private PropertiesComparator() {
        }

        @Override
        public int compare(Pair<String, SortOrder> p1, Pair<String, SortOrder> p2) {
            return ((String)p1.getFirst()).compareTo((String)p2.getFirst());
        }
    }
}

