/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.uml.project.ui;

import com.intellij.openapi.module.Module;
import com.intellij.openapi.roots.libraries.Library;
import com.intellij.ui.SizedIcon;
import com.intellij.util.PlatformIcons;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.UIUtil;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import javax.swing.DefaultListCellRenderer;
import javax.swing.Icon;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;

public class ModulesListCellRenderer
extends DefaultListCellRenderer {
    private static final Icon MODULE_ICON = JBUI.scale((JBUI.JBIcon)new SizedIcon(PlatformIcons.CONTENT_ROOT_ICON_CLOSED, 18, 18));
    private static final Icon LIBRARY_ICON = JBUI.scale((JBUI.JBIcon)new SizedIcon(PlatformIcons.LIBRARY_ICON, 18, 18));

    @Override
    public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
        JPanel panel = new JPanel(new BorderLayout());
        panel.setOpaque(true);
        Color bg = isSelected ? UIUtil.getListSelectionBackground((boolean)true) : UIUtil.getListBackground();
        Color fg = isSelected ? UIUtil.getListSelectionForeground() : UIUtil.getListForeground();
        panel.setBackground(bg);
        if (value instanceof Module) {
            Module module = (Module)value;
            JLabel label = new JLabel(module.getName(), MODULE_ICON, 2);
            label.setBackground(bg);
            label.setForeground(fg);
            panel.add((Component)label, "West");
            return panel;
        }
        if (value instanceof Library) {
            Library library = (Library)value;
            JLabel label = new JLabel(library.getName(), LIBRARY_ICON, 2);
            label.setBackground(bg);
            label.setForeground(fg);
            panel.add((Component)label, "West");
            return panel;
        }
        return super.getListCellRendererComponent((JList<?>)list, value, index, isSelected, cellHasFocus);
    }
}

