/*
 * Decompiled with CFR 0.152.
 */
package com.intellij;

import com.intellij.TestClassesFilter;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.MultiMap;
import gnu.trove.THashSet;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;

public class GroupBasedTestClassFilter
extends TestClassesFilter {
    public static final String ALL_EXCLUDE_DEFINED = "ALL_EXCLUDE_DEFINED";
    private final List<Group> myGroups = new SmartList();
    private final Set<String> myTestGroupNames;

    public GroupBasedTestClassFilter(MultiMap<String, String> filters, List<String> testGroupNames) {
        this.myTestGroupNames = new THashSet(testGroupNames);
        for (String groupName : filters.keySet()) {
            Collection groupFilters = filters.get((Object)groupName);
            ArrayList<Pattern> includePatterns = GroupBasedTestClassFilter.compilePatterns(ContainerUtil.filter((Collection)groupFilters, s -> !s.startsWith("-")));
            ArrayList<Pattern> excludedPatterns = GroupBasedTestClassFilter.compilePatterns(groupFilters.stream().filter(s -> s.startsWith("-") && s.length() > 1).map(s -> s.substring(1)).collect(Collectors.toList()));
            this.myGroups.add(new Group(groupName, includePatterns, excludedPatterns));
        }
    }

    @NotNull
    public static TestClassesFilter createOn(@NotNull Reader reader, @NotNull List<String> testGroupNames) throws IOException {
        if (reader == null) {
            GroupBasedTestClassFilter.$$$reportNull$$$0(0);
        }
        if (testGroupNames == null) {
            GroupBasedTestClassFilter.$$$reportNull$$$0(1);
        }
        return new GroupBasedTestClassFilter(GroupBasedTestClassFilter.readGroups(reader), testGroupNames);
    }

    public static MultiMap<String, String> readGroups(Reader reader) throws IOException {
        String line;
        MultiMap groupNameToPatternsMap = MultiMap.createLinked();
        String currentGroupName = "";
        BufferedReader bufferedReader = new BufferedReader(reader);
        while ((line = bufferedReader.readLine()) != null) {
            if (line.startsWith("#")) continue;
            if (line.startsWith("[") && line.endsWith("]")) {
                currentGroupName = line.substring(1, line.length() - 1);
                continue;
            }
            groupNameToPatternsMap.putValue((Object)currentGroupName, (Object)line);
        }
        return groupNameToPatternsMap;
    }

    @Override
    public boolean matches(String className, String moduleName) {
        if (this.myGroups.stream().filter(g -> this.myTestGroupNames.contains(((Group)g).name)).anyMatch(g -> ((Group)g).matches(className))) {
            return true;
        }
        return GroupBasedTestClassFilter.containsAllExcludeDefinedGroup(this.myTestGroupNames) && this.myGroups.stream().noneMatch(g -> ((Group)g).matches(className));
    }

    private static boolean containsAllExcludeDefinedGroup(Set<String> groupNames) {
        return groupNames.isEmpty() || groupNames.contains(ALL_EXCLUDE_DEFINED);
    }

    public String toString() {
        return "GroupBasedTestClassFilter{names=" + this.myTestGroupNames + '}';
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "reader";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "testGroupNames";
                break;
            }
        }
        objectArray[1] = "com/intellij/GroupBasedTestClassFilter";
        objectArray[2] = "createOn";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private static class Group {
        private final String name;
        private final List<Pattern> included;
        private final List<Pattern> excluded;

        private Group(String name, List<Pattern> included, List<Pattern> excluded) {
            this.name = name;
            this.excluded = excluded;
            this.included = included;
        }

        private boolean matches(String className) {
            return !TestClassesFilter.matchesAnyPattern(this.excluded, className) && TestClassesFilter.matchesAnyPattern(this.included, className);
        }
    }
}

