/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.structuralsearch.plugin.ui;

import a.g.lb;
import com.intellij.codeInsight.daemon.DaemonCodeAnalyzer;
import com.intellij.codeInsight.template.TemplateContextType;
import com.intellij.codeInsight.template.impl.TemplateEditorUtil;
import com.intellij.icons.AllIcons;
import com.intellij.ide.IdeTooltip;
import com.intellij.ide.IdeTooltipManager;
import com.intellij.lang.Language;
import com.intellij.lang.injection.InjectedLanguageManager;
import com.intellij.notification.NotificationDisplayType;
import com.intellij.notification.NotificationGroup;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorFactory;
import com.intellij.openapi.editor.EditorSettings;
import com.intellij.openapi.editor.colors.EditorColors;
import com.intellij.openapi.editor.colors.EditorColorsManager;
import com.intellij.openapi.editor.colors.EditorColorsScheme;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.FileTypeManager;
import com.intellij.openapi.fileTypes.FileTypes;
import com.intellij.openapi.fileTypes.LanguageFileType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.popup.Balloon;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiCodeFragment;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileFactory;
import com.intellij.structuralsearch.MatchOptions;
import com.intellij.structuralsearch.MatchVariableConstraint;
import com.intellij.structuralsearch.PatternContext;
import com.intellij.structuralsearch.ReplacementVariableDefinition;
import com.intellij.structuralsearch.SSRBundle;
import com.intellij.structuralsearch.StructuralSearchProfile;
import com.intellij.structuralsearch.StructuralSearchUtil;
import com.intellij.structuralsearch.plugin.StructuralSearchAction;
import com.intellij.structuralsearch.plugin.replace.ReplaceOptions;
import com.intellij.structuralsearch.plugin.ui.Configuration;
import com.intellij.structuralsearch.plugin.ui.SearchConfiguration;
import com.intellij.structuralsearch.plugin.ui.SearchContext;
import com.intellij.structuralsearch.plugin.ui.SubstitutionShortInfoHandler;
import com.intellij.ui.EditorTextField;
import com.intellij.ui.TooltipWithClickableLinks;
import com.intellij.util.LocalTimeCounter;
import com.intellij.util.containers.ContainerUtil;
import java.awt.Color;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.lang.invoke.MethodHandles;
import java.util.function.Consumer;
import java.util.function.Supplier;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class UIUtil {
    @NonNls
    private static final String a = "structuralsearchgroup";
    public static final NotificationGroup SSR_NOTIFICATION_GROUP;
    @NonNls
    public static final String TEXT = "TEXT";
    @NonNls
    public static final String TEXT_HIERARCHY = "TEXT HIERARCHY";
    @NonNls
    public static final String REFERENCE = "REFERENCE";
    @NonNls
    public static final String TYPE = "TYPE";
    @NonNls
    public static final String TYPE_REGEX = "TYPE REGEX";
    @NonNls
    public static final String EXPECTED_TYPE = "EXPECTED TYPE";
    @NonNls
    public static final String MINIMUM_ZERO = "MINIMUM ZERO";
    @NonNls
    public static final String MAXIMUM_UNLIMITED = "MAXIMUM UNLIMITED";
    @NonNls
    public static final String CONTEXT = "CONTEXT";
    private static final long b;

    private UIUtil() {
    }

    @NotNull
    public static Editor createEditor(@NotNull Document doc, Project project, boolean editable, @Nullable TemplateContextType contextType) {
        if (doc == null) {
            UIUtil.a(0);
        }
        Editor editor = editable ? EditorFactory.getInstance().createEditor(doc, project) : EditorFactory.getInstance().createViewer(doc, project);
        EditorSettings editorSettings = editor.getSettings();
        editorSettings.setVirtualSpace(false);
        editorSettings.setLineMarkerAreaShown(false);
        editorSettings.setIndentGuidesShown(false);
        editorSettings.setLineNumbersShown(false);
        editorSettings.setFoldingOutlineShown(false);
        editorSettings.setCaretRowShown(false);
        if (!editable) {
            EditorColorsScheme editorColorsScheme = EditorColorsManager.getInstance().getGlobalScheme();
            Color color = editorColorsScheme.getColor(EditorColors.READONLY_BACKGROUND_COLOR);
            if (color == null) {
                color = editorColorsScheme.getDefaultBackground();
            }
            ((EditorEx)editor).setBackgroundColor(color);
        } else {
            ((EditorEx)editor).setEmbeddedIntoDialogWrapper(true);
        }
        TemplateEditorUtil.setHighlighter((Editor)editor, (TemplateContextType)contextType);
        Editor editor2 = editor;
        if (editor2 == null) {
            UIUtil.a(1);
        }
        return editor2;
    }

    public static void setContent(@NotNull Editor editor, String text) {
        long l2 = b ^ 0x748A132FBFA1L;
        if (editor == null) {
            UIUtil.a(2);
        }
        String string = text != null ? text : "";
        Document document = editor.getDocument();
        WriteCommandAction.runWriteCommandAction((Project)editor.getProject(), (String)SSRBundle.message("modify.editor.content.command.name", new Object[0]), (String)a, () -> document.replaceString(0, document.getTextLength(), (CharSequence)string), (PsiFile[])new PsiFile[0]);
    }

    public static void setContent(@NotNull EditorTextField editor, String text) {
        long l2 = b ^ 0x63959021715L;
        if (editor == null) {
            UIUtil.a(3);
        }
        String string = text != null ? text : "";
        Document document = editor.getDocument();
        WriteCommandAction.runWriteCommandAction((Project)editor.getProject(), (String)SSRBundle.message("modify.editor.content.command.name", new Object[0]), (String)a, () -> document.replaceString(0, document.getTextLength(), (CharSequence)string), (PsiFile[])new PsiFile[0]);
    }

    public static void invokeAction(Configuration config, SearchContext context) {
        StructuralSearchAction.triggerAction(config, context, !(config instanceof SearchConfiguration));
    }

    public static MatchVariableConstraint getOrAddVariableConstraint(String varName, Configuration configuration) {
        MatchOptions matchOptions = configuration.getMatchOptions();
        MatchVariableConstraint matchVariableConstraint = matchOptions.getVariableConstraint(varName);
        if (matchVariableConstraint != null) {
            return matchVariableConstraint;
        }
        return configuration.getMatchOptions().addNewVariableConstraint(varName);
    }

    public static ReplacementVariableDefinition getOrAddReplacementVariable(String varName, Configuration configuration) {
        ReplaceOptions replaceOptions = configuration.getReplaceOptions();
        ReplacementVariableDefinition replacementVariableDefinition = replaceOptions.getVariableDefinition(varName);
        if (replacementVariableDefinition != null) {
            return replacementVariableDefinition;
        }
        return replaceOptions.addNewVariableDefinition(varName);
    }

    public static boolean isTarget(String varName, MatchOptions matchOptions) {
        long l2 = b ^ 0x4045AEDEDBDAL;
        if ("__context__".equals(varName)) {
            for (String string : matchOptions.getVariableConstraintNames()) {
                if (string.equals("__context__") || !matchOptions.getVariableConstraint(string).isPartOfSearchResults()) continue;
                return false;
            }
            return true;
        }
        MatchVariableConstraint matchVariableConstraint = matchOptions.getVariableConstraint(varName);
        if (matchVariableConstraint == null) {
            return false;
        }
        return matchVariableConstraint.isPartOfSearchResults();
    }

    @NotNull
    public static JComponent createCompleteMatchInfo(Supplier<? extends Configuration> configurationProducer) {
        return UIUtil.installCompleteMatchInfo(new JLabel(AllIcons.Actions.ListFiles), configurationProducer, null);
    }

    @NotNull
    public static JComponent installCompleteMatchInfo(final JLabel completeMatchInfo, final Supplier<? extends Configuration> configurationProducer, final Consumer<? super String> linkConsumer) {
        completeMatchInfo.putClientProperty(IdeTooltip.TOOLTIP_DISMISS_DELAY_KEY, 20000);
        completeMatchInfo.addMouseListener(new MouseAdapter(){
            private static final long a = lb.a(-689072356657240738L, -3992089967897940193L, MethodHandles.lookup().lookupClass()).a(84328252466318L);

            @Override
            public void mouseEntered(MouseEvent ignore) {
                long l2 = a ^ 0x76EEE6AF8EEBL;
                if (Registry.is((String)"ssr.use.editor.inlays.instead.of.tool.tips")) {
                    return;
                }
                Configuration configuration = (Configuration)configurationProducer.get();
                if (configuration == null) {
                    return;
                }
                MatchOptions matchOptions = configuration.getMatchOptions();
                if (matchOptions.getSearchPattern().isEmpty()) {
                    return;
                }
                MatchVariableConstraint matchVariableConstraint = UIUtil.getOrAddVariableConstraint("__context__", configuration);
                if (UIUtil.isTarget("__context__", matchOptions)) {
                    matchVariableConstraint.setPartOfSearchResults(true);
                }
                String string = StringUtil.escapeXmlEntities((String)SSRBundle.message("complete.match.variable.tooltip.message", SubstitutionShortInfoHandler.getShortParamString(matchVariableConstraint, linkConsumer == null)));
                if (linkConsumer != null && !"__context__".equals(configuration.getCurrentVariableName())) {
                    string = SubstitutionShortInfoHandler.appendLinkText(string, "__context__");
                }
                HyperlinkListener hyperlinkListener = hyperlinkEvent -> {
                    long l2 = a ^ 0xF8CA8DAD817L;
                    if (hyperlinkEvent.getEventType() == HyperlinkEvent.EventType.ACTIVATED && linkConsumer != null) {
                        linkConsumer.accept("__context__");
                        IdeTooltipManager.getInstance().hideCurrentNow(true);
                    }
                };
                TooltipWithClickableLinks tooltipWithClickableLinks = new TooltipWithClickableLinks((JComponent)completeMatchInfo, string, hyperlinkListener);
                Rectangle rectangle = completeMatchInfo.getBounds();
                tooltipWithClickableLinks.setHint(true).setExplicitClose(true).setPreferredPosition(Balloon.Position.below).setPoint(new Point(rectangle.x + rectangle.width / 2, rectangle.y + rectangle.height));
                IdeTooltipManager.getInstance().show((IdeTooltip)tooltipWithClickableLinks, true);
                if (linkConsumer == null) {
                    configuration.setCurrentVariableName("__context__");
                }
            }
        });
        JLabel jLabel = completeMatchInfo;
        if (jLabel == null) {
            UIUtil.a(4);
        }
        return jLabel;
    }

    public static EditorTextField createTextComponent(String text, Project project) {
        long l2 = b ^ 0x568DE1D3CE0BL;
        return UIUtil.createEditorComponent(text, "1.txt", project);
    }

    public static EditorTextField createRegexComponent(String text, Project project) {
        long l2 = b ^ 0x23FA08CAFEA9L;
        return UIUtil.createEditorComponent(text, "1.regexp", project);
    }

    public static EditorTextField createScriptComponent(String text, Project project) {
        long l2 = b ^ 0x7374E28B1EAAL;
        return UIUtil.createEditorComponent(text, "1.groovy", project);
    }

    @NotNull
    public static EditorTextField createEditorComponent(String text, String fileName, Project project) {
        return new EditorTextField(text, project, UIUtil.a(fileName));
    }

    private static FileType a(String string) {
        FileType fileType = FileTypeManager.getInstance().getFileTypeByFileName(string);
        if (fileType == FileTypes.UNKNOWN) {
            fileType = FileTypes.PLAIN_TEXT;
        }
        return fileType;
    }

    public static LanguageFileType detectFileType(@NotNull SearchContext searchContext) {
        Language language;
        StructuralSearchProfile structuralSearchProfile;
        if (searchContext == null) {
            UIUtil.a(5);
        }
        PsiFile psiFile = searchContext.getFile();
        PsiElement psiElement = null;
        Editor editor = searchContext.getEditor();
        if (editor != null && psiFile != null) {
            int n2 = editor.getCaretModel().getOffset();
            psiElement = InjectedLanguageManager.getInstance((Project)searchContext.getProject()).findInjectedElementAt(psiFile, n2);
            if (psiElement == null) {
                psiElement = psiFile.findElementAt(n2);
            }
            if (psiElement != null) {
                psiElement = psiElement.getParent();
            }
            if (psiElement == null) {
                psiElement = psiFile;
            }
        }
        if (psiElement != null && (structuralSearchProfile = StructuralSearchUtil.getProfileByLanguage(language = psiElement.getLanguage())) != null) {
            LanguageFileType languageFileType = structuralSearchProfile.detectFileType(psiElement);
            return languageFileType != null ? languageFileType : language.getAssociatedFileType();
        }
        return StructuralSearchUtil.getDefaultFileType();
    }

    @NotNull
    public static Document createDocument(@NotNull Project project, @NotNull LanguageFileType fileType, Language dialect, PatternContext patternContext, @NotNull String text, @NotNull StructuralSearchProfile profile) {
        String string;
        PsiCodeFragment psiCodeFragment;
        long l2 = b ^ 0x44EAB9BB960BL;
        if (project == null) {
            UIUtil.a(6);
        }
        if (fileType == null) {
            UIUtil.a(7);
        }
        if (text == null) {
            UIUtil.a(8);
        }
        if (profile == null) {
            UIUtil.a(9);
        }
        if ((psiCodeFragment = profile.createCodeFragment(project, text, string = patternContext == null ? null : patternContext.getId())) == null) {
            psiCodeFragment = UIUtil.a(project, fileType, dialect, text);
        }
        if (psiCodeFragment != null) {
            Document document = PsiDocumentManager.getInstance((Project)project).getDocument((PsiFile)psiCodeFragment);
            assert (document != null) : "code fragment element should be physical";
            Document document2 = document;
            if (document2 == null) {
                UIUtil.a(10);
            }
            return document2;
        }
        Document document = EditorFactory.getInstance().createDocument((CharSequence)text);
        if (document == null) {
            UIUtil.a(11);
        }
        return document;
    }

    @NotNull
    public static Editor createEditor(@NotNull Project project, @NotNull LanguageFileType fileType, Language dialect, @NotNull String text, boolean editable, @NotNull StructuralSearchProfile profile) {
        Document document;
        PsiCodeFragment psiCodeFragment;
        long l2 = b ^ 0x7D14E5A01488L;
        if (project == null) {
            UIUtil.a(12);
        }
        if (fileType == null) {
            UIUtil.a(13);
        }
        if (text == null) {
            UIUtil.a(14);
        }
        if (profile == null) {
            UIUtil.a(15);
        }
        if ((psiCodeFragment = profile.createCodeFragment(project, text, null)) == null) {
            psiCodeFragment = UIUtil.a(project, fileType, dialect, text);
        }
        if (psiCodeFragment != null) {
            document = PsiDocumentManager.getInstance((Project)project).getDocument((PsiFile)psiCodeFragment);
            assert (document != null) : "code fragment element should be physical";
            DaemonCodeAnalyzer.getInstance((Project)project).setHighlightingEnabled((PsiFile)psiCodeFragment, false);
        } else {
            document = EditorFactory.getInstance().createDocument((CharSequence)"");
        }
        return UIUtil.createEditor(document, project, editable, UIUtil.getTemplateContextType(profile));
    }

    private static PsiFile a(@NotNull Project project, @NotNull LanguageFileType languageFileType, Language language, @NotNull String string) {
        long l2 = b ^ 0x5B30E49C153CL;
        if (project == null) {
            UIUtil.a(16);
        }
        if (languageFileType == null) {
            UIUtil.a(17);
        }
        if (string == null) {
            UIUtil.a(18);
        }
        String string2 = "__dummy." + languageFileType.getDefaultExtension();
        PsiFileFactory psiFileFactory = PsiFileFactory.getInstance((Project)project);
        return language == null ? psiFileFactory.createFileFromText(string2, (FileType)languageFileType, (CharSequence)string, LocalTimeCounter.currentTime(), true, true) : psiFileFactory.createFileFromText(string2, language, (CharSequence)string, true, true);
    }

    public static TemplateContextType getTemplateContextType(StructuralSearchProfile profile) {
        Class<? extends TemplateContextType> clazz = profile.getTemplateContextTypeClass();
        return (TemplateContextType)ContainerUtil.findInstance((Object[])TemplateContextType.EP_NAME.getExtensions(), clazz);
    }

    static {
        b = lb.a(-3546013535090391005L, 5913376870131759143L, MethodHandles.lookup().lookupClass()).a(113409733001942L);
        long l2 = b ^ 0x2E1D15C06027L;
        SSR_NOTIFICATION_GROUP = new NotificationGroup(SSRBundle.message("structural.search.title", new Object[0]), NotificationDisplayType.STICKY_BALLOON, true, "Find");
    }

    private static /* synthetic */ void a(int n2) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n3;
        String string;
        long l2 = b ^ 0xE96A7E043A2L;
        switch (n2) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 4: 
            case 10: 
            case 11: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n2) {
            default: {
                n3 = 3;
                break;
            }
            case 1: 
            case 4: 
            case 10: 
            case 11: {
                n3 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n3];
        switch (n2) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "doc";
                break;
            }
            case 1: 
            case 4: 
            case 10: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/structuralsearch/plugin/ui/UIUtil";
                break;
            }
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "searchContext";
                break;
            }
            case 6: 
            case 12: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 7: 
            case 13: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileType";
                break;
            }
            case 8: 
            case 14: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
            case 9: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "profile";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/structuralsearch/plugin/ui/UIUtil";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "createEditor";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "installCompleteMatchInfo";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "createDocument";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "createEditor";
                break;
            }
            case 1: 
            case 4: 
            case 10: 
            case 11: {
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "setContent";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "detectFileType";
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "createDocument";
                break;
            }
            case 16: 
            case 17: 
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "createFileFragment";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n2) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 4: 
            case 10: 
            case 11: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

