/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.structuralsearch;

import a.g.lb;
import com.intellij.lang.Language;
import com.intellij.openapi.fileTypes.FileTypeManager;
import com.intellij.openapi.fileTypes.LanguageFileType;
import com.intellij.openapi.fileTypes.StdFileTypes;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.structuralsearch.PatternContext;
import com.intellij.structuralsearch.StructuralSearchProfile;
import com.intellij.structuralsearch.StructuralSearchProfileBase;
import com.intellij.structuralsearch.XmlStructuralSearchProfile;
import com.intellij.structuralsearch.plugin.ui.Configuration;
import java.lang.invoke.MethodHandles;
import java.text.Normalizer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import one.util.streamex.StreamEx;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class StructuralSearchUtil {
    private static final String b = ".$|()[]{}^?*+\\";
    private static final Key<StructuralSearchProfile> a;
    private static final Pattern e;
    private static LanguageFileType f;
    public static boolean ourUseUniversalMatchingAlgorithm;
    private static StructuralSearchProfile[] d;
    private static List<Configuration> c;
    private static final long g;

    private StructuralSearchUtil() {
    }

    @Nullable
    public static StructuralSearchProfile getProfileByPsiElement(@NotNull PsiElement element) {
        if (element == null) {
            StructuralSearchUtil.a(0);
        }
        return StructuralSearchUtil.getProfileByLanguage(element.getLanguage());
    }

    @Contract(value="null -> false")
    public static boolean isIdentifier(PsiElement element) {
        if (element == null) {
            return false;
        }
        StructuralSearchProfile structuralSearchProfile = StructuralSearchUtil.getProfileByPsiElement(element);
        return structuralSearchProfile != null && structuralSearchProfile.isIdentifier(element);
    }

    public static PsiElement getParentIfIdentifier(PsiElement element) {
        return !StructuralSearchUtil.isIdentifier(element) ? element : element.getParent();
    }

    @Contract(value="!null -> !null")
    public static PsiElement getPresentableElement(PsiElement element) {
        if (element == null) {
            return null;
        }
        StructuralSearchProfile structuralSearchProfile = StructuralSearchUtil.getProfileByPsiElement(element);
        return structuralSearchProfile == null ? element : structuralSearchProfile.getPresentableElement(element);
    }

    private static StructuralSearchProfile[] b() {
        if (d == null) {
            ArrayList<StructuralSearchProfile> arrayList = new ArrayList<StructuralSearchProfile>();
            for (StructuralSearchProfile structuralSearchProfile : (StructuralSearchProfile[])StructuralSearchProfile.EP_NAME.getExtensions()) {
                if (!(structuralSearchProfile instanceof StructuralSearchProfileBase)) continue;
                arrayList.add(structuralSearchProfile);
            }
            arrayList.add(new XmlStructuralSearchProfile());
            d = arrayList.toArray(new StructuralSearchProfile[0]);
        }
        return d;
    }

    private static StructuralSearchProfile[] a() {
        return ourUseUniversalMatchingAlgorithm ? StructuralSearchUtil.b() : (StructuralSearchProfile[])StructuralSearchProfile.EP_NAME.getExtensions();
    }

    @NotNull
    public static LanguageFileType getDefaultFileType() {
        if (f == null) {
            for (StructuralSearchProfile structuralSearchProfile : StructuralSearchUtil.a()) {
                f = structuralSearchProfile.getDefaultFileType(f);
            }
            if (f == null) {
                f = StdFileTypes.XML;
            }
        }
        LanguageFileType languageFileType = f;
        if (languageFileType == null) {
            StructuralSearchUtil.a(1);
        }
        return languageFileType;
    }

    public static void clearProfileCache(@NotNull Language language) {
        if (language == null) {
            StructuralSearchUtil.a(2);
        }
        language.putUserData(a, null);
    }

    @Nullable
    public static StructuralSearchProfile getProfileByLanguage(@NotNull Language language) {
        StructuralSearchProfile structuralSearchProfile;
        if (language == null) {
            StructuralSearchUtil.a(3);
        }
        if ((structuralSearchProfile = (StructuralSearchProfile)language.getUserData(a)) != null) {
            return structuralSearchProfile;
        }
        for (StructuralSearchProfile structuralSearchProfile2 : StructuralSearchUtil.a()) {
            if (!structuralSearchProfile2.isMyLanguage(language)) continue;
            language.putUserData(a, (Object)structuralSearchProfile2);
            return structuralSearchProfile2;
        }
        return null;
    }

    public static boolean isTypedVariable(@NotNull String name) {
        if (name == null) {
            StructuralSearchUtil.a(4);
        }
        return name.length() > 1 && name.charAt(0) == '$' && name.charAt(name.length() - 1) == '$';
    }

    @Nullable
    public static StructuralSearchProfile getProfileByFileType(LanguageFileType fileType) {
        return StructuralSearchUtil.getProfileByLanguage(fileType.getLanguage());
    }

    public static LanguageFileType @NotNull [] getSuitableFileTypes() {
        Object[] objectArray = FileTypeManager.getInstance().getRegisteredFileTypes();
        Set set = (Set)StreamEx.of((Object[])objectArray).select(LanguageFileType.class).collect(Collectors.toSet());
        for (Language language : Language.getRegisteredLanguages()) {
            LanguageFileType languageFileType = language.getAssociatedFileType();
            if (languageFileType == null) continue;
            set.add(languageFileType);
        }
        LanguageFileType[] languageFileTypeArray = set.toArray(new LanguageFileType[0]);
        if (languageFileTypeArray == null) {
            StructuralSearchUtil.a(5);
        }
        return languageFileTypeArray;
    }

    public static boolean containsRegExpMetaChar(String s2) {
        return s2.chars().anyMatch(StructuralSearchUtil::isRegExpMetaChar);
    }

    public static boolean isRegExpMetaChar(int ch2) {
        long l2 = g ^ 0x2B22F8E43463L;
        return b.indexOf(ch2) >= 0;
    }

    public static String shieldRegExpMetaChars(String word) {
        return StructuralSearchUtil.shieldRegExpMetaChars(word, new StringBuilder(word.length())).toString();
    }

    @NotNull
    public static StringBuilder shieldRegExpMetaChars(String word, StringBuilder out) {
        int n2 = word.length();
        for (int i10 = 0; i10 < n2; ++i10) {
            if (StructuralSearchUtil.isRegExpMetaChar(word.charAt(i10))) {
                out.append("\\");
            }
            out.append(word.charAt(i10));
        }
        StringBuilder stringBuilder = out;
        if (stringBuilder == null) {
            StructuralSearchUtil.a(6);
        }
        return stringBuilder;
    }

    public static Pattern[] createPatterns(String[] prefixes) {
        long l2 = g ^ 0x6C2929F3FE11L;
        Pattern[] patternArray = new Pattern[prefixes.length];
        for (int i10 = 0; i10 < prefixes.length; ++i10) {
            String string = StructuralSearchUtil.shieldRegExpMetaChars(prefixes[i10]);
            patternArray[i10] = Pattern.compile("\\b(" + string + "\\w+)\\b");
        }
        return patternArray;
    }

    public static List<Configuration> getPredefinedTemplates() {
        if (c == null) {
            ArrayList arrayList = new ArrayList();
            for (StructuralSearchProfile structuralSearchProfile : StructuralSearchUtil.a()) {
                Collections.addAll(arrayList, structuralSearchProfile.getPredefinedTemplates());
            }
            Collections.sort(arrayList);
            c = Collections.unmodifiableList(arrayList);
        }
        return c;
    }

    public static boolean isDocCommentOwner(PsiElement match) {
        StructuralSearchProfile structuralSearchProfile = StructuralSearchUtil.getProfileByPsiElement(match);
        return structuralSearchProfile != null && structuralSearchProfile.isDocCommentOwner(match);
    }

    public static String getMeaningfulText(PsiElement matchedNode) {
        StructuralSearchProfile structuralSearchProfile = StructuralSearchUtil.getProfileByPsiElement(matchedNode);
        return structuralSearchProfile != null ? structuralSearchProfile.getMeaningfulText(matchedNode) : matchedNode.getText();
    }

    public static String getAlternativeText(PsiElement matchedNode, String previousText) {
        StructuralSearchProfile structuralSearchProfile = StructuralSearchUtil.getProfileByPsiElement(matchedNode);
        return structuralSearchProfile != null ? structuralSearchProfile.getAlternativeText(matchedNode, previousText) : null;
    }

    public static String normalizeWhiteSpace(@NotNull String text) {
        if (text == null) {
            StructuralSearchUtil.a(7);
        }
        text = text.trim();
        StringBuilder stringBuilder = new StringBuilder();
        boolean bl2 = false;
        int n2 = text.length();
        for (int i10 = 0; i10 < n2; ++i10) {
            char c10 = text.charAt(i10);
            if (StringUtil.isWhiteSpace((char)c10)) {
                if (bl2) continue;
                stringBuilder.append(' ');
                bl2 = true;
                continue;
            }
            bl2 = false;
            stringBuilder.append(c10);
        }
        return stringBuilder.toString();
    }

    public static String stripAccents(@NotNull String input) {
        if (input == null) {
            StructuralSearchUtil.a(8);
        }
        return e.matcher(Normalizer.normalize(input, Normalizer.Form.NFD)).replaceAll("");
    }

    public static String normalize(@NotNull String text) {
        if (text == null) {
            StructuralSearchUtil.a(9);
        }
        return StructuralSearchUtil.stripAccents(StructuralSearchUtil.normalizeWhiteSpace(text));
    }

    public static PatternContext findPatternContextByID(@Nullable String id2, @NotNull Language language) {
        if (language == null) {
            StructuralSearchUtil.a(10);
        }
        return StructuralSearchUtil.findPatternContextByID(id2, StructuralSearchUtil.getProfileByLanguage(language));
    }

    public static PatternContext findPatternContextByID(@Nullable String id2, @Nullable StructuralSearchProfile profile) {
        if (profile == null) {
            return null;
        }
        List<PatternContext> list2 = profile.getPatternContexts();
        if (list2.isEmpty()) {
            return null;
        }
        if (id2 == null) {
            return list2.get(0);
        }
        return list2.stream().filter(patternContext -> patternContext.getId().equals(id2)).findFirst().orElse(list2.get(0));
    }

    static {
        g = lb.a(-3444740256482726189L, -515548663469546920L, MethodHandles.lookup().lookupClass()).a(39238466940612L);
        long l2 = g ^ 0x13B703A10352L;
        a = new Key("Structural Search Profile");
        e = Pattern.compile("\\p{InCombiningDiacriticalMarks}+");
        f = null;
        ourUseUniversalMatchingAlgorithm = false;
        c = null;
    }

    private static /* synthetic */ void a(int n2) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n3;
        String string;
        long l2 = g ^ 0x31E8FF54930DL;
        switch (n2) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 5: 
            case 6: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n2) {
            default: {
                n3 = 3;
                break;
            }
            case 1: 
            case 5: 
            case 6: {
                n3 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n3];
        switch (n2) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 1: 
            case 5: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/structuralsearch/StructuralSearchUtil";
                break;
            }
            case 2: 
            case 3: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "language";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 7: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "input";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/structuralsearch/StructuralSearchUtil";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getDefaultFileType";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getSuitableFileTypes";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "shieldRegExpMetaChars";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getProfileByPsiElement";
                break;
            }
            case 1: 
            case 5: 
            case 6: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "clearProfileCache";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getProfileByLanguage";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "isTypedVariable";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "normalizeWhiteSpace";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "stripAccents";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "normalize";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "findPatternContextByID";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n2) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 5: 
            case 6: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

