/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ssh.interaction;

import a.g.lb;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.Disposer;
import com.intellij.ssh.common.ServerDescription;
import com.intellij.ssh.interaction.ConnectionOwner;
import com.intellij.ssh.interaction.ConnectionOwnerFactory;
import java.awt.Component;
import java.lang.invoke.MethodHandles;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class ProjectBasedConnectionOwner
implements ConnectionOwner {
    @Nullable
    protected final Project myProject;
    private static final long b = lb.a(-6131243369823672411L, -8486944415589111422L, MethodHandles.lookup().lookupClass()).a(104328689861021L);

    protected ProjectBasedConnectionOwner(@Nullable Project project) {
        this.myProject = project;
    }

    @Override
    public boolean promptYesNo(@NotNull String message, @NotNull String title, @Nullable ProgressIndicator progressIndicator) {
        if (message == null) {
            ProjectBasedConnectionOwner.a(0);
        }
        if (title == null) {
            ProjectBasedConnectionOwner.a(1);
        }
        Computable computable = () -> {
            ProgressManager.checkCanceled();
            if (this.myProject != null) {
                return Messages.showYesNoDialog((Project)this.myProject, (String)message, (String)title, (Icon)Messages.getWarningIcon()) == 0;
            }
            return Messages.showYesNoDialog((String)message, (String)title, (Icon)Messages.getWarningIcon()) == 0;
        };
        ProgressManager.checkCanceled();
        return (Boolean)ConnectionOwnerFactory.computeOnEDT(computable, progressIndicator, ModalityState.any(), ModalityState.any());
    }

    @Override
    @Nullable
    public String promptPassword(@NotNull String message, @NotNull String title, @Nullable ProgressIndicator progressIndicator) {
        if (message == null) {
            ProjectBasedConnectionOwner.a(2);
        }
        if (title == null) {
            ProjectBasedConnectionOwner.a(3);
        }
        Computable computable = () -> {
            ProgressManager.checkCanceled();
            return Messages.showPasswordDialog((Project)this.myProject, (String)message, (String)title, (Icon)Messages.getQuestionIcon());
        };
        ProgressManager.checkCanceled();
        return (String)ConnectionOwnerFactory.computeOnEDT(computable, progressIndicator, ModalityState.any(), ModalityState.any());
    }

    @Override
    public final void showMessage(@NotNull String message, @NotNull String title, @Nullable ServerDescription server, @Nullable ProgressIndicator progressIndicator, @Nullable DialogWrapper.DoNotAskOption doNotAskOption) {
        if (message == null) {
            ProjectBasedConnectionOwner.a(4);
        }
        if (title == null) {
            ProjectBasedConnectionOwner.a(5);
        }
        ConnectionOwnerFactory.invokeLater(() -> this.showMessageImpl(message, title, server, doNotAskOption), progressIndicator, ModalityState.defaultModalityState());
    }

    protected abstract void showMessageImpl(@NotNull String var1, @NotNull String var2, @Nullable ServerDescription var3, @Nullable DialogWrapper.DoNotAskOption var4);

    @Override
    @Nullable
    public final String getHash() {
        return this.myProject != null && !this.myProject.isDisposed() ? this.myProject.getLocationHash() : null;
    }

    @Override
    public final void registerDisposable(@Nullable Disposable disposable) {
        if (disposable == null) {
            return;
        }
        if (this.myProject == null || this.myProject.isDefault()) {
            Disposer.register((Disposable)ApplicationManager.getApplication(), (Disposable)disposable);
        } else {
            Disposer.register((Disposable)this.myProject, (Disposable)disposable);
        }
    }

    @Override
    @Nullable
    public Project getProjectForDialogCreation() {
        return this.myProject;
    }

    @Override
    @Nullable
    public Component getComponentForDialogCreation() {
        return null;
    }

    @Override
    public void checkDisposed() throws IllegalStateException {
        long l2 = b ^ 0xB6BB90DC89DL;
        if (this.myProject != null && this.myProject.isDisposed()) {
            throw new IllegalStateException("Project is disposed");
        }
    }

    public final boolean equals(Object o2) {
        if (this == o2) {
            return true;
        }
        if (!(o2 instanceof ProjectBasedConnectionOwner)) {
            return false;
        }
        ProjectBasedConnectionOwner projectBasedConnectionOwner = (ProjectBasedConnectionOwner)o2;
        if (this.myProject == null) {
            return projectBasedConnectionOwner.myProject == null;
        }
        return this.myProject.equals(projectBasedConnectionOwner.myProject);
    }

    public final int hashCode() {
        return this.myProject != null ? this.myProject.hashCode() : 0;
    }

    private static /* synthetic */ void a(int n2) {
        Object[] objectArray;
        Object[] objectArray2;
        long l2 = b ^ 0x11B91B66665BL;
        Object[] objectArray3 = new Object[3];
        switch (n2) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "message";
                break;
            }
            case 1: 
            case 3: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "title";
                break;
            }
        }
        objectArray2[1] = "com/intellij/ssh/interaction/ProjectBasedConnectionOwner";
        switch (n2) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "promptYesNo";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "promptPassword";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "showMessage";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

