/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.dupLocator.resultUI;

import a.g.lb;
import com.intellij.codeInsight.highlighting.HighlightManager;
import com.intellij.dupLocator.DupInfo;
import com.intellij.dupLocator.DupLocatorBundle;
import com.intellij.dupLocator.DuplicatesPresentation;
import com.intellij.dupLocator.DuplicatesPresentationCache;
import com.intellij.dupLocator.DuplicatesProfileCache;
import com.intellij.dupLocator.resultUI.BasicTreeNode;
import com.intellij.dupLocator.resultUI.CodeNode;
import com.intellij.dupLocator.resultUI.ContentPanel;
import com.intellij.dupLocator.resultUI.DuplicatesModel;
import com.intellij.dupLocator.resultUI.DuplicatesView;
import com.intellij.dupLocator.resultUI.ExportHTMLAction;
import com.intellij.dupLocator.resultUI.GroupNode;
import com.intellij.dupLocator.util.PsiFragment;
import com.intellij.icons.AllIcons;
import com.intellij.ide.util.PropertiesComponent;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataKey;
import com.intellij.openapi.actionSystem.DataProvider;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.PlatformDataKeys;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.colors.EditorColors;
import com.intellij.openapi.editor.colors.EditorColorsManager;
import com.intellij.openapi.editor.markup.RangeHighlighter;
import com.intellij.openapi.editor.markup.TextAttributes;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.fileEditor.OpenFileDescriptor;
import com.intellij.openapi.keymap.KeymapUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.AbstractPainter;
import com.intellij.openapi.ui.Painter;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.wm.IdeGlassPaneUtil;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.ui.AutoScrollToSourceHandler;
import com.intellij.ui.DoubleClickListener;
import com.intellij.ui.JBSplitter;
import com.intellij.ui.PopupHandler;
import com.intellij.ui.ScrollPaneFactory;
import com.intellij.ui.SimpleColoredComponent;
import com.intellij.ui.treeStructure.Tree;
import com.intellij.usageView.UsageInfo;
import com.intellij.usageView.impl.SelectInEditorHandler;
import com.intellij.util.Alarm;
import com.intellij.util.EditSourceOnDoubleClickHandler;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.UIUtil;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionAdapter;
import java.awt.event.MouseMotionListener;
import java.lang.invoke.MethodHandles;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTree;
import javax.swing.ToolTipManager;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeCellRenderer;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreePath;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DuplicatesForm
implements Disposable {
    private final JLabel g;
    private final JLabel h;
    private final JPanel n;
    @NonNls
    private static final String l = "DuplicatesForm.SendToLeft";
    @NonNls
    private static final String f = "DuplicatesForm.SendToRight";
    @NonNls
    private static final String o = "find.locateDuplicates.result";
    private final JBSplitter c;
    private final Tree j;
    private final MyDuplicatesModelListener e;
    private final DupInfo r;
    private final Map<DuplicatesPresentation, DuplicatesView> s;
    private final Map<Editor, List<RangeHighlighter>> p;
    private final HighlightManager b;
    private DuplicatesModel d;
    private final Project k;
    private static final DataKey<DuplicatesModel> i;
    private static final String a = "DuplicatesForm.settings.scrollToSource";
    private final MyGlassPanePainter m;
    private static DupInfo q;
    private static final long t;

    private DuplicatesForm(Project project, DupInfo dupInfo) {
        long l2 = t ^ 0x284E885B5847L;
        this.g = new JLabel(AllIcons.Duplicates.SendToTheLeft);
        this.h = new JLabel(AllIcons.Duplicates.SendToTheRight);
        this.n = new JPanel(new BorderLayout());
        this.j = new Tree((TreeModel)new DefaultTreeModel(new DefaultMutableTreeNode()));
        this.e = new MyDuplicatesModelListener();
        this.s = new HashMap<DuplicatesPresentation, DuplicatesView>();
        this.p = new HashMap<Editor, List<RangeHighlighter>>();
        this.m = new MyGlassPanePainter();
        this.k = project;
        this.r = dupInfo;
        this.b = HighlightManager.getInstance((Project)this.k);
        DataProvider dataProvider = string -> {
            long l2 = t ^ 0x3B1F9342119CL;
            if (PlatformDataKeys.HELP_ID.is(string)) {
                return o;
            }
            if (i.is(string)) {
                return this.d;
            }
            if (this.d == null) {
                return null;
            }
            if (CommonDataKeys.NAVIGATABLE.getName().equals(string)) {
                CodeNode codeNode = this.d.getSelectedCodeNode();
                return codeNode != null ? codeNode.getOpenFileDescriptorIfValid() : null;
            }
            return null;
        };
        this.c = new MySplitter(dataProvider);
        this.c.setFirstComponent((JComponent)ScrollPaneFactory.createScrollPane((Component)this.j));
        ToolTipManager.sharedInstance().registerComponent((JComponent)this.j);
        SelectInEditorHandler.installKeyListener((JComponent)this.j);
        this.c();
        this.j.setShowsRootHandles(true);
        this.j.setRootVisible(false);
        final MyColoredTreeCellRenderer myColoredTreeCellRenderer = new MyColoredTreeCellRenderer();
        this.j.setCellRenderer((TreeCellRenderer)myColoredTreeCellRenderer);
        PopupHandler.installUnknownPopupHandler((JComponent)this.j, (ActionGroup)DuplicatesForm.a(this.getComponent()), (ActionManager)ActionManager.getInstance());
        this.j.addMouseListener((MouseListener)new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e10) {
                int n2 = DuplicatesForm.this.j.getRowForLocation(e10.getX(), e10.getY());
                if (n2 >= 0) {
                    Rectangle rectangle = DuplicatesForm.this.j.getRowBounds(n2);
                    myColoredTreeCellRenderer.setBounds(rectangle);
                    if (!DuplicatesForm.this.a(e10, rectangle.getLocation(), DuplicatesForm.this.g, 0)) {
                        DuplicatesForm.this.a(e10, new Point(rectangle.x + DuplicatesForm.this.g.getWidth(), rectangle.y), DuplicatesForm.this.h, 1);
                    }
                }
            }
        });
        this.n.add((Component)this.g, "West");
        this.n.add((Component)this.h, "East");
        this.n.setBackground(UIUtil.getTreeBackground());
        IdeGlassPaneUtil.installPainter((JComponent)this.j, (Painter)this.m, (Disposable)this);
        this.j.addMouseMotionListener((MouseMotionListener)new MouseMotionAdapter(){

            @Override
            public void mouseMoved(MouseEvent e10) {
                Object object;
                int n2 = DuplicatesForm.this.j.getRowForLocation(e10.getX(), e10.getY());
                if (n2 >= 0 && (object = DuplicatesForm.this.j.getPathForRow(n2).getLastPathComponent()) instanceof CodeNode) {
                    Rectangle rectangle = DuplicatesForm.this.j.getRowBounds(n2);
                    myColoredTreeCellRenderer.setBounds(rectangle);
                    Point point = e10.getPoint();
                    Rectangle rectangle2 = DuplicatesForm.this.g.getBounds();
                    rectangle2.setLocation(rectangle.getLocation());
                    Icon icon = null;
                    if (rectangle2.contains(point)) {
                        icon = AllIcons.Duplicates.SendToTheLeft;
                    } else {
                        rectangle2 = DuplicatesForm.this.h.getBounds();
                        rectangle2.setLocation(new Point(rectangle.x + AllIcons.Duplicates.SendToTheRight.getIconWidth(), rectangle.y));
                        if (rectangle2.contains(point)) {
                            icon = AllIcons.Duplicates.SendToTheRight;
                        }
                    }
                    if (icon != null) {
                        DuplicatesForm.this.m.setPaint(icon, rectangle2.getLocation());
                        return;
                    }
                }
                DuplicatesForm.this.m.setPaint(null, null);
            }
        });
    }

    private void c() {
        final EditSourceOnDoubleClickHandler.TreeMouseListener treeMouseListener = new EditSourceOnDoubleClickHandler.TreeMouseListener((JTree)this.j);
        new DoubleClickListener(){

            protected boolean onDoubleClick(MouseEvent e10) {
                treeMouseListener.onDoubleClick(e10);
                CodeNode codeNode = DuplicatesForm.this.b();
                if (codeNode != null) {
                    PsiFragment psiFragment = codeNode.getFragment();
                    UsageInfo usageInfo = psiFragment.getUsageInfo();
                    if (usageInfo == null) {
                        return true;
                    }
                    PsiElement[] psiElementArray = psiFragment.getElements();
                    assert (psiElementArray.length > 0);
                    PsiElement psiElement = psiElementArray[0];
                    OpenFileDescriptor openFileDescriptor = new OpenFileDescriptor(DuplicatesForm.this.k, usageInfo.getVirtualFile(), psiElement.getTextOffset());
                    Editor editor = FileEditorManager.getInstance((Project)DuplicatesForm.this.k).openTextEditor(openFileDescriptor, false);
                    if (editor != null) {
                        List list2 = (List)DuplicatesForm.this.p.get(editor);
                        if (list2 != null) {
                            for (RangeHighlighter rangeHighlighter : list2) {
                                DuplicatesForm.this.b.removeSegmentHighlighter(editor, rangeHighlighter);
                            }
                        }
                        List<RangeHighlighter> list3 = DuplicatesForm.highlightPsiFragment(editor, psiFragment, DuplicatesForm.this.b, 0);
                        DuplicatesForm.this.p.put(editor, list3);
                    }
                }
                return true;
            }
        }.installOn((Component)this.j);
    }

    private boolean a(MouseEvent mouseEvent, Point point, JLabel jLabel, int n2) {
        Point point2 = mouseEvent.getPoint();
        Rectangle rectangle = jLabel.getBounds();
        rectangle.setLocation(point);
        CodeNode codeNode = this.d.getSelectedCodeNode();
        if (codeNode != null && rectangle.contains(point2)) {
            this.d.setDiff(n2, codeNode);
            mouseEvent.consume();
            return true;
        }
        return false;
    }

    public JTree getDuplicatesTree() {
        return this.j;
    }

    private static DefaultActionGroup a(JComponent jComponent) {
        long l2 = t ^ 0xDAF332D1061L;
        DefaultActionGroup defaultActionGroup = new DefaultActionGroup();
        ActionManager actionManager = ActionManager.getInstance();
        defaultActionGroup.add(actionManager.getAction("EditSource"));
        defaultActionGroup.add(actionManager.getAction("ViewSource"));
        defaultActionGroup.addSeparator();
        AnAction anAction = actionManager.getAction(l);
        anAction.registerCustomShortcutSet(anAction.getShortcutSet(), jComponent);
        defaultActionGroup.add(anAction);
        anAction = actionManager.getAction(f);
        anAction.registerCustomShortcutSet(anAction.getShortcutSet(), jComponent);
        defaultActionGroup.add(anAction);
        return defaultActionGroup;
    }

    public void addToolbarActionsTo(ContentPanel panel2) {
        panel2.addActionSeparator();
        AutoScrollToSourceHandler autoScrollToSourceHandler = new AutoScrollToSourceHandler(){
            private static final long a = lb.a(-4052107084203584702L, -5084368782643110859L, MethodHandles.lookup().lookupClass()).a(274276737727192L);

            protected boolean isAutoScrollMode() {
                long l2 = a ^ 0x2B16ECFF6DA3L;
                return PropertiesComponent.getInstance().getBoolean(DuplicatesForm.a);
            }

            protected void setAutoScrollMode(boolean state) {
                long l2 = a ^ 0x292A3FE1213DL;
                PropertiesComponent.getInstance().setValue(DuplicatesForm.a, state);
            }
        };
        autoScrollToSourceHandler.install((JTree)this.j);
        panel2.addAction((AnAction)autoScrollToSourceHandler.createToggleAction());
        if (DuplicatesForm.a()) {
            panel2.addAction(new EliminateDuplicatesAction(this));
        }
        panel2.addAction(new ExportHTMLAction(this.d.getRoot()));
    }

    private static boolean a() {
        for (int i10 = 0; i10 < q.getPatterns(); ++i10) {
            DuplicatesPresentation duplicatesPresentation = DuplicatesPresentationCache.getPresentation(q, i10);
            if (duplicatesPresentation == null || !duplicatesPresentation.isFixAbilityProvided()) continue;
            return true;
        }
        return false;
    }

    @Nullable
    private CodeNode b() {
        BasicTreeNode basicTreeNode;
        CodeNode codeNode = this.d.getSelectedCodeNode();
        if (codeNode != null) {
            return codeNode;
        }
        TreePath treePath = this.j.getSelectionPath();
        if (treePath != null && (basicTreeNode = (BasicTreeNode)treePath.getLastPathComponent()) instanceof GroupNode && basicTreeNode.getChildCount() > 0) {
            return (CodeNode)basicTreeNode.getChildAt(0);
        }
        return null;
    }

    private void a(DuplicatesModel duplicatesModel) {
        if (this.d != null) {
            this.d.removeListener(this.e);
        }
        this.d = duplicatesModel;
        this.j.setModel(duplicatesModel.getTreeModel());
        this.j.setSelectionModel(duplicatesModel.getSelectionModel());
        duplicatesModel.addListener(this.e);
        this.e.a();
    }

    public JComponent getComponent() {
        return this.c;
    }

    public static DuplicatesForm create(Project project, DupInfo duplicates) {
        q = duplicates;
        PsiDocumentManager.getInstance((Project)project).commitAllDocuments();
        DuplicatesForm duplicatesForm = new DuplicatesForm(project, duplicates);
        DuplicatesModel duplicatesModel = new DuplicatesModel(duplicates, project);
        duplicatesForm.a(duplicatesModel);
        return duplicatesForm;
    }

    public void dispose() {
        for (Editor editor : this.p.keySet()) {
            List<RangeHighlighter> list2 = this.p.get(editor);
            for (RangeHighlighter rangeHighlighter : list2) {
                this.b.removeSegmentHighlighter(editor, rangeHighlighter);
            }
        }
        DuplicatesProfileCache.clear(this.r);
        DuplicatesPresentationCache.clear(this.r);
    }

    public static List<RangeHighlighter> highlightPsiFragment(Editor editor, PsiFragment fragment, HighlightManager highlightManager, int firstOffset) {
        PsiElement[] psiElementArray = fragment.getElements();
        EditorColorsManager editorColorsManager = EditorColorsManager.getInstance();
        TextAttributes textAttributes = editorColorsManager.getGlobalScheme().getAttributes(EditorColors.SEARCH_RESULT_ATTRIBUTES);
        ArrayList<RangeHighlighter> arrayList = new ArrayList<RangeHighlighter>();
        for (PsiElement psiElement : psiElementArray) {
            if (psiElement == null) continue;
            TextRange textRange = psiElement.getTextRange();
            int n2 = textRange.getStartOffset() - firstOffset;
            int n3 = textRange.getEndOffset() - firstOffset;
            highlightManager.addRangeHighlight(editor, n2, n3, textAttributes, false, arrayList);
        }
        return arrayList;
    }

    static {
        t = lb.a(-456300039310415487L, 6485881822242763219L, MethodHandles.lookup().lookupClass()).a(281242416182778L);
        long l2 = t ^ 0x5D9D6A546F5FL;
        i = DataKey.create((String)"DUPLICATES_MODEL");
    }

    private class EliminateDuplicatesAction
    extends AnAction {
        final /* synthetic */ DuplicatesForm this$0;
        private static final long a = lb.a(8167785932270750906L, 7449089716898899083L, MethodHandles.lookup().lookupClass()).a(8545440387687L);

        EliminateDuplicatesAction(DuplicatesForm duplicatesForm) {
            long l2 = a ^ 0x10E4F8BBB2C6L;
            this.this$0 = duplicatesForm;
            super(DupLocatorBundle.messagePointer("eliminate.duplicates.action.text", new Object[0]), DupLocatorBundle.messagePointer("eliminate.duplicates.action.text", new Object[0]), AllIcons.Actions.Replace);
        }

        public void actionPerformed(@NotNull AnActionEvent e10) {
            if (e10 == null) {
                EliminateDuplicatesAction.a(0);
            }
            CodeNode codeNode = this.this$0.b();
            assert (codeNode != null);
            DuplicatesPresentation duplicatesPresentation = codeNode.getPresentation();
            assert (duplicatesPresentation != null);
            duplicatesPresentation.applyFix(codeNode);
        }

        public void update(@NotNull AnActionEvent e10) {
            CodeNode codeNode;
            boolean bl2;
            if (e10 == null) {
                EliminateDuplicatesAction.a(1);
            }
            boolean bl3 = bl2 = (codeNode = this.this$0.b()) != null;
            if (bl2) {
                DuplicatesPresentation duplicatesPresentation = codeNode.getPresentation();
                bl2 = duplicatesPresentation != null && duplicatesPresentation.isFixAvailable(codeNode);
            }
            e10.getPresentation().setEnabled(bl2);
        }

        private static /* synthetic */ void a(int n2) {
            Object[] objectArray;
            long l2 = a ^ 0x7836BF95AD66L;
            Object[] objectArray2 = new Object[3];
            objectArray2[0] = "e";
            objectArray2[1] = "com/intellij/dupLocator/resultUI/DuplicatesForm$EliminateDuplicatesAction";
            switch (n2) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "actionPerformed";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "update";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static class MyGlassPanePainter
    extends AbstractPainter {
        private Icon a;
        private Point b;

        private MyGlassPanePainter() {
        }

        public boolean setPaint(Icon icon, Point point) {
            this.a = (Icon)this.setNeedsRepaint(this.a, icon);
            this.b = (Point)this.setNeedsRepaint(this.b, point);
            return this.needsRepaint();
        }

        public void executePaint(Component component, Graphics2D g10) {
            if (this.a == null) {
                return;
            }
            this.a.paintIcon(component, g10, this.b.x, this.b.y);
        }
    }

    private class MyDuplicatesModelListener
    implements DuplicatesModel.Listener {
        private final Alarm a = new Alarm();

        private MyDuplicatesModelListener() {
        }

        @Override
        public void onSelectionChanged() {
            this.a.cancelAllRequests();
            DuplicatesModel duplicatesModel = DuplicatesForm.this.d;
            this.a.addRequest(() -> {
                if (duplicatesModel == DuplicatesForm.this.d && DuplicatesForm.this.c.isDisplayable()) {
                    this.a();
                }
            }, 200);
        }

        private void a() {
            JComponent jComponent;
            CodeNode codeNode = DuplicatesForm.this.d.getLeft();
            CodeNode codeNode2 = DuplicatesForm.this.d.getRight();
            if (codeNode == null || codeNode2 == null) {
                return;
            }
            DuplicatesPresentation duplicatesPresentation = codeNode.getPresentation();
            DuplicatesView duplicatesView = null;
            if (duplicatesPresentation != null && (duplicatesView = (DuplicatesView)DuplicatesForm.this.s.get(duplicatesPresentation)) == null) {
                duplicatesView = duplicatesPresentation.createView(DuplicatesForm.this.k);
                Disposer.register((Disposable)DuplicatesForm.this, (Disposable)duplicatesView);
                DuplicatesForm.this.s.put(duplicatesPresentation, duplicatesView);
            }
            JComponent jComponent2 = DuplicatesForm.this.c.getSecondComponent();
            JComponent jComponent3 = jComponent = duplicatesView != null ? duplicatesView.getComponent() : null;
            if (jComponent != jComponent2) {
                if (jComponent2 != null) {
                    jComponent2.setVisible(false);
                }
                DuplicatesForm.this.c.setSecondComponent(jComponent);
                if (jComponent != null) {
                    jComponent.setMinimumSize((Dimension)JBUI.size((int)10));
                    jComponent.setVisible(true);
                }
            }
            if (duplicatesView != null) {
                duplicatesView.setContent(codeNode, codeNode2);
            }
            DuplicatesForm.this.j.repaint();
        }
    }

    private static class SendToAction
    extends AnAction {
        private final int a;
        private static final long b = lb.a(311132320392432511L, -4699040530278609703L, MethodHandles.lookup().lookupClass()).a(155847109870963L);

        SendToAction(String text, String description, Icon icon, String actionId, int diffIndex) {
            super(text, description, icon);
            this.a = diffIndex;
            this.registerCustomShortcutSet(KeymapUtil.getActiveKeymapShortcuts((String)actionId), null);
        }

        public void actionPerformed(@NotNull AnActionEvent e10) {
            if (e10 == null) {
                SendToAction.a(0);
            }
            DuplicatesModel duplicatesModel = (DuplicatesModel)e10.getData(i);
            duplicatesModel.setDiff(this.a, duplicatesModel.getSelectedCodeNode());
        }

        public void update(@NotNull AnActionEvent e10) {
            if (e10 == null) {
                SendToAction.a(1);
            }
            Presentation presentation = e10.getPresentation();
            DuplicatesModel duplicatesModel = (DuplicatesModel)e10.getData(i);
            if (duplicatesModel == null) {
                presentation.setEnabled(false);
                return;
            }
            CodeNode codeNode = duplicatesModel.getSelectedCodeNode();
            if (codeNode == null) {
                presentation.setEnabled(false);
                return;
            }
            presentation.setEnabled(true);
        }

        private static /* synthetic */ void a(int n2) {
            Object[] objectArray;
            long l2 = b ^ 0xAC2E5A7557CL;
            Object[] objectArray2 = new Object[3];
            objectArray2[0] = "e";
            objectArray2[1] = "com/intellij/dupLocator/resultUI/DuplicatesForm$SendToAction";
            switch (n2) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "actionPerformed";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "update";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static class MySplitter
    extends JBSplitter
    implements DataProvider {
        private final DataProvider a;
        private static final long b = lb.a(-5473694358669235564L, 6485201042933413904L, MethodHandles.lookup().lookupClass()).a(224085688770911L);

        MySplitter(DataProvider dataProvider) {
            long l2 = b ^ 0x79647CE39E5AL;
            super("DuplicatesForm.settings", 0.3f);
            this.a = dataProvider;
        }

        public Object getData(@NotNull String dataId) {
            if (dataId == null) {
                MySplitter.a(0);
            }
            return this.a.getData(dataId);
        }

        private static /* synthetic */ void a(int n2) {
            long l2 = b ^ 0x41DE7AC78FA5L;
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dataId", "com/intellij/dupLocator/resultUI/DuplicatesForm$MySplitter", "getData"));
        }
    }

    private class MyColoredTreeCellRenderer
    extends DefaultTreeCellRenderer {
        private static final long a = lb.a(-3537133559357026973L, 2990813666694142611L, MethodHandles.lookup().lookupClass()).a(210783073880234L);

        private MyColoredTreeCellRenderer() {
        }

        @Override
        public Component getTreeCellRendererComponent(JTree tree, Object value, boolean sel, boolean expanded, boolean leaf, int row, boolean hasFocus) {
            long l2 = a ^ 0x31744D53E6E4L;
            JPanel jPanel = new JPanel(new BorderLayout(5, 0));
            Color color = UIUtil.getTreeBackground((boolean)sel, (boolean)true);
            UIUtil.changeBackGround((Component)jPanel, (Color)color);
            SimpleColoredComponent simpleColoredComponent = new SimpleColoredComponent();
            simpleColoredComponent.setOpaque(true);
            jPanel.add((Component)simpleColoredComponent, "Center");
            if (value instanceof GroupNode) {
                ((GroupNode)value).getTitle(sel).customize(simpleColoredComponent);
            } else if (value instanceof CodeNode) {
                CodeNode codeNode = (CodeNode)value;
                jPanel.add((Component)DuplicatesForm.this.n, "West");
                DuplicatesForm.this.g.setIcon(codeNode.isLeftInDiff() ? AllIcons.Duplicates.SendToTheLeft : AllIcons.Duplicates.SendToTheLeftGrayed);
                DuplicatesForm.this.h.setIcon(codeNode.isRightInDiff() ? AllIcons.Duplicates.SendToTheRight : AllIcons.Duplicates.SendToTheRightGrayed);
                codeNode.getTitle(sel).customize(simpleColoredComponent);
                jPanel.setToolTipText(DupLocatorBundle.message("tooltip.tree.text", new Object[0]));
            }
            return jPanel;
        }
    }

    public static class SendToLeftAction
    extends SendToAction {
        private static final long c = lb.a(7251590870553301174L, 1024595202312097059L, MethodHandles.lookup().lookupClass()).a(24971485881745L);

        public SendToLeftAction() {
            long l2 = c ^ 0x2589AB833D2AL;
            super(DupLocatorBundle.message("duplicates.send.to.left.action", new Object[0]), DupLocatorBundle.message("duplicates.send.to.left.action.description", new Object[0]), AllIcons.Duplicates.SendToTheLeft, DuplicatesForm.l, 0);
        }
    }

    public static class SendToRightAction
    extends SendToAction {
        private static final long c = lb.a(-4341169208030145254L, -4852331889225640451L, MethodHandles.lookup().lookupClass()).a(277935638057901L);

        public SendToRightAction() {
            long l2 = c ^ 0x119EFA3B230CL;
            super(DupLocatorBundle.message("duplicates.send.to.right.action", new Object[0]), DupLocatorBundle.message("duplicates.send.to.right.action.description", new Object[0]), AllIcons.Duplicates.SendToTheRight, DuplicatesForm.f, 1);
        }
    }
}

