/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.xml.util.documentation;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.ArrayUtilRt;
import java.io.IOException;
import java.io.InputStream;
import java.util.Set;
import java.util.TreeSet;

public class MimeTypeDictionary {
    public static final String[] HTML_CONTENT_TYPES = ArrayUtilRt.toStringArray(MimeTypeDictionary.loadContentTypes());

    private static Set<String> loadContentTypes() {
        TreeSet<String> result = new TreeSet<String>();
        result.add("*/*");
        MimeTypeDictionary.readMediaTypes(result, "application");
        MimeTypeDictionary.readMediaTypes(result, "audio");
        MimeTypeDictionary.readMediaTypes(result, "image");
        MimeTypeDictionary.readMediaTypes(result, "message");
        MimeTypeDictionary.readMediaTypes(result, "model");
        MimeTypeDictionary.readMediaTypes(result, "multipart");
        MimeTypeDictionary.readMediaTypes(result, "text");
        MimeTypeDictionary.readMediaTypes(result, "video");
        return result;
    }

    private static void readMediaTypes(TreeSet<? super String> result, String category) {
        String[] lines;
        InputStream stream = MimeTypeDictionary.class.getResourceAsStream("mimeTypes/" + category + ".csv");
        String csv = "";
        try {
            csv = stream != null ? FileUtil.loadTextAndClose((InputStream)stream) : "";
        }
        catch (IOException e) {
            Logger.getInstance(MimeTypeDictionary.class).error((Throwable)e);
        }
        for (String line : lines = StringUtil.splitByLines((String)csv)) {
            String[] split;
            if (line == lines[0] || (split = line.split(",")).length <= 1) continue;
            result.add(!split[1].isEmpty() ? split[1] : MimeTypeDictionary.withCategory(category, split[0]));
        }
    }

    private static String withCategory(String category, String name) {
        int whitespacePosition = name.indexOf(32);
        return category + "/" + (whitespacePosition > 0 ? name.substring(0, whitespacePosition) : name);
    }
}

