/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.tasks.redmine;

import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.ComboBox;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.tasks.TaskBundle;
import com.intellij.tasks.config.BaseRepositoryEditor;
import com.intellij.tasks.impl.BaseRepository;
import com.intellij.tasks.impl.TaskUiUtil;
import com.intellij.tasks.redmine.RedmineRepository;
import com.intellij.tasks.redmine.model.RedmineProject;
import com.intellij.ui.SimpleListCellRenderer;
import com.intellij.ui.components.JBCheckBox;
import com.intellij.ui.components.JBLabel;
import com.intellij.util.Consumer;
import com.intellij.util.containers.Stack;
import com.intellij.util.ui.FormBuilder;
import com.intellij.util.ui.UIUtil;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JPasswordField;
import javax.swing.JTextField;
import javax.swing.ListCellRenderer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class RedmineRepositoryEditor
extends BaseRepositoryEditor<RedmineRepository> {
    private ComboBox<RedmineProjectItem> myProjectCombo;
    private JTextField myAPIKey;
    private JCheckBox myAllAssigneesCheckBox;
    private JBLabel myProjectLabel;
    private JBLabel myAPIKeyLabel;

    public RedmineRepositoryEditor(Project project, RedmineRepository repository, Consumer<? super RedmineRepository> changeListener) {
        super(project, (BaseRepository)repository, changeListener);
        this.myTestButton.setEnabled(((RedmineRepository)this.myRepository).isConfigured());
        this.myAPIKey.setText(repository.getAPIKey());
        this.myAllAssigneesCheckBox.setSelected(!repository.isAssignedToMe());
        this.installListener((JComboBox)this.myProjectCombo);
        this.installListener(this.myAPIKey);
        this.installListener(this.myAllAssigneesCheckBox);
        this.toggleCredentialsVisibility();
        UIUtil.invokeLaterIfNeeded(() -> this.initialize());
    }

    protected void afterTestConnection(boolean connectionSuccessful) {
        if (connectionSuccessful) {
            new FetchProjectsTask().queue();
        } else {
            this.myProjectCombo.removeAllItems();
        }
    }

    private void initialize() {
        RedmineProject currentProject = ((RedmineRepository)this.myRepository).getCurrentProject();
        if (currentProject != null && ((RedmineRepository)this.myRepository).isConfigured()) {
            new FetchProjectsTask().queue();
        } else {
            this.myProjectCombo.removeAllItems();
        }
    }

    public void apply() {
        super.apply();
        RedmineProjectItem selected = (RedmineProjectItem)this.myProjectCombo.getSelectedItem();
        ((RedmineRepository)this.myRepository).setCurrentProject(selected != null ? selected.myProject : null);
        ((RedmineRepository)this.myRepository).setAPIKey(this.myAPIKey.getText().trim());
        ((RedmineRepository)this.myRepository).setAssignedToMe(!this.myAllAssigneesCheckBox.isSelected());
        this.myTestButton.setEnabled(((RedmineRepository)this.myRepository).isConfigured());
        this.toggleCredentialsVisibility();
    }

    private void toggleCredentialsVisibility() {
        this.myPasswordLabel.setVisible(((RedmineRepository)this.myRepository).isUseHttpAuthentication());
        this.myPasswordText.setVisible(((RedmineRepository)this.myRepository).isUseHttpAuthentication());
        this.myUsernameLabel.setVisible(((RedmineRepository)this.myRepository).isUseHttpAuthentication());
        this.myUserNameText.setVisible(((RedmineRepository)this.myRepository).isUseHttpAuthentication());
        this.myAPIKeyLabel.setVisible(!((RedmineRepository)this.myRepository).isUseHttpAuthentication());
        this.myAPIKey.setVisible(!((RedmineRepository)this.myRepository).isUseHttpAuthentication());
    }

    @Nullable
    protected JComponent createCustomPanel() {
        this.myProjectLabel = new JBLabel("Project:", 4);
        this.myProjectCombo = new ComboBox(300);
        this.myProjectCombo.setRenderer((ListCellRenderer)SimpleListCellRenderer.create((String)"Set URL and password/token first", value -> {
            if (this.myProjectCombo.isPopupVisible()) {
                return StringUtil.repeat((String)"   ", (int)value.myLevel) + value.myProject.getName();
            }
            return value.myProject.getName();
        }));
        this.myAPIKeyLabel = new JBLabel("API Token:", 4);
        this.myAPIKey = new JPasswordField();
        this.myAllAssigneesCheckBox = new JBCheckBox(TaskBundle.message((String)"checkbox.include.issues.not.assigned.to.me", (Object[])new Object[0]));
        return FormBuilder.createFormBuilder().addLabeledComponent((JComponent)this.myAPIKeyLabel, (JComponent)this.myAPIKey).addLabeledComponent((JComponent)this.myProjectLabel, this.myProjectCombo).addComponentToRightColumn((JComponent)this.myAllAssigneesCheckBox).getPanel();
    }

    public void setAnchor(@Nullable JComponent anchor) {
        super.setAnchor(anchor);
        this.myProjectLabel.setAnchor(anchor);
        this.myAPIKeyLabel.setAnchor(anchor);
    }

    private class FetchProjectsTask
    extends TaskUiUtil.ComboBoxUpdater<RedmineProjectItem> {
        private FetchProjectsTask() {
            super(RedmineRepositoryEditor.this.myProject, "Downloading Redmine projects...", RedmineRepositoryEditor.this.myProjectCombo);
        }

        @Override
        public RedmineProjectItem getExtraItem() {
            return new RedmineProjectItem(RedmineRepository.UNSPECIFIED_PROJECT, 0);
        }

        @Override
        @Nullable
        public RedmineProjectItem getSelectedItem() {
            RedmineProject currentProject = ((RedmineRepository)RedmineRepositoryEditor.this.myRepository).getCurrentProject();
            return currentProject != null ? new RedmineProjectItem(currentProject, -1) : null;
        }

        @Override
        @NotNull
        protected List<RedmineProjectItem> fetch(@NotNull ProgressIndicator indicator) throws Exception {
            if (indicator == null) {
                FetchProjectsTask.$$$reportNull$$$0(0);
            }
            Stack parents = new Stack();
            ArrayList<RedmineProjectItem> items = new ArrayList<RedmineProjectItem>();
            for (RedmineProject project : ((RedmineRepository)RedmineRepositoryEditor.this.myRepository).fetchProjects()) {
                RedmineProject parentProject = project.getParent();
                if (parentProject == null) {
                    items.add(new RedmineProjectItem(project, 0));
                    parents.clear();
                } else {
                    while (!parents.isEmpty() && !((RedmineProject)parents.peek()).equals(parentProject)) {
                        parents.pop();
                    }
                    items.add(new RedmineProjectItem(project, parents.size()));
                }
                parents.push((Object)project);
            }
            ArrayList<RedmineProjectItem> arrayList = items;
            if (arrayList == null) {
                FetchProjectsTask.$$$reportNull$$$0(1);
            }
            return arrayList;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 1: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 1: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "indicator";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/tasks/redmine/RedmineRepositoryEditor$FetchProjectsTask";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/tasks/redmine/RedmineRepositoryEditor$FetchProjectsTask";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "fetch";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "fetch";
                    break;
                }
                case 1: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 1: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    private static class RedmineProjectItem {
        public final RedmineProject myProject;
        public final int myLevel;

        RedmineProjectItem(@NotNull RedmineProject project, int level) {
            if (project == null) {
                RedmineProjectItem.$$$reportNull$$$0(0);
            }
            this.myProject = project;
            this.myLevel = level;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null) {
                return false;
            }
            if (o instanceof RedmineProject) {
                return this.myProject.equals(o);
            }
            if (o instanceof RedmineProjectItem) {
                return this.myProject.equals(((RedmineProjectItem)o).myProject);
            }
            return false;
        }

        public int hashCode() {
            return this.myProject.hashCode();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/tasks/redmine/RedmineRepositoryEditor$RedmineProjectItem", "<init>"));
        }
    }
}

