/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.plugins.remotesdk.ui;

import com.intellij.openapi.ui.TextFieldWithBrowseButton;
import com.intellij.remote.RemoteCredentials;
import com.intellij.ui.ComboboxWithBrowseButton;
import com.intellij.util.AsyncProducer;
import com.intellij.util.ui.UIUtil;
import com.jetbrains.plugins.remotesdk.RemoteSdkUtil;
import com.jetbrains.plugins.webDeployment.config.Deployable;
import com.jetbrains.plugins.webDeployment.config.WebServerConfig;
import com.jetbrains.plugins.webDeployment.ui.ServerBrowserDialog;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JTextField;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;

public class RemoteBrowseActionListener
implements ActionListener {
    private final JTextField myPathField;
    private final String myTitle;
    private final AsyncProducer<? extends RemoteCredentials> mySdkDataProducer;
    private boolean myFoldersOnly = false;

    public RemoteBrowseActionListener(JTextField pathField, String title, AsyncProducer<? extends RemoteCredentials> sdkDataProducer) {
        this.myPathField = pathField;
        this.myTitle = title;
        this.mySdkDataProducer = sdkDataProducer;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        RemoteBrowseActionListener.showBrowseDialog(this.myPathField, this.myTitle, this.myFoldersOnly, this.mySdkDataProducer);
    }

    public static void showBrowseDialog(@NotNull JTextField pathField, @Nls @NotNull String title, boolean foldersOnly, @NotNull AsyncProducer<? extends RemoteCredentials> sdkDataProducer) {
        if (pathField == null) {
            RemoteBrowseActionListener.$$$reportNull$$$0(0);
        }
        if (title == null) {
            RemoteBrowseActionListener.$$$reportNull$$$0(1);
        }
        if (sdkDataProducer == null) {
            RemoteBrowseActionListener.$$$reportNull$$$0(2);
        }
        sdkDataProducer.produce(data -> {
            if (RemoteSdkUtil.testConnection((Component)pathField, data, false)) {
                UIUtil.invokeLaterIfNeeded(() -> {
                    WebServerConfig.RemotePath path;
                    ServerBrowserDialog d = RemoteSdkUtil.showBrowseRemoteDialog(title, pathField, foldersOnly, (Deployable)RemoteSdkUtil.createDeployable(data));
                    if (d.isOK() && (path = d.getPath()) != null) {
                        pathField.setText(path.path);
                    }
                });
            }
        });
    }

    public RemoteBrowseActionListener withFoldersOnly(boolean foldersOnly) {
        this.myFoldersOnly = foldersOnly;
        return this;
    }

    public static void addShowBrowseRemoteDialogAction(TextFieldWithBrowseButton pathField, String title, AsyncProducer<? extends RemoteCredentials> producer) {
        pathField.addActionListener((ActionListener)new RemoteBrowseActionListener(pathField.getTextField(), title, producer));
    }

    public static void addShowBrowseRemoteDialogAction(ComboboxWithBrowseButton pathField, String title, AsyncProducer<? extends RemoteCredentials> producer) {
        Component component = pathField.getComboBox().getEditor().getEditorComponent();
        if (component instanceof JTextField) {
            pathField.addActionListener((ActionListener)new RemoteBrowseActionListener((JTextField)component, title, producer));
        }
    }

    public static void addShowBrowseRemoteDialogAction(JTextField pathField, JButton button, String title, AsyncProducer<? extends RemoteCredentials> producer) {
        button.addActionListener(new RemoteBrowseActionListener(pathField, title, producer));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "pathField";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "title";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[0] = "sdkDataProducer";
                break;
            }
        }
        objectArray[1] = "com/jetbrains/plugins/remotesdk/ui/RemoteBrowseActionListener";
        objectArray[2] = "showBrowseDialog";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

