/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.svn.diff;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.FileStatus;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vcs.changes.Change;
import com.intellij.openapi.vcs.changes.ContentRevision;
import com.intellij.openapi.vcs.changes.CurrentContentRevision;
import com.intellij.vcsUtil.VcsUtil;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import javax.xml.bind.JAXBException;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlElementWrapper;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlValue;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.svn.SvnUtil;
import org.jetbrains.idea.svn.WorkingCopyFormat;
import org.jetbrains.idea.svn.api.BaseSvnClient;
import org.jetbrains.idea.svn.api.NodeKind;
import org.jetbrains.idea.svn.api.Revision;
import org.jetbrains.idea.svn.api.Target;
import org.jetbrains.idea.svn.commandLine.CommandExecutor;
import org.jetbrains.idea.svn.commandLine.CommandUtil;
import org.jetbrains.idea.svn.commandLine.SvnBindException;
import org.jetbrains.idea.svn.commandLine.SvnCommandName;
import org.jetbrains.idea.svn.diff.DiffClient;
import org.jetbrains.idea.svn.history.SvnRepositoryContentRevision;
import org.jetbrains.idea.svn.status.Status;
import org.jetbrains.idea.svn.status.StatusType;

public class CmdDiffClient
extends BaseSvnClient
implements DiffClient {
    private static final Logger LOG = Logger.getInstance(CmdDiffClient.class);

    @Override
    @NotNull
    public List<Change> compare(@NotNull Target target1, @NotNull Target target2) throws VcsException {
        if (target1 == null) {
            CmdDiffClient.$$$reportNull$$$0(0);
        }
        if (target2 == null) {
            CmdDiffClient.$$$reportNull$$$0(1);
        }
        this.assertUrl(target1);
        if (target2.isFile()) {
            this.assertDirectory(target2);
            WorkingCopyFormat format = WorkingCopyFormat.from(this.myFactory.createVersionClient().getVersion());
            if (format.less(WorkingCopyFormat.ONE_DOT_EIGHT)) {
                throw new SvnBindException("Could not compare local file and remote url with executable for svn " + (Object)((Object)format));
            }
        }
        ArrayList<String> parameters = new ArrayList<String>();
        CommandUtil.put(parameters, target1);
        CommandUtil.put(parameters, target2);
        parameters.add("--xml");
        parameters.add("--summarize");
        CommandExecutor executor = this.execute(this.myVcs, target1, SvnCommandName.diff, parameters, null);
        return this.parseOutput(target1, target2, executor);
    }

    @Override
    public void unifiedDiff(@NotNull Target target1, @NotNull Target target2, @NotNull OutputStream output) throws VcsException {
        if (target1 == null) {
            CmdDiffClient.$$$reportNull$$$0(2);
        }
        if (target2 == null) {
            CmdDiffClient.$$$reportNull$$$0(3);
        }
        if (output == null) {
            CmdDiffClient.$$$reportNull$$$0(4);
        }
        this.assertUrl(target1);
        this.assertUrl(target2);
        ArrayList<String> parameters = new ArrayList<String>();
        CommandUtil.put(parameters, target1);
        CommandUtil.put(parameters, target2);
        CommandExecutor executor = this.execute(this.myVcs, target1, SvnCommandName.diff, parameters, null);
        try {
            executor.getBinaryOutput().writeTo(output);
        }
        catch (IOException e) {
            throw new SvnBindException(e);
        }
    }

    @NotNull
    private List<Change> parseOutput(@NotNull Target target1, @NotNull Target target2, @NotNull CommandExecutor executor) throws SvnBindException {
        ArrayList<Change> arrayList;
        if (target1 == null) {
            CmdDiffClient.$$$reportNull$$$0(5);
        }
        if (target2 == null) {
            CmdDiffClient.$$$reportNull$$$0(6);
        }
        if (executor == null) {
            CmdDiffClient.$$$reportNull$$$0(7);
        }
        try {
            DiffInfo diffInfo = CommandUtil.parse(executor.getOutput(), DiffInfo.class);
            ArrayList<Change> result = new ArrayList<Change>();
            if (diffInfo != null) {
                for (DiffPath path : diffInfo.diffPaths) {
                    result.add(this.createChange(target1, target2, path));
                }
            }
            arrayList = result;
        }
        catch (JAXBException e) {
            throw new SvnBindException(e);
        }
        if (arrayList == null) {
            CmdDiffClient.$$$reportNull$$$0(8);
        }
        return arrayList;
    }

    @NotNull
    private ContentRevision createRevision(@NotNull FilePath path, @NotNull FilePath localPath, @NotNull Revision revision, @NotNull FileStatus status) {
        if (path == null) {
            CmdDiffClient.$$$reportNull$$$0(9);
        }
        if (localPath == null) {
            CmdDiffClient.$$$reportNull$$$0(10);
        }
        if (revision == null) {
            CmdDiffClient.$$$reportNull$$$0(11);
        }
        if (status == null) {
            CmdDiffClient.$$$reportNull$$$0(12);
        }
        ContentRevision result = path.isNonLocal() ? SvnRepositoryContentRevision.create(this.myVcs, path, (FilePath)(status == FileStatus.DELETED ? localPath : null), revision.getNumber()) : CurrentContentRevision.create((FilePath)path);
        ContentRevision contentRevision = result;
        if (contentRevision == null) {
            CmdDiffClient.$$$reportNull$$$0(13);
        }
        return contentRevision;
    }

    private static FilePath createFilePath(@NotNull Target target, boolean isDirectory) {
        if (target == null) {
            CmdDiffClient.$$$reportNull$$$0(14);
        }
        return target.isFile() ? VcsUtil.getFilePath((File)target.getFile(), (boolean)isDirectory) : VcsUtil.getFilePathOnNonLocal((String)SvnUtil.toDecodedString(target), (boolean)isDirectory);
    }

    @NotNull
    private Change createChange(@NotNull Target target1, @NotNull Target target2, @NotNull DiffPath diffPath) throws SvnBindException {
        Target subTarget1;
        String relativePath;
        if (target1 == null) {
            CmdDiffClient.$$$reportNull$$$0(15);
        }
        if (target2 == null) {
            CmdDiffClient.$$$reportNull$$$0(16);
        }
        if (diffPath == null) {
            CmdDiffClient.$$$reportNull$$$0(17);
        }
        if ((relativePath = SvnUtil.getRelativeUrl(target1, subTarget1 = SvnUtil.append(target1, diffPath.path, true))) == null) {
            throw new SvnBindException("Could not get relative path for " + target1 + " and " + subTarget1);
        }
        Target subTarget2 = SvnUtil.append(target2, FileUtil.toSystemIndependentName((String)relativePath));
        FilePath target1Path = CmdDiffClient.createFilePath(subTarget1, diffPath.isDirectory());
        FilePath target2Path = CmdDiffClient.createFilePath(subTarget2, diffPath.isDirectory());
        FileStatus status = Status.convertStatus(CmdDiffClient.getStatus(diffPath.itemStatus), CmdDiffClient.getStatus(diffPath.propertiesStatus), false, false);
        ContentRevision beforeRevision = status == FileStatus.ADDED ? null : this.createRevision(target1Path, target2Path, target1.getPegRevision(), status);
        ContentRevision afterRevision = status == FileStatus.DELETED ? null : this.createRevision(target2Path, target1Path, target2.getPegRevision(), status);
        return CmdDiffClient.createChange(status, beforeRevision, afterRevision);
    }

    @NotNull
    private static Change createChange(@NotNull FileStatus status, @Nullable ContentRevision beforeRevision, @Nullable ContentRevision afterRevision) {
        if (status == null) {
            CmdDiffClient.$$$reportNull$$$0(18);
        }
        return new Change(beforeRevision, afterRevision, status){

            public boolean isRenamed() {
                return false;
            }

            public boolean isMoved() {
                return false;
            }
        };
    }

    @Nullable
    private static StatusType getStatus(@NotNull String code) {
        StatusType result;
        if (code == null) {
            CmdDiffClient.$$$reportNull$$$0(19);
        }
        if ((result = StatusType.forStatusOperation(code)) == null) {
            LOG.info("Unknown status type " + code);
        }
        return result;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 8: 
            case 13: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 8: 
            case 13: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "target1";
                break;
            }
            case 1: 
            case 3: 
            case 6: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "target2";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "output";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "executor";
                break;
            }
            case 8: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/idea/svn/diff/CmdDiffClient";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "path";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "localPath";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "revision";
                break;
            }
            case 12: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "status";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "target";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "diffPath";
                break;
            }
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "code";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/idea/svn/diff/CmdDiffClient";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "parseOutput";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "createRevision";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "compare";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "unifiedDiff";
                break;
            }
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "parseOutput";
                break;
            }
            case 8: 
            case 13: {
                break;
            }
            case 9: 
            case 10: 
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "createRevision";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "createFilePath";
                break;
            }
            case 15: 
            case 16: 
            case 17: 
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "createChange";
                break;
            }
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "getStatus";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 8: 
            case 13: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static class DiffPath {
        @XmlAttribute(name="kind", required=true)
        public NodeKind kind;
        @XmlAttribute(name="props")
        public String propertiesStatus;
        @XmlAttribute(name="item")
        public String itemStatus;
        @XmlValue
        public String path;

        public boolean isDirectory() {
            return this.kind.isDirectory();
        }
    }

    @XmlRootElement(name="diff")
    public static class DiffInfo {
        @XmlElementWrapper(name="paths")
        @XmlElement(name="path")
        public List<DiffPath> diffPaths = new ArrayList<DiffPath>();
    }
}

