/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.sql.refactoring;

import com.intellij.database.Dbms;
import com.intellij.database.util.DdlBuilder;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.impl.source.PostprocessReformattingAspect;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.sql.dialects.SqlLanguageDialectEx;
import com.intellij.sql.psi.SqlAsExpression;
import com.intellij.sql.psi.SqlExpression;
import com.intellij.sql.psi.SqlNAryExpression;
import com.intellij.sql.psi.SqlParenthesizedExpression;
import com.intellij.sql.psi.SqlResultSetExpression;
import com.intellij.sql.psi.SqlStatement;
import com.intellij.sql.psi.SqlWithClause;
import com.intellij.sql.psi.SqlWithQueryExpression;
import com.intellij.sql.psi.impl.SqlImplUtil;
import com.intellij.sql.psi.impl.SqlInsertDmlInstructionImpl;
import com.intellij.sql.psi.impl.SqlNamedQueryDefinitionImpl;
import com.intellij.sql.psi.impl.SqlPsiElementFactory;
import com.intellij.sql.refactoring.SqlCteInplaceIntroducer;
import com.intellij.util.ObjectUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SqlSubqueryUtils {
    public static SqlExpression smartFindQuery(Editor editor, PsiFile file) {
        return SqlSubqueryUtils.findCteAbleParent(file.findElementAt(editor.getCaretModel().getOffset()), false);
    }

    @Nullable
    public static SqlExpression findCteAbleParent(@Nullable PsiElement el, boolean strict) {
        if (strict && el != null) {
            el = el.getParent();
        }
        while (el != null) {
            if (el instanceof SqlResultSetExpression && !(el instanceof SqlNAryExpression)) {
                return (SqlExpression)el;
            }
            el = el.getParent();
        }
        return null;
    }

    public static SqlWithClause extractWithClause(PsiElement query) {
        SqlWithQueryExpression withQuery = (SqlWithQueryExpression)ObjectUtils.tryCast((Object)query, SqlWithQueryExpression.class);
        return withQuery != null ? withQuery.getWithClause() : null;
    }

    public static SqlExpression removeCteDefinition(SqlNamedQueryDefinitionImpl q) {
        SqlWithClause with = (SqlWithClause)ObjectUtils.tryCast((Object)q.getParent(), SqlWithClause.class);
        assert (with != null);
        SqlWithQueryExpression withEx = (SqlWithQueryExpression)ObjectUtils.tryCast((Object)with.getParent(), SqlWithQueryExpression.class);
        assert (withEx != null);
        SqlNamedQueryDefinitionImpl sibling = (SqlNamedQueryDefinitionImpl)PsiTreeUtil.getNextSiblingOfType((PsiElement)q, SqlNamedQueryDefinitionImpl.class);
        if (sibling != null) {
            with.deleteChildRange((PsiElement)q, sibling.getPrevSibling());
            return withEx;
        }
        sibling = (SqlNamedQueryDefinitionImpl)PsiTreeUtil.getPrevSiblingOfType((PsiElement)q, SqlNamedQueryDefinitionImpl.class);
        if (sibling != null) {
            with.deleteChildRange(sibling.getNextSibling(), (PsiElement)q);
            return withEx;
        }
        SqlExpression query = withEx.getExpression();
        if (query != null) {
            query = (SqlExpression)withEx.getParent().addAfter((PsiElement)query, (PsiElement)withEx);
            withEx.delete();
            return query;
        }
        return withEx;
    }

    public static SqlExpression findEnclosingQueryWithContext(PsiElement el) {
        PsiElement possibleWithClause;
        SqlExpression ex;
        if (el == null) {
            return null;
        }
        SqlWithQueryExpression withEx = (SqlWithQueryExpression)ObjectUtils.tryCast((Object)el.getParent(), SqlWithQueryExpression.class);
        if (withEx != null) {
            if (withEx.getExpression() != el) {
                return null;
            }
            el = el.getParent();
        }
        if ((ex = SqlSubqueryUtils.findCteAbleParent(el, true)) == null || ObjectUtils.tryCast((Object)ex, SqlWithQueryExpression.class) != null) {
            return null;
        }
        PsiElement parent2 = ex.getParent();
        if (parent2 instanceof SqlNamedQueryDefinitionImpl && (possibleWithClause = parent2.getParent()) instanceof SqlWithClause) {
            parent2 = possibleWithClause.getParent();
        }
        return (withEx = (SqlWithQueryExpression)ObjectUtils.tryCast((Object)parent2, SqlWithQueryExpression.class)) != null ? withEx : ex;
    }

    public static SqlParenthesizedExpression parenthesized(@NotNull SqlExpression q) {
        if (q == null) {
            SqlSubqueryUtils.$$$reportNull$$$0(0);
        }
        if (q instanceof SqlParenthesizedExpression) {
            return (SqlParenthesizedExpression)q;
        }
        SqlLanguageDialectEx dialect = SqlImplUtil.getSqlDialectSafe((PsiElement)q);
        DdlBuilder ddl = SqlSubqueryUtils.createSelectStarFromBuilder(q, dialect);
        int check = ddl.length();
        ddl.symbol("(").plain(q.getText()).symbol(")");
        SqlStatement el = SqlPsiElementFactory.createStatementFromText(ddl.getStatement(), dialect, q.getProject(), (PsiElement)q);
        SqlParenthesizedExpression res = (SqlParenthesizedExpression)PsiTreeUtil.findChildOfType((PsiElement)el, SqlParenthesizedExpression.class);
        assert (res != null && res.getTextRange().getStartOffset() == check);
        return res;
    }

    public static SqlAsExpression aliased(@NotNull SqlExpression q, @NotNull String alias) {
        if (q == null) {
            SqlSubqueryUtils.$$$reportNull$$$0(1);
        }
        if (alias == null) {
            SqlSubqueryUtils.$$$reportNull$$$0(2);
        }
        boolean appendParentheses = !(q instanceof SqlParenthesizedExpression);
        SqlLanguageDialectEx dialect = SqlImplUtil.getSqlDialectSafe((PsiElement)q);
        DdlBuilder ddl = SqlSubqueryUtils.createSelectStarFromBuilder(q, dialect);
        int check = ddl.length();
        if (appendParentheses) {
            ddl.symbol("(");
        }
        ddl.plain(q.getText());
        if (appendParentheses) {
            ddl.symbol(")");
        }
        ddl.space().alias(alias);
        SqlStatement el = SqlPsiElementFactory.createStatementFromText(ddl.getStatement(), dialect, q.getProject(), (PsiElement)q);
        SqlAsExpression res = (SqlAsExpression)PsiTreeUtil.findChildOfType((PsiElement)el, SqlAsExpression.class);
        assert (res != null && res.getTextRange().getStartOffset() == check);
        return res;
    }

    @NotNull
    private static DdlBuilder createSelectStarFromBuilder(@NotNull SqlExpression q, @NotNull SqlLanguageDialectEx dialect) {
        if (q == null) {
            SqlSubqueryUtils.$$$reportNull$$$0(3);
        }
        if (dialect == null) {
            SqlSubqueryUtils.$$$reportNull$$$0(4);
        }
        DdlBuilder ddl = new DdlBuilder().applyCodeStyle(q.getProject(), dialect).withDialect(dialect.getDatabaseDialect());
        ddl.keyword("select").space().symbol("*").space().keyword("from").space();
        DdlBuilder ddlBuilder = ddl;
        if (ddlBuilder == null) {
            SqlSubqueryUtils.$$$reportNull$$$0(5);
        }
        return ddlBuilder;
    }

    public static boolean isSubquery(SqlExpression query, SqlExpression el) {
        return query != null && PsiTreeUtil.isAncestor((PsiElement)query, (PsiElement)el, (boolean)true);
    }

    public static void extractCte(Project project, Editor editor, PsiFile file, SqlExpression subquery, SqlExpression query) {
        PostprocessReformattingAspect.getInstance((Project)project).disablePostprocessFormattingInside(() -> WriteCommandAction.runWriteCommandAction((Project)project, (String)"Extract CTE", (String)"Extract CTE", () -> new SqlCteInplaceIntroducer(project, editor, SqlSubqueryUtils.fixCteSubquery(subquery), SqlSubqueryUtils.fixCteContext(query), file.getFileType()).startInplaceIntroduceTemplate(), (PsiFile[])new PsiFile[]{file}));
    }

    @NotNull
    private static SqlExpression fixCteSubquery(@NotNull SqlExpression subquery) {
        PsiElement parent2;
        if (subquery == null) {
            SqlSubqueryUtils.$$$reportNull$$$0(6);
        }
        while ((parent2 = subquery.getParent()) instanceof SqlNAryExpression) {
            subquery = (SqlExpression)parent2;
        }
        SqlExpression sqlExpression = subquery;
        if (sqlExpression == null) {
            SqlSubqueryUtils.$$$reportNull$$$0(7);
        }
        return sqlExpression;
    }

    @NotNull
    private static PsiElement fixCteContext(@NotNull SqlExpression context) {
        if (context == null) {
            SqlSubqueryUtils.$$$reportNull$$$0(8);
        }
        SqlExpression ctx = context;
        PsiElement parent2 = context.getParent();
        if (parent2 instanceof SqlInsertDmlInstructionImpl) {
            ctx = parent2.getParent();
        }
        if (SqlImplUtil.getSqlDialectSafe((PsiElement)context).getDbms().isMicrosoft()) {
            while (ctx != null && !(ctx instanceof SqlStatement) && !(ctx instanceof SqlWithQueryExpression)) {
                ctx = ctx.getParent();
            }
        }
        SqlExpression sqlExpression = ctx == null ? context : ctx;
        if (sqlExpression == null) {
            SqlSubqueryUtils.$$$reportNull$$$0(9);
        }
        return sqlExpression;
    }

    public static SqlExpression expanded(SqlExpression query) {
        if (query.getParent() instanceof SqlParenthesizedExpression) {
            return (SqlExpression)query.getParent();
        }
        return query;
    }

    public static SqlExpression expandedToAlias(SqlExpression query) {
        SqlExpression expandedExpression = SqlSubqueryUtils.expanded(query);
        PsiElement parent2 = expandedExpression.getParent();
        return parent2 instanceof SqlAsExpression ? (SqlAsExpression)parent2 : expandedExpression;
    }

    public static boolean canExtractWithoutContextLoss(SqlExpression subquery) {
        PsiElement parent2 = (subquery = SqlSubqueryUtils.expanded(subquery)).getParent();
        if (!(parent2 instanceof SqlAsExpression)) {
            return true;
        }
        if (((SqlAsExpression)parent2).getColumnAliasList().isEmpty()) {
            return true;
        }
        SqlLanguageDialectEx dialect = SqlImplUtil.getSqlDialectSafe((PsiElement)subquery);
        Dbms dbms = dialect.getDbms();
        return !dbms.isMicrosoft() && !dbms.isMysql();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 5: 
            case 7: 
            case 9: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 5: 
            case 7: 
            case 9: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "q";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "alias";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dialect";
                break;
            }
            case 5: 
            case 7: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/sql/refactoring/SqlSubqueryUtils";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "subquery";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/sql/refactoring/SqlSubqueryUtils";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "createSelectStarFromBuilder";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "fixCteSubquery";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "fixCteContext";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "parenthesized";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "aliased";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "createSelectStarFromBuilder";
                break;
            }
            case 5: 
            case 7: 
            case 9: {
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "fixCteSubquery";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "fixCteContext";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 5: 
            case 7: 
            case 9: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

