/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.sql.formatter;

import com.intellij.database.dataSource.LocalDataSource;
import com.intellij.database.model.DasDataSource;
import com.intellij.database.psi.DbDataSource;
import com.intellij.database.util.DbImplUtil;
import com.intellij.lang.Language;
import com.intellij.psi.PsiFile;
import com.intellij.psi.codeStyle.CodeStyleScheme;
import com.intellij.psi.codeStyle.CodeStyleSchemes;
import com.intellij.psi.codeStyle.CodeStyleSettings;
import com.intellij.psi.codeStyle.FileCodeStyleProvider;
import com.intellij.sql.dialects.SqlLanguageDialect;
import com.intellij.sql.psi.SqlLanguage;
import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \u00072\u00020\u0001:\u0001\u0007B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0012\u0010\u0003\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016\u00a8\u0006\b"}, d2={"Lcom/intellij/sql/formatter/SqlCodeStyleProvider;", "Lcom/intellij/psi/codeStyle/FileCodeStyleProvider;", "()V", "getSettings", "Lcom/intellij/psi/codeStyle/CodeStyleSettings;", "file", "Lcom/intellij/psi/PsiFile;", "Companion", "intellij.database.sql.impl"})
public final class SqlCodeStyleProvider
implements FileCodeStyleProvider {
    public static final Companion Companion = new Companion(null);

    @Nullable
    public CodeStyleSettings getSettings(@NotNull PsiFile file) {
        Intrinsics.checkParameterIsNotNull((Object)file, (String)"file");
        Language language = file.getLanguage();
        return language instanceof SqlLanguage || language instanceof SqlLanguageDialect ? Companion.findAppropriateCodeStyleSettings(file) : null;
    }

    @JvmStatic
    @Nullable
    public static final CodeStyleSettings findAppropriateCodeStyleSettings(@NotNull PsiFile file) {
        return Companion.findAppropriateCodeStyleSettings(file);
    }

    @JvmStatic
    @Nullable
    public static final CodeStyleSettings findAppropriateCodeStyleSettings(@Nullable String name) {
        return Companion.findAppropriateCodeStyleSettings(name);
    }

    @JvmStatic
    private static final String findCodeStyleSchemeName(PsiFile file) {
        return SqlCodeStyleProvider.Companion.findCodeStyleSchemeName(file);
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0012\u0010\u0003\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0007J\u0014\u0010\u0003\u001a\u0004\u0018\u00010\u00042\b\u0010\u0007\u001a\u0004\u0018\u00010\bH\u0007J\u0012\u0010\t\u001a\u0004\u0018\u00010\b2\u0006\u0010\u0005\u001a\u00020\u0006H\u0003\u00a8\u0006\n"}, d2={"Lcom/intellij/sql/formatter/SqlCodeStyleProvider$Companion;", "", "()V", "findAppropriateCodeStyleSettings", "Lcom/intellij/psi/codeStyle/CodeStyleSettings;", "file", "Lcom/intellij/psi/PsiFile;", "name", "", "findCodeStyleSchemeName", "intellij.database.sql.impl"})
    public static final class Companion {
        @JvmStatic
        @Nullable
        public final CodeStyleSettings findAppropriateCodeStyleSettings(@NotNull PsiFile file) {
            Intrinsics.checkParameterIsNotNull((Object)file, (String)"file");
            String name = this.findCodeStyleSchemeName(file);
            return this.findAppropriateCodeStyleSettings(name);
        }

        @JvmStatic
        @Nullable
        public final CodeStyleSettings findAppropriateCodeStyleSettings(@Nullable String name) {
            if (name == null) {
                return null;
            }
            CodeStyleSchemes css = CodeStyleSchemes.getInstance();
            CodeStyleScheme codeStyleScheme = css.findSchemeByName(name);
            if (codeStyleScheme == null) {
                return null;
            }
            Intrinsics.checkExpressionValueIsNotNull((Object)codeStyleScheme, (String)"css.findSchemeByName(name) ?: return null");
            CodeStyleScheme scheme = codeStyleScheme;
            return scheme.getCodeStyleSettings();
        }

        @JvmStatic
        private final String findCodeStyleSchemeName(PsiFile file) {
            String string = file.getName();
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"file.name");
            String fileName = string;
            if (Intrinsics.areEqual((Object)fileName, (Object)"preview\u22c8style.sql")) {
                return null;
            }
            DbDataSource dataSource2 = DbImplUtil.getForcedDataSource(file);
            DasDataSource ds = DbImplUtil.unwrapDS((DasDataSource)dataSource2);
            return ds instanceof LocalDataSource ? ((LocalDataSource)ds).getCodeStyleName() : null;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

