/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.view;

import com.intellij.database.Dbms;
import com.intellij.database.dataSource.DatabaseModelLoader;
import com.intellij.database.dataSource.LocalDataSource;
import com.intellij.database.dataSource.validation.DataSourceProblem;
import com.intellij.database.dataSource.validation.DatabaseConfigValidator;
import com.intellij.database.model.DasDataSource;
import com.intellij.database.model.DasModel;
import com.intellij.database.model.DasNamespace;
import com.intellij.database.model.DasObject;
import com.intellij.database.model.DatabaseSystem;
import com.intellij.database.model.DescriptionService;
import com.intellij.database.model.ModelFacade;
import com.intellij.database.model.ObjectKind;
import com.intellij.database.model.basic.BasicElement;
import com.intellij.database.model.basic.BasicModel;
import com.intellij.database.model.basic.BasicNamespaceOwner;
import com.intellij.database.model.basic.BasicSourceAware;
import com.intellij.database.psi.DbDataSource;
import com.intellij.database.psi.DbPresentation;
import com.intellij.database.psi.DbPsiFacade;
import com.intellij.database.util.DasUtil;
import com.intellij.database.util.DbImplUtil;
import com.intellij.database.util.QNameUtil;
import com.intellij.database.util.TreePattern;
import com.intellij.database.view.DatabaseStructure;
import com.intellij.database.view.DatabaseViewOptions;
import com.intellij.execution.runners.ExecutionUtil;
import com.intellij.ide.projectView.PresentationData;
import com.intellij.ide.ui.UISettings;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.pom.Navigatable;
import com.intellij.psi.PsiElement;
import com.intellij.ui.JBColor;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.util.containers.JBIterable;
import com.intellij.util.containers.JBTreeTraverser;
import com.intellij.util.ui.UIUtil;
import java.awt.Color;
import javax.swing.Icon;
import javax.swing.tree.TreePath;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DbNodeDescriptor {
    public static final SimpleTextAttributes INFO_ATTRS = SimpleTextAttributes.GRAYED_SMALL_ATTRIBUTES;
    public static final SimpleTextAttributes INACTIVE_LINK_ATTRS = SimpleTextAttributes.GRAYED_SMALL_ATTRIBUTES.derive(SimpleTextAttributes.GRAYED_SMALL_ATTRIBUTES.getStyle() | 0x200, null, null, null);
    public static final SimpleTextAttributes ACTIVE_LINK_ATTRS = INACTIVE_LINK_ATTRS.derive(INACTIVE_LINK_ATTRS.getStyle() | 0x400, UIUtil.getLabelForeground(), null, null);
    static final String spaceDelimiter = "\u2002";

    public static void updatePresentation(PresentationData presentation, DasObject element2, Project project, DatabaseViewOptions viewOptions, TreePath pathUnderMouse) {
        presentation.clear();
        presentation.setIcon(element2 instanceof DbDataSource ? DbNodeDescriptor.getDataSourceIcon((DbDataSource)element2) : DbPresentation.getIcon(element2));
        boolean commentsMode = UISettings.getInstance().getShowInplaceComments();
        String nodeText = DbPresentation.getPresentableName(element2, false);
        presentation.setPresentableText(nodeText);
        SimpleTextAttributes style = DbNodeDescriptor.handleErrors(presentation, element2);
        presentation.addText(StringUtil.isEmpty((String)nodeText) ? "<unnamed>" : nodeText, style);
        DbNodeDescriptor.addSpaceDelimiter(presentation);
        String comment = DbNodeDescriptor.adjustCommentString(element2.getComment());
        Dbms dbms = element2 instanceof BasicElement ? DbImplUtil.getDbms((BasicElement)element2) : Dbms.UNKNOWN;
        DescriptionService service = ModelFacade.forDbms(dbms).getDescriptionService();
        if (!commentsMode || StringUtil.isEmpty((String)comment)) {
            service.updatePresentation(project, element2, presentation);
        }
        if (element2 instanceof DbDataSource || element2 instanceof DasNamespace) {
            DbNodeDescriptor.appendCollapsedNamespaces(project, presentation, element2, viewOptions);
        }
        DbNodeDescriptor.appendNamespaceChooserLink(presentation, element2, project, viewOptions, pathUnderMouse);
        if (StringUtil.isNotEmpty((String)comment)) {
            DbNodeDescriptor.addTooltip(presentation, true, "<pre>" + StringUtil.escapeXmlEntities((String)comment) + "</pre>");
            if (commentsMode) {
                DbNodeDescriptor.addSpaceDelimiter(presentation);
                presentation.addText(comment, SimpleTextAttributes.GRAYED_SMALL_ATTRIBUTES);
            }
        }
    }

    @Nullable
    private static Icon getDataSourceIcon(@NotNull DbDataSource element2) {
        if (element2 == null) {
            DbNodeDescriptor.$$$reportNull$$$0(0);
        }
        Project project = element2.getProject();
        Icon icon = element2.getIcon();
        if (project.isDisposed()) {
            return icon;
        }
        DatabaseSystem delegate = element2.getDelegate();
        if (delegate instanceof LocalDataSource) {
            LocalDataSource lds = (LocalDataSource)delegate;
            int connectionCount = DbImplUtil.isConnected(project, lds) ? DbImplUtil.getActiveConnectionCount(lds) : 0;
            return connectionCount > 0 ? ExecutionUtil.getLiveIndicator((Icon)icon) : icon;
        }
        return icon;
    }

    @NotNull
    public static String adjustCommentString(@Nullable String comment) {
        String string = comment == null ? "" : StringUtil.shortenTextWithEllipsis((String)comment, (int)2000, (int)0, (boolean)true);
        if (string == null) {
            DbNodeDescriptor.$$$reportNull$$$0(1);
        }
        return string;
    }

    private static void appendNamespaceChooserLink(PresentationData presentation, DasObject element2, Project project, DatabaseViewOptions viewOptions, TreePath pathUnderMouse) {
        JBTreeTraverser traverser;
        DasObject root2;
        Object dataSource2 = element2 instanceof DbDataSource ? (DbDataSource)element2 : (element2 instanceof BasicNamespaceOwner ? DbPsiFacade.getInstance((Project)project).findDataSource(element2) : null);
        LocalDataSource localDataSource = DbImplUtil.getMaybeLocalDataSource((DasDataSource)dataSource2);
        if (localDataSource == null) {
            return;
        }
        boolean activate = pathUnderMouse != null && element2 == pathUnderMouse.getLastPathComponent();
        DasModel model = localDataSource.getModel();
        TreePattern scope = localDataSource.getIntrospectionScope();
        if (model instanceof BasicModel) {
            JBTreeTraverser tmp = ((BasicModel)model).basicTraverser();
            root2 = element2 instanceof BasicNamespaceOwner ? element2 : DatabaseStructure.getTopSingleRoot(dataSource2, viewOptions);
            traverser = root2 instanceof BasicNamespaceOwner ? (JBTreeTraverser)tmp.withRoot((Object)((BasicElement)root2)) : tmp;
        } else {
            root2 = element2;
            traverser = model.traverser();
        }
        Condition kindCondition = root2 == dataSource2 && model instanceof BasicModel && ((BasicModel)model).getRoot().familyOf(ObjectKind.DATABASE) != null ? DasUtil.byKind((ObjectKind)ObjectKind.DATABASE) : o -> DbImplUtil.isSchema(o);
        JBIterable allSchemas = ((JBTreeTraverser)((JBTreeTraverser)traverser.expandAndFilter(DasUtil.byClass(DasNamespace.class))).filter(kindCondition)).filter(DasNamespace.class);
        int enabled = 0;
        int total = 0;
        for (DasNamespace ns : allSchemas) {
            boolean shown = !viewOptions.HIDDEN_KINDS.contains(ns.getKind().code()) && DatabaseModelLoader.matches((DasObject)ns, scope);
            enabled += shown ? 1 : 0;
            ++total;
        }
        String text2 = enabled == 0 && total == 0 ? "  ...  " : (enabled != total ? " " + enabled + " of " + total + ' ' : " " + enabled + ' ');
        presentation.addText(text2, activate ? ACTIVE_LINK_ATTRS : INACTIVE_LINK_ATTRS);
    }

    private static void appendCollapsedNamespaces(Project project, PresentationData presentation, DasObject element2, DatabaseViewOptions options) {
        String textExt;
        DasObject root2;
        DasObject dasObject = options.SHOW_INTERMEDIATE ? element2 : (element2 instanceof DbDataSource ? DatabaseStructure.getTopSingleRoot((DbDataSource)element2, options) : (root2 = element2 instanceof DasNamespace ? DatabaseStructure.getTopSingleRoot(DbPsiFacade.getInstance((Project)project).findDataSource(element2), element2, options) : element2));
        if (root2 != element2 && StringUtil.isNotEmpty((String)(textExt = QNameUtil.getQualifiedName(root2)))) {
            presentation.addText('(' + textExt + ')', SimpleTextAttributes.GRAYED_ATTRIBUTES);
            DbNodeDescriptor.addSpaceDelimiter(presentation);
        }
    }

    private static void addSpaceDelimiter(PresentationData presentation) {
        presentation.addText(spaceDelimiter, SimpleTextAttributes.REGULAR_ATTRIBUTES);
    }

    private static SimpleTextAttributes handleErrors(PresentationData presentation, Object element2) {
        SimpleTextAttributes style;
        boolean hasErrors = false;
        boolean hasWarnings = false;
        int connectionCount = -1;
        if (element2 instanceof DbDataSource && ((DbDataSource)element2).getDelegate() instanceof LocalDataSource) {
            Project project;
            LocalDataSource dataSource2 = (LocalDataSource)((DbDataSource)element2).getDelegate();
            hasErrors = !DbImplUtil.canConnectTo(dataSource2);
            hasWarnings = hasErrors;
            if (!hasErrors) {
                for (DataSourceProblem problem : DatabaseConfigValidator.getProblems(element2, null)) {
                    DataSourceProblem.Level level = problem.getLevel();
                    if (level == DataSourceProblem.Level.WARNING) {
                        hasWarnings = true;
                        continue;
                    }
                    if (level != DataSourceProblem.Level.ERROR) continue;
                    hasErrors = true;
                    hasWarnings = true;
                }
            }
            connectionCount = DbImplUtil.isConnected(project = ((DbDataSource)element2).getProject(), dataSource2) ? DbImplUtil.getActiveConnectionCount(dataSource2) : -1;
        } else if (element2 instanceof BasicSourceAware) {
            hasErrors = ((BasicSourceAware)element2).isInvalid();
        }
        SimpleTextAttributes simpleTextAttributes = style = element2 instanceof DasObject && DbPresentation.isUnnamed((DasObject)element2) ? INFO_ATTRS : SimpleTextAttributes.REGULAR_ATTRIBUTES;
        if (hasErrors || hasWarnings) {
            SimpleTextAttributes waved = new SimpleTextAttributes(8, null, (Color)(hasErrors ? JBColor.RED : JBColor.ORANGE));
            style = SimpleTextAttributes.merge((SimpleTextAttributes)style, (SimpleTextAttributes)waved);
        }
        if (hasErrors && element2 instanceof LocalDataSource && !DbImplUtil.hasDriverFiles((LocalDataSource)element2)) {
            DbNodeDescriptor.addTooltip(presentation, false, "Database driver files not found, open Properties to download");
        }
        if (connectionCount >= 0) {
            DbNodeDescriptor.addTooltip(presentation, false, connectionCount + " " + StringUtil.pluralize((String)"connection", (int)connectionCount));
        }
        return style;
    }

    private static void addTooltip(PresentationData presentation, boolean before2, String tooltip) {
        String result;
        String cur = presentation.getTooltip();
        if (StringUtil.isEmpty((String)cur)) {
            result = tooltip;
        } else {
            String separator = "<p><p>";
            result = before2 ? tooltip + separator + cur : cur + separator + tooltip;
        }
        presentation.setTooltip(result.startsWith("<html>") ? result : "<html>" + result);
    }

    @Nullable
    public static Object getData(@NonNls @NotNull String dataId, Project project, Object node) {
        if (dataId == null) {
            DbNodeDescriptor.$$$reportNull$$$0(2);
        }
        if (!(node instanceof DasObject)) {
            if (CommonDataKeys.NAVIGATABLE.is(dataId) && node instanceof Navigatable) {
                return node;
            }
            if (CommonDataKeys.PSI_ELEMENT.is(dataId) && node instanceof PsiElement) {
                return node;
            }
            return null;
        }
        if (!CommonDataKeys.NAVIGATABLE.is(dataId) && !CommonDataKeys.PSI_ELEMENT.is(dataId)) {
            return null;
        }
        DbDataSource dataSource2 = DbPsiFacade.getInstance((Project)project).findDataSource((DasObject)node);
        if (dataSource2 == null) {
            return null;
        }
        if (CommonDataKeys.NAVIGATABLE.is(dataId)) {
            if (node instanceof Navigatable && ((Navigatable)node).canNavigate()) {
                return node;
            }
            return DbImplUtil.findElement(dataSource2, (DasObject)node);
        }
        if (CommonDataKeys.PSI_ELEMENT.is(dataId)) {
            return DbImplUtil.findElement(dataSource2, (DasObject)node);
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/view/DbNodeDescriptor";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataId";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/view/DbNodeDescriptor";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "adjustCommentString";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getDataSourceIcon";
                break;
            }
            case 1: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getData";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

