/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.util;

import com.intellij.database.util.IllegalDateTimeFormatException;
import java.sql.Date;
import java.sql.Timestamp;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.util.GregorianCalendar;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.JvmName;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.MatchResult;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=2, d1={"\u0000:\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\u0010\b\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\r\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\u001a\u000e\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013\u001a\u000e\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0012\u001a\u00020\u0013\u001a\n\u0010\u0016\u001a\u00020\b*\u00020\u0017\u001a\n\u0010\u0016\u001a\u00020\b*\u00020\u0011\u001a\u0012\u0010\u0016\u001a\u00020\b*\u00020\u00112\u0006\u0010\u0018\u001a\u00020\u0003\u001a\n\u0010\u0016\u001a\u00020\b*\u00020\u0004\u001a\u0012\u0010\u0016\u001a\u00020\b*\u00020\u00042\u0006\u0010\u0018\u001a\u00020\u0003\u001a\n\u0010\u0016\u001a\u00020\b*\u00020\u0015\u001a\n\u0010\u0019\u001a\u00020\b*\u00020\u0015\u001a\u0012\u0010\u001a\u001a\u00020\b*\u00020\u00152\u0006\u0010\u0018\u001a\u00020\u0003\u001a\n\u0010\u0002\u001a\u00020\u0003*\u00020\u0015\u001a\n\u0010\u001b\u001a\u00020\u0003*\u00020\u0015\u001a\f\u0010\u001c\u001a\u00020\u0017*\u00020\u0015H\u0002\u001a\f\u0010\u001d\u001a\u00020\u0011*\u00020\u0015H\u0002\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u0015\u0010\u0002\u001a\u00020\u0003*\u00020\u00048F\u00a2\u0006\u0006\u001a\u0004\b\u0005\u0010\u0006\"\u0018\u0010\u0007\u001a\u00020\b*\u00020\t8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\u000b\"\u0018\u0010\f\u001a\u00020\b*\u00020\t8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\u000b\"\u0018\u0010\u000e\u001a\u00020\b*\u00020\t8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\u000b\u00a8\u0006\u001e"}, d2={"formalSqlDateTimePattern", "Lkotlin/text/Regex;", "hasMilliseconds", "", "Ljava/time/LocalTime;", "getHasMilliseconds", "(Ljava/time/LocalTime;)Z", "str2", "", "", "getStr2", "(I)Ljava/lang/String;", "str3", "getStr3", "str4", "getStr4", "importLocalDateTime", "Ljava/time/LocalDateTime;", "string", "", "importSqlDateTime", "Ljava/util/Date;", "export", "Ljava/time/LocalDate;", "withMilliseconds", "exportDateOnly", "exportDateTime", "hasTime", "toLocalDate", "toLocalDateTime", "intellij.database.impl"})
@JvmName(name="CalendarFun")
public final class CalendarFun {
    private static final Regex formalSqlDateTimePattern = new Regex("^\\s*(-?\\d+)-(\\d+)-(\\d+)(\\s*\\.\\s*(\\d+):(\\d+)(:(\\d+)(\\.(\\d{3}))?)?)?\\s*$");

    @NotNull
    public static final String export(@NotNull LocalDate $this$export) {
        Intrinsics.checkParameterIsNotNull((Object)$this$export, (String)"$this$export");
        return CalendarFun.getStr4($this$export.getYear()) + '-' + CalendarFun.getStr2($this$export.getMonthValue()) + '-' + CalendarFun.getStr2($this$export.getDayOfMonth());
    }

    @NotNull
    public static final String export(@NotNull LocalTime $this$export) {
        Intrinsics.checkParameterIsNotNull((Object)$this$export, (String)"$this$export");
        return CalendarFun.export($this$export, CalendarFun.getHasMilliseconds($this$export));
    }

    @NotNull
    public static final String export(@NotNull LocalTime $this$export, boolean withMilliseconds) {
        Intrinsics.checkParameterIsNotNull((Object)$this$export, (String)"$this$export");
        return withMilliseconds ? CalendarFun.getStr2($this$export.getHour()) + ':' + CalendarFun.getStr2($this$export.getMinute()) + ':' + CalendarFun.getStr2($this$export.getSecond()) + '.' + CalendarFun.getStr3($this$export.getNano() / 1000000) : CalendarFun.getStr2($this$export.getHour()) + ':' + CalendarFun.getStr2($this$export.getMinute()) + ':' + CalendarFun.getStr2($this$export.getSecond());
    }

    @NotNull
    public static final String export(@NotNull LocalDateTime $this$export) {
        Intrinsics.checkParameterIsNotNull((Object)$this$export, (String)"$this$export");
        StringBuilder stringBuilder = new StringBuilder();
        LocalDate localDate = $this$export.toLocalDate();
        Intrinsics.checkExpressionValueIsNotNull((Object)localDate, (String)"toLocalDate()");
        StringBuilder stringBuilder2 = stringBuilder.append(CalendarFun.export(localDate)).append('.');
        LocalTime localTime = $this$export.toLocalTime();
        Intrinsics.checkExpressionValueIsNotNull((Object)localTime, (String)"toLocalTime()");
        return stringBuilder2.append(CalendarFun.export(localTime)).toString();
    }

    @NotNull
    public static final String export(@NotNull LocalDateTime $this$export, boolean withMilliseconds) {
        Intrinsics.checkParameterIsNotNull((Object)$this$export, (String)"$this$export");
        StringBuilder stringBuilder = new StringBuilder();
        LocalDate localDate = $this$export.toLocalDate();
        Intrinsics.checkExpressionValueIsNotNull((Object)localDate, (String)"toLocalDate()");
        StringBuilder stringBuilder2 = stringBuilder.append(CalendarFun.export(localDate)).append('.');
        LocalTime localTime = $this$export.toLocalTime();
        Intrinsics.checkExpressionValueIsNotNull((Object)localTime, (String)"toLocalTime()");
        return stringBuilder2.append(CalendarFun.export(localTime, withMilliseconds)).toString();
    }

    @NotNull
    public static final String export(@NotNull java.util.Date $this$export) {
        String string;
        Intrinsics.checkParameterIsNotNull((Object)$this$export, (String)"$this$export");
        java.util.Date date = $this$export;
        if (date instanceof Date) {
            LocalDate localDate = ((Date)$this$export).toLocalDate();
            Intrinsics.checkExpressionValueIsNotNull((Object)localDate, (String)"this.toLocalDate()");
            string = CalendarFun.export(localDate);
        } else if (date instanceof Timestamp) {
            LocalDateTime localDateTime = ((Timestamp)$this$export).toLocalDateTime();
            Intrinsics.checkExpressionValueIsNotNull((Object)localDateTime, (String)"this.toLocalDateTime()");
            string = CalendarFun.export(localDateTime);
        } else {
            string = CalendarFun.hasTime($this$export) ? CalendarFun.export(CalendarFun.toLocalDate($this$export)) : CalendarFun.export(CalendarFun.toLocalDateTime($this$export));
        }
        return string;
    }

    @NotNull
    public static final String exportDateOnly(@NotNull java.util.Date $this$exportDateOnly) {
        Intrinsics.checkParameterIsNotNull((Object)$this$exportDateOnly, (String)"$this$exportDateOnly");
        return CalendarFun.export(CalendarFun.toLocalDate($this$exportDateOnly));
    }

    public static final boolean getHasMilliseconds(@NotNull LocalTime $this$hasMilliseconds) {
        Intrinsics.checkParameterIsNotNull((Object)$this$hasMilliseconds, (String)"$this$hasMilliseconds");
        return $this$hasMilliseconds.getNano() >= 1000000;
    }

    @NotNull
    public static final String exportDateTime(@NotNull java.util.Date $this$exportDateTime, boolean withMilliseconds) {
        Intrinsics.checkParameterIsNotNull((Object)$this$exportDateTime, (String)"$this$exportDateTime");
        return CalendarFun.export(CalendarFun.toLocalDateTime($this$exportDateTime), withMilliseconds);
    }

    public static final boolean hasTime(@NotNull java.util.Date $this$hasTime) {
        Intrinsics.checkParameterIsNotNull((Object)$this$hasTime, (String)"$this$hasTime");
        GregorianCalendar c2 = new GregorianCalendar();
        c2.setTimeInMillis($this$hasTime.getTime());
        return c2.get(11) > 0 || c2.get(12) > 0 || c2.get(13) > 0 || c2.get(14) > 0;
    }

    public static final boolean hasMilliseconds(@NotNull java.util.Date $this$hasMilliseconds) {
        Intrinsics.checkParameterIsNotNull((Object)$this$hasMilliseconds, (String)"$this$hasMilliseconds");
        return $this$hasMilliseconds.getTime() % 1000L > 0L;
    }

    @NotNull
    public static final LocalDateTime importLocalDateTime(@NotNull CharSequence string) {
        Intrinsics.checkParameterIsNotNull((Object)string, (String)"string");
        MatchResult match2 = formalSqlDateTimePattern.matchEntire(string);
        if (match2 == null) {
            throw (Throwable)new IllegalDateTimeFormatException("The string \"" + string + "\" is not a valid date and time (wrong format).");
        }
        List values2 = match2.getGroupValues();
        try {
            String string2 = (String)values2.get(1);
            boolean bl = false;
            int y = Integer.parseInt(string2);
            String string3 = (String)values2.get(2);
            boolean bl2 = false;
            int m = Integer.parseInt(string3);
            String string4 = (String)values2.get(3);
            boolean bl3 = false;
            int d2 = Integer.parseInt(string4);
            LocalDate date = LocalDate.of(y, m, d2);
            CharSequence charSequence = (CharSequence)values2.get(4);
            boolean bl4 = false;
            if (charSequence.length() == 0) {
                LocalDateTime localDateTime = LocalDateTime.of(date, LocalTime.MIDNIGHT);
                Intrinsics.checkExpressionValueIsNotNull((Object)localDateTime, (String)"LocalDateTime.of(date, LocalTime.MIDNIGHT)");
                return localDateTime;
            }
            String string5 = (String)values2.get(5);
            boolean bl5 = false;
            int h = Integer.parseInt(string5);
            String string6 = (String)values2.get(6);
            boolean bl6 = false;
            int n = Integer.parseInt(string6);
            Integer n2 = StringsKt.toIntOrNull((String)((String)values2.get(8)));
            int s = n2 != null ? n2 : 0;
            Integer n3 = StringsKt.toIntOrNull((String)((String)values2.get(10)));
            int l = n3 != null ? n3 : 0;
            LocalTime time = LocalTime.of(h, n, s, l * 1000000);
            LocalDateTime localDateTime = LocalDateTime.of(date, time);
            Intrinsics.checkExpressionValueIsNotNull((Object)localDateTime, (String)"LocalDateTime.of(date, time)");
            return localDateTime;
        }
        catch (Exception e) {
            throw (Throwable)new IllegalDateTimeFormatException("The string \"" + string + "\" is not a valid date and time (wrong values).", e);
        }
    }

    @NotNull
    public static final java.util.Date importSqlDateTime(@NotNull CharSequence string) {
        Intrinsics.checkParameterIsNotNull((Object)string, (String)"string");
        LocalDateTime dt = CalendarFun.importLocalDateTime(string);
        try {
            java.util.Date date;
            if (Intrinsics.areEqual((Object)dt.toLocalTime(), (Object)LocalTime.MIDNIGHT)) {
                Date date2 = Date.valueOf(dt.toLocalDate());
                Intrinsics.checkExpressionValueIsNotNull((Object)date2, (String)"java.sql.Date.valueOf(dt.toLocalDate())");
                date = date2;
            } else {
                Timestamp timestamp = Timestamp.valueOf(dt);
                Intrinsics.checkExpressionValueIsNotNull((Object)timestamp, (String)"java.sql.Timestamp.valueOf(dt)");
                date = timestamp;
            }
            return date;
        }
        catch (Exception e) {
            throw (Throwable)new IllegalDateTimeFormatException("Cannot convert timestamp (" + string + ") from LocalDateTime to java.sql.Date/Timestamp.", e);
        }
    }

    private static final LocalDate toLocalDate(@NotNull java.util.Date $this$toLocalDate) {
        LocalDate localDate = new Date($this$toLocalDate.getTime()).toLocalDate();
        Intrinsics.checkExpressionValueIsNotNull((Object)localDate, (String)"java.sql.Date(this.time).toLocalDate()");
        return localDate;
    }

    private static final LocalDateTime toLocalDateTime(@NotNull java.util.Date $this$toLocalDateTime) {
        LocalDateTime localDateTime = new Timestamp($this$toLocalDateTime.getTime()).toLocalDateTime();
        Intrinsics.checkExpressionValueIsNotNull((Object)localDateTime, (String)"java.sql.Timestamp(this.time).toLocalDateTime()");
        return localDateTime;
    }

    private static final String getStr2(int $this$str2) {
        String string;
        int n = $this$str2;
        int n2 = n;
        if (0 <= n2 && 9 >= n2) {
            string = "" + '0' + $this$str2;
        } else {
            n2 = n;
            if (-9 <= n2 && -1 >= n2) {
                n2 = $this$str2;
                StringBuilder stringBuilder = new StringBuilder().append("-0");
                boolean bl = false;
                int n3 = Math.abs(n2);
                string = stringBuilder.append(n3).toString();
            } else {
                string = String.valueOf($this$str2);
            }
        }
        return string;
    }

    private static final String getStr3(int $this$str3) {
        String string;
        int n = $this$str3;
        int n2 = n;
        if (0 <= n2 && 9 >= n2) {
            string = "00" + $this$str3;
        } else {
            n2 = n;
            if (10 <= n2 && 99 >= n2) {
                string = "" + '0' + $this$str3;
            } else {
                n2 = n;
                if (-9 <= n2 && -1 >= n2) {
                    n2 = $this$str3;
                    StringBuilder stringBuilder = new StringBuilder().append("-00");
                    boolean bl = false;
                    int n3 = Math.abs(n2);
                    string = stringBuilder.append(n3).toString();
                } else {
                    n2 = n;
                    if (-99 <= n2 && -10 >= n2) {
                        n2 = $this$str3;
                        StringBuilder stringBuilder = new StringBuilder().append("-0");
                        boolean bl = false;
                        int n4 = Math.abs(n2);
                        string = stringBuilder.append(n4).toString();
                    } else {
                        string = String.valueOf($this$str3);
                    }
                }
            }
        }
        return string;
    }

    private static final String getStr4(int $this$str4) {
        String string;
        int n = $this$str4;
        int n2 = n;
        if (0 <= n2 && 9 >= n2) {
            string = "000" + $this$str4;
        } else {
            n2 = n;
            if (10 <= n2 && 99 >= n2) {
                string = "00" + $this$str4;
            } else {
                n2 = n;
                if (100 <= n2 && 999 >= n2) {
                    string = "" + '0' + $this$str4;
                } else {
                    n2 = n;
                    if (-9 <= n2 && -1 >= n2) {
                        n2 = $this$str4;
                        StringBuilder stringBuilder = new StringBuilder().append("-000");
                        boolean bl = false;
                        int n3 = Math.abs(n2);
                        string = stringBuilder.append(n3).toString();
                    } else {
                        n2 = n;
                        if (-99 <= n2 && -10 >= n2) {
                            n2 = $this$str4;
                            StringBuilder stringBuilder = new StringBuilder().append("-00");
                            boolean bl = false;
                            int n4 = Math.abs(n2);
                            string = stringBuilder.append(n4).toString();
                        } else {
                            n2 = n;
                            if (-999 <= n2 && -100 >= n2) {
                                n2 = $this$str4;
                                StringBuilder stringBuilder = new StringBuilder().append("-0");
                                boolean bl = false;
                                int n5 = Math.abs(n2);
                                string = stringBuilder.append(n5).toString();
                            } else {
                                string = String.valueOf($this$str4);
                            }
                        }
                    }
                }
            }
        }
        return string;
    }
}

