/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.run.ui.treetable;

import com.intellij.database.Dbms;
import com.intellij.database.datagrid.DataConsumer;
import com.intellij.database.datagrid.DataGrid;
import com.intellij.database.datagrid.DataGridUtil;
import com.intellij.database.datagrid.GridModel;
import com.intellij.database.datagrid.ModelIndex;
import com.intellij.database.datagrid.SelectionModel;
import com.intellij.database.datagrid.ViewIndex;
import com.intellij.database.extractors.JsonUtilKt;
import com.intellij.database.run.ReservedCellValue;
import com.intellij.database.run.ui.DataAccessType;
import com.intellij.database.run.ui.ResultViewWithCells;
import com.intellij.database.run.ui.ResultViewWithRows;
import com.intellij.database.run.ui.TableResultPanel;
import com.intellij.database.run.ui.grid.GridColorSchemeUtil;
import com.intellij.database.run.ui.grid.GridColorsScheme;
import com.intellij.database.run.ui.grid.TableCellImageCache;
import com.intellij.database.run.ui.grid.renderers.DefaultTextRendererFactory;
import com.intellij.database.run.ui.grid.renderers.GridCellRenderer;
import com.intellij.database.run.ui.grid.renderers.GridCellRenderers;
import com.intellij.database.run.ui.treetable.GridTreeTableModel;
import com.intellij.database.run.ui.treetable.Node;
import com.intellij.database.run.ui.treetable.TreeTableResultView;
import com.intellij.lang.Language;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.editor.colors.EditorColorsListener;
import com.intellij.openapi.editor.colors.EditorColorsScheme;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.editor.markup.TextAttributes;
import com.intellij.openapi.fileTypes.PlainTextLanguage;
import com.intellij.openapi.ui.Splitter;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.ui.EditorTextFieldCellRenderer;
import com.intellij.ui.components.JBTreeTable;
import com.intellij.ui.table.JBTable;
import com.intellij.ui.treeStructure.treetable.TreeTableModel;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.util.List;
import java.util.Map;
import javax.swing.JComponent;
import javax.swing.JScrollBar;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.table.TableCellRenderer;
import javax.swing.tree.TreePath;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GridTreeTable
extends JBTreeTable
implements Disposable,
EditorColorsListener,
ResultViewWithRows {
    private final TableResultPanel myResultPanel;
    private final TreeTableResultView myView;
    private final TableCellImageCache myCellImageCache;
    private final FieldNameColumnRenderer myFieldNameRenderer;

    public GridTreeTable(@NotNull GridTreeTableModel model, @NotNull TableResultPanel resultPanel, @NotNull TreeTableResultView view2) {
        if (model == null) {
            GridTreeTable.$$$reportNull$$$0(0);
        }
        if (resultPanel == null) {
            GridTreeTable.$$$reportNull$$$0(1);
        }
        if (view2 == null) {
            GridTreeTable.$$$reportNull$$$0(2);
        }
        super((TreeTableModel)model);
        this.myResultPanel = resultPanel;
        this.myView = view2;
        this.myCellImageCache = new TableCellImageCache(this, resultPanel);
        this.setColumnProportion(0.7f);
        this.myFieldNameRenderer = new FieldNameColumnRenderer();
        Disposer.register((Disposable)this, (Disposable)this.myFieldNameRenderer);
        this.setDefaultRenderer(TreeTableModel.class, this.myCellImageCache.wrapCellRenderer(this.myFieldNameRenderer));
        this.setDefaultRenderer(Object.class, new ValueColumnRenderer(resultPanel, this, view2, this.getDefaultRenderer(Object.class)));
        this.getTree().setLargeModel(true);
        this.getTable().getEmptyText().setText("");
        this.getTree().getEmptyText().setText("");
        this.hideColumnHeader();
        this.getTable().setShowVerticalLines(true);
        this.colorSchemeUpdated();
    }

    private void hideColumnHeader() {
        this.getTable().setTableHeader(null);
        JScrollPane scrollPane = this.getScrollPane();
        if (scrollPane != null) {
            scrollPane.setColumnHeaderView(null);
        }
    }

    void dropCaches() {
        this.myCellImageCache.reset();
    }

    protected void paintComponent(Graphics g) {
        this.adjustCacheSize();
        super.paintComponent(g);
    }

    private void adjustCacheSize() {
        if (!this.myCellImageCache.isCacheEnabled()) {
            return;
        }
        int rowCount = this.getTable().getRowCount();
        Rectangle visibleRect = this.getVisibleRect();
        if (rowCount == 0 || visibleRect.isEmpty()) {
            return;
        }
        int rowHeight = this.getRowHeight();
        int rowsMax = rowHeight == 0 ? rowCount : Math.min(rowCount, (int)Math.ceil((float)visibleRect.height / (float)rowHeight));
        rowsMax = Math.min(100, rowsMax);
        int columnsMax = 2;
        int factor = Math.max(1, Registry.intValue((String)"database.grid.cache.factor"));
        int treeTableFactor = 3;
        this.myCellImageCache.adjustCacheSize(rowsMax * columnsMax * factor * treeTableFactor);
    }

    private void colorSchemeUpdated() {
        this.getTable().setGridColor(GridColorSchemeUtil.doGetGridColor(this.getColorsScheme()));
        this.updateInnerComponentsBackground(GridColorSchemeUtil.doGetBackground(this.getColorsScheme()));
        this.getTable().setSelectionBackground(GridColorSchemeUtil.doGetSelectionBackground(this.getColorsScheme()));
        this.getTable().setSelectionForeground(GridColorSchemeUtil.doGetSelectionForeground(this.getColorsScheme()));
    }

    private void updateInnerComponentsBackground(Color bg) {
        this.getTree().setBackground(bg);
        this.getTable().setBackground(bg);
    }

    @NotNull
    private GridColorsScheme getColorsScheme() {
        GridColorsScheme gridColorsScheme = this.myResultPanel.getColorsScheme();
        if (gridColorsScheme == null) {
            GridTreeTable.$$$reportNull$$$0(3);
        }
        return gridColorsScheme;
    }

    public Color getBackground() {
        return GridColorSchemeUtil.doGetBackground(this.getColorsScheme());
    }

    public void setBackground(@NotNull Color bg) {
        if (bg == null) {
            GridTreeTable.$$$reportNull$$$0(4);
        }
    }

    @Override
    public void resetRowHeights() {
        int defaultRowHeight = this.getRowHeight();
        JBTable table = this.getTable();
        for (int i2 = 0; i2 < table.getRowCount(); ++i2) {
            if (table.getRowHeight(i2) == defaultRowHeight) continue;
            table.setRowHeight(i2, defaultRowHeight);
        }
    }

    public GridTreeTableModel getModel() {
        return (GridTreeTableModel)super.getModel();
    }

    @Nullable
    public Color getPathBackground(@NotNull TreePath path, int row) {
        if (path == null) {
            GridTreeTable.$$$reportNull$$$0(5);
        }
        ViewIndex<DataConsumer.Row> rowIdx = ViewIndex.forRow(this.myResultPanel, row);
        ViewIndex<DataConsumer.Column> colIdx = ViewIndex.forColumn(this.myResultPanel, 0);
        SelectionModel<DataConsumer.Row, DataConsumer.Column> selectionModel = SelectionModel.get(this.myResultPanel, this.myView);
        boolean selected = selectionModel.isSelected(rowIdx, colIdx);
        return this.myView.getCellBackground(rowIdx, colIdx, selected);
    }

    public void dispose() {
        this.getTable().removeEditor();
    }

    public void globalSchemeChange(@Nullable EditorColorsScheme scheme) {
        this.myFieldNameRenderer.myComponent.getEditor().reinitSettings();
        this.colorSchemeUpdated();
    }

    @Override
    @NotNull
    public JComponent getComponent() {
        GridTreeTable gridTreeTable = this;
        if (gridTreeTable == null) {
            GridTreeTable.$$$reportNull$$$0(6);
        }
        return gridTreeTable;
    }

    @Nullable
    private JScrollPane getScrollPane() {
        if (this.getComponentCount() < 1) {
            return null;
        }
        Splitter split = (Splitter)ObjectUtils.tryCast((Object)this.getComponent(0), Splitter.class);
        return split == null ? null : (JScrollPane)ObjectUtils.tryCast((Object)split.getFirstComponent(), JScrollPane.class);
    }

    @Override
    @Nullable
    public JScrollBar getVerticalScrollBar() {
        JScrollPane scrollPane = this.getScrollPane();
        return scrollPane == null ? null : scrollPane.getVerticalScrollBar();
    }

    @Override
    @Nullable
    public JScrollBar getHorizontalScrollBar() {
        JScrollPane scrollPane = this.getScrollPane();
        return scrollPane == null ? null : scrollPane.getHorizontalScrollBar();
    }

    @Override
    public int getRowHeight() {
        return this.getTable().getRowHeight();
    }

    public void contentLanguageUpdated() {
        this.myCellImageCache.reset();
        this.revalidate();
        this.repaint();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 6: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 6: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "model";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "resultPanel";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "view";
                break;
            }
            case 3: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/run/ui/treetable/GridTreeTable";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "bg";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "path";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/run/ui/treetable/GridTreeTable";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getColorsScheme";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getComponent";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: 
            case 6: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "setBackground";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getPathBackground";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: 
            case 6: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class GridCellRendererWrapper
    implements TableCellRenderer {
        final GridCellRenderer delegate;

        GridCellRendererWrapper(GridCellRenderer renderer) {
            this.delegate = renderer;
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value2, boolean isSelected, boolean hasFocus, int row, int column) {
            DataGrid grid = this.delegate.myGrid;
            ViewIndex<DataConsumer.Row> rowIdx = ViewIndex.forRow(grid, row);
            ViewIndex<DataConsumer.Column> columnIdx = ViewIndex.forColumn(grid, column);
            return this.delegate.getComponent(rowIdx, columnIdx, value2);
        }
    }

    private static class Renderers {
        final GridCellRenderer myJsonRenderer;
        final GridCellRenderer myEmptyRenderer;
        final GridCellRenderers myGridRenderers;
        final GridTreeTable myTreeTable;
        final Map<GridCellRenderer, TableCellRenderer> myTableCellRenderers = ContainerUtil.newIdentityTroveMap();

        Renderers(DataGrid resultPanel, GridTreeTable treeTable) {
            this.myGridRenderers = new GridCellRenderers(resultPanel);
            this.myTreeTable = treeTable;
            this.myEmptyRenderer = new DefaultTextRendererFactory.TextRenderer(resultPanel, (Language)PlainTextLanguage.INSTANCE){

                @Override
                @NotNull
                protected String getText(@Nullable Object value2, @NotNull ModelIndex<DataConsumer.Column> columnIdx) {
                    if (columnIdx == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    return "";
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "columnIdx", "com/intellij/database/run/ui/treetable/GridTreeTable$Renderers$1", "getText"));
                }
            };
            this.myJsonRenderer = new DefaultTextRendererFactory.TextRenderer(resultPanel, (Language)ObjectUtils.notNull((Object)DefaultTextRendererFactory.JSON_LANGUAGE, (Object)PlainTextLanguage.INSTANCE)){

                @Override
                @NotNull
                protected String getText(@Nullable Object value2, @NotNull ModelIndex<DataConsumer.Column> columnIdx) {
                    if (columnIdx == null) {
                        2.$$$reportNull$$$0(0);
                    }
                    if (value2 == null || value2 instanceof ReservedCellValue) {
                        String string = ((ReservedCellValue)((Object)ObjectUtils.notNull((Object)((Object)((ReservedCellValue)((Object)value2))), (Object)((Object)ReservedCellValue.NULL)))).getDisplayName();
                        if (string == null) {
                            2.$$$reportNull$$$0(1);
                        }
                        return string;
                    }
                    GridModel model = this.myGrid.getDataModel(DataAccessType.DATA_WITH_MUTATIONS);
                    DataConsumer.Column column = model.getColumn(columnIdx);
                    Dbms dbms = DataGridUtil.getDbms(this.myGrid);
                    if (column != null) {
                        String string = this.myGrid.getObjectFormatter().getPlainValue(value2, column, dbms);
                        if (string == null) {
                            2.$$$reportNull$$$0(2);
                        }
                        return string;
                    }
                    String string = value2 instanceof List || value2 instanceof Object[] || value2 instanceof Map ? JsonUtilKt.toJson(value2, dbms, this.myGrid.getObjectFormatter()) : value2.toString();
                    if (string == null) {
                        2.$$$reportNull$$$0(3);
                    }
                    return string;
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    RuntimeException runtimeException;
                    Object[] objectArray;
                    Object[] objectArray2;
                    int n2;
                    String string;
                    switch (n) {
                        default: {
                            string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                            break;
                        }
                        case 1: 
                        case 2: 
                        case 3: {
                            string = "@NotNull method %s.%s must not return null";
                            break;
                        }
                    }
                    switch (n) {
                        default: {
                            n2 = 3;
                            break;
                        }
                        case 1: 
                        case 2: 
                        case 3: {
                            n2 = 2;
                            break;
                        }
                    }
                    Object[] objectArray3 = new Object[n2];
                    switch (n) {
                        default: {
                            objectArray2 = objectArray3;
                            objectArray3[0] = "columnIdx";
                            break;
                        }
                        case 1: 
                        case 2: 
                        case 3: {
                            objectArray2 = objectArray3;
                            objectArray3[0] = "com/intellij/database/run/ui/treetable/GridTreeTable$Renderers$2";
                            break;
                        }
                    }
                    switch (n) {
                        default: {
                            objectArray = objectArray2;
                            objectArray2[1] = "com/intellij/database/run/ui/treetable/GridTreeTable$Renderers$2";
                            break;
                        }
                        case 1: 
                        case 2: 
                        case 3: {
                            objectArray = objectArray2;
                            objectArray2[1] = "getText";
                            break;
                        }
                    }
                    switch (n) {
                        default: {
                            objectArray = objectArray;
                            objectArray[2] = "getText";
                            break;
                        }
                        case 1: 
                        case 2: 
                        case 3: {
                            break;
                        }
                    }
                    String string2 = String.format(string, objectArray);
                    switch (n) {
                        default: {
                            runtimeException = new IllegalArgumentException(string2);
                            break;
                        }
                        case 1: 
                        case 2: 
                        case 3: {
                            runtimeException = new IllegalStateException(string2);
                            break;
                        }
                    }
                    throw runtimeException;
                }
            };
            Disposer.register((Disposable)resultPanel, (Disposable)this.myGridRenderers);
            Disposer.register((Disposable)resultPanel, (Disposable)this.myEmptyRenderer);
            Disposer.register((Disposable)resultPanel, (Disposable)this.myJsonRenderer);
        }

        @Nullable
        public TableCellRenderer getRenderer(int viewRow, int viewColumn) {
            DataGrid grid = this.myGridRenderers.grid;
            Pair<Integer, Integer> rowAndColumn = grid.getRawIndexConverter().rowAndColumn2Model().fun(viewRow, viewColumn);
            int modelColumnIdx = (Integer)rowAndColumn.second;
            GridCellRenderer gridCellRenderer = this.myTreeTable.getTree().isExpanded(viewRow) ? this.myEmptyRenderer : (modelColumnIdx == -1 ? this.myJsonRenderer : this.myGridRenderers.getRenderer(ModelIndex.forRow(grid, (int)((Integer)rowAndColumn.first)), ModelIndex.forColumn(grid, modelColumnIdx)));
            TableCellRenderer renderer = this.myTableCellRenderers.get(gridCellRenderer);
            if (renderer == null) {
                renderer = new GridCellRendererWrapper(gridCellRenderer);
                this.myTableCellRenderers.put(gridCellRenderer, renderer);
            }
            return renderer;
        }
    }

    private static class ValueColumnRenderer
    implements TableCellRenderer {
        final Renderers myRenderers;
        final DataGrid myDataGrid;
        final GridTreeTable myTreeTable;
        final TreeTableResultView myView;
        final TableCellRenderer myDefaultRenderer;

        private ValueColumnRenderer(DataGrid dataGrid, GridTreeTable treeTable, TreeTableResultView view2, TableCellRenderer defaultRenderer) {
            this.myDataGrid = dataGrid;
            this.myTreeTable = treeTable;
            this.myView = view2;
            this.myDefaultRenderer = defaultRenderer;
            this.myRenderers = new Renderers(dataGrid, treeTable);
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, @Nullable Object value2, boolean isSelected, boolean hasFocus, int row, int column) {
            TableCellRenderer renderer = this.myRenderers.getRenderer(row, 1);
            renderer = renderer != null ? renderer : this.myDefaultRenderer;
            renderer = this.myTreeTable.myCellImageCache.wrapCellRenderer(renderer);
            Component component = renderer.getTableCellRendererComponent(table, value2, isSelected, hasFocus, row, column);
            ViewIndex<DataConsumer.Row> rowIdx = ViewIndex.forRow(this.myDataGrid, row);
            ViewIndex<DataConsumer.Column> columnIdx = ViewIndex.forColumn(this.myDataGrid, column);
            return ResultViewWithCells.prepareComponent(component, this.myDataGrid, this.myView, rowIdx, columnIdx, true);
        }
    }

    private class FieldNameColumnRenderer
    implements TableCellRenderer,
    Disposable {
        final EditorTextFieldCellRenderer.AbbreviatingRendererComponent myComponent;

        private FieldNameColumnRenderer() {
            this.myComponent = DefaultTextRendererFactory.TextRenderer.createComponent(DataGridUtil.getProject(GridTreeTable.this.myResultPanel), null);
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value2, boolean isSelected, boolean hasFocus, int row, int column) {
            EditorEx editor = this.myComponent.getEditor();
            if (editor.isDisposed()) {
                return this.myComponent;
            }
            DefaultTextRendererFactory.TextRenderer.configureEditor(editor, GridTreeTable.this.myResultPanel);
            TextAttributes attributes2 = DefaultTextRendererFactory.TextRenderer.getAttributes(value2, editor.getColorsScheme(), isSelected);
            this.myComponent.setText(((Node)value2).getName(), attributes2, isSelected);
            return ResultViewWithCells.prepareComponent((Component)this.myComponent, GridTreeTable.this.myResultPanel, GridTreeTable.this.myView, ViewIndex.forRow(GridTreeTable.this.myResultPanel, row), ViewIndex.forColumn(GridTreeTable.this.myResultPanel, column), true);
        }

        public void dispose() {
            Disposer.dispose((Disposable)this.myComponent);
        }
    }
}

