/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.run.ui.grid;

import com.intellij.database.data.types.DataTypeConversion;
import com.intellij.database.datagrid.DataConsumer;
import com.intellij.database.datagrid.DataGrid;
import com.intellij.database.datagrid.DataGridUtil;
import com.intellij.database.datagrid.GridModel;
import com.intellij.database.datagrid.SelectionModel;
import com.intellij.database.datagrid.ViewIndex;
import com.intellij.database.datagrid.ViewIndexSet;
import com.intellij.database.extractors.DataExtractor;
import com.intellij.database.extractors.DataExtractorFactories;
import com.intellij.database.extractors.DataExtractorFactory;
import com.intellij.database.extractors.ExtractorsUtil;
import com.intellij.database.model.DasDataSource;
import com.intellij.database.run.ReservedCellValue;
import com.intellij.database.run.ui.DataAccessType;
import com.intellij.database.run.ui.grid.GridTransferableData;
import com.intellij.database.util.DbImplUtil;
import com.intellij.ide.CopyProvider;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.ide.CopyPasteManager;
import com.intellij.util.ui.TextTransferable;
import java.awt.datatransfer.StringSelection;
import java.awt.datatransfer.Transferable;
import java.util.ArrayList;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;

public class GridCopyProvider
implements CopyProvider {
    private static final Logger LOG = Logger.getInstance(GridCopyProvider.class);
    private final DataGrid myGrid;

    public GridCopyProvider(@NotNull DataGrid grid) {
        if (grid == null) {
            GridCopyProvider.$$$reportNull$$$0(0);
        }
        this.myGrid = grid;
    }

    public void performCopy(@NotNull DataContext dataContext) {
        if (dataContext == null) {
            GridCopyProvider.$$$reportNull$$$0(1);
        }
        DataExtractor.Text extractor = this.createExtractor(dataContext);
        String data = DataGridUtil.extractSelectedValues(this.myGrid, extractor).toString();
        boolean htmlNeeded = extractor.getFileExtension().contains("htm");
        Object content = htmlNeeded ? new TextTransferable(data) : new StringSelection(data);
        CopyPasteManager.getInstance().setContents(this.createData((Transferable)content));
    }

    public boolean isCopyEnabled(@NotNull DataContext dataContext) {
        if (dataContext == null) {
            GridCopyProvider.$$$reportNull$$$0(2);
        }
        return !this.myGrid.isEditing() && !this.myGrid.isEmpty();
    }

    public boolean isCopyVisible(@NotNull DataContext dataContext) {
        if (dataContext == null) {
            GridCopyProvider.$$$reportNull$$$0(3);
        }
        return true;
    }

    @NotNull
    private DataExtractor.Text createExtractor(@NotNull DataContext context) {
        SelectionModel selectionModel;
        if (context == null) {
            GridCopyProvider.$$$reportNull$$$0(4);
        }
        if ((selectionModel = this.myGrid.getSelectionModel()).getSelectedRowCount() == 1 && selectionModel.getSelectedColumnCount() == 1) {
            DataExtractor.Text text2 = ExtractorsUtil.getSingleValueExtractor(this.myGrid.getObjectFormatter());
            if (text2 == null) {
                GridCopyProvider.$$$reportNull$$$0(5);
            }
            return text2;
        }
        DataExtractorFactory.Text extractorFactory = this.myGrid.getExtractorFactory();
        DataExtractor.Text extractor = extractorFactory.createExtractor(context);
        extractor = extractor != null ? extractor : DataExtractorFactories.getDefault().createExtractor(context);
        DataExtractor.Text text3 = Objects.requireNonNull(extractor);
        if (text3 == null) {
            GridCopyProvider.$$$reportNull$$$0(6);
        }
        return text3;
    }

    @NotNull
    private Transferable createData(@NotNull Transferable content) {
        if (content == null) {
            GridCopyProvider.$$$reportNull$$$0(7);
        }
        SelectionModel model = this.myGrid.getSelectionModel();
        ViewIndexSet rows = model.getSelectedRows().toView(this.myGrid);
        ViewIndexSet columns = model.getSelectedColumns().toView(this.myGrid);
        if (rows.size() == 0 || columns.size() == 0) {
            Transferable transferable = content;
            if (transferable == null) {
                GridCopyProvider.$$$reportNull$$$0(8);
            }
            return transferable;
        }
        GridModel dataModel = this.myGrid.getDataModel(DataAccessType.DATA_WITH_MUTATIONS);
        int minRow = DataGridUtil.min(rows);
        int minColumn = DataGridUtil.min(columns);
        ArrayList<DataTypeConversion.Builder> result = new ArrayList<DataTypeConversion.Builder>();
        for (ViewIndex row : rows.asIterable()) {
            for (ViewIndex columnIdx : columns.asIterable()) {
                Object value2 = dataModel.getValueAt(row.toModel(this.myGrid), columnIdx.toModel(this.myGrid));
                DataConsumer.Column column = (DataConsumer.Column)this.myGrid.getDataModel(DataAccessType.DATABASE_DATA).getColumn(columnIdx.toModel(this.myGrid));
                result.add(new DataTypeConversion.Builder().value(value2 instanceof ReservedCellValue ? null : value2).firstColumn(Objects.requireNonNull(column)).firstRowIdx(row.asInteger()).firstColumnIdx(columnIdx.asInteger()).firstSystem(DbImplUtil.getMaybeLocalDataSource((DasDataSource)DataGridUtil.getDatabaseSystem(this.myGrid))).firstDbms(DataGridUtil.getDbms(this.myGrid)));
            }
        }
        return new GridTransferableData(result, content, minRow, minColumn);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 5: 
            case 6: 
            case 8: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 5: 
            case 6: 
            case 8: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "grid";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataContext";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 5: 
            case 6: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/run/ui/grid/GridCopyProvider";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "content";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/run/ui/grid/GridCopyProvider";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "createExtractor";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "createData";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "performCopy";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "isCopyEnabled";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "isCopyVisible";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "createExtractor";
                break;
            }
            case 5: 
            case 6: 
            case 8: {
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "createData";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 5: 
            case 6: 
            case 8: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

