/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.psi;

import com.intellij.database.model.DasDataSource;
import com.intellij.database.model.DasModel;
import com.intellij.database.model.DasObject;
import com.intellij.database.model.ObjectKind;
import com.intellij.database.util.DbImplUtil;
import com.intellij.database.util.TreePattern;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.JBIterable;
import com.intellij.util.containers.JBTreeTraverser;
import com.intellij.util.containers.MultiMap;
import com.intellij.util.text.CaseInsensitiveStringHashingStrategy;
import gnu.trove.TObjectHashingStrategy;
import java.util.Collection;
import java.util.Set;
import java.util.concurrent.atomic.AtomicReference;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class ModelNameIndex {
    private final AtomicReference<NameIndex> myNameIndex = new AtomicReference();

    @NotNull
    protected abstract DasModel getModel();

    @Nullable
    protected DasObject getRoot() {
        return null;
    }

    public void clear() {
        this.myNameIndex.set(null);
    }

    @NotNull
    public Collection<String> getAllNames() {
        Set set = this.getNameIndex().objects.keySet();
        if (set == null) {
            ModelNameIndex.$$$reportNull$$$0(0);
        }
        return set;
    }

    @NotNull
    public Collection<DasObject> getObjectsByName(@NotNull String name) {
        if (name == null) {
            ModelNameIndex.$$$reportNull$$$0(1);
        }
        Collection collection = this.getNameIndex().objects.get((Object)name);
        if (collection == null) {
            ModelNameIndex.$$$reportNull$$$0(2);
        }
        return collection;
    }

    @NotNull
    public Iterable<DasObject> getObjectsByNameInsensitive(@NotNull String name) {
        if (name == null) {
            ModelNameIndex.$$$reportNull$$$0(3);
        }
        NameIndex index2 = this.getNameIndex();
        JBIterable jBIterable = JBIterable.from((Iterable)index2.insensitive.get((Object)name)).flatten(arg_0 -> index2.objects.get(arg_0));
        if (jBIterable == null) {
            ModelNameIndex.$$$reportNull$$$0(4);
        }
        return jBIterable;
    }

    @NotNull
    private NameIndex getNameIndex() {
        NameIndex res;
        DasObject root2 = this.getRoot();
        DasModel model = this.getModel();
        do {
            NameIndex result;
            if ((result = this.myNameIndex.get()) != null) {
                NameIndex nameIndex = result;
                if (nameIndex == null) {
                    ModelNameIndex.$$$reportNull$$$0(5);
                }
                return nameIndex;
            }
            res = new NameIndex();
            if (root2 != null) {
                res.objects.putValue((Object)root2.getName(), (Object)root2);
            }
            int i2 = 0;
            TreePattern scope = DbImplUtil.getIntrospectionScope((DasDataSource)ObjectUtils.tryCast((Object)root2, DasDataSource.class));
            JBTreeTraverser traverser = (JBTreeTraverser)model.traverser().expand(o -> o.getKind() != ObjectKind.ROUTINE && DbImplUtil.isExpandable(o, scope));
            for (DasObject o2 : traverser.bfsTraversal()) {
                if (++i2 % 1000 == 0 && (result = this.myNameIndex.get()) != null) {
                    NameIndex nameIndex = result;
                    if (nameIndex == null) {
                        ModelNameIndex.$$$reportNull$$$0(6);
                    }
                    return nameIndex;
                }
                String name = o2.getName();
                res.objects.putValue((Object)name, (Object)o2);
                res.insensitive.putValue((Object)name, (Object)name);
            }
        } while (!this.myNameIndex.compareAndSet(null, res));
        NameIndex nameIndex = res;
        if (nameIndex == null) {
            ModelNameIndex.$$$reportNull$$$0(7);
        }
        return nameIndex;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 3: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 3: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/psi/ModelNameIndex";
                break;
            }
            case 1: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getAllNames";
                break;
            }
            case 1: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/psi/ModelNameIndex";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getObjectsByName";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getObjectsByNameInsensitive";
                break;
            }
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getNameIndex";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "getObjectsByName";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getObjectsByNameInsensitive";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 3: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class NameIndex {
        MultiMap<String, DasObject> objects = MultiMap.createLinkedSet();
        MultiMap<String, String> insensitive = MultiMap.createSet((TObjectHashingStrategy)CaseInsensitiveStringHashingStrategy.INSTANCE);

        private NameIndex() {
        }
    }
}

