/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.psi;

import com.intellij.database.model.ModelFacade;
import com.intellij.database.model.basic.BasicElement;
import com.intellij.database.psi.DbElement;
import com.intellij.database.run.ui.DataGridDocumentationProvider;
import com.intellij.database.util.QNameUtil;
import com.intellij.lang.documentation.DocumentationProviderEx;
import com.intellij.lang.documentation.ExternalDocumentationHandler;
import com.intellij.openapi.util.Pair;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiManager;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import java.awt.Image;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DbDocumentationProvider
extends DocumentationProviderEx
implements ExternalDocumentationHandler {
    @Nullable
    public String getQuickNavigateInfo(PsiElement element2, PsiElement originalElement) {
        if (element2 instanceof DbElement) {
            DbElement e = (DbElement)element2;
            return e.getTypeName() + " " + QNameUtil.getQualifiedName(e);
        }
        return null;
    }

    @Nullable
    private static String generateDoc(PsiElement element2, boolean hover) {
        if (element2 instanceof DbElement) {
            return ((DbElement)element2).getDocumentation(hover).toString();
        }
        return null;
    }

    @Nullable
    public String generateDoc(PsiElement element2, PsiElement originalElement) {
        return DbDocumentationProvider.generateDoc(element2, false);
    }

    @Nullable
    public String generateHoverDoc(@NotNull PsiElement element2, @Nullable PsiElement originalElement) {
        if (element2 == null) {
            DbDocumentationProvider.$$$reportNull$$$0(0);
        }
        return DbDocumentationProvider.generateDoc(element2, true);
    }

    @Nullable
    public Image getLocalImageForElement(@NotNull PsiElement element2, @NotNull String imageSpec) {
        if (element2 == null) {
            DbDocumentationProvider.$$$reportNull$$$0(1);
        }
        if (imageSpec == null) {
            DbDocumentationProvider.$$$reportNull$$$0(2);
        }
        return DataGridDocumentationProvider.resolveImageRef(imageSpec);
    }

    @Nullable
    public List<String> getUrlFor(PsiElement element2, PsiElement originalElement) {
        BasicElement basic;
        DbElement dbElement = (DbElement)ObjectUtils.tryCast((Object)element2, DbElement.class);
        BasicElement basicElement = basic = dbElement == null ? null : (BasicElement)ObjectUtils.tryCast((Object)dbElement.getDelegate(), BasicElement.class);
        if (basic != null) {
            String link = (String)Pair.getSecond(ModelFacade.forDbms(dbElement.getDataSource().getDbms()).getModelHelper().getDocumentationLink(basic));
            return ContainerUtil.createMaybeSingletonList((Object)link);
        }
        return null;
    }

    public boolean handleExternal(PsiElement element2, PsiElement originalElement) {
        return false;
    }

    public boolean handleExternalLink(PsiManager psiManager, String link, PsiElement context) {
        return false;
    }

    public boolean canFetchDocumentationLink(String link) {
        return false;
    }

    @NotNull
    public String fetchExternalDocumentation(@NotNull String link, @Nullable PsiElement element2) {
        if (link == null) {
            DbDocumentationProvider.$$$reportNull$$$0(3);
        }
        return "";
    }

    public boolean canHandleExternal(@Nullable PsiElement element2, @Nullable PsiElement originalElement) {
        return false;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "imageSpec";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "link";
                break;
            }
        }
        objectArray2[1] = "com/intellij/database/psi/DbDocumentationProvider";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "generateHoverDoc";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "getLocalImageForElement";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "fetchExternalDocumentation";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

