/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.plan.ui;

import com.intellij.database.plan.PlanModel;
import com.intellij.database.plan.ui.PlanRenderers;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.profiler.ui.flamechart.FlameChartColors;
import com.intellij.profiler.ui.flamegraph.DefaultFlameGraphRenderer;
import com.intellij.profiler.ui.flamegraph.FlameGraphNode;
import com.intellij.profiler.ui.flamegraph.FlameGraphPanel;
import com.intellij.ui.JBColor;
import java.awt.Color;
import java.awt.Component;
import java.awt.FontMetrics;
import java.awt.Graphics2D;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;

public class PlanFlameRenderer
extends DefaultFlameGraphRenderer<PlanModel.GenericNode> {
    @NotNull
    public String getDisplayableText(PlanModel.GenericNode node) {
        String string = node.getFullTitle();
        if (string == null) {
            PlanFlameRenderer.$$$reportNull$$$0(0);
        }
        return string;
    }

    @NotNull
    public String getTooltipText(PlanModel.GenericNode node) {
        StringBuilder res = new StringBuilder("<html><body>");
        res.append(node.getFullTitle());
        if (node.getTotalCost() != null) {
            res.append("<br>").append("Total cost: ").append(node.getTotalCost());
        }
        if (StringUtil.isNotEmpty((String)node.getRawDescription())) {
            res.append("<br>").append(node.getRawDescription().replace("\n", "<br>"));
        }
        res.append("</body></html>");
        String string = res.toString();
        if (string == null) {
            PlanFlameRenderer.$$$reportNull$$$0(1);
        }
        return string;
    }

    @NotNull
    protected Color getBackgroundColor(@NotNull FlameGraphPanel<PlanModel.GenericNode> component, @NotNull FlameGraphNode<PlanModel.GenericNode> bounds) {
        if (component == null) {
            PlanFlameRenderer.$$$reportNull$$$0(2);
        }
        if (bounds == null) {
            PlanFlameRenderer.$$$reportNull$$$0(3);
        }
        JBColor jBColor = FlameChartColors.NATIVE.INSTANCE.getBackground(component.isSearchActive(), component.isMatchingSearch(bounds), component.getSelectedNode() == bounds);
        if (jBColor == null) {
            PlanFlameRenderer.$$$reportNull$$$0(4);
        }
        return jBColor;
    }

    protected void paintText(@NotNull FlameGraphPanel<PlanModel.GenericNode> component, @NotNull Graphics2D g, @NotNull FlameGraphNode<PlanModel.GenericNode> bounds) {
        if (component == null) {
            PlanFlameRenderer.$$$reportNull$$$0(5);
        }
        if (g == null) {
            PlanFlameRenderer.$$$reportNull$$$0(6);
        }
        if (bounds == null) {
            PlanFlameRenderer.$$$reportNull$$$0(7);
        }
        g.setColor((Color)FlameChartColors.NATIVE.INSTANCE.getForeground(component.getSelectedNode() == bounds));
        String text2 = this.getDisplayableText((PlanModel.GenericNode)bounds.getContent());
        FontMetrics fm = g.getFontMetrics(g.getFont());
        int y = component.getRowHeight() / 2 + fm.getAscent() * 2 / 5;
        Icon icon = PlanRenderers.getIcon((PlanModel.GenericNode)bounds.getContent());
        if (icon != null) {
            icon.paintIcon((Component)component, g, 0, (component.getRowHeight() - icon.getIconHeight()) / 2);
        }
        g.drawString(text2, icon == null ? 0 : icon.getIconWidth(), y);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 2: 
            case 3: 
            case 5: 
            case 6: 
            case 7: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 2: 
            case 3: 
            case 5: 
            case 6: 
            case 7: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/plan/ui/PlanFlameRenderer";
                break;
            }
            case 2: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "component";
                break;
            }
            case 3: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "bounds";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "g";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getDisplayableText";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getTooltipText";
                break;
            }
            case 2: 
            case 3: 
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/plan/ui/PlanFlameRenderer";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getBackgroundColor";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getBackgroundColor";
                break;
            }
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "paintText";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 2: 
            case 3: 
            case 5: 
            case 6: 
            case 7: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

