/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.plan.ui;

import com.intellij.database.plan.PlanModel;
import com.intellij.profiler.ui.flamegraph.DefaultFlameGraphModel;
import com.intellij.util.Function;
import com.intellij.util.containers.FactoryMap;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PlanFlameModel
extends DefaultFlameGraphModel<PlanModel.GenericNode> {
    private final PlanModel myModel;
    private final Function<? super PlanModel.GenericNode, Double> myAccessor;
    private final Map<PlanModel.GenericNode, Double> myFillIn;
    private static final double RESCALE_FACTOR = 1.1;

    public PlanFlameModel(@NotNull PlanModel model, @NotNull Function<? super PlanModel.GenericNode, Double> accessor) {
        if (model == null) {
            PlanFlameModel.$$$reportNull$$$0(0);
        }
        if (accessor == null) {
            PlanFlameModel.$$$reportNull$$$0(1);
        }
        this.myFillIn = FactoryMap.create(n -> {
            Double val = null;
            for (PlanModel.GenericNode child : n.getChildren()) {
                Double cv = this.value(child);
                if (cv == null) continue;
                if (val == null) {
                    val = 0.0;
                }
                val = val + cv;
            }
            return val;
        });
        this.myModel = model;
        this.myAccessor = accessor;
    }

    @NotNull
    public PlanModel.GenericNode getRoot() {
        PlanModel.GenericNode genericNode = this.myModel.getRoot();
        if (genericNode == null) {
            PlanFlameModel.$$$reportNull$$$0(2);
        }
        return genericNode;
    }

    public PlanModel.GenericNode getChild(PlanModel.GenericNode parent2, int index2) {
        return parent2.getChildren()[index2];
    }

    public int getChildCount(PlanModel.GenericNode parent2) {
        return parent2.getChildren().length;
    }

    @Nullable
    private Double value(@NotNull PlanModel.GenericNode node) {
        Double val;
        if (node == null) {
            PlanFlameModel.$$$reportNull$$$0(3);
        }
        if ((val = (Double)this.myAccessor.fun((Object)node)) != null) {
            return val;
        }
        return this.myFillIn.get(node);
    }

    public double getFractionOfParent(PlanModel.GenericNode parent2, PlanModel.GenericNode child) {
        Double pv = this.value(parent2);
        if (pv == null || pv < 9.9E-324) {
            return 1.0;
        }
        Double cv = this.value(child);
        if (cv == null) {
            return 0.0;
        }
        if (cv.compareTo(pv) > 0) {
            return 1.0;
        }
        int cc = parent2.getChildren().length;
        if (cc == 0) {
            return cv / pv;
        }
        return cv / pv / 1.1 + 0.10000000000000009 / (double)cc / 1.1;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "model";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "accessor";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/plan/ui/PlanFlameModel";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "node";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/plan/ui/PlanFlameModel";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getRoot";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "value";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

