/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.introspection;

import com.intellij.database.model.MetaModel;
import com.intellij.database.model.ObjectKind;
import com.intellij.database.model.ObjectName;
import com.intellij.database.util.TreePattern;
import com.intellij.database.util.TreePatternNode;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.JBIterable;
import com.intellij.util.containers.MultiMap;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class IntrospectionScopes {
    static final String SPLIT = ":";
    private static final List<String> escapeChars = Arrays.asList("\u0000", "\u0001", "\u0002", "\u0003", "\u0004", "\u0005", "\u0006", "\u0007", "\b", "\t", "\n", "\u000b", "\f", "\r", "\u000e", "\u000f", "\u0010", "\u0011", "\u0012", "\u0013", "\u0014", "\u0015", "\u0016", "\u0017", "\u0018", "\u0019", "\u001a", "\u001b", "\u001c", "\u001d", "\u001e", "\u001f", " ", ",", ";", "<", ">", "'", "\"", "|", "\\", ":");
    private static final List<String> escapedChars = Arrays.asList("\\u0000", "\\u0001", "\\u0002", "\\u0003", "\\u0004", "\\u0005", "\\u0006", "\\u0007", "\\u0008", "\\u0009", "\\u000A", "\\u000B", "\\u000C", "\\u000D", "\\u000E", "\\u000F", "\\u0010", "\\u0011", "\\u0012", "\\u0013", "\\u0014", "\\u0015", "\\u0016", "\\u0017", "\\u0018", "\\u0019", "\\u001A", "\\u001B", "\\u001C", "\\u001D", "\\u001E", "\\u001F", "\\u0020", "\\u002C", "\\u003B", "\\u003C", "\\u003E", "\\u0027", "\\u0022", "\\u007C", "\\u005C", "\\u003A");

    public static void fromSchemaPatternToMap(@Nullable String schemaPattern, MultiMap<String, String> res) {
        String[] strings;
        if (StringUtil.isEmpty((String)schemaPattern)) {
            return;
        }
        for (String string : strings = IntrospectionScopes.splitSchemaPattern(schemaPattern)) {
            if ("*".equals(string)) {
                res.clear();
                res.putValue((Object)"*", (Object)"*");
                return;
            }
            List split = StringUtil.split((String)string, (String)".");
            if (split.size() == 1) {
                split.add(string.startsWith(".") ? 0 : 1, "");
            }
            if (split.size() != 2) continue;
            res.putValue(split.get(0), split.get(1));
        }
    }

    @NotNull
    public static String[] splitSchemaPattern(@NotNull String schemaPattern) {
        String[] stringArray;
        if (schemaPattern == null) {
            IntrospectionScopes.$$$reportNull$$$0(0);
        }
        if (StringUtil.isEmptyOrSpaces((String)schemaPattern)) {
            String[] stringArray2 = new String[1];
            stringArray = stringArray2;
            stringArray2[0] = "*";
        } else {
            stringArray = schemaPattern.split("[\\s,]+");
        }
        String[] strings = stringArray;
        for (int i2 = 0; i2 < strings.length; ++i2) {
            strings[i2] = strings[i2].replaceAll("&nbsp;", " ").replaceAll("&amp;", "&");
        }
        if (strings == null) {
            IntrospectionScopes.$$$reportNull$$$0(1);
        }
        return strings;
    }

    @NotNull
    public static String exportState(@NotNull MetaModel model, @NotNull TreePattern pattern) {
        if (model == null) {
            IntrospectionScopes.$$$reportNull$$$0(2);
        }
        if (pattern == null) {
            IntrospectionScopes.$$$reportNull$$$0(3);
        }
        StringBuilder b2 = new StringBuilder();
        if (model.getRootNamespaceKinds().contains((Object)ObjectKind.DATABASE)) {
            TreePatternNode.Group dbG = pattern.root.getGroup(ObjectKind.DATABASE);
            if (dbG != null) {
                if (dbG.positiveChildren != null) {
                    for (TreePatternNode<TreePatternNode.PositiveNaming> db : dbG.positiveChildren) {
                        TreePatternNode.Group scG = db.getGroup(ObjectKind.SCHEMA);
                        for (ObjectName dbName : ((TreePatternNode.BaseNaming)db.naming).names) {
                            IntrospectionScopes.exportSchemas(b2, dbName.name, scG);
                        }
                    }
                }
                if (dbG.negativeChild != null) {
                    TreePatternNode.Group scG = dbG.negativeChild.getGroup(ObjectKind.SCHEMA);
                    for (ObjectName dbName : ((TreePatternNode.NegativeNaming)dbG.negativeChild.naming).names) {
                        IntrospectionScopes.exportSchemas(b2, dbName.name, scG);
                    }
                }
            }
        } else {
            IntrospectionScopes.exportSchemas(b2, "*", pattern.root.getGroup(ObjectKind.SCHEMA));
        }
        String string = b2.toString();
        if (string == null) {
            IntrospectionScopes.$$$reportNull$$$0(4);
        }
        return string;
    }

    private static void exportSchemas(StringBuilder b2, String db, @Nullable TreePatternNode.Group scG) {
        if (b2.length() != 0) {
            b2.append('|');
        }
        b2.append(IntrospectionScopes.escape(db)).append(SPLIT);
        if (scG != null) {
            if (scG.negativeChild != null) {
                b2.append("*");
            } else if (scG.positiveChildren != null) {
                StringUtil.join((Iterable)JBIterable.of((Object[])scG.positiveChildren).flatten(n -> JBIterable.of((Object[])((TreePatternNode.PositiveNaming)n.naming).names)), n -> IntrospectionScopes.escape(n.name), (String)",", (StringBuilder)b2);
            }
        }
    }

    public static void importStateToMap(@NotNull String string, MultiMap<String, String> map2) {
        String[] bunches;
        if (string == null) {
            IntrospectionScopes.$$$reportNull$$$0(5);
        }
        for (String bunch : bunches = string.split("\\|")) {
            Object[] objectArray;
            String[] pair = bunch.split(SPLIT, 2);
            if (pair.length == 1 && ("*".equals(pair[0]) || "@".equals(pair[0]))) {
                map2.putValue((Object)pair[0], (Object)pair[0]);
            }
            if (pair.length < 2) continue;
            String database = IntrospectionScopes.unescape(pair[0]);
            if (StringUtil.isEmpty((String)pair[1])) {
                Object[] objectArray2 = new String[1];
                objectArray = objectArray2;
                objectArray2[0] = "";
            } else {
                objectArray = pair[1].split(",");
            }
            Object[] schemas = objectArray;
            Collection modifiable = map2.getModifiable((Object)database);
            ContainerUtil.addAll((Collection)modifiable, (Object[])schemas);
        }
    }

    @Contract(pure=true)
    static String escape(@NotNull String string) {
        if (string == null) {
            IntrospectionScopes.$$$reportNull$$$0(6);
        }
        return StringUtil.replace((String)string, escapeChars, escapedChars);
    }

    @Contract(pure=true)
    private static String unescape(@NotNull String string) {
        if (string == null) {
            IntrospectionScopes.$$$reportNull$$$0(7);
        }
        return StringUtil.replaceUnicodeEscapeSequences((String)string);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 4: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 4: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "schemaPattern";
                break;
            }
            case 1: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/introspection/IntrospectionScopes";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "model";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pattern";
                break;
            }
            case 5: 
            case 6: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "string";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/introspection/IntrospectionScopes";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "splitSchemaPattern";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "exportState";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "splitSchemaPattern";
                break;
            }
            case 1: 
            case 4: {
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "exportState";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "importStateToMap";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "escape";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "unescape";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 4: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

