/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dataSource;

import com.intellij.database.DatabaseBundle;
import com.intellij.database.actions.AssignColorAction;
import com.intellij.database.dataSource.AbstractDataSource;
import com.intellij.database.dataSource.AbstractDataSourceConfigurable;
import com.intellij.database.dataSource.DatabaseNameComponent;
import com.intellij.database.psi.DataSourceManager;
import com.intellij.database.psi.DbDataSource;
import com.intellij.database.psi.DbElement;
import com.intellij.database.psi.DbPsiFacade;
import com.intellij.database.psi.DbPsiFacadeImpl;
import com.intellij.database.view.DatabaseColorManager;
import com.intellij.ide.ui.laf.darcula.ui.TextFieldWithPopupHandlerUI;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.KeyboardShortcut;
import com.intellij.openapi.application.ApplicationBundle;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.application.WriteAction;
import com.intellij.openapi.keymap.KeymapUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.GraphicsConfig;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.ui.popup.ListPopup;
import com.intellij.openapi.ui.popup.ListPopupStep;
import com.intellij.openapi.ui.popup.PopupStep;
import com.intellij.openapi.ui.popup.util.BaseListPopupStep;
import com.intellij.openapi.util.Conditions;
import com.intellij.openapi.util.Ref;
import com.intellij.ui.ColorChooser;
import com.intellij.ui.ColorUtil;
import com.intellij.ui.FileColorManager;
import com.intellij.ui.JBColor;
import com.intellij.ui.awt.RelativePoint;
import com.intellij.ui.components.fields.ExtendableTextComponent;
import com.intellij.ui.components.fields.ExtendableTextField;
import com.intellij.ui.scale.JBUIScale;
import com.intellij.util.containers.JBIterable;
import com.intellij.util.ui.ColorIcon;
import com.intellij.util.ui.EmptyIcon;
import com.intellij.util.ui.GraphicsUtil;
import com.intellij.util.ui.UIUtil;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class DatabaseNameColorExtension
implements ExtendableTextComponent.Extension {
    private final String NO_COLOR;
    private static final int ICON_SIZE = EmptyIcon.ICON_16.getIconWidth();
    private static final String SHORTCUT_ACTION = "ExpandExpandableComponent";
    private static final Color ICON_COLOR = JBColor.namedColor((String)"Component.iconColor", (Color)ColorUtil.withAlpha((Color)new JBColor(8358801, 8358801), (double)0.5));
    private static final Color ICON_COLOR_HOVERED = JBColor.namedColor((String)"Component.hoverIconColor", (Color)ColorUtil.withAlpha((Color)new JBColor(8358801, 8358801), (double)0.9));
    final Icon icon;
    final Icon iconHovered;
    private final DatabaseNameComponent myNameComponent;
    private String myColorString;
    private List<String> myStandardColors;

    DatabaseNameColorExtension(@NotNull DatabaseNameComponent nameComponent) {
        if (nameComponent == null) {
            DatabaseNameColorExtension.$$$reportNull$$$0(0);
        }
        this.NO_COLOR = DatabaseBundle.message((String)"DatabaseNameColorExtension.no.color", (Object[])new Object[0]);
        this.icon = this.createColorIcon(false);
        this.iconHovered = this.createColorIcon(true);
        this.myColorString = null;
        this.myNameComponent = nameComponent;
        this.myStandardColors = this.getStandardColors();
        if (!(this.myNameComponent.getConfigurable() instanceof AbstractDataSourceConfigurable)) {
            throw new AssertionError();
        }
    }

    private Project getProject() {
        return this.myNameComponent.getConfigurable().getProject();
    }

    private ExtendableTextField getTextField() {
        return this.myNameComponent.getNameField();
    }

    @NotNull
    static Icon createColorIcon(@Nullable Color color) {
        return color == null ? EmptyIcon.ICON_16 : new RoundColorIcon(ICON_SIZE, color);
    }

    @NotNull
    Icon createColorIcon(final boolean hovered) {
        return new RoundColorIcon(ICON_SIZE, ICON_COLOR){

            @Override
            public void paintIcon(Component component, Graphics g, int i2, int j) {
                Color color;
                Color color2 = DatabaseNameColorExtension.this.myColorString != null ? DatabaseNameColorExtension.getColor(DatabaseNameColorExtension.this.myColorString, DatabaseNameColorExtension.this.getProject()) : (color = hovered ? ICON_COLOR_HOVERED : DatabaseNameColorExtension.this.getTextField().getBackground());
                Color borderColor = DatabaseNameColorExtension.this.myColorString != null ? ICON_COLOR : (hovered ? ICON_COLOR_HOVERED : ICON_COLOR);
                this.doPaint(g, i2, j, color, borderColor);
            }
        };
    }

    private List<String> getStandardColors() {
        if (this.myStandardColors == null) {
            this.myStandardColors = new ArrayList<String>(FileColorManager.getInstance((Project)this.getProject()).getColorNames());
        }
        return this.myStandardColors;
    }

    public void apply(@NotNull AbstractDataSource source) {
        if (source == null) {
            DatabaseNameColorExtension.$$$reportNull$$$0(1);
        }
        WriteAction.run(() -> DatabaseColorManager.setColorName(this.getElement(source), this.myColorString, false, false));
        AssignColorAction.updateOpenFileEditors(this.getProject());
        AssignColorAction.updateDatabaseToolwindow(this.getProject());
    }

    public void reset(@NotNull AbstractDataSource source) {
        if (source == null) {
            DatabaseNameColorExtension.$$$reportNull$$$0(2);
        }
        this.myColorString = DatabaseColorManager.getColorName(this.getElement(source), (Ref<Boolean>)Ref.create((Object)false));
        this.getTextField().repaint();
    }

    void setChosenColor(@Nullable String string) {
        this.myColorString = string;
        this.getTextField().repaint();
        this.myNameComponent.getConfigurable().getController().clearModifiedCache();
    }

    @NotNull
    private DbElement getElement(@NotNull AbstractDataSource dataSource2) {
        if (dataSource2 == null) {
            DatabaseNameColorExtension.$$$reportNull$$$0(3);
        }
        Object manager = ((AbstractDataSourceConfigurable)this.myNameComponent.getConfigurable()).getManager();
        DbDataSource dbDataSource = ((DbPsiFacadeImpl)DbPsiFacade.getInstance((Project)this.getProject())).createDataSourceWrapperElement(dataSource2, (DataSourceManager<?>)manager);
        if (dbDataSource == null) {
            DatabaseNameColorExtension.$$$reportNull$$$0(4);
        }
        return dbDataSource;
    }

    public boolean isModified() {
        Object target = this.myNameComponent.getConfigurable().getTarget();
        return !Objects.equals(DatabaseColorManager.getColorName(this.getElement((AbstractDataSource)((Object)target)), (Ref<Boolean>)Ref.create((Object)false)), this.myColorString);
    }

    @NotNull
    private static Color getColor(@Nullable String curColorName, @NotNull Project project) {
        Color color;
        if (project == null) {
            DatabaseNameColorExtension.$$$reportNull$$$0(5);
        }
        if (curColorName == null) {
            Color color2 = UIUtil.getInactiveTextFieldBackgroundColor();
            if (color2 == null) {
                DatabaseNameColorExtension.$$$reportNull$$$0(6);
            }
            return color2;
        }
        Color color3 = FileColorManager.getInstance((Project)project).getColor(curColorName);
        if (color3 != null) {
            Color color4 = color3;
            if (color4 == null) {
                DatabaseNameColorExtension.$$$reportNull$$$0(7);
            }
            return color4;
        }
        try {
            color = ColorUtil.fromHex((String)curColorName);
        }
        catch (Exception e) {
            Color color5 = UIUtil.getInactiveTextFieldBackgroundColor();
            if (color5 == null) {
                DatabaseNameColorExtension.$$$reportNull$$$0(9);
            }
            return color5;
        }
        if (color == null) {
            DatabaseNameColorExtension.$$$reportNull$$$0(8);
        }
        return color;
    }

    @Nullable
    static KeyboardShortcut getExtensionKeyboardShortcut() {
        AnAction baseAction = ActionManager.getInstance().getAction(SHORTCUT_ACTION);
        return baseAction == null ? null : (KeyboardShortcut)JBIterable.of((Object[])baseAction.getShortcutSet().getShortcuts()).filter(KeyboardShortcut.class).first();
    }

    public Icon getIcon(boolean hovered) {
        return hovered ? this.iconHovered : this.icon;
    }

    public String getTooltip() {
        return DatabaseBundle.message((String)"DatabaseNameColorExtension.choose.color", (Object[])new Object[]{KeymapUtil.getFirstKeyboardShortcutText((String)SHORTCUT_ACTION)});
    }

    public int getIconGap() {
        return 3;
    }

    public Runnable getActionOnClick() {
        return this::perform;
    }

    private void perform() {
        FileColorManager colorManager = FileColorManager.getInstance((Project)this.getProject());
        JBIterable values2 = JBIterable.of((Object)this.NO_COLOR).append((Iterable)colorManager.getColorNames()).append(this.myColorString != null && !colorManager.getColorNames().contains(this.myColorString) ? this.myColorString : null).append((Object)DatabaseNameColorExtension.getCustom());
        JBIterable icons = values2.map(o -> o == this.NO_COLOR || o == DatabaseNameColorExtension.getCustom() ? null : colorManager.getColor(o)).map(DatabaseNameColorExtension::createColorIcon);
        BaseListPopupStep<String> popupStep = new BaseListPopupStep<String>("", values2.toList(), icons.toList()){

            public boolean isSpeedSearchEnabled() {
                return true;
            }

            @Nullable
            public PopupStep onChosen(String selectedValue, boolean finalChoice) {
                if (selectedValue == DatabaseNameColorExtension.getCustom()) {
                    ApplicationManager.getApplication().invokeLater(() -> {
                        Color color = ColorChooser.chooseColor((Component)DatabaseNameColorExtension.this.getTextField(), (String)DatabaseBundle.message((String)"DatabaseNameColorExtension.choose.color.title", (Object[])new Object[0]), (Color)DatabaseNameColorExtension.getColor(DatabaseNameColorExtension.this.myColorString, DatabaseNameColorExtension.this.getProject()));
                        if (color != null) {
                            DatabaseNameColorExtension.this.setChosenColor(ColorUtil.toHex((Color)color));
                        }
                    }, ModalityState.stateForComponent((Component)DatabaseNameColorExtension.this.getTextField()));
                } else {
                    DatabaseNameColorExtension.this.setChosenColor(selectedValue == DatabaseNameColorExtension.this.NO_COLOR ? null : selectedValue);
                }
                return super.onChosen((Object)selectedValue, finalChoice);
            }
        };
        popupStep.setDefaultOptionIndex(values2.indexOf(Conditions.equalTo((Object)this.myColorString)));
        ListPopup popup = JBPopupFactory.getInstance().createListPopup((ListPopupStep)popupStep);
        Rectangle bounds = ((TextFieldWithPopupHandlerUI)this.getTextField().getUI()).getExtensionIconBounds((ExtendableTextComponent.Extension)this);
        Point point = bounds.getLocation();
        point.y += bounds.width + JBUIScale.scale((int)2);
        popup.show(new RelativePoint((Component)this.getTextField(), point));
    }

    private static String getCustom() {
        return ApplicationBundle.message((String)"custom.option", (Object[])new Object[0]);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: 
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: 
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "nameComponent";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "source";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataSource";
                break;
            }
            case 4: 
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/dataSource/DatabaseNameColorExtension";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/dataSource/DatabaseNameColorExtension";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getElement";
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getColor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "apply";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "reset";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getElement";
                break;
            }
            case 4: 
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getColor";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 4: 
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class RoundColorIcon
    extends ColorIcon {
        final Color borderColor;

        RoundColorIcon(int size, @NotNull Color color) {
            if (color == null) {
                RoundColorIcon.$$$reportNull$$$0(0);
            }
            this(size, color, ICON_COLOR);
        }

        RoundColorIcon(int size, @NotNull Color color, @NotNull Color borderColor) {
            if (color == null) {
                RoundColorIcon.$$$reportNull$$$0(1);
            }
            if (borderColor == null) {
                RoundColorIcon.$$$reportNull$$$0(2);
            }
            super(size, color, true);
            this.borderColor = borderColor;
        }

        public void paintIcon(Component component, Graphics g, int i2, int j) {
            this.doPaint(g, i2, j, this.getIconColor(), this.borderColor);
        }

        void doPaint(Graphics g, int i2, int j, Color color, Color borderColor) {
            GraphicsConfig config = GraphicsUtil.setupAAPainting((Graphics)g);
            int dim = this.getIconWidth() - 2;
            g.setColor(color);
            g.fillOval(i2 + 1, j + 1, dim, dim);
            g.setColor(borderColor);
            g.drawOval(i2 + 1, j + 1, dim, dim);
            config.restore();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "color";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[0] = "borderColor";
                    break;
                }
            }
            objectArray[1] = "com/intellij/database/dataSource/DatabaseNameColorExtension$RoundColorIcon";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

