/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.console.session;

import com.intellij.database.DataBus;
import com.intellij.database.console.client.DatabaseSessionClient;
import com.intellij.database.console.client.DatabaseSessionClientWithFile;
import com.intellij.database.console.session.DatabaseSession;
import com.intellij.database.dataSource.LocalDataSource;
import com.intellij.database.dataSource.connection.DatabaseDepartment;
import com.intellij.database.datagrid.DataRequest;
import com.intellij.icons.AllIcons;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ui.AnimatedIcon;
import com.intellij.util.ThrowableConsumer;
import com.intellij.util.ThrowableConvertor;
import java.util.Collection;
import java.util.List;
import javax.swing.Icon;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.JvmName;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=2, d1={"\u0000l\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\u001a6\u0010\u0002\u001a\u000e\u0012\u0004\u0012\u0002H\u0004\u0012\u0004\u0012\u00020\u00050\u0003\"\u0004\b\u0000\u0010\u0004\"\b\b\u0001\u0010\u0006*\u00020\u00072\u0012\u0010\u0002\u001a\u000e\u0012\u0004\u0012\u0002H\u0004\u0012\u0004\u0012\u0002H\u00060\b\u001a\u000e\u0010\t\u001a\u00020\u00052\u0006\u0010\n\u001a\u00020\u000b\u001a\u0018\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0001H\u0002\u001aB\u0010\u0011\u001a\u000e\u0012\u0004\u0012\u0002H\u0004\u0012\u0004\u0012\u0002H\u00120\u0003\"\u0004\b\u0000\u0010\u0004\"\u0004\b\u0001\u0010\u0012\"\b\b\u0002\u0010\u0006*\u00020\u00072\u0018\u0010\u0013\u001a\u0014\u0012\u0004\u0012\u0002H\u0004\u0012\u0004\u0012\u0002H\u0012\u0012\u0004\u0012\u0002H\u00060\u0014\u001a\u0012\u0010\u0015\u001a\u0004\u0018\u00010\r2\u0006\u0010\u0016\u001a\u00020\u0017H\u0002\u001a\u0018\u0010\u0018\u001a\u0004\u0018\u00010\u00192\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u0016\u001a\u00020\u0017\u001a \u0010\u0018\u001a\u0004\u0018\u00010\u00192\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u001c\u001a\u00020\u000f\u001a\u0010\u0010\u001d\u001a\u0004\u0018\u00010\r2\u0006\u0010\u0016\u001a\u00020\u0017\u001a\u0018\u0010\u001d\u001a\u0004\u0018\u00010\r2\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u0016\u001a\u00020\u0017\u001a\u000e\u0010\u001e\u001a\u00020\u000f2\u0006\u0010\u0016\u001a\u00020\u0017\u001a\u000e\u0010\u001f\u001a\u00020\u000f2\u0006\u0010 \u001a\u00020!\u001a\u000e\u0010\"\u001a\u00020\u000f2\u0006\u0010\n\u001a\u00020#\u001a\u0016\u0010$\u001a\u00020\u000f2\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010%\u001a\u00020&\u001a\u0016\u0010$\u001a\u00020\u000f2\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010'\u001a\u00020(\u001a\u000e\u0010)\u001a\u00020\u000f2\u0006\u0010\u0016\u001a\u00020\u0017\u001a\u000e\u0010*\u001a\u00020\u000f2\u0006\u0010\u0016\u001a\u00020\u0017\u001a\u000e\u0010+\u001a\u00020\r2\u0006\u0010\u0016\u001a\u00020\u0017\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006,"}, d2={"progressTimeout", "", "consumer", "Lkotlin/Function1;", "T", "", "E", "", "Lcom/intellij/util/ThrowableConsumer;", "disconnect", "owner", "Lcom/intellij/database/datagrid/DataRequest$OwnerEx;", "formatDuration", "", "inProgress", "", "time", "function", "R", "func", "Lcom/intellij/util/ThrowableConvertor;", "getIdleMessage", "session", "Lcom/intellij/database/console/session/DatabaseSession;", "getProgressIcon", "Ljavax/swing/Icon;", "work", "Lcom/intellij/database/console/session/DatabaseSession$State$Work;", "idleIcon", "getTimeSpent", "hasAnyNonFinishedWork", "isInternalDepartment", "department", "Lcom/intellij/database/dataSource/connection/DatabaseDepartment;", "isInternalOwner", "Lcom/intellij/database/datagrid/DataRequest$Owner;", "needToSaveSessionName", "client", "Lcom/intellij/database/console/client/DatabaseSessionClientWithFile;", "file", "Lcom/intellij/openapi/vfs/VirtualFile;", "needToShowProgress", "needToShowTimeSpent", "qualifiedName", "intellij.database.impl"})
@JvmName(name="SessionsUtil")
public final class SessionsUtil {
    public static final long progressTimeout = 1000L;

    @NotNull
    public static final <T, R, E extends Throwable> Function1<T, R> function(@NotNull ThrowableConvertor<T, R, E> func) {
        Intrinsics.checkParameterIsNotNull(func, (String)"func");
        return new Function1<T, R>(func){
            final /* synthetic */ ThrowableConvertor $func;

            public final R invoke(T t) {
                return (R)this.$func.convert(t);
            }
            {
                this.$func = throwableConvertor;
                super(1);
            }
        };
    }

    @NotNull
    public static final <T, E extends Throwable> Function1<T, Unit> consumer(@NotNull ThrowableConsumer<T, E> consumer2) {
        Intrinsics.checkParameterIsNotNull(consumer2, (String)"consumer");
        return new Function1<T, Unit>(consumer2){
            final /* synthetic */ ThrowableConsumer $consumer;

            public final void invoke(T t) {
                this.$consumer.consume(t);
            }
            {
                this.$consumer = throwableConsumer;
                super(1);
            }
        };
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static final boolean isInternalOwner(@NotNull DataRequest.Owner owner) {
        Intrinsics.checkParameterIsNotNull((Object)owner, (String)"owner");
        if (!(owner instanceof DatabaseSessionClient)) return false;
        DatabaseDepartment databaseDepartment = ((DatabaseSessionClient)owner).getDepartment();
        Intrinsics.checkExpressionValueIsNotNull((Object)databaseDepartment, (String)"owner.department");
        if (!SessionsUtil.isInternalDepartment(databaseDepartment)) return false;
        return true;
    }

    public static final boolean isInternalDepartment(@NotNull DatabaseDepartment department) {
        Intrinsics.checkParameterIsNotNull((Object)department, (String)"department");
        Application application = ApplicationManager.getApplication();
        Intrinsics.checkExpressionValueIsNotNull((Object)application, (String)"ApplicationManager.getApplication()");
        return !application.isUnitTestMode() && department.isInternal() && !department.isService();
    }

    public static final void disconnect(@NotNull DataRequest.OwnerEx owner) {
        Intrinsics.checkParameterIsNotNull((Object)owner, (String)"owner");
        DataBus.Consuming consuming = owner.getMessageBus();
        Intrinsics.checkExpressionValueIsNotNull((Object)consuming, (String)"owner.messageBus");
        consuming.getDataProducer().processRequest(new DataRequest.Disconnect(owner));
    }

    public static final boolean needToSaveSessionName(@NotNull DatabaseSession session2, @NotNull DatabaseSessionClientWithFile client) {
        Intrinsics.checkParameterIsNotNull((Object)session2, (String)"session");
        Intrinsics.checkParameterIsNotNull((Object)client, (String)"client");
        return SessionsUtil.needToSaveSessionName(session2, client.getVirtualFile());
    }

    public static final boolean needToSaveSessionName(@NotNull DatabaseSession session2, @NotNull VirtualFile file) {
        Intrinsics.checkParameterIsNotNull((Object)session2, (String)"session");
        Intrinsics.checkParameterIsNotNull((Object)file, (String)"file");
        return !session2.isService() && Intrinsics.areEqual((Object)session2.getTitle(), (Object)DatabaseSession.Companion.getTitle(session2.getProject(), file)) ^ true;
    }

    @Nullable
    public static final Icon getProgressIcon(@NotNull DatabaseSession.State.Work work, @NotNull DatabaseSession session2) {
        Intrinsics.checkParameterIsNotNull((Object)work, (String)"work");
        Intrinsics.checkParameterIsNotNull((Object)session2, (String)"session");
        return SessionsUtil.getProgressIcon(work, session2, false);
    }

    @Nullable
    public static final Icon getProgressIcon(@NotNull DatabaseSession.State.Work work, @NotNull DatabaseSession session2, boolean idleIcon) {
        Intrinsics.checkParameterIsNotNull((Object)work, (String)"work");
        Intrinsics.checkParameterIsNotNull((Object)session2, (String)"session");
        return work.getState() != DatabaseSession.State.WorkState.FINISHED && SessionsUtil.needToShowProgress(session2) ? (idleIcon && work.getState() == DatabaseSession.State.WorkState.SUBMITTED ? AllIcons.RunConfigurations.TestNotRan : (Icon)AnimatedIcon.Default.INSTANCE) : null;
    }

    @Nullable
    public static final String getTimeSpent(@NotNull DatabaseSession.State.Work work, @NotNull DatabaseSession session2) {
        Intrinsics.checkParameterIsNotNull((Object)work, (String)"work");
        Intrinsics.checkParameterIsNotNull((Object)session2, (String)"session");
        if (!SessionsUtil.needToShowTimeSpent(session2)) {
            return null;
        }
        long time = work.getTimeSpentMs();
        if (time <= 0L) {
            return null;
        }
        DatabaseSession.State.WorkState workState = work.getState();
        return workState != DatabaseSession.State.WorkState.SUBMITTED ? SessionsUtil.formatDuration(workState == DatabaseSession.State.WorkState.RUNNING, time) : SessionsUtil.getIdleMessage(session2);
    }

    @Nullable
    public static final String getTimeSpent(@NotNull DatabaseSession session2) {
        Intrinsics.checkParameterIsNotNull((Object)session2, (String)"session");
        if (!SessionsUtil.needToShowTimeSpent(session2)) {
            return null;
        }
        DatabaseSession.State state = session2.getState();
        long time = state.getTimeSpentMs();
        return time <= 0L ? null : SessionsUtil.formatDuration(!state.isIdle(), time);
    }

    public static final boolean needToShowProgress(@NotNull DatabaseSession session2) {
        Intrinsics.checkParameterIsNotNull((Object)session2, (String)"session");
        DatabaseSession.State state = session2.getState();
        return SessionsUtil.hasAnyNonFinishedWork(session2) && System.currentTimeMillis() - state.getStartTime() >= 1000L;
    }

    public static final boolean hasAnyNonFinishedWork(@NotNull DatabaseSession session2) {
        Intrinsics.checkParameterIsNotNull((Object)session2, (String)"session");
        DatabaseSession.State state = session2.getState();
        return !state.isIdle() && state.getStartTime() != 0L;
    }

    public static final boolean needToShowTimeSpent(@NotNull DatabaseSession session2) {
        Intrinsics.checkParameterIsNotNull((Object)session2, (String)"session");
        DatabaseSession.State state = session2.getState();
        return !state.isEmpty() && (state.isIdle() || state.getTimeSpentMs() >= 1000L);
    }

    @NotNull
    public static final String qualifiedName(@NotNull DatabaseSession session2) {
        Intrinsics.checkParameterIsNotNull((Object)session2, (String)"session");
        StringBuilder stringBuilder = new StringBuilder().append(session2.getTitle()).append(" [");
        LocalDataSource localDataSource = (LocalDataSource)session2.getTarget();
        Intrinsics.checkExpressionValueIsNotNull((Object)localDataSource, (String)"session.target");
        return stringBuilder.append(localDataSource.getName()).append(']').toString();
    }

    private static final String formatDuration(boolean inProgress, long time) {
        long timeToFormat = inProgress && time > 3000L ? time / 1000L * 1000L : time;
        String string = StringUtil.formatDuration((long)timeToFormat);
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"StringUtil.formatDuration(timeToFormat)");
        return string;
    }

    private static final String getIdleMessage(DatabaseSession session2) {
        boolean bl;
        block3: {
            DatabaseSession.State state = session2.getState();
            List<DatabaseSession.State.Work> work = state.getWork();
            Iterable $this$any$iv = work;
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    DatabaseSession.State.Work w = (DatabaseSession.State.Work)element$iv;
                    boolean bl2 = false;
                    if (!(w.getState() == DatabaseSession.State.WorkState.RUNNING)) continue;
                    bl = true;
                    break block3;
                }
                bl = false;
            }
        }
        return bl ? "waiting" : null;
    }
}

