/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.console;

import com.intellij.database.DataBus;
import com.intellij.database.DatabaseBundle;
import com.intellij.database.DatabaseDataKeys;
import com.intellij.database.Dbms;
import com.intellij.database.access.DatabaseCredentials;
import com.intellij.database.console.AbstractEngine;
import com.intellij.database.console.DatabaseAccessController;
import com.intellij.database.console.DbQueryValidator;
import com.intellij.database.console.EngineConnectionWatcher;
import com.intellij.database.console.ExecutionEnvironmentHelper;
import com.intellij.database.console.GridColumnsManager;
import com.intellij.database.console.GridColumnsManagerFactory;
import com.intellij.database.console.JdbcDriverManager;
import com.intellij.database.console.SuppressUserStackTrace;
import com.intellij.database.console.session.DatabaseSession;
import com.intellij.database.console.session.SessionsUtil;
import com.intellij.database.dataSource.DatabaseConnection;
import com.intellij.database.dataSource.DatabaseConnectionManager;
import com.intellij.database.dataSource.DatabaseDriver;
import com.intellij.database.dataSource.LocalDataSource;
import com.intellij.database.dataSource.connection.ConnectionRequestor;
import com.intellij.database.dataSource.connection.DGDepartment;
import com.intellij.database.dataSource.connection.DatabaseDepartment;
import com.intellij.database.dataSource.connection.audit.AuditService;
import com.intellij.database.dataSource.connection.statements.CallableStatementData;
import com.intellij.database.dataSource.connection.statements.ClosableResultsProducer;
import com.intellij.database.dataSource.connection.statements.Configuration;
import com.intellij.database.dataSource.connection.statements.ExecutionMode;
import com.intellij.database.dataSource.connection.statements.OutParameter;
import com.intellij.database.dataSource.connection.statements.ParameterizedStatementData;
import com.intellij.database.dataSource.connection.statements.ResultsProducer;
import com.intellij.database.dataSource.connection.statements.SmartStatementMark;
import com.intellij.database.dataSource.connection.statements.SmartStatements;
import com.intellij.database.dataSource.connection.statements.SmartStatementsUtil;
import com.intellij.database.dataSource.connection.statements.StandardExecutionMode;
import com.intellij.database.dataSource.connection.statements.StandardResultsProcessors;
import com.intellij.database.dataSource.connection.statements.StatementParameters;
import com.intellij.database.dataSource.connection.statements.TypedOutParameter;
import com.intellij.database.dataSource.url.JdbcUrlParserUtil;
import com.intellij.database.datagrid.AutoValueDescriptor;
import com.intellij.database.datagrid.DataAuditor;
import com.intellij.database.datagrid.DataConsumer;
import com.intellij.database.datagrid.DataProducer;
import com.intellij.database.datagrid.DataRequest;
import com.intellij.database.datagrid.PreparedStatementContext;
import com.intellij.database.datagrid.RawStatementContext;
import com.intellij.database.datagrid.mutating.ColumnDescriptor;
import com.intellij.database.datagrid.mutating.ColumnQueryData;
import com.intellij.database.datagrid.mutating.QueryData;
import com.intellij.database.datagrid.mutating.RowMutation;
import com.intellij.database.datagrid.mutating.RowQueryData;
import com.intellij.database.datagrid.mutating.RowUpdateData;
import com.intellij.database.dialects.DatabaseDialectEx;
import com.intellij.database.dialects.DatabaseErrorHandler;
import com.intellij.database.model.DasObject;
import com.intellij.database.model.ObjectKind;
import com.intellij.database.psi.DbDataSource;
import com.intellij.database.remote.jdbc.RemoteConnection;
import com.intellij.database.remote.jdbc.RemoteDatabaseMetaData;
import com.intellij.database.remote.jdbc.RemoteResultSet;
import com.intellij.database.remote.jdbc.RemoteResultSetMetaData;
import com.intellij.database.remote.jdbc.RemoteSavepoint;
import com.intellij.database.remote.jdbc.helpers.CassJdbcHelper;
import com.intellij.database.remote.jdbc.helpers.JdbcNativeUtil;
import com.intellij.database.run.ConsoleDataRequest;
import com.intellij.database.run.ConsoleRunConfiguration;
import com.intellij.database.run.ReservedCellValue;
import com.intellij.database.run.actions.TransactionAction;
import com.intellij.database.run.audit.MeasuringDataAuditor;
import com.intellij.database.script.generator.dml.DeleteRowsTask;
import com.intellij.database.script.generator.dml.DmlGenerator;
import com.intellij.database.script.generator.dml.DmlTaskKt;
import com.intellij.database.script.generator.dml.DmlUtilKt;
import com.intellij.database.script.generator.dml.SelectTask;
import com.intellij.database.settings.DatabaseSettings;
import com.intellij.database.util.DbImplUtil;
import com.intellij.database.util.DbSqlUtil;
import com.intellij.database.util.DdlBuilder;
import com.intellij.database.util.ErrorHandler;
import com.intellij.database.util.GuardedRef;
import com.intellij.database.util.JdbcUtil;
import com.intellij.database.util.ObjectPath;
import com.intellij.database.util.SearchPath;
import com.intellij.execution.ExecutionException;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.ThrowableComputable;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.sql.psi.SqlFile;
import com.intellij.sql.psi.SqlPsiFacade;
import com.intellij.sql.psi.SqlTableType;
import com.intellij.util.Consumer;
import com.intellij.util.ExceptionUtil;
import com.intellij.util.Function;
import com.intellij.util.ObjectUtils;
import com.intellij.util.ThrowableRunnable;
import com.intellij.util.TimeoutUtil;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.ImmutableList;
import com.intellij.util.containers.JBIterable;
import gnu.trove.TIntArrayList;
import gnu.trove.TIntObjectHashMap;
import gnu.trove.TObjectHashingStrategy;
import gnu.trove.TObjectIntHashMap;
import java.io.IOException;
import java.lang.invoke.LambdaMetafactory;
import java.rmi.RemoteException;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JdbcEngine
extends AbstractEngine
implements DataProducer,
ConnectionRequestor {
    public static final Key<Boolean> SUPPORTS_SAVEPOINTS_KEY = Key.create((String)"SUPPORTS_SAVEPOINTS");
    private static final Key<Boolean> WAS_STATEMENTS = Key.create((String)"engine.audit.service.was.statements");
    private static final Logger LOG = Logger.getInstance(JdbcEngine.class);
    private static final TObjectHashingStrategy<RowQueryData> QUERY_DATA_HASHING_STRATEGY = new TObjectHashingStrategy<RowQueryData>(){

        public int computeHashCode(RowQueryData object) {
            return Comparing.hashcode(object.getColumnsData());
        }

        public boolean equals(RowQueryData o1, RowQueryData o2) {
            return Comparing.equal(o1.getColumnsData(), o2.getColumnsData());
        }
    };
    private final DatabaseAccessController myDatabaseAccessController;
    private final JdbcDriverManager myDriverManager;
    private final List<SmartStatementMark> myCurrentStatements;
    private final LocalDataSource myDataSource;
    private final AuditService myAuditService;
    private final EngineConnectionWatcher myConnectionWatcher;
    private final ThrowableComputable<GuardedRef<DatabaseConnection>, Exception> myConnectionFactory;
    private volatile GuardedRef<DatabaseConnection> myConnection;
    private DataRequest.TxMarker myTxMarker;
    private DataRequest.Owner myTransactionOwner;
    private final Supplier<ConsoleRunConfiguration> myConfigurationSupplier;
    private volatile ConsoleRunConfiguration myConfiguration;
    private final AtomicReference<State> myState;
    private boolean mySupportsSavepoints;
    private volatile boolean mySystemQuery;
    private volatile SearchPath mySearchPath;
    private DatabaseDialectEx myDialect;
    private Dbms myDbms;

    public JdbcEngine(@NotNull Project project, @NotNull DataBus.Producing messageBus, @NotNull LocalDataSource dataSource2) {
        if (project == null) {
            JdbcEngine.$$$reportNull$$$0(0);
        }
        if (messageBus == null) {
            JdbcEngine.$$$reportNull$$$0(1);
        }
        if (dataSource2 == null) {
            JdbcEngine.$$$reportNull$$$0(2);
        }
        this(project, messageBus, dataSource2, dataSource2.isAutoCommit());
    }

    public JdbcEngine(@NotNull Project project, @NotNull DataBus.Producing messageBus, @NotNull LocalDataSource dataSource2, boolean autoCommit) {
        if (project == null) {
            JdbcEngine.$$$reportNull$$$0(3);
        }
        if (messageBus == null) {
            JdbcEngine.$$$reportNull$$$0(4);
        }
        if (dataSource2 == null) {
            JdbcEngine.$$$reportNull$$$0(5);
        }
        this(project, messageBus, dataSource2, null, null, autoCommit);
    }

    public JdbcEngine(@NotNull Project project, @NotNull DataBus.Producing messageBus, @NotNull LocalDataSource dataSource2, @Nullable DatabaseCredentials credentialStore, @NotNull DatabaseSession session2) {
        if (project == null) {
            JdbcEngine.$$$reportNull$$$0(6);
        }
        if (messageBus == null) {
            JdbcEngine.$$$reportNull$$$0(7);
        }
        if (dataSource2 == null) {
            JdbcEngine.$$$reportNull$$$0(8);
        }
        if (session2 == null) {
            JdbcEngine.$$$reportNull$$$0(9);
        }
        this(project, messageBus, dataSource2, () -> JdbcDriverManager.getDriverManager(project).getDefaultRunConfiguration(dataSource2, credentialStore), session2, dataSource2.isAutoCommit());
    }

    private JdbcEngine(@NotNull Project project, @NotNull DataBus.Producing messageBus, @NotNull LocalDataSource dataSource2, @Nullable Supplier<ConsoleRunConfiguration> configurationSupplier, @Nullable DatabaseSession session2, boolean autoCommit) {
        if (project == null) {
            JdbcEngine.$$$reportNull$$$0(10);
        }
        if (messageBus == null) {
            JdbcEngine.$$$reportNull$$$0(11);
        }
        if (dataSource2 == null) {
            JdbcEngine.$$$reportNull$$$0(12);
        }
        super(project, messageBus);
        this.myCurrentStatements = ContainerUtil.createConcurrentList();
        this.myState = new AtomicReference<State>(State.IDLE);
        this.myDataSource = dataSource2;
        this.myDriverManager = JdbcDriverManager.getDriverManager(project);
        this.myConfigurationSupplier = configurationSupplier == null ? () -> this.myDriverManager.getDefaultRunConfiguration(this.myDataSource, null) : configurationSupplier;
        this.myConnectionFactory = this::createConnection;
        this.myTxMarker = DataRequest.getInitialTxMarker(autoCommit);
        this.myDatabaseAccessController = this.createAccessController();
        this.myAuditService = AuditService.compose(new EngineAuditService(), session2 == null ? null : session2.getAuditService());
        this.myConnectionWatcher = new EngineConnectionWatcher(project, dataSource2, this);
    }

    @NotNull
    private DatabaseAccessController createAccessController() {
        Project project = this.getProject();
        DbDataSource dataSource2 = DbImplUtil.getDbDataSource(project, this.myDataSource);
        if (dataSource2 == null) {
            DatabaseAccessController databaseAccessController = DatabaseAccessController.alwaysSuccess();
            if (databaseAccessController == null) {
                JdbcEngine.$$$reportNull$$$0(13);
            }
            return databaseAccessController;
        }
        DatabaseAccessController.PsiBasedReadOnly psiBased = new DatabaseAccessController.PsiBasedReadOnly(project, DbSqlUtil.getSqlDialect(this.myDataSource), dataSource2, () -> this.mySearchPath);
        return new DatabaseAccessController.DataSourceBased(dataSource2, psiBased);
    }

    @Nullable
    private GuardedRef<DatabaseConnection> createConnection() {
        ObjectPath currentNamespace = this.getCurrentNamespace();
        try {
            this.myConfiguration = this.myConfigurationSupplier.get();
            GuardedRef<DatabaseConnection> connection2 = DatabaseConnectionManager.getInstance().build(this.getProject(), this.myDataSource).setRequestor(this).setRunConfiguration(this.myConfiguration).setDestination(currentNamespace).create();
            if (connection2 != null) {
                String dest = "";
                if (connection2.get().getConnectionPoint() != this.myDataSource) {
                    String bounded;
                    DatabaseDriver driver = this.myDataSource.getDatabaseDriver();
                    DatabaseDriver.Bounds bounds = driver == null ? null : driver.getConnectionBounds();
                    String string = bounded = bounds != null ? JdbcUrlParserUtil.getObjectItem(currentNamespace, bounds.boundTo) : null;
                    if (StringUtil.isNotEmpty((String)bounded)) {
                        dest = " to " + bounded;
                    }
                }
                this.getDataAuditor().print(this.getRequestContext(), "Connected" + dest);
            }
            this.myConnectionWatcher.restart();
            return connection2;
        }
        catch (Exception e) {
            ErrorHandler handler = new ErrorHandler();
            DatabaseConnectionManager.handleConnectionError(e, handler, this.myDataSource);
            this.getDataAuditor().error(this.getRequestContext(), handler.getSummary(), null);
            throw new ProcessCanceledException((Throwable)e);
        }
    }

    @Nullable
    public DatabaseConnection getCurrentConnection() {
        return this.myConnection == null ? null : this.purposedConnection(this.myConnection.get());
    }

    @Nullable
    public DatabaseConnection getConnection() throws Exception {
        return this.getConnection(true);
    }

    @Nullable
    private SearchPath getSearchPath() {
        return this.mySearchPath;
    }

    private void requestSearchPath(@NotNull DatabaseConnection connection2) {
        if (connection2 == null) {
            JdbcEngine.$$$reportNull$$$0(14);
        }
        try {
            this.setSearchPath(this.loadSearchPath(connection2));
        }
        catch (Exception e) {
            LOG.warn(JdbcEngine.getErrorMessage(e, this.myDataSource));
        }
    }

    @Nullable
    private SearchPath loadSearchPath(@NotNull DatabaseConnection connection2) throws SQLException {
        if (connection2 == null) {
            JdbcEngine.$$$reportNull$$$0(15);
        }
        this.mySystemQuery = true;
        try {
            SearchPath searchPath = this.myDialect.tryToLoadSearchPath(this.myDataSource, connection2);
            return searchPath;
        }
        finally {
            this.mySystemQuery = false;
        }
    }

    private void requestSearchPathTransparent(@NotNull DatabaseConnection connection2) throws Exception {
        if (connection2 == null) {
            JdbcEngine.$$$reportNull$$$0(16);
        }
        new PotentiallyAtomicOperation(new PotentiallyTransparentOperation(){

            @Override
            public boolean shouldRequestSearchPath() {
                return false;
            }

            @Override
            boolean transparent(@NotNull DatabaseConnection connection2) {
                if (connection2 == null) {
                    2.$$$reportNull$$$0(0);
                }
                JdbcEngine.this.requestSearchPath(connection2);
                return true;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "connection", "com/intellij/database/console/JdbcEngine$2", "transparent"));
            }
        }, this.isTransactionJustStarted()).perform(connection2);
    }

    private void setSearchPath(@Nullable SearchPath searchPath) {
        this.mySearchPath = searchPath;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    private DatabaseConnection getConnection(boolean setCurrentSchema) throws Exception {
        DatabaseConnection connection2 = this.getCurrentConnection();
        boolean freshConnection = false;
        if (!this.isConnectionReady(connection2)) {
            ThrowableComputable<GuardedRef<DatabaseConnection>, Exception> throwableComputable = this.myConnectionFactory;
            synchronized (throwableComputable) {
                GuardedRef ref;
                this.releaseConnection(false);
                this.myConnection = ref = (GuardedRef)this.myConnectionFactory.compute();
                connection2 = ref == null ? null : this.purposedConnection((DatabaseConnection)ref.get());
                freshConnection = true;
            }
            this.myDbms = this.myDataSource.getDbms();
            this.myDialect = DbImplUtil.getDatabaseDialect(this.myDataSource);
        }
        if (!this.isConnectionReady(connection2)) {
            this.releaseConnection(true);
            this.myConnection = null;
            connection2 = null;
        }
        if (connection2 == null) {
            this.getDataAuditor().error(this.getRequestContext(), "Connection failed", null);
        } else {
            this.prepareConnection(connection2, setCurrentSchema && freshConnection);
        }
        return connection2;
    }

    @Nullable
    DatabaseConnection getConnectionIfValid() {
        DatabaseConnection connection2 = this.getCurrentConnection();
        return this.isConnectionReady(connection2) ? connection2 : null;
    }

    @Nullable
    private DatabaseConnection purposedConnection(@Nullable DatabaseConnection connection2) {
        if (connection2 == null) {
            return null;
        }
        DatabaseDepartment department = this.currentDepartment();
        return department == null ? connection2 : SmartStatements.purposed(connection2, department);
    }

    @Nullable
    private DatabaseDepartment currentDepartment() {
        DataRequest.Context context = this.getRequestContextIfAny();
        if (context == null) {
            return null;
        }
        DataRequest.DepartmentHolder holder = (DataRequest.DepartmentHolder)ObjectUtils.tryCast((Object)context.request.owner, DataRequest.DepartmentHolder.class);
        return holder == null ? null : holder.getDepartment();
    }

    @Override
    public boolean cancelPendingRequests() {
        super.cancelPendingRequests();
        DataRequest.Context context = this.getRequestContextIfAny();
        if (context == null) {
            return false;
        }
        if (this.myState.compareAndSet(State.STREAMING, State.CANCELED)) {
            this.getDataAuditor().print(context, "Cancelling...");
            return true;
        }
        if (this.myState.compareAndSet(State.RUNNING, State.CANCELED)) {
            ArrayList<SmartStatementMark> marks = new ArrayList<SmartStatementMark>(this.myCurrentStatements);
            if (marks.isEmpty()) {
                return true;
            }
            ApplicationManager.getApplication().executeOnPooledThread(() -> {
                if (this.getRequestContextIfAny() == context) {
                    TimeoutUtil.sleep((long)500L);
                    if (this.getRequestContextIfAny() == context) {
                        this.getDataAuditor().print(context, "Cancelling...");
                        for (SmartStatementMark mark2 : marks) {
                            try {
                                mark2.cancel();
                            }
                            catch (Throwable throwable) {}
                        }
                    }
                }
            });
            return true;
        }
        return false;
    }

    @NotNull
    public LocalDataSource getDataSource() {
        LocalDataSource localDataSource = this.myDataSource;
        if (localDataSource == null) {
            JdbcEngine.$$$reportNull$$$0(17);
        }
        return localDataSource;
    }

    @Override
    public void terminate() {
        super.terminate();
        GuardedRef<DatabaseConnection> connection2 = this.myConnection;
        ConsoleRunConfiguration configuration = this.myConfiguration;
        ApplicationManager.getApplication().executeOnPooledThread(() -> {
            if (connection2 != null) {
                connection2.close();
            }
            this.myDriverManager.releaseDriver(this.myDataSource, configuration);
        });
        this.myConnection = null;
    }

    @Override
    public void visitQuery(@NotNull DataRequest.QueryRequest r) {
        if (r == null) {
            JdbcEngine.$$$reportNull$$$0(18);
        }
        this.submitRequest(r, (ThrowableComputable<Boolean, Exception>)((ThrowableComputable)() -> {
            Executor executor = this.createExecutor(r);
            if (executor == null) {
                return false;
            }
            DatabaseConnection connection2 = this.getConnection();
            QueryExecutionOperation operation = new QueryExecutionOperation(executor, r);
            if (connection2 == null) {
                return false;
            }
            SilentOperation silentOperation = new SilentOperation(operation, this.myDbms.isRedshift() || this.isTransactionJustStarted());
            return silentOperation.perform(connection2);
        }));
    }

    @Override
    public void visitCall(DataRequest.CallRequest r) {
        this.submitRequest(r, (ThrowableComputable<Boolean, Exception>)((ThrowableComputable)() -> {
            DatabaseConnection connection2 = this.getConnection();
            if (connection2 == null) {
                return false;
            }
            CallOperation call = new CallOperation(r);
            return this.wrap(call, connection2.getDbms()).perform(connection2);
        }));
    }

    private OperationBase wrap(@NotNull AtomicOperation operation, @NotNull Dbms dbms) {
        if (operation == null) {
            JdbcEngine.$$$reportNull$$$0(19);
        }
        if (dbms == null) {
            JdbcEngine.$$$reportNull$$$0(20);
        }
        if (TransactionAction.isTransactionsSupported(dbms)) {
            return new TransactionOperation(operation);
        }
        return new PotentiallyAtomicOperation(operation, this.isTransactionJustStarted());
    }

    @Override
    public void visitUpdate(@NotNull DataRequest.UpdateRequest r) {
        if (r == null) {
            JdbcEngine.$$$reportNull$$$0(21);
        }
        this.executeUpdateStatement(r, Collections.singletonList(this.buildDataForUpdate(r)));
    }

    @Override
    public void visitInsert(@NotNull DataRequest.InsertRequest r) {
        if (r == null) {
            JdbcEngine.$$$reportNull$$$0(22);
        }
        this.executeUpdateStatement(r, Collections.singletonList(this.buildDataForInsert(r)));
    }

    @Override
    public void visitDelete(@NotNull DataRequest.DeleteRequest r) {
        if (r == null) {
            JdbcEngine.$$$reportNull$$$0(23);
        }
        this.executeUpdateStatement(r, Collections.singletonList(this.buildDataForDelete(r)));
    }

    @Override
    public void visitComposite(DataRequest.CompositeRequest r) {
        final ArrayList<QueryData> infos = new ArrayList<QueryData>();
        for (DataRequest.DmlRequest request : r.requests) {
            request.accept(new DataRequest.Visitor(){

                @Override
                public void visitInsert(DataRequest.InsertRequest r) {
                    infos.add(JdbcEngine.this.buildDataForInsert(r));
                }

                @Override
                public void visitUpdate(DataRequest.UpdateRequest r) {
                    infos.add(JdbcEngine.this.buildDataForUpdate(r));
                }

                @Override
                public void visitDelete(DataRequest.DeleteRequest r) {
                    infos.add(JdbcEngine.this.buildDataForDelete(r));
                }
            });
        }
        this.executeUpdateStatement(r, infos);
    }

    @Override
    public void visitTx(DataRequest.TxRequest r) {
        this.submitRequest(r, (ThrowableComputable<Boolean, Exception>)((ThrowableComputable)() -> {
            if (r instanceof DisposalRollbackRequest && this.myTransactionOwner != r.owner) {
                if (!this.myTxMarker.isTransactionInProgress()) {
                    Boolean bl = false;
                    return bl;
                }
                try {
                    this.getDataAuditor().txCompleted(this.getRequestContext(), DataAuditor.TxEvent.OWNER_DISPOSAL);
                    Boolean bl = false;
                    return bl;
                }
                finally {
                    this.myTxMarker = DataRequest.IN_PROGRESS;
                }
            }
            Boolean bl = this.completeTransaction(r.command == DataRequest.TxCommand.COMMIT);
            return bl;
            finally {
                this.myTransactionOwner = null;
            }
        }));
    }

    protected boolean completeTransaction(boolean commit) throws Exception {
        if (!this.myTxMarker.isTransactionInProgress() || this.getCurrentConnection() == null) {
            this.suppressAudit();
            return true;
        }
        DatabaseConnection connection2 = this.getConnection();
        if (!this.isConnectionReady(connection2)) {
            this.suppressAudit();
            return false;
        }
        this.finishTx(connection2, commit, true);
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void finishTx(@NotNull DatabaseConnection connection2, boolean commit, boolean explicit) throws SQLException {
        if (connection2 == null) {
            JdbcEngine.$$$reportNull$$$0(24);
        }
        boolean autoCommit = connection2.getAutoCommit();
        try {
            if (!autoCommit && this.myTxMarker.isTransactionInProgress()) {
                if (commit) {
                    connection2.commit();
                } else {
                    connection2.rollback();
                }
                if (explicit) {
                    DataAuditor.TxEvent event = commit ? DataAuditor.TxEvent.COMPLETED : DataAuditor.TxEvent.REVERTED;
                    this.getDataAuditor().txCompleted(this.getRequestContext(), event);
                }
                this.suppressAudit();
            }
        }
        finally {
            if (explicit) {
                this.myTxMarker = DataRequest.NONE;
            }
        }
    }

    @Override
    public void visitSchemaSwitch(@NotNull DataRequest.SchemaSwitchRequest r) {
        if (r == null) {
            JdbcEngine.$$$reportNull$$$0(25);
        }
        this.submitRequest(r, (ThrowableComputable<Boolean, Exception>)((ThrowableComputable)() -> {
            DatabaseConnection connection2;
            DatabaseConnection prevConnection = connection2 = this.getCurrentConnection();
            boolean reconnect = this.willReconnect(r.pathToSwitch.getCurrent());
            if (!r.forced && reconnect && connection2 != null) {
                this.suppressAudit();
                return Boolean.FALSE;
            }
            if (reconnect && connection2 != null) {
                this.releaseConnection(false);
            }
            if (connection2 == null && !r.forced) {
                this.setSearchPath(r.pathToSwitch);
                this.suppressAudit();
                return Boolean.TRUE;
            }
            if (reconnect) {
                this.setSearchPath(r.pathToSwitch);
                connection2 = this.getConnection(true);
                return connection2 != null;
            }
            connection2 = this.getConnection(false);
            return connection2 != null && this.performSchemaSwitch(connection2, r.pathToSwitch, prevConnection == connection2);
        }));
    }

    @Override
    public void visitDisconnect(DataRequest.Disconnect r) {
        this.terminate();
    }

    @Override
    public void visitRaw(DataRequest.RawRequest r) {
        this.submitRequest(r, (ThrowableComputable<Boolean, Exception>)((ThrowableComputable)() -> {
            DatabaseConnection connection2 = this.getConnection();
            if (connection2 == null) {
                return false;
            }
            try {
                new RawOperation(r).perform(connection2);
            }
            catch (ProcessCanceledException processCanceledException) {
            }
            catch (Throwable ex) {
                this.getRequestContext().reportException(ex, null);
                return false;
            }
            return true;
        }));
    }

    @Override
    @NotNull
    protected DataRequest.Context createRequestContext(@NotNull DataRequest request) {
        boolean ownerFailed;
        if (request == null) {
            JdbcEngine.$$$reportNull$$$0(26);
        }
        this.myTransactionOwner = this.myTransactionOwner == request.owner ? this.myTransactionOwner : null;
        boolean startedTransaction = false;
        if (!this.isConnectionReady(this.getCurrentConnection()) || this.myTxMarker == DataRequest.NONE) {
            this.myTxMarker = DataRequest.getInitialTxMarker(this.myTxMarker == DataRequest.AUTO_COMMIT || this.myTxMarker == DataRequest.NONE);
        }
        boolean bl = ownerFailed = this.myTxMarker.getOwner() != null && this.myTxMarker != request.getTxMarker();
        if (!(ownerFailed || request instanceof DataRequest.TxRequest || request.getTxMarker() != DataRequest.START_NEW && this.myTxMarker != DataRequest.START_NEW && this.myTxMarker != DataRequest.IN_PROGRESS)) {
            startedTransaction = this.myTxMarker != DataRequest.IN_PROGRESS;
            this.myTxMarker = DataRequest.newTxMarker("@" + request.owner.getDisplayName(), request.owner);
            DataRequest.TxMarker marker = this.myTxMarker;
            DataRequest.Owner owner = marker.getOwner();
            if (!(!(owner instanceof DataRequest.OwnerEx) || ((DataRequest.OwnerEx)owner).isEphemeral() && startedTransaction)) {
                this.myTransactionOwner = ((DataRequest.OwnerEx)owner).isEphemeral() ? null : owner;
                DataRequest.Owner disposable2 = request.owner instanceof DataRequest.CrossSessionOwner ? ((DataRequest.CrossSessionOwner)request.owner).getTxDisposable() : request.owner;
                DataRequest.Owner parentOwner = request.owner instanceof DataRequest.CrossSessionOwner ? ((DataRequest.CrossSessionOwner)request.owner).getParentOwner() : request.owner;
                Disposer.register((Disposable)disposable2, () -> {
                    if (this.isDisposed()) {
                        return;
                    }
                    this.processRequest(new DisposalRollbackRequest(parentOwner, marker));
                });
            }
        }
        MyContext context = new MyContext(this, request, this.mySearchPath, startedTransaction);
        if (ownerFailed) {
            JdbcEngine.reportError(context, "locked by transaction: " + this.myTxMarker.getOwner().getDisplayName());
        }
        context.putUserData(SUPPORTS_SAVEPOINTS_KEY, this.mySupportsSavepoints);
        MyContext myContext = context;
        if (myContext == null) {
            JdbcEngine.$$$reportNull$$$0(27);
        }
        return myContext;
    }

    @Override
    @NotNull
    public AuditService getAuditService() {
        AuditService auditService = this.myAuditService;
        if (auditService == null) {
            JdbcEngine.$$$reportNull$$$0(28);
        }
        return auditService;
    }

    private static void reportError(@NotNull DataRequest.Context context, @NotNull String message2) {
        if (context == null) {
            JdbcEngine.$$$reportNull$$$0(29);
        }
        if (message2 == null) {
            JdbcEngine.$$$reportNull$$$0(30);
        }
        ExecutionException th = new ExecutionException(message2);
        context.reportException(th, null);
        throw new ProcessCanceledException((Throwable)th);
    }

    @Nullable
    private Object getQueryType(@NotNull String queryText2, @NotNull DataRequest r) {
        if (queryText2 == null) {
            JdbcEngine.$$$reportNull$$$0(31);
        }
        if (r == null) {
            JdbcEngine.$$$reportNull$$$0(32);
        }
        try {
            if (r instanceof ConsoleDataRequest) {
                return ((ConsoleDataRequest)r).resultType;
            }
            LocalDataSource dataSource2 = this.getDataSource();
            return DbSqlUtil.parseQueryType(this.getProject(), DbSqlUtil.getSqlDialect(dataSource2), DbSqlUtil.getDbDataSource(this.getProject(), dataSource2), this.getSearchPath(), queryText2, null);
        }
        catch (Exception e) {
            LOG.warn((Throwable)e);
            return null;
        }
    }

    @Nullable
    public ObjectPath getCurrentNamespace() {
        return SearchPath.getCurrent((SearchPath)this.mySearchPath);
    }

    private boolean isConnectionReady(@Nullable DatabaseConnection connection2) {
        if (connection2 == null) {
            return false;
        }
        try {
            return !connection2.getRemoteConnection().isClosed() && (JdbcEngine.isJTds(this.myDataSource) || connection2.getRemoteConnection().isValid(20));
        }
        catch (Exception e) {
            return false;
        }
    }

    /*
     * Unable to fully structure code
     */
    private void prepareConnection(@NotNull DatabaseConnection connection, boolean setCurrentSchema) throws Exception {
        if (connection == null) {
            JdbcEngine.$$$reportNull$$$0(33);
        }
        autoCommit = this.myTxMarker == DataRequest.AUTO_COMMIT;
        metaData = connection.getRemoteMetaData();
        if (metaData == null) ** GOTO lbl-1000
        if (JdbcNativeUtil.getBooleanSafe((ThrowableComputable)(ThrowableComputable)LambdaMetafactory.metafactory(null, null, null, ()Ljava/lang/Object;, supportsSavepoints(), ()Ljava/lang/Boolean;)((RemoteDatabaseMetaData)metaData))) {
            v0 = true;
        } else lbl-1000:
        // 2 sources

        {
            v0 = this.mySupportsSavepoints = false;
        }
        if (connection.getAutoCommit() != autoCommit) {
            connection.setAutoCommit(autoCommit);
        }
        this.setTxIsolation(connection);
        if ((autoCommit || DbImplUtil.supportsReadOnlyChangeDuringTx(this.myDbms)) && DbImplUtil.supportsReadOnlyChangeOnTheFly(this.myDbms)) {
            DbImplUtil.tryToSetReadOnly(connection, this.myDataSource.isReadOnly());
        }
        schema = this.mySearchPath;
        if (setCurrentSchema && schema != null) {
            if (DbImplUtil.supportsDynamicSchemaSwitching(this.myDataSource)) {
                this.performSchemaSwitch(connection, schema, false);
            }
        } else if (schema == null) {
            this.requestSearchPathTransparent(connection);
        }
    }

    private void setTxIsolation(@NotNull DatabaseConnection dbConnection) throws SQLException {
        if (dbConnection == null) {
            JdbcEngine.$$$reportNull$$$0(34);
        }
        DataRequest.Context context = this.getRequestContextIfAny();
        if (!TransactionAction.TxIsolation.levelsSupported(this.myDbms) || context == null) {
            return;
        }
        DataRequest.TxIsolationOwner owner = (DataRequest.TxIsolationOwner)ObjectUtils.tryCast((Object)context.request.owner, DataRequest.TxIsolationOwner.class);
        if (owner == null || !this.shouldChangeIsolation(dbConnection, owner, context)) {
            return;
        }
        JdbcNativeUtil.performRemote(() -> dbConnection.getRemoteConnection().setTransactionIsolation(owner.getTxIsolation()));
    }

    private void storeTxIsolation(@NotNull DataRequest.Context context, @NotNull DatabaseConnection connection2) {
        if (context == null) {
            JdbcEngine.$$$reportNull$$$0(35);
        }
        if (connection2 == null) {
            JdbcEngine.$$$reportNull$$$0(36);
        }
        if (!TransactionAction.TxIsolation.levelsSupported(this.myDbms)) {
            return;
        }
        RemoteConnection remoteConnection = connection2.getRemoteConnection();
        try {
            RemoteDatabaseMetaData metaData = connection2.getRemoteMetaData();
            if (metaData == null || !metaData.supportsTransactions()) {
                return;
            }
            int isolation = remoteConnection.getTransactionIsolation();
            ObjectUtils.consumeIfCast((Object)((Object)context), DataRequest.TxContext.class, ex -> ex.setIsolation(isolation));
        }
        catch (AbstractMethodError | RemoteException | SQLException e) {
            LOG.warn(e);
        }
    }

    private boolean shouldChangeIsolation(@NotNull DatabaseConnection connection2, @NotNull DataRequest.TxIsolationOwner owner, @NotNull DataRequest.Context context) {
        if (connection2 == null) {
            JdbcEngine.$$$reportNull$$$0(37);
        }
        if (owner == null) {
            JdbcEngine.$$$reportNull$$$0(38);
        }
        if (context == null) {
            JdbcEngine.$$$reportNull$$$0(39);
        }
        try {
            RemoteDatabaseMetaData data = connection2.getRemoteMetaData();
            RemoteConnection remoteConnection = connection2.getRemoteConnection();
            int ownerIsolation = owner.getTxIsolation();
            return !(data == null || !data.supportsTransactions() || context.request.getTxMarker() != DataRequest.AUTO_COMMIT && context.request.getTxMarker() != DataRequest.START_NEW || ownerIsolation == TransactionAction.TxIsolation.DEFAULT.getIsolation() || !this.myDbms.isSybase() && !data.supportsTransactionIsolationLevel(ownerIsolation) || remoteConnection.getTransactionIsolation() == ownerIsolation);
        }
        catch (AbstractMethodError | RemoteException | SQLException e) {
            LOG.warn(e);
            return false;
        }
    }

    private boolean performSchemaSwitch(@NotNull DatabaseConnection connection2, @NotNull SearchPath searchPath, boolean allowReset) {
        if (connection2 == null) {
            JdbcEngine.$$$reportNull$$$0(40);
        }
        if (searchPath == null) {
            JdbcEngine.$$$reportNull$$$0(41);
        }
        try {
            if (DbImplUtil.switchSchemaThroughJdbc(searchPath, connection2, this.myDataSource)) {
                this.setSearchPath(searchPath);
                return true;
            }
        }
        catch (SQLException e) {
            this.getRequestContext().reportException(e, null);
            return false;
        }
        String setSchemaSql = DbImplUtil.getSearchPathSql(searchPath, this.myDataSource, this.myDialect);
        String sql = setSchemaSql == null && allowReset && searchPath.getCurrent().kind == ObjectKind.DATABASE && JdbcUrlParserUtil.isDatabaseBounded(connection2.getConnectionPoint()) ? this.myDialect.sqlResetSearchPath() : setSchemaSql;
        if (sql == null) {
            return false;
        }
        boolean requestSearchPath = sql != setSchemaSql;
        return SmartStatements.poweredBy(connection2).simple().execute(sql, __ -> {
            if (requestSearchPath) {
                this.requestSearchPath(connection2);
            } else {
                this.setSearchPath(searchPath);
            }
            return true;
        }).rightOr(false);
    }

    private void suppressAudit() {
        MeasuringDataAuditor.SILENT_KEY.set((UserDataHolder)this.getRequestContext(), (Object)true);
    }

    @Nullable
    private RowQueryData buildDataForSelect(@NotNull DataRequest.ConditionQueryRequest r) {
        if (r == null) {
            JdbcEngine.$$$reportNull$$$0(42);
        }
        RowQueryData data = r.rowQueryData;
        String alias = r.table == null ? DbImplUtil.findFreeAlias(this.getProject(), this.myDbms, data.getSql(), "a") : "t";
        DmlGenerator generator = DmlUtilKt.dmlGenerator(this.myDbms);
        ArrayList<ColumnQueryData> newData = new ArrayList<ColumnQueryData>();
        SelectTask.Companion.Builder task = DmlTaskKt.allColumns().alias(alias).whereClause(DmlUtilKt.whereClause(data.getColumnsData(), newData, (Ref<Boolean>)new Ref((Object)false))).system(this.myDataSource);
        OffsetSavingBuilder builder = new OffsetSavingBuilder(DbImplUtil.createBuilderForUIExec(this.myDbms, (DasObject)r.table));
        if (r.table != null) {
            generator.generate(builder, task.table(r.table).build());
        } else {
            DmlGenerator.Companion.Result result = generator.wrap(builder, r.rowQueryData.getSql(), this.getProject(), task.build());
            if (result == null) {
                return null;
            }
        }
        return new RowQueryData(newData, builder.getOffsets(), builder.getStatement());
    }

    @NotNull
    public QueryData buildDataForDelete(@NotNull DataRequest.DeleteRequest r) {
        if (r == null) {
            JdbcEngine.$$$reportNull$$$0(43);
        }
        return JdbcEngine.mergedQueryData(r.context.getMutations(), (Function<RowMutation, RowQueryData>)((Function)mutation -> {
            OffsetSavingBuilder builder = new OffsetSavingBuilder(DbImplUtil.createBuilderForUIExec(this.myDialect));
            List<ColumnQueryData> filtered2 = DbImplUtil.getWhereClauseColumns(r.context.getTable(), mutation.getData(), this.myDbms);
            ArrayList<ColumnQueryData> newData = new ArrayList<ColumnQueryData>();
            Ref allColumnsGenerated = new Ref((Object)false);
            DeleteRowsTask task = DmlTaskKt.deleteRows().table(r.context.getTable()).alias(this.myDbms.isDb2() ? "t" : null).whereClause(DmlUtilKt.whereClause(filtered2, newData, (Ref<Boolean>)allColumnsGenerated)).build();
            DmlUtilKt.dmlGenerator(this.myDbms).generate(builder, task);
            if (!((Boolean)allColumnsGenerated.get()).booleanValue()) {
                String msg = String.format("Number of columns in WHERE clause does not match expected value. Expected %d column(s). Generated statement: %s", filtered2.size(), builder.getStatement());
                LOG.error(msg);
                builder.clear().comment(msg);
            }
            return new RowQueryData(newData, builder.getOffsets(), builder.getStatement());
        }), QueryData.Operation.DELETE);
    }

    @NotNull
    public QueryData buildDataForUpdate(@NotNull DataRequest.UpdateRequest r) {
        Dbms dbms;
        if (r == null) {
            JdbcEngine.$$$reportNull$$$0(44);
        }
        String alias = (dbms = this.myDataSource.getDbms()).isSqlite() || dbms.isPostgres() || dbms.isTransactSql() || dbms.isVertica() || dbms.isCassandra() || dbms.isHive() || dbms == Dbms.FRONTBASE ? null : "t";
        return JdbcEngine.mergedQueryData(r.context.getMutations(), (Function<RowMutation, RowQueryData>)((Function)mutation -> {
            DataConsumer.Row row = mutation.getRow();
            List<DataConsumer.Column> keyColumns = DbImplUtil.getWhereClauseColumns(r.context.getTable(), Objects.requireNonNull(r.context.getColumns()), this.myDbms);
            OffsetSavingBuilder builder = new OffsetSavingBuilder(DbImplUtil.createBuilderForUIExec(this.myDialect));
            builder.keyword("UPDATE").space().qualifiedRef((DasObject)r.context.getTable()).space();
            if (alias != null) {
                builder.alias(alias).space();
            }
            builder.keyword("SET").space();
            boolean first2 = true;
            ArrayList<ColumnQueryData> columnsData = new ArrayList<ColumnQueryData>();
            for (ColumnQueryData data : mutation.getData()) {
                DataConsumer.Column targetColumn = data.getColumn();
                if (!first2) {
                    builder.symbol(",").space();
                } else {
                    first2 = false;
                }
                if (alias != null) {
                    builder.alias(alias).symbol(".");
                }
                builder.identifier(targetColumn.name).space().symbol("=").space();
                Object value2 = data.getObject();
                if (value2 == ReservedCellValue.DEFAULT) {
                    builder.keyword("DEFAULT");
                    continue;
                }
                if (JdbcEngine.shouldValueBeInlined(value2, targetColumn.typeName, dbms)) {
                    builder.plain(value2.toString());
                    continue;
                }
                builder.placeholder();
                columnsData.add(data);
            }
            int escapingIndex = columnsData.size();
            builder.space().keyword("WHERE").space();
            List keyData = ContainerUtil.map(keyColumns, column -> new ColumnQueryData((DataConsumer.Column)column, column.getValue(row)));
            List<ColumnQueryData> whereData = DbImplUtil.composeWhereConditionWithParameters(builder, keyData, alias, this.myDbms, true);
            String sql = builder.getStatement();
            columnsData.addAll(whereData);
            return new RowQueryData(columnsData, builder.getOffsets(), sql, escapingIndex);
        }), QueryData.Operation.UPDATE);
    }

    @Contract(value="null, _, _ -> false")
    private static boolean shouldValueBeInlined(@Nullable Object object, @NotNull String typeName, Dbms dbms) {
        if (typeName == null) {
            JdbcEngine.$$$reportNull$$$0(45);
        }
        return dbms.isCassandra() && object instanceof String && !CassJdbcHelper.hasCodec((String)typeName);
    }

    @NotNull
    public QueryData buildDataForInsert(@NotNull DataRequest.InsertRequest r) {
        if (r == null) {
            JdbcEngine.$$$reportNull$$$0(46);
        }
        Dbms dbms = this.myDataSource.getDbms();
        DatabaseDialectEx dialect = DbImplUtil.getDatabaseDialect(dbms);
        ArrayList<RowUpdateData> params = new ArrayList<RowUpdateData>();
        List<RowMutation> mutations = r.context.getMutations();
        OffsetSavingBuilder builder = new OffsetSavingBuilder(DbImplUtil.createBuilderForUIExec(dialect));
        for (RowMutation mutation : mutations) {
            List<AutoValueDescriptor.DelegateDescriptor<ColumnQueryData>> delegateDescriptors = JdbcEngine.createDescriptors(mutation);
            List<Consumer<DdlBuilder>> placeholders = JdbcEngine.getPlaceholdersOrInlineValues(delegateDescriptors, dbms);
            List<String> colNames = JdbcEngine.getColumnNamesForInsert(delegateDescriptors, dbms);
            dialect.sqlInsertInto(builder, r.context.getTable(), colNames, placeholders);
            String sql = builder.getStatement();
            List withPlaceholders = ContainerUtil.filter(delegateDescriptors, d2 -> JdbcEngine.hasPlaceholder(d2, dbms));
            List delegates = ContainerUtil.map((Collection)withPlaceholders, AutoValueDescriptor.DelegateDescriptor::getDelegate);
            RowQueryData qData = new RowQueryData(delegates, builder.getOffsets(), sql, delegates.size());
            params.add(new RowUpdateData(qData, 1));
            builder.clear();
        }
        return new QueryData(params, QueryData.Operation.INSERT);
    }

    private static boolean hasPlaceholder(@NotNull AutoValueDescriptor.DelegateDescriptor<ColumnQueryData> d2, @NotNull Dbms dbms) {
        if (d2 == null) {
            JdbcEngine.$$$reportNull$$$0(47);
        }
        if (dbms == null) {
            JdbcEngine.$$$reportNull$$$0(48);
        }
        return !d2.isComputed() && !d2.isAutogenerated() && !d2.hasDefault() && !JdbcEngine.shouldValueBeInlined(d2.getDelegate().getObject(), d2.getTypeName(), dbms);
    }

    @NotNull
    private static List<AutoValueDescriptor.DelegateDescriptor<ColumnQueryData>> createDescriptors(@NotNull RowMutation mutation) {
        if (mutation == null) {
            JdbcEngine.$$$reportNull$$$0(49);
        }
        DataConsumer.Row row = mutation.getRow();
        List list = JBIterable.from(mutation.getData()).map(data -> {
            DataConsumer.Column column = data.getColumn();
            Object value2 = column.getValue(row);
            boolean autogenerated = value2 == ReservedCellValue.GENERATED;
            boolean isDefault = value2 == ReservedCellValue.DEFAULT;
            boolean isComputed = value2 == ReservedCellValue.COMPUTED;
            return new AutoValueDescriptor.DelegateDescriptor<ColumnQueryData>((ColumnQueryData)data, autogenerated, isDefault, isComputed);
        }).toList();
        if (list == null) {
            JdbcEngine.$$$reportNull$$$0(50);
        }
        return list;
    }

    private void executeUpdateStatement(@NotNull DataRequest request, @NotNull List<QueryData> infos) {
        if (request == null) {
            JdbcEngine.$$$reportNull$$$0(51);
        }
        if (infos == null) {
            JdbcEngine.$$$reportNull$$$0(52);
        }
        this.submitRequest(request, (ThrowableComputable<Boolean, Exception>)((ThrowableComputable)() -> {
            QueryData unsupported = (QueryData)ContainerUtil.find((Iterable)infos, i2 -> !i2.getOperation().isSupported(this.myDbms));
            if (unsupported != null) {
                throw new StackTraceFreeException(String.format("%s is not supported by %s tables", unsupported.getOperation().displayName(), this.myDbms.getDisplayName()));
            }
            DatabaseConnection connection2 = this.getConnection();
            if (connection2 == null) {
                return false;
            }
            return this.wrap(new UpdateOperation(infos), connection2.getDbms()).perform(connection2);
        }));
    }

    @Nullable
    private Executor createExecutor(@NotNull DataRequest.QueryRequest r) {
        if (r == null) {
            JdbcEngine.$$$reportNull$$$0(53);
        }
        if (r instanceof DataRequest.ConditionQueryRequest) {
            RowQueryData data = this.buildDataForSelect((DataRequest.ConditionQueryRequest)r);
            return data == null ? null : new ParameterizedExecutor(data);
        }
        return new RegularExecutor(r);
    }

    @NotNull
    public static String getErrorMessage(Throwable th, @Nullable LocalDataSource dataSource2) {
        if (th instanceof ProcessCanceledException) {
            return "";
        }
        Throwable cause = ExceptionUtil.getRootCause((Throwable)th);
        if (cause instanceof OutOfMemoryError) {
            LOG.info(cause);
        } else if (!(cause instanceof SuppressUserStackTrace || cause instanceof UnsupportedOperationException || cause instanceof IOException || cause instanceof ExecutionException || cause instanceof UnsafeUpdateRolledBackException)) {
            try {
                ExceptionUtil.getUserStackTrace((Throwable)cause, (Logger)LOG);
            }
            catch (AssertionError e) {
                String string = cause.toString();
                if (string == null) {
                    JdbcEngine.$$$reportNull$$$0(54);
                }
                return string;
            }
        }
        DatabaseErrorHandler handler = (DatabaseErrorHandler)DatabaseErrorHandler.EP.forDbms(dataSource2 == null ? Dbms.UNKNOWN : dataSource2.getDbms());
        String string = handler.getErrorMessage(dataSource2, th, cause, null).trim();
        if (string == null) {
            JdbcEngine.$$$reportNull$$$0(55);
        }
        return string;
    }

    @NotNull
    public static <T extends AutoValueDescriptor> List<String> getColumnNamesForInsert(@NotNull Collection<T> descriptors, @NotNull Dbms dbms) {
        if (descriptors == null) {
            JdbcEngine.$$$reportNull$$$0(56);
        }
        if (dbms == null) {
            JdbcEngine.$$$reportNull$$$0(57);
        }
        List list = JdbcEngine.shouldParticipateInInsert(descriptors, dbms).map(ColumnDescriptor::getName).toList();
        if (list == null) {
            JdbcEngine.$$$reportNull$$$0(58);
        }
        return list;
    }

    @NotNull
    public static <T extends AutoValueDescriptor> List<Consumer<DdlBuilder>> getPlaceholdersForInsert(@NotNull Collection<T> descriptors, @NotNull Dbms dbms) {
        if (descriptors == null) {
            JdbcEngine.$$$reportNull$$$0(59);
        }
        if (dbms == null) {
            JdbcEngine.$$$reportNull$$$0(60);
        }
        List list = JdbcEngine.shouldParticipateInInsert(descriptors, dbms).map(JdbcEngine::defaultOrPlaceholder).toList();
        if (list == null) {
            JdbcEngine.$$$reportNull$$$0(61);
        }
        return list;
    }

    public static <T extends AutoValueDescriptor> Consumer<DdlBuilder> defaultOrPlaceholder(T d2) {
        return d2.isAutogenerated() || d2.hasDefault() ? builder -> builder.plain("DEFAULT") : DdlBuilder::placeholder;
    }

    @NotNull
    public static <T extends AutoValueDescriptor.DelegateDescriptor<ColumnQueryData>> List<Consumer<DdlBuilder>> getPlaceholdersOrInlineValues(@NotNull Collection<T> descriptors, @NotNull Dbms dbms) {
        if (descriptors == null) {
            JdbcEngine.$$$reportNull$$$0(62);
        }
        if (dbms == null) {
            JdbcEngine.$$$reportNull$$$0(63);
        }
        List list = JdbcEngine.shouldParticipateInInsert(descriptors, dbms).map(d2 -> JdbcEngine.shouldValueBeInlined(((ColumnQueryData)d2.getDelegate()).getObject(), d2.getTypeName(), dbms) ? builder -> builder.plain(((ColumnQueryData)d2.getDelegate()).getObject().toString()) : JdbcEngine.defaultOrPlaceholder(d2)).toList();
        if (list == null) {
            JdbcEngine.$$$reportNull$$$0(64);
        }
        return list;
    }

    public static <T extends AutoValueDescriptor> boolean shouldParticipateInInsert(@NotNull Dbms dbms, @NotNull T column) {
        if (dbms == null) {
            JdbcEngine.$$$reportNull$$$0(65);
        }
        if (column == null) {
            JdbcEngine.$$$reportNull$$$0(66);
        }
        DatabaseDialectEx dialect = DbImplUtil.getDatabaseDialect(dbms);
        return !(column.isComputed() || column.isAutogenerated() && !dialect.supportsInsertDefaultIntoAutoVal() || column.hasDefault() && dbms.isSqlite());
    }

    @NotNull
    private static <T extends AutoValueDescriptor> JBIterable<T> shouldParticipateInInsert(@NotNull Collection<T> descriptors, @NotNull Dbms dbms) {
        if (descriptors == null) {
            JdbcEngine.$$$reportNull$$$0(67);
        }
        if (dbms == null) {
            JdbcEngine.$$$reportNull$$$0(68);
        }
        JBIterable jBIterable = JBIterable.from(descriptors).filter(d2 -> JdbcEngine.shouldParticipateInInsert(dbms, d2));
        if (jBIterable == null) {
            JdbcEngine.$$$reportNull$$$0(69);
        }
        return jBIterable;
    }

    @NotNull
    private static QueryData mergedQueryData(@NotNull List<RowMutation> mutations, @NotNull Function<RowMutation, RowQueryData> converter, @NotNull QueryData.Operation operation) {
        if (mutations == null) {
            JdbcEngine.$$$reportNull$$$0(70);
        }
        if (converter == null) {
            JdbcEngine.$$$reportNull$$$0(71);
        }
        if (operation == null) {
            JdbcEngine.$$$reportNull$$$0(72);
        }
        TObjectIntHashMap map2 = new TObjectIntHashMap(QUERY_DATA_HASHING_STRATEGY);
        for (RowMutation mutation : mutations) {
            RowQueryData qData = (RowQueryData)converter.fun((Object)mutation);
            if (map2.increment((Object)qData)) continue;
            map2.put((Object)qData, 1);
        }
        return new QueryData(ContainerUtil.map((Object[])map2.keys(), o -> new RowUpdateData((RowQueryData)o, map2.get((Object)((RowQueryData)o)))), operation);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void printResultSet(@NotNull RemoteResultSet resultSet, int resultSetIndex, int absolutePosition, int limit, int queryOffset, int chunkSize, int[] rowCount) throws Exception {
        if (resultSet == null) {
            JdbcEngine.$$$reportNull$$$0(73);
        }
        this.checkCanceled();
        DataRequest request = this.getRequestContext().request;
        DataConsumer handler = this.getDataConsumer();
        if (request instanceof DataRequest.IsolatedQueryRequest) {
            handler = (DataConsumer)((Object)request);
        }
        if (absolutePosition < 0) {
            handler = new LastPageHandler(handler, absolutePosition, limit);
            limit = -1;
        }
        DataConsumer.Column[] columnsDescr = JdbcEngine.getColumnDescriptors(resultSet, this.myDbms);
        handler.setColumns(this.getRequestContext(), resultSetIndex, columnsDescr, Math.max(1, absolutePosition + 1));
        GridColumnsManager layoutManager = ((GridColumnsManagerFactory)GridColumnsManagerFactory.Companion.getEP().forDbms(this.myDbms)).createManager(columnsDescr);
        rowCount[0] = 0;
        int rowNum = 0;
        boolean hasNext = true;
        ArrayList<DataConsumer.Row> rows = new ArrayList<DataConsumer.Row>(chunkSize);
        try {
            rowNum = resultSet.scrollToPosition(0, absolutePosition) + queryOffset;
            if (request instanceof DataRequest.RawQueryRequest) {
                List rowObjects;
                RemoteResultSet.DataRetrievingOptions options = new RemoteResultSet.DataRetrievingOptions(1, -1, true);
                while (!(rowObjects = resultSet.getObjects(options)).isEmpty()) {
                    this.checkCanceled();
                    Object[] data = (Object[])ContainerUtil.getFirstItem((List)rowObjects);
                    if (data == null) continue;
                    DataConsumer.Row row = layoutManager.createRow(rowNum++, data);
                    handler.updateColumns(this.getRequestContext(), layoutManager.getColumns());
                    handler.addRows(this.getRequestContext(), Collections.singletonList(row));
                    rowCount[0] = rowCount[0] + 1;
                    if (DbImplUtil.isPageSizeUnlimited(limit) || rowCount[0] < limit) continue;
                    break;
                }
                hasNext = !rowObjects.isEmpty() && resultSet.next();
            } else {
                int maxLobLength = DatabaseSettings.getSettings().getMaxLobLength();
                while (hasNext) {
                    int rowsToLoad;
                    this.checkCanceled();
                    int n = rowsToLoad = DbImplUtil.isPageSizeUnlimited(limit) ? chunkSize : Math.min(chunkSize, limit - rowCount[0]);
                    if (rowsToLoad == 0) break;
                    RemoteResultSet.DataRetrievingOptions options = new RemoteResultSet.DataRetrievingOptions(rowsToLoad, maxLobLength, false);
                    List data = resultSet.getObjects(options);
                    hasNext = data.size() == rowsToLoad;
                    rowCount[0] = rowCount[0] + data.size();
                    for (Object[] rowData2 : data) {
                        rows.add(layoutManager.createRow(rowNum++, rowData2));
                        if (rows.size() != chunkSize) continue;
                        handler.updateColumns(this.getRequestContext(), layoutManager.getColumns());
                        handler.addRows(this.getRequestContext(), rows);
                        rows = new ArrayList(chunkSize);
                    }
                }
                if (hasNext) {
                    hasNext = resultSet.next();
                }
            }
        }
        finally {
            if (!rows.isEmpty()) {
                handler.updateColumns(this.getRequestContext(), layoutManager.getColumns());
                handler.addRows(this.getRequestContext(), rows);
            }
            if (absolutePosition < 0) {
                rowCount[0] = ((LastPageHandler)handler).getRowCount();
            }
            try {
                if (hasNext && rowCount[0] != 0) {
                    ++rowNum;
                }
            }
            finally {
                handler.afterLastRowAdded(this.getRequestContext(), rowNum);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void printParameterResults(@NotNull List<? extends OutParameter<?>> parameters, @NotNull Function1<? super OutParameter<?>, ?> retriever, int resultSetIndex) {
        if (parameters == null) {
            JdbcEngine.$$$reportNull$$$0(74);
        }
        if (retriever == null) {
            JdbcEngine.$$$reportNull$$$0(75);
        }
        this.checkCanceled();
        DataRequest request = this.getRequestContext().request;
        DataConsumer handler = this.getDataConsumer();
        if (request instanceof DataRequest.IsolatedQueryRequest) {
            handler = (DataConsumer)((Object)request);
        }
        int count2 = parameters.size();
        try {
            Object[] parameterValues = ContainerUtil.map2Array(parameters, arg_0 -> retriever.invoke(arg_0));
            DataConsumer.Column[] columnsDescr = new DataConsumer.Column[count2];
            for (int i2 = 0; i2 < count2; ++i2) {
                Object value2 = parameterValues[i2];
                OutParameter<?> parameter = parameters.get(i2);
                String name = parameter instanceof CallableStatementData.SimpleOutParameter ? ((CallableStatementData.SimpleOutParameter)parameter).getName() : null;
                int type = 1111;
                int scale = 0;
                if (parameter instanceof TypedOutParameter) {
                    TypedOutParameter typed = (TypedOutParameter)parameter;
                    type = typed.getType();
                    scale = typed.getScale();
                }
                columnsDescr[i2] = new DataConsumer.Column(i2, (String)ObjectUtils.notNull((Object)name, (Object)("#" + (i2 + 1))), type, JdbcUtil.getJdbcTypeName((int)type), (value2 != null ? value2.getClass() : Object.class).getName(), 0, scale, "", "", "");
            }
            handler.setColumns(this.getRequestContext(), resultSetIndex, columnsDescr, 1);
            GridColumnsManager layoutManager = ((GridColumnsManagerFactory)GridColumnsManagerFactory.Companion.getEP().forDbms(this.myDbms)).createManager(columnsDescr);
            DataConsumer.Row row = layoutManager.createRow(0, parameterValues);
            handler.updateColumns(this.getRequestContext(), layoutManager.getColumns());
            handler.addRows(this.getRequestContext(), Collections.singletonList(row));
        }
        finally {
            handler.afterLastRowAdded(this.getRequestContext(), 1);
        }
    }

    public static DataConsumer.Column[] getColumnDescriptors(@NotNull RemoteResultSet resultSet, @NotNull Dbms dbms) throws Exception {
        if (resultSet == null) {
            JdbcEngine.$$$reportNull$$$0(76);
        }
        if (dbms == null) {
            JdbcEngine.$$$reportNull$$$0(77);
        }
        RemoteResultSetMetaData metaData = resultSet.getMetaData();
        int count2 = metaData.getColumnCount();
        DataConsumer.Column[] columnsDescr = new DataConsumer.Column[count2];
        int columnNum = 0;
        for (int i2 = 1; i2 <= count2; ++i2) {
            String name = null;
            try {
                name = metaData.getColumnLabel(i2);
            }
            catch (Exception exception) {
                // empty catch block
            }
            String typeName = null;
            try {
                typeName = metaData.getColumnTypeName(i2);
            }
            catch (Exception exception) {
                // empty catch block
            }
            int type = 1111;
            try {
                type = metaData.getColumnType(i2);
            }
            catch (Exception exception) {
                // empty catch block
            }
            String clazz = null;
            try {
                clazz = metaData.getColumnClassName(i2);
            }
            catch (Exception exception) {
                // empty catch block
            }
            String catalog = null;
            try {
                catalog = metaData.getCatalogName(i2);
            }
            catch (Exception exception) {
                // empty catch block
            }
            String schema = null;
            try {
                schema = metaData.getSchemaName(i2);
            }
            catch (Exception exception) {
                // empty catch block
            }
            String table = null;
            try {
                table = metaData.getTableName(i2);
            }
            catch (Exception exception) {
                // empty catch block
            }
            int precision = -1;
            try {
                precision = metaData.getPrecision(i2);
            }
            catch (Exception exception) {
                // empty catch block
            }
            int scale = -1;
            try {
                scale = metaData.getScale(i2);
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (dbms.isClickHouse()) {
                if (table != null) {
                    table = StringUtil.trimEnd((String)table, (char)';');
                }
            } else if (dbms.isSqlite()) {
                catalog = "";
            } else if (dbms.isDb2()) {
                schema = schema == null ? null : StringUtil.trimTrailing((String)schema);
            }
            columnsDescr[i2 - 1] = new DataConsumer.Column(columnNum++, name, type, typeName, clazz, precision, scale, catalog, schema, table);
        }
        return columnsDescr;
    }

    private void checkCanceled() {
        if (this.myState.get() == State.CANCELED) {
            throw new ProcessCanceledException();
        }
    }

    @Override
    protected void releaseConnection() {
        this.releaseConnection(true);
    }

    private void releaseConnection(boolean explicit) {
        if (this.myConnection == null) {
            return;
        }
        try (GuardedRef<DatabaseConnection> connection2 = this.myConnection;){
            this.myConnection = null;
            this.finishTx(connection2.get(), false, explicit);
            DataRequest.Context requestContext = this.getRequestContextIfAny();
            if (requestContext != null) {
                this.getDataAuditor().print(requestContext, "Disconnected");
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @NotNull
    DataRequest.TxMarker getTxMarker() {
        DataRequest.TxMarker txMarker = this.myTxMarker;
        if (txMarker == null) {
            JdbcEngine.$$$reportNull$$$0(78);
        }
        return txMarker;
    }

    private boolean isTransactionJustStarted() {
        DataRequest.Context context = this.getRequestContextIfAny();
        return context instanceof MyContext && ((MyContext)context).startedTransaction;
    }

    @Override
    protected void onRequestStarted(@NotNull DataRequest.Context context) throws Exception {
        if (context == null) {
            JdbcEngine.$$$reportNull$$$0(79);
        }
        try {
            this.changeSearchPathIfNeeded(context, true);
        }
        finally {
            super.onRequestStarted(context);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void onRequestFinished(@NotNull DataRequest.Context context) throws Exception {
        if (context == null) {
            JdbcEngine.$$$reportNull$$$0(80);
        }
        try {
            try {
                this.changeSearchPathIfNeeded(context, false);
            }
            finally {
                try {
                    DatabaseConnection connection2 = this.getCurrentConnection();
                    if (connection2 != null) {
                        this.storeTxIsolation(context, connection2);
                    }
                }
                finally {
                    DataRequest.Owner owner = context.request.owner;
                    if (owner instanceof DataRequest.OwnerEx && ((DataRequest.OwnerEx)owner).isEphemeral() && ((MyContext)context).startedTransaction) {
                        this.completeTransaction(true);
                    }
                }
            }
        }
        finally {
            super.onRequestFinished(context);
        }
    }

    private void changeSearchPathIfNeeded(@NotNull DataRequest.Context context, boolean requestStarted2) {
        SearchPath targetPath;
        DataRequest request;
        if (context == null) {
            JdbcEngine.$$$reportNull$$$0(81);
        }
        if ((request = context.request) instanceof DataRequest.TxRequest || request instanceof DataRequest.SchemaSwitchRequest || !requestStarted2 && request.owner instanceof DataRequest.CustomSearchPathOwner && !((DataRequest.CustomSearchPathOwner)request.owner).cleanup()) {
            return;
        }
        SearchPath requestPath = request.path;
        MyContext myContext = (MyContext)context;
        SearchPath persistentPath = myContext.startPath;
        SearchPath searchPath = targetPath = requestStarted2 ? request.path : myContext.startPath;
        if (requestPath == null || targetPath == null || Comparing.equal((Object)requestPath, (Object)persistentPath)) {
            return;
        }
        DatabaseConnection connection2 = this.getCurrentConnection();
        if (connection2 == null) {
            this.setSearchPath(targetPath);
            return;
        }
        if (requestStarted2 && !this.canSwitchSchemaForRequest(myContext, requestPath)) {
            ReconnectErrorBuilder errorBuilder = ReconnectErrorBuilder.of(this.currentDepartment());
            DataRequest.Owner owner = this.myTxMarker.getOwner();
            JdbcEngine.reportError(context, errorBuilder.message(owner == null ? null : owner.getDisplayName()));
        }
        if (this.willReconnect(targetPath.getCurrent())) {
            this.releaseConnection(!requestStarted2);
            this.setSearchPath(targetPath);
            return;
        }
        this.performSchemaSwitch(connection2, targetPath, false);
    }

    private boolean canSwitchSchemaForRequest(@NotNull MyContext context, @NotNull SearchPath path) {
        if (context == null) {
            JdbcEngine.$$$reportNull$$$0(82);
        }
        if (path == null) {
            JdbcEngine.$$$reportNull$$$0(83);
        }
        return !this.willReconnect(path.getCurrent()) || context.startedTransaction || !this.myTxMarker.isTransactionInProgress() || this.myTxMarker.getOwner() == context.request.owner;
    }

    public static boolean isJTds(@NotNull LocalDataSource dataSource2) {
        DatabaseDriver driver;
        if (dataSource2 == null) {
            JdbcEngine.$$$reportNull$$$0(84);
        }
        String driverClass = (driver = dataSource2.getDatabaseDriver()) == null ? null : driver.getDriverClass();
        return driverClass != null && StringUtil.containsIgnoreCase((String)driverClass, (String)"jTds");
    }

    private boolean willReconnect(@NotNull ObjectPath needed) {
        if (needed == null) {
            JdbcEngine.$$$reportNull$$$0(85);
        }
        ObjectPath current = this.getCurrentNamespace();
        DatabaseConnection connection2 = this.getCurrentConnection();
        return current == null ? JdbcUrlParserUtil.outOfBounds(connection2 == null ? this.myDataSource : connection2.getConnectionPoint(), needed) : JdbcUrlParserUtil.outOfBounds(this.myDataSource, current, needed);
    }

    private void addStatement(@NotNull SmartStatementMark mark2) {
        DataRequest.Context any;
        if (mark2 == null) {
            JdbcEngine.$$$reportNull$$$0(86);
        }
        if ((any = this.getRequestContextIfAny()) != null) {
            WAS_STATEMENTS.set((UserDataHolder)any, (Object)true);
        }
        this.myCurrentStatements.add(mark2);
        this.myState.set(State.RUNNING);
    }

    private void removeStatement(@NotNull SmartStatementMark mark2) {
        if (mark2 == null) {
            JdbcEngine.$$$reportNull$$$0(87);
        }
        this.myCurrentStatements.remove(mark2);
        if (this.myCurrentStatements.isEmpty()) {
            this.myState.set(State.IDLE);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 13: 
            case 17: 
            case 27: 
            case 28: 
            case 50: 
            case 54: 
            case 55: 
            case 58: 
            case 61: 
            case 64: 
            case 69: 
            case 78: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 13: 
            case 17: 
            case 27: 
            case 28: 
            case 50: 
            case 54: 
            case 55: 
            case 58: 
            case 61: 
            case 64: 
            case 69: 
            case 78: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 4: 
            case 7: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "messageBus";
                break;
            }
            case 2: 
            case 5: 
            case 8: 
            case 12: 
            case 84: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataSource";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "session";
                break;
            }
            case 13: 
            case 17: 
            case 27: 
            case 28: 
            case 50: 
            case 54: 
            case 55: 
            case 58: 
            case 61: 
            case 64: 
            case 69: 
            case 78: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/console/JdbcEngine";
                break;
            }
            case 14: 
            case 15: 
            case 16: 
            case 24: 
            case 33: 
            case 36: 
            case 37: 
            case 40: {
                objectArray2 = objectArray3;
                objectArray3[0] = "connection";
                break;
            }
            case 18: 
            case 21: 
            case 22: 
            case 23: 
            case 25: 
            case 32: 
            case 42: 
            case 43: 
            case 44: 
            case 46: 
            case 53: {
                objectArray2 = objectArray3;
                objectArray3[0] = "r";
                break;
            }
            case 19: 
            case 72: {
                objectArray2 = objectArray3;
                objectArray3[0] = "operation";
                break;
            }
            case 20: 
            case 48: 
            case 57: 
            case 60: 
            case 63: 
            case 65: 
            case 68: 
            case 77: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dbms";
                break;
            }
            case 26: 
            case 51: {
                objectArray2 = objectArray3;
                objectArray3[0] = "request";
                break;
            }
            case 29: 
            case 35: 
            case 39: 
            case 79: 
            case 80: 
            case 81: 
            case 82: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 30: {
                objectArray2 = objectArray3;
                objectArray3[0] = "message";
                break;
            }
            case 31: {
                objectArray2 = objectArray3;
                objectArray3[0] = "queryText";
                break;
            }
            case 34: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dbConnection";
                break;
            }
            case 38: {
                objectArray2 = objectArray3;
                objectArray3[0] = "owner";
                break;
            }
            case 41: {
                objectArray2 = objectArray3;
                objectArray3[0] = "searchPath";
                break;
            }
            case 45: {
                objectArray2 = objectArray3;
                objectArray3[0] = "typeName";
                break;
            }
            case 47: {
                objectArray2 = objectArray3;
                objectArray3[0] = "d";
                break;
            }
            case 49: {
                objectArray2 = objectArray3;
                objectArray3[0] = "mutation";
                break;
            }
            case 52: {
                objectArray2 = objectArray3;
                objectArray3[0] = "infos";
                break;
            }
            case 56: 
            case 59: 
            case 62: 
            case 67: {
                objectArray2 = objectArray3;
                objectArray3[0] = "descriptors";
                break;
            }
            case 66: {
                objectArray2 = objectArray3;
                objectArray3[0] = "column";
                break;
            }
            case 70: {
                objectArray2 = objectArray3;
                objectArray3[0] = "mutations";
                break;
            }
            case 71: {
                objectArray2 = objectArray3;
                objectArray3[0] = "converter";
                break;
            }
            case 73: 
            case 76: {
                objectArray2 = objectArray3;
                objectArray3[0] = "resultSet";
                break;
            }
            case 74: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parameters";
                break;
            }
            case 75: {
                objectArray2 = objectArray3;
                objectArray3[0] = "retriever";
                break;
            }
            case 83: {
                objectArray2 = objectArray3;
                objectArray3[0] = "path";
                break;
            }
            case 85: {
                objectArray2 = objectArray3;
                objectArray3[0] = "needed";
                break;
            }
            case 86: 
            case 87: {
                objectArray2 = objectArray3;
                objectArray3[0] = "mark";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/console/JdbcEngine";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "createAccessController";
                break;
            }
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "getDataSource";
                break;
            }
            case 27: {
                objectArray = objectArray2;
                objectArray2[1] = "createRequestContext";
                break;
            }
            case 28: {
                objectArray = objectArray2;
                objectArray2[1] = "getAuditService";
                break;
            }
            case 50: {
                objectArray = objectArray2;
                objectArray2[1] = "createDescriptors";
                break;
            }
            case 54: 
            case 55: {
                objectArray = objectArray2;
                objectArray2[1] = "getErrorMessage";
                break;
            }
            case 58: {
                objectArray = objectArray2;
                objectArray2[1] = "getColumnNamesForInsert";
                break;
            }
            case 61: {
                objectArray = objectArray2;
                objectArray2[1] = "getPlaceholdersForInsert";
                break;
            }
            case 64: {
                objectArray = objectArray2;
                objectArray2[1] = "getPlaceholdersOrInlineValues";
                break;
            }
            case 69: {
                objectArray = objectArray2;
                objectArray2[1] = "shouldParticipateInInsert";
                break;
            }
            case 78: {
                objectArray = objectArray2;
                objectArray2[1] = "getTxMarker";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 13: 
            case 17: 
            case 27: 
            case 28: 
            case 50: 
            case 54: 
            case 55: 
            case 58: 
            case 61: 
            case 64: 
            case 69: 
            case 78: {
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "requestSearchPath";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "loadSearchPath";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "requestSearchPathTransparent";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "visitQuery";
                break;
            }
            case 19: 
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "wrap";
                break;
            }
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "visitUpdate";
                break;
            }
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "visitInsert";
                break;
            }
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "visitDelete";
                break;
            }
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "finishTx";
                break;
            }
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "visitSchemaSwitch";
                break;
            }
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "createRequestContext";
                break;
            }
            case 29: 
            case 30: {
                objectArray = objectArray;
                objectArray[2] = "reportError";
                break;
            }
            case 31: 
            case 32: {
                objectArray = objectArray;
                objectArray[2] = "getQueryType";
                break;
            }
            case 33: {
                objectArray = objectArray;
                objectArray[2] = "prepareConnection";
                break;
            }
            case 34: {
                objectArray = objectArray;
                objectArray[2] = "setTxIsolation";
                break;
            }
            case 35: 
            case 36: {
                objectArray = objectArray;
                objectArray[2] = "storeTxIsolation";
                break;
            }
            case 37: 
            case 38: 
            case 39: {
                objectArray = objectArray;
                objectArray[2] = "shouldChangeIsolation";
                break;
            }
            case 40: 
            case 41: {
                objectArray = objectArray;
                objectArray[2] = "performSchemaSwitch";
                break;
            }
            case 42: {
                objectArray = objectArray;
                objectArray[2] = "buildDataForSelect";
                break;
            }
            case 43: {
                objectArray = objectArray;
                objectArray[2] = "buildDataForDelete";
                break;
            }
            case 44: {
                objectArray = objectArray;
                objectArray[2] = "buildDataForUpdate";
                break;
            }
            case 45: {
                objectArray = objectArray;
                objectArray[2] = "shouldValueBeInlined";
                break;
            }
            case 46: {
                objectArray = objectArray;
                objectArray[2] = "buildDataForInsert";
                break;
            }
            case 47: 
            case 48: {
                objectArray = objectArray;
                objectArray[2] = "hasPlaceholder";
                break;
            }
            case 49: {
                objectArray = objectArray;
                objectArray[2] = "createDescriptors";
                break;
            }
            case 51: 
            case 52: {
                objectArray = objectArray;
                objectArray[2] = "executeUpdateStatement";
                break;
            }
            case 53: {
                objectArray = objectArray;
                objectArray[2] = "createExecutor";
                break;
            }
            case 56: 
            case 57: {
                objectArray = objectArray;
                objectArray[2] = "getColumnNamesForInsert";
                break;
            }
            case 59: 
            case 60: {
                objectArray = objectArray;
                objectArray[2] = "getPlaceholdersForInsert";
                break;
            }
            case 62: 
            case 63: {
                objectArray = objectArray;
                objectArray[2] = "getPlaceholdersOrInlineValues";
                break;
            }
            case 65: 
            case 66: 
            case 67: 
            case 68: {
                objectArray = objectArray;
                objectArray[2] = "shouldParticipateInInsert";
                break;
            }
            case 70: 
            case 71: 
            case 72: {
                objectArray = objectArray;
                objectArray[2] = "mergedQueryData";
                break;
            }
            case 73: {
                objectArray = objectArray;
                objectArray[2] = "printResultSet";
                break;
            }
            case 74: 
            case 75: {
                objectArray = objectArray;
                objectArray[2] = "printParameterResults";
                break;
            }
            case 76: 
            case 77: {
                objectArray = objectArray;
                objectArray[2] = "getColumnDescriptors";
                break;
            }
            case 79: {
                objectArray = objectArray;
                objectArray[2] = "onRequestStarted";
                break;
            }
            case 80: {
                objectArray = objectArray;
                objectArray[2] = "onRequestFinished";
                break;
            }
            case 81: {
                objectArray = objectArray;
                objectArray[2] = "changeSearchPathIfNeeded";
                break;
            }
            case 82: 
            case 83: {
                objectArray = objectArray;
                objectArray[2] = "canSwitchSchemaForRequest";
                break;
            }
            case 84: {
                objectArray = objectArray;
                objectArray[2] = "isJTds";
                break;
            }
            case 85: {
                objectArray = objectArray;
                objectArray[2] = "willReconnect";
                break;
            }
            case 86: {
                objectArray = objectArray;
                objectArray[2] = "addStatement";
                break;
            }
            case 87: {
                objectArray = objectArray;
                objectArray[2] = "removeStatement";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 13: 
            case 17: 
            case 27: 
            case 28: 
            case 50: 
            case 54: 
            case 55: 
            case 58: 
            case 61: 
            case 64: 
            case 69: 
            case 78: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private class RawOperation
    extends OperationBase {
        RawOperation(final DataRequest.RawRequest r) {
            if (r == null) {
                RawOperation.$$$reportNull$$$0(0);
            }
            super(new AtomicOperation(){

                @Override
                public boolean shouldRequestSearchPath() {
                    return DbImplUtil.omitSchemaQualifier() && WAS_STATEMENTS.get((UserDataHolder)JdbcEngine.this.getRequestContext()) == Boolean.TRUE;
                }

                @Override
                public boolean perform(@NotNull DatabaseConnection connection2, boolean isAtomic) throws Exception {
                    if (connection2 == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    r.processRaw(JdbcEngine.this.getRequestContext(), connection2);
                    return true;
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "connection", "com/intellij/database/console/JdbcEngine$RawOperation$1", "perform"));
                }
            });
        }

        @Override
        @NotNull
        protected AtomicHelper createHelper(@NotNull DatabaseConnection connection2) {
            if (connection2 == null) {
                RawOperation.$$$reportNull$$$0(1);
            }
            return new OperationBase.Inactive();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "r";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "connection";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/database/console/JdbcEngine$RawOperation";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "createHelper";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    public static enum ExecutionConcession {
        SIDE_EFFECTS_IN_RO_MODE,
        UNSAFE_STATEMENT;

    }

    private static class DisposalRollbackRequest
    extends DataRequest.TxRequest {
        DisposalRollbackRequest(@NotNull DataRequest.Owner owner, @NotNull DataRequest.TxMarker marker) {
            if (owner == null) {
                DisposalRollbackRequest.$$$reportNull$$$0(0);
            }
            if (marker == null) {
                DisposalRollbackRequest.$$$reportNull$$$0(1);
            }
            super(owner, marker, DataRequest.TxCommand.ROLLBACK);
        }

        @Override
        public boolean isAsyncFriendly() {
            return false;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "owner";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "marker";
                    break;
                }
            }
            objectArray[1] = "com/intellij/database/console/JdbcEngine$DisposalRollbackRequest";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static enum ReconnectErrorBuilder {
        DATA_IMPORT(DGDepartment.DATA_IMPORT){

            @Override
            @NotNull
            String action() {
                return "import data";
            }
        }
        ,
        INTROSPECTION(DGDepartment.INTROSPECTION){

            @Override
            @NotNull
            String action() {
                return "perform introspection";
            }
        }
        ,
        DATA_EXPORT(DGDepartment.DATA_EXPORT){

            @Override
            @NotNull
            String action() {
                return "export data";
            }
        }
        ,
        DEFAULT(null){

            @Override
            @NotNull
            String action() {
                return "execute request";
            }
        };

        private final DGDepartment myDepartment;

        private ReconnectErrorBuilder(DGDepartment department) {
            this.myDepartment = department;
        }

        @NotNull
        String message(@Nullable String transactionName) {
            String string = "Failed to " + this.action() + ". The transaction is in progress" + (transactionName != null ? " \"" + transactionName + "\"" : "") + ". Commit or rollback it first and try again";
            if (string == null) {
                ReconnectErrorBuilder.$$$reportNull$$$0(0);
            }
            return string;
        }

        @NotNull
        abstract String action();

        @NotNull
        static ReconnectErrorBuilder of(@Nullable DatabaseDepartment department) {
            DGDepartment dgDepartment = (DGDepartment)ObjectUtils.tryCast((Object)department, DGDepartment.class);
            for (ReconnectErrorBuilder value2 : ReconnectErrorBuilder.values()) {
                if (value2.myDepartment != dgDepartment) continue;
                ReconnectErrorBuilder reconnectErrorBuilder = value2;
                if (reconnectErrorBuilder == null) {
                    ReconnectErrorBuilder.$$$reportNull$$$0(1);
                }
                return reconnectErrorBuilder;
            }
            ReconnectErrorBuilder reconnectErrorBuilder = DEFAULT;
            if (reconnectErrorBuilder == null) {
                ReconnectErrorBuilder.$$$reportNull$$$0(2);
            }
            return reconnectErrorBuilder;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[2];
            objectArray2[0] = "com/intellij/database/console/JdbcEngine$ReconnectErrorBuilder";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "message";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "of";
                    break;
                }
            }
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
        }
    }

    private static class StackTraceFreeException
    extends RuntimeException
    implements SuppressUserStackTrace {
        StackTraceFreeException(@NotNull String message2) {
            if (message2 == null) {
                StackTraceFreeException.$$$reportNull$$$0(0);
            }
            super(message2);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "message", "com/intellij/database/console/JdbcEngine$StackTraceFreeException", "<init>"));
        }
    }

    private static enum State {
        IDLE,
        RUNNING,
        STREAMING,
        CANCELED;

    }

    public static class OffsetSavingBuilder
    extends DdlBuilder {
        private final TIntArrayList myOffsets;

        public OffsetSavingBuilder(@NotNull DdlBuilder builder) {
            if (builder == null) {
                OffsetSavingBuilder.$$$reportNull$$$0(0);
            }
            super(new StringBuilder(builder.getStatement()));
            this.myOffsets = new TIntArrayList();
            this.configureFrom(builder);
        }

        @Override
        @NotNull
        public DdlBuilder placeholder() {
            this.myOffsets.add(this.length());
            DdlBuilder ddlBuilder = super.placeholder();
            if (ddlBuilder == null) {
                OffsetSavingBuilder.$$$reportNull$$$0(1);
            }
            return ddlBuilder;
        }

        public int[] getOffsets() {
            return this.myOffsets.toNativeArray();
        }

        @Override
        @NotNull
        public DdlBuilder clear() {
            this.myOffsets.clear();
            DdlBuilder ddlBuilder = super.clear();
            if (ddlBuilder == null) {
                OffsetSavingBuilder.$$$reportNull$$$0(2);
            }
            return ddlBuilder;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 1: 
                case 2: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 1: 
                case 2: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "builder";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/database/console/JdbcEngine$OffsetSavingBuilder";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/database/console/JdbcEngine$OffsetSavingBuilder";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "placeholder";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "clear";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: 
                case 2: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 1: 
                case 2: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    public static class EngineWarningException
    extends SQLException {
        private final String myLogMessage;
        private final ExecutionConcession myConcession;
        private final Runnable mySuppressAction;

        EngineWarningException(@NotNull String message2, @NotNull String logMessage, @NotNull ExecutionConcession concession, @Nullable Runnable suppressAction) {
            if (message2 == null) {
                EngineWarningException.$$$reportNull$$$0(0);
            }
            if (logMessage == null) {
                EngineWarningException.$$$reportNull$$$0(1);
            }
            if (concession == null) {
                EngineWarningException.$$$reportNull$$$0(2);
            }
            super(message2);
            this.myLogMessage = logMessage;
            this.myConcession = concession;
            this.mySuppressAction = suppressAction;
            this.setStackTrace(new StackTraceElement[0]);
        }

        @NotNull
        public ExecutionConcession getConcession() {
            ExecutionConcession executionConcession = this.myConcession;
            if (executionConcession == null) {
                EngineWarningException.$$$reportNull$$$0(3);
            }
            return executionConcession;
        }

        @NotNull
        public String getLogMessage() {
            String string = this.myLogMessage;
            if (string == null) {
                EngineWarningException.$$$reportNull$$$0(4);
            }
            return string;
        }

        @Nullable
        public Runnable getSuppressAction() {
            return this.mySuppressAction;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 3: 
                case 4: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 3: 
                case 4: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "message";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "logMessage";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "concession";
                    break;
                }
                case 3: 
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/database/console/JdbcEngine$EngineWarningException";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/database/console/JdbcEngine$EngineWarningException";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getConcession";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getLogMessage";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 3: 
                case 4: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 3: 
                case 4: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    public static class QueryValidationException
    extends EngineWarningException {
        QueryValidationException(String message2) {
            super(message2, message2, ExecutionConcession.UNSAFE_STATEMENT, () -> {
                DatabaseSettings.getSettings().warnAboutUnsafeQuery = false;
                DatabaseSettings.fireSettingsChanged();
            });
        }
    }

    private class QueryExecutionOperation
    implements AtomicOperation {
        private final Executor myHolder;
        private final DataRequest.Constraints myConstraints;
        private final DataRequest myRequest;
        private final boolean myFromConsole;
        private final boolean myRequestSearchPath;
        private boolean mySearchPathRequested;

        QueryExecutionOperation(@NotNull Executor holder, DataRequest request) {
            if (holder == null) {
                QueryExecutionOperation.$$$reportNull$$$0(0);
            }
            if (request == null) {
                QueryExecutionOperation.$$$reportNull$$$0(1);
            }
            this.myHolder = holder;
            this.myRequest = request;
            this.myConstraints = this.myRequest instanceof DataRequest.QueryRequest ? ((DataRequest.QueryRequest)this.myRequest).constraints : DataRequest.newConstraints();
            this.myFromConsole = request instanceof ConsoleDataRequest;
            this.myRequestSearchPath = this.myFromConsole && ((ConsoleDataRequest)request).isExecutionStopper();
        }

        @Override
        public boolean shouldRequestSearchPath() {
            return !this.mySearchPathRequested && (DbImplUtil.omitSchemaQualifier() || this.myFromConsole && this.myRequestSearchPath);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean perform(@NotNull DatabaseConnection connection2, boolean isAtomic) throws SQLException {
            if (connection2 == null) {
                QueryExecutionOperation.$$$reportNull$$$0(2);
            }
            boolean suppressReadOnly = this.shouldSuppressReadOnly(connection2);
            try {
                if (suppressReadOnly) {
                    connection2.setReadOnly(false);
                }
                boolean bl = this.execute(connection2);
                return bl;
            }
            catch (EngineWarningException e) {
                JdbcEngine.this.getRequestContext().reportException(e, null);
                boolean bl = false;
                return bl;
            }
            catch (SQLException e) {
                boolean bl = false;
                return bl;
            }
            catch (Throwable e) {
                JdbcEngine.this.getRequestContext().reportException(e, null);
                boolean bl = false;
                return bl;
            }
            finally {
                if (suppressReadOnly) {
                    connection2.setReadOnly(true);
                }
            }
        }

        private boolean shouldSuppressReadOnly(@NotNull DatabaseConnection connection2) throws SQLException {
            if (connection2 == null) {
                QueryExecutionOperation.$$$reportNull$$$0(3);
            }
            if (JdbcEngine.this.myDbms == Dbms.MYSQL && connection2.isReadOnly()) {
                return true;
            }
            if (!(this.myRequest instanceof ConsoleDataRequest)) {
                return false;
            }
            ConsoleDataRequest request = (ConsoleDataRequest)this.myRequest;
            boolean autoCommit = JdbcEngine.this.myTxMarker == DataRequest.AUTO_COMMIT;
            boolean canChange = DbImplUtil.supportsReadOnlyChangeOnTheFly(JdbcEngine.this.myDbms);
            boolean canChangeDuringTx = DbImplUtil.supportsReadOnlyChangeDuringTx(JdbcEngine.this.myDbms);
            return request.concessions.contains((Object)ExecutionConcession.SIDE_EFFECTS_IN_RO_MODE) && canChange && (autoCommit || canChangeDuringTx);
        }

        private boolean execute(@NotNull DatabaseConnection connection2) throws Exception {
            if (connection2 == null) {
                QueryExecutionOperation.$$$reportNull$$$0(4);
            }
            String statement = this.myHolder.getStatement();
            this.requestWriteAccess(statement);
            this.validateStatement(statement);
            Integer maxRows = null;
            Object type = JdbcEngine.this.getQueryType(statement, this.myRequest);
            if (type instanceof SqlTableType) {
                if (this.myConstraints.absolutePosition >= 0 && !DbImplUtil.isPageSizeUnlimited(this.myConstraints.limit)) {
                    maxRows = this.myConstraints.absolutePosition + this.myConstraints.limit + 1;
                }
                JdbcEngine.this.requestSearchPath(connection2);
                this.mySearchPathRequested = true;
            }
            int maxAllowedChunkSize = maxRows == null || maxRows < 0 ? Integer.MAX_VALUE : maxRows;
            int defaultPrefetchSize = DatabaseSettings.getSettings().getPrefetchSize();
            final int chunkSize = Math.min(maxAllowedChunkSize, Math.max(this.myConstraints.limit / 10, defaultPrefetchSize <= 0 ? 100 : defaultPrefetchSize));
            Configuration configuration = new Configuration(false, maxRows, this.myConstraints.resultSetNumber, JdbcEngine.this.myDbms.isMysql() ? Integer.MIN_VALUE : chunkSize, SmartStatements.Source.USER, DGDepartment.UNKNOWN);
            final Ref lastResultsIndex = Ref.create((Object)-1);
            final int[] rowCount = new int[]{0};
            ExecutionEnvironmentHelper environmentHelper = (ExecutionEnvironmentHelper)ExecutionEnvironmentHelper.EP.forDbms(JdbcEngine.this.myDbms);
            environmentHelper.runInSpecificEnvironment(this.myHolder.getStatement(), configuration, connection2, JdbcEngine.this.getProject(), (ThrowableRunnable<Exception>)((ThrowableRunnable)() -> this.myHolder.execute(connection2, configuration, (Consumer<ResultsProducer>)((Consumer)producer -> {
                JdbcEngine.this.myState.compareAndSet(State.RUNNING, State.STREAMING);
                producer.processRemaining(new ResultsProducer.Processor<Unit>(){

                    public Unit processResults(int index2, ThrowableRunnable<? extends Exception> action2) throws Exception {
                        lastResultsIndex.set((Object)index2);
                        try {
                            JdbcEngine.this.checkCanceled();
                            JdbcEngine.this.getDataAuditor().fetchStarted(JdbcEngine.this.getRequestContext(), index2);
                            action2.run();
                        }
                        finally {
                            JdbcEngine.this.getDataAuditor().fetchFinished(JdbcEngine.this.getRequestContext(), index2, rowCount[0]);
                        }
                        return Unit.INSTANCE;
                    }

                    @Override
                    @NotNull
                    public Unit results(@NotNull RemoteResultSet resultSet, int index2) throws Exception {
                        if (resultSet == null) {
                            1.$$$reportNull$$$0(0);
                        }
                        Unit unit = this.processResults(index2, (ThrowableRunnable<? extends Exception>)((ThrowableRunnable)() -> JdbcEngine.this.printResultSet(resultSet, index2, ((QueryExecutionOperation)QueryExecutionOperation.this).myConstraints.absolutePosition, ((QueryExecutionOperation)QueryExecutionOperation.this).myConstraints.limit, ((QueryExecutionOperation)QueryExecutionOperation.this).myConstraints.queryOffset, chunkSize, rowCount)));
                        if (unit == null) {
                            1.$$$reportNull$$$0(1);
                        }
                        return unit;
                    }

                    @Override
                    public Unit parameterResults(@NotNull List<? extends OutParameter<?>> parameters, @NotNull Function1<? super OutParameter<?>, ?> retriever, int index2) throws Exception {
                        if (parameters == null) {
                            1.$$$reportNull$$$0(2);
                        }
                        if (retriever == null) {
                            1.$$$reportNull$$$0(3);
                        }
                        return this.processResults(index2, (ThrowableRunnable<? extends Exception>)((ThrowableRunnable)() -> {
                            JdbcEngine.this.printParameterResults(parameters, retriever, index2);
                            rowCount2[0] = 1;
                        }));
                    }

                    @Override
                    @NotNull
                    public Unit updateCount(int count2, int index2) {
                        Unit unit = Unit.INSTANCE;
                        if (unit == null) {
                            1.$$$reportNull$$$0(4);
                        }
                        return unit;
                    }

                    private static /* synthetic */ void $$$reportNull$$$0(int n) {
                        RuntimeException runtimeException;
                        Object[] objectArray;
                        Object[] objectArray2;
                        int n2;
                        String string;
                        switch (n) {
                            default: {
                                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                                break;
                            }
                            case 1: 
                            case 4: {
                                string = "@NotNull method %s.%s must not return null";
                                break;
                            }
                        }
                        switch (n) {
                            default: {
                                n2 = 3;
                                break;
                            }
                            case 1: 
                            case 4: {
                                n2 = 2;
                                break;
                            }
                        }
                        Object[] objectArray3 = new Object[n2];
                        switch (n) {
                            default: {
                                objectArray2 = objectArray3;
                                objectArray3[0] = "resultSet";
                                break;
                            }
                            case 1: 
                            case 4: {
                                objectArray2 = objectArray3;
                                objectArray3[0] = "com/intellij/database/console/JdbcEngine$QueryExecutionOperation$1";
                                break;
                            }
                            case 2: {
                                objectArray2 = objectArray3;
                                objectArray3[0] = "parameters";
                                break;
                            }
                            case 3: {
                                objectArray2 = objectArray3;
                                objectArray3[0] = "retriever";
                                break;
                            }
                        }
                        switch (n) {
                            default: {
                                objectArray = objectArray2;
                                objectArray2[1] = "com/intellij/database/console/JdbcEngine$QueryExecutionOperation$1";
                                break;
                            }
                            case 1: {
                                objectArray = objectArray2;
                                objectArray2[1] = "results";
                                break;
                            }
                            case 4: {
                                objectArray = objectArray2;
                                objectArray2[1] = "updateCount";
                                break;
                            }
                        }
                        switch (n) {
                            default: {
                                objectArray = objectArray;
                                objectArray[2] = "results";
                                break;
                            }
                            case 1: 
                            case 4: {
                                break;
                            }
                            case 2: 
                            case 3: {
                                objectArray = objectArray;
                                objectArray[2] = "parameterResults";
                                break;
                            }
                        }
                        String string2 = String.format(string, objectArray);
                        switch (n) {
                            default: {
                                runtimeException = new IllegalArgumentException(string2);
                                break;
                            }
                            case 1: 
                            case 4: {
                                runtimeException = new IllegalStateException(string2);
                                break;
                            }
                        }
                        throw runtimeException;
                    }
                });
            }))));
            Integer resultSetIndex = (Integer)lastResultsIndex.get();
            int maxResultSetIndex = SmartStatements.Companion.getMaxResults();
            if (resultSetIndex > maxResultSetIndex) {
                JdbcEngine.this.getDataAuditor().warn(JdbcEngine.this.getRequestContext(), "The query yielded " + resultSetIndex + " result sets, only " + maxResultSetIndex + " were retrieved.");
            }
            return true;
        }

        private void requestWriteAccess(@NotNull String sql) throws EngineWarningException {
            if (sql == null) {
                QueryExecutionOperation.$$$reportNull$$$0(5);
            }
            ExecutionConcession concession = ExecutionConcession.SIDE_EFFECTS_IN_RO_MODE;
            if (this.myRequest instanceof ConsoleDataRequest) {
                ConsoleDataRequest request = (ConsoleDataRequest)this.myRequest;
                if (request.concessions.contains((Object)concession)) {
                    return;
                }
            }
            DatabaseAccessController.Token token = JdbcEngine.this.myDatabaseAccessController.requestAccess(sql);
            if (!token.success) {
                throw new EngineWarningException(token.message, token.logMessage, concession, null);
            }
        }

        private void validateStatement(@NotNull String queryText2) throws QueryValidationException {
            if (queryText2 == null) {
                QueryExecutionOperation.$$$reportNull$$$0(6);
            }
            if (this.myRequest instanceof ConsoleDataRequest) {
                ConsoleDataRequest request = (ConsoleDataRequest)this.myRequest;
                if (request.concessions.contains((Object)ExecutionConcession.UNSAFE_STATEMENT)) {
                    return;
                }
            }
            if (!DatabaseSettings.getSettings().warnAboutUnsafeQuery) {
                return;
            }
            Project project = JdbcEngine.this.getProject();
            SqlFile file = SqlPsiFacade.getInstance((Project)project).createROFile(DbSqlUtil.getSqlDialect(JdbcEngine.this.myDataSource), (CharSequence)queryText2, null);
            DatabaseDataKeys.DATA_SOURCE_KEY.set((UserDataHolder)file, (Object)DbImplUtil.getDbDataSource(JdbcEngine.this.getProject(), JdbcEngine.this.myDataSource));
            DatabaseDataKeys.SEARCH_PATH_KEY.set((UserDataHolder)file, (Object)JdbcEngine.this.mySearchPath);
            String message2 = Arrays.stream(DbQueryValidator.EP_NAME.getExtensions()).map(v -> String.join((CharSequence)"\n", v.getValidationErrors(file))).filter(s -> !s.isEmpty()).collect(Collectors.joining("\n"));
            if (message2.length() > 0) {
                throw new QueryValidationException("Unsafe query: " + message2);
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "holder";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "request";
                    break;
                }
                case 2: 
                case 3: 
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "connection";
                    break;
                }
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "sql";
                    break;
                }
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "queryText";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/database/console/JdbcEngine$QueryExecutionOperation";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "perform";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[2] = "shouldSuppressReadOnly";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[2] = "execute";
                    break;
                }
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[2] = "requestWriteAccess";
                    break;
                }
                case 6: {
                    objectArray = objectArray2;
                    objectArray2[2] = "validateStatement";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private class CallOperation
    implements AtomicOperation {
        private final DataRequest.CallRequest myRequest;
        private boolean myRequestSearchPath;

        CallOperation(DataRequest.CallRequest request) {
            if (request == null) {
                CallOperation.$$$reportNull$$$0(0);
            }
            this.myRequest = request;
        }

        @Override
        public boolean shouldRequestSearchPath() {
            return this.myRequestSearchPath;
        }

        @Override
        public boolean perform(@NotNull DatabaseConnection connection2, boolean isAtomic) throws SQLException {
            if (connection2 == null) {
                CallOperation.$$$reportNull$$$0(1);
            }
            for (DataRequest.CallRequest.Statement statement : this.myRequest.queries) {
                Executor executor = this.createExecutor(statement);
                QueryExecutionOperation operation = new QueryExecutionOperation(executor, this.myRequest);
                boolean result = operation.perform(connection2, isAtomic);
                this.myRequestSearchPath = operation.shouldRequestSearchPath();
                if (result) continue;
                return false;
            }
            return true;
        }

        @NotNull
        private Executor createExecutor(@NotNull DataRequest.CallRequest.Statement statement) {
            if (statement == null) {
                CallOperation.$$$reportNull$$$0(2);
            }
            return statement.outParameters.isEmpty() && statement.inParameters.isEmpty() ? new SimpleExecutor(statement.statement) : new CallExecutor(statement.statement, statement.outParameters, statement.inParameters);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "request";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "connection";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "statement";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/database/console/JdbcEngine$CallOperation";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "perform";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "createExecutor";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private class UpdateOperation
    implements AtomicOperation {
        private final List<QueryData> myQueryData;
        private final UnexpectedUpdatesGuard myGuard;

        UpdateOperation(List<QueryData> queryData) {
            if (queryData == null) {
                UpdateOperation.$$$reportNull$$$0(0);
            }
            this.myQueryData = queryData;
            this.myGuard = new UnexpectedUpdatesGuard();
        }

        @Override
        public boolean shouldRequestSearchPath() {
            return false;
        }

        @Override
        public boolean perform(@NotNull DatabaseConnection connection2, boolean isAtomic) {
            if (connection2 == null) {
                UpdateOperation.$$$reportNull$$$0(1);
            }
            for (QueryData data : this.myQueryData) {
                if (this.executeUpdateStatementAndGetUpdateCounts(connection2, data, isAtomic)) continue;
                return false;
            }
            return true;
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        private boolean executeUpdateStatementAndGetUpdateCounts(@NotNull DatabaseConnection connection2, @NotNull QueryData data, boolean isAtomic) {
            if (connection2 == null) {
                UpdateOperation.$$$reportNull$$$0(2);
            }
            if (data == null) {
                UpdateOperation.$$$reportNull$$$0(3);
            }
            try {
                Iterator<RowUpdateData> iterator = data.iterator();
                while (iterator.hasNext()) {
                    RowUpdateData rowInfo = iterator.next();
                    RowQueryData qData = rowInfo.getQueryData();
                    ClosableResultsProducer producer = SmartStatements.poweredBy(connection2).parameterized().noisy().execute(qData.asParameterizedStatementData(), StandardExecutionMode.UPDATE);
                    Throwable throwable = null;
                    try {
                        int updateCount2 = producer.advanceSafe() ? producer.processCurrent(StandardResultsProcessors.updateCount(-1)) : -1;
                        if (updateCount2 == -2 || this.myGuard.updateSuccessful(updateCount2, rowInfo.getUpdateCount(), isAtomic)) continue;
                        boolean bl = false;
                        return bl;
                    }
                    catch (Throwable throwable2) {
                        throwable = throwable2;
                        throw throwable2;
                    }
                    finally {
                        if (producer == null) continue;
                        if (throwable != null) {
                            try {
                                producer.close();
                            }
                            catch (Throwable throwable3) {
                                throwable.addSuppressed(throwable3);
                            }
                            continue;
                        }
                        producer.close();
                    }
                }
                return true;
            }
            catch (SQLException e) {
                return false;
            }
            catch (Exception e) {
                JdbcEngine.this.getRequestContext().reportException(e, null);
                return false;
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "queryData";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "connection";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "data";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/database/console/JdbcEngine$UpdateOperation";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "perform";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[2] = "executeUpdateStatementAndGetUpdateCounts";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }

        private class UnexpectedUpdatesGuard {
            private UnexpectedUpdatesGuard() {
            }

            public boolean updateSuccessful(int actual, int expected, boolean atomic) {
                boolean unexpectedUpdateCount;
                boolean bl = unexpectedUpdateCount = expected != actual;
                if (unexpectedUpdateCount) {
                    if (atomic) {
                        this.reportChangesWillBeRolledBack(actual, expected);
                    } else {
                        this.reportUnexpectedUpdateCount(actual, expected);
                    }
                }
                return !unexpectedUpdateCount;
            }

            private void reportUnexpectedUpdateCount(int actual, int expected) {
                String message2 = DatabaseBundle.message((String)"message.text.error.unexpected.update.count", (Object[])new Object[0]) + this.getDiffString(actual, expected) + "Rollback the current transaction to undo changes.";
                JdbcEngine.this.getDataAuditor().print(JdbcEngine.this.getRequestContext(), message2);
            }

            protected final void reportChangesWillBeRolledBack(int actual, int expected) {
                String message2 = DatabaseBundle.message((String)"message.text.error.unexpected.update.count", (Object[])new Object[0]) + this.getDiffString(actual, expected) + "All changes will be rolled back.";
                JdbcEngine.this.getRequestContext().reportException(new UnsafeUpdateRolledBackException(message2), null);
            }

            @NotNull
            protected final String getDiffString(int actual, int expected) {
                String diffString = " (Actual: %s, Expected: %s). ";
                String string = String.format(diffString, actual, expected);
                if (string == null) {
                    UnexpectedUpdatesGuard.$$$reportNull$$$0(0);
                }
                return string;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/console/JdbcEngine$UpdateOperation$UnexpectedUpdatesGuard", "getDiffString"));
            }
        }
    }

    private static abstract class PotentiallyTransparentOperation
    implements AtomicOperation {
        private PotentiallyTransparentOperation() {
        }

        @Override
        public boolean perform(@NotNull DatabaseConnection connection2, boolean isAtomic) throws Exception {
            if (connection2 == null) {
                PotentiallyTransparentOperation.$$$reportNull$$$0(0);
            }
            return this.transparent(connection2) && !isAtomic;
        }

        abstract boolean transparent(@NotNull DatabaseConnection var1) throws Exception;

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "connection", "com/intellij/database/console/JdbcEngine$PotentiallyTransparentOperation", "perform"));
        }
    }

    private class TransactionOperation
    extends OperationBase {
        private boolean myAuto;

        TransactionOperation(AtomicOperation operation) {
            if (operation == null) {
                TransactionOperation.$$$reportNull$$$0(0);
            }
            super(operation);
        }

        @Override
        public boolean perform(@NotNull DatabaseConnection connection2) throws Exception {
            if (connection2 == null) {
                TransactionOperation.$$$reportNull$$$0(1);
            }
            this.myAuto = connection2.getAutoCommit();
            if (this.myAuto) {
                connection2.setAutoCommit(false);
            }
            try {
                boolean bl = super.perform(connection2);
                return bl;
            }
            finally {
                if (this.myAuto) {
                    connection2.setAutoCommit(true);
                }
            }
        }

        @Override
        @NotNull
        protected AtomicHelper createHelper(@NotNull DatabaseConnection connection2) {
            if (connection2 == null) {
                TransactionOperation.$$$reportNull$$$0(2);
            }
            return this.myAuto ? new OperationBase.CommitOrRollback(connection2) : new OperationBase.RollbackToSavepoint(connection2);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "operation";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "connection";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/database/console/JdbcEngine$TransactionOperation";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "perform";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "createHelper";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private class SilentOperation
    extends PotentiallyAtomicOperation {
        SilentOperation(AtomicOperation delegate, boolean isTransactionJustStarted) {
            if (delegate == null) {
                SilentOperation.$$$reportNull$$$0(0);
            }
            super(delegate, isTransactionJustStarted);
        }

        @Override
        @NotNull
        protected AtomicHelper createHelper(@NotNull DatabaseConnection connection2) throws SQLException {
            if (connection2 == null) {
                SilentOperation.$$$reportNull$$$0(1);
            }
            return new SilentHelper(super.createHelper(connection2));
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "delegate";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "connection";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/database/console/JdbcEngine$SilentOperation";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "createHelper";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }

        private class SilentHelper
        implements AtomicHelper {
            private final AtomicHelper myDelegate;

            SilentHelper(AtomicHelper delegate) {
                if (delegate == null) {
                    SilentHelper.$$$reportNull$$$0(0);
                }
                this.myDelegate = delegate;
            }

            @Override
            public void free(boolean success) {
                JdbcNativeUtil.performSafe(() -> this.myDelegate.free(success));
            }

            @Override
            public boolean isAvailable() {
                return this.myDelegate.isAvailable();
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "delegate", "com/intellij/database/console/JdbcEngine$SilentOperation$SilentHelper", "<init>"));
            }
        }
    }

    private class PotentiallyAtomicOperation
    extends OperationBase {
        private final boolean myTransactionJustStarted;

        private PotentiallyAtomicOperation(AtomicOperation delegate, boolean isTransactionJustStarted) {
            if (delegate == null) {
                PotentiallyAtomicOperation.$$$reportNull$$$0(0);
            }
            super(delegate);
            this.myTransactionJustStarted = isTransactionJustStarted;
        }

        @Override
        @NotNull
        protected AtomicHelper createHelper(@NotNull DatabaseConnection connection2) throws SQLException {
            if (connection2 == null) {
                PotentiallyAtomicOperation.$$$reportNull$$$0(1);
            }
            return connection2.getAutoCommit() ? new OperationBase.Inactive() : (this.myTransactionJustStarted ? new OperationBase.Rollback(connection2) : new OperationBase.RollbackToSavepoint(connection2));
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "delegate";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "connection";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/database/console/JdbcEngine$PotentiallyAtomicOperation";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "createHelper";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private abstract class OperationBase
    implements Operation {
        private final AtomicOperation myDelegate;

        OperationBase(AtomicOperation delegate) {
            if (delegate == null) {
                OperationBase.$$$reportNull$$$0(0);
            }
            this.myDelegate = delegate;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean perform(@NotNull DatabaseConnection connection2) throws Exception {
            if (connection2 == null) {
                OperationBase.$$$reportNull$$$0(1);
            }
            AtomicHelper helper = this.createHelper(connection2);
            boolean result = false;
            try {
                result = this.myDelegate.perform(connection2, helper.isAvailable());
            }
            finally {
                try {
                    if (this.myDelegate.shouldRequestSearchPath()) {
                        JdbcEngine.this.requestSearchPath(connection2);
                    }
                }
                finally {
                    helper.free(result);
                }
            }
            return result;
        }

        @NotNull
        protected abstract AtomicHelper createHelper(@NotNull DatabaseConnection var1) throws SQLException;

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "delegate";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "connection";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/database/console/JdbcEngine$OperationBase";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "perform";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }

        class RollbackToSavepoint
        implements AtomicHelper {
            private final RemoteSavepoint mySavepoint;
            private final DatabaseConnection myGuardedConnection;

            RollbackToSavepoint(DatabaseConnection connection2) {
                if (connection2 == null) {
                    RollbackToSavepoint.$$$reportNull$$$0(0);
                }
                this.myGuardedConnection = connection2;
                this.mySavepoint = this.createSavepoint();
            }

            @Override
            public boolean isAvailable() {
                return this.mySavepoint != null;
            }

            @Override
            public void free(boolean success) throws SQLException {
                if (this.mySavepoint == null) {
                    return;
                }
                try {
                    if (!success) {
                        this.myGuardedConnection.rollback(this.mySavepoint);
                    }
                }
                catch (SQLException e) {
                    throw new SQLException(DatabaseBundle.message((String)"message.text.error.failed.to.rollback.to.a.savepoint", (Object[])new Object[0]), e);
                }
                finally {
                    JdbcNativeUtil.performSafe(() -> this.myGuardedConnection.releaseSavepoint(this.mySavepoint));
                }
            }

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            @Nullable
            private RemoteSavepoint createSavepoint() {
                try {
                    RemoteDatabaseMetaData metaData = this.myGuardedConnection.getRemoteMetaData();
                    if (metaData == null) return null;
                    if (!JdbcNativeUtil.getBooleanSafe(() -> ((RemoteDatabaseMetaData)metaData).supportsSavepoints())) return null;
                    RemoteSavepoint remoteSavepoint = this.myGuardedConnection.setSavepoint();
                    return remoteSavepoint;
                }
                catch (Exception e) {
                    LOG.info("Exception while setting an unnamed savepoint", (Throwable)e);
                    return null;
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "connection", "com/intellij/database/console/JdbcEngine$OperationBase$RollbackToSavepoint", "<init>"));
            }
        }

        class CommitOrRollback
        implements AtomicHelper {
            private final DatabaseConnection myConnection;

            CommitOrRollback(DatabaseConnection connection2) {
                if (connection2 == null) {
                    CommitOrRollback.$$$reportNull$$$0(0);
                }
                this.myConnection = connection2;
            }

            @Override
            public void free(boolean success) throws SQLException {
                if (success) {
                    this.myConnection.commit();
                } else {
                    this.myConnection.rollback();
                }
            }

            @Override
            public boolean isAvailable() {
                return true;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "connection", "com/intellij/database/console/JdbcEngine$OperationBase$CommitOrRollback", "<init>"));
            }
        }

        class Rollback
        implements AtomicHelper {
            private final DatabaseConnection myConnection;

            Rollback(DatabaseConnection connection2) {
                if (connection2 == null) {
                    Rollback.$$$reportNull$$$0(0);
                }
                this.myConnection = connection2;
            }

            @Override
            public void free(boolean success) throws SQLException {
                if (!success) {
                    this.myConnection.rollback();
                }
            }

            @Override
            public boolean isAvailable() {
                return true;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "connection", "com/intellij/database/console/JdbcEngine$OperationBase$Rollback", "<init>"));
            }
        }

        class Inactive
        implements AtomicHelper {
            Inactive() {
            }

            @Override
            public void free(boolean success) {
            }

            @Override
            public boolean isAvailable() {
                return true;
            }
        }
    }

    static interface AtomicHelper {
        public void free(boolean var1) throws SQLException;

        public boolean isAvailable();
    }

    private class EngineAuditService
    implements AuditService {
        private EngineAuditService() {
        }

        @Override
        public void error(@NotNull String message2) {
            DataRequest.Context context;
            if (message2 == null) {
                EngineAuditService.$$$reportNull$$$0(0);
            }
            if ((context = JdbcEngine.this.getRequestContextIfAny()) != null) {
                JdbcEngine.this.getDataAuditor().error(context, message2, null);
            }
        }

        @Override
        public void warning(@NotNull String message2) {
            DataRequest.Context context;
            if (message2 == null) {
                EngineAuditService.$$$reportNull$$$0(1);
            }
            if ((context = JdbcEngine.this.getRequestContextIfAny()) != null) {
                JdbcEngine.this.getDataAuditor().warn(context, message2);
            }
        }

        @Override
        public void afterStatement(@NotNull SmartStatementMark mark2) {
            if (mark2 == null) {
                EngineAuditService.$$$reportNull$$$0(2);
            }
            if (this.isSystemQuery(mark2)) {
                JdbcEngine.this.removeStatement(mark2);
            }
        }

        @Override
        public void beforeCallableStatement(@NotNull CallableStatementData data, @NotNull SmartStatementMark mark2) {
            if (data == null) {
                EngineAuditService.$$$reportNull$$$0(3);
            }
            if (mark2 == null) {
                EngineAuditService.$$$reportNull$$$0(4);
            }
            this.beforeParameterizedStatement(data, mark2);
        }

        @Override
        public void beforeParameterizedStatement(@NotNull ParameterizedStatementData data, @NotNull SmartStatementMark mark2) {
            if (data == null) {
                EngineAuditService.$$$reportNull$$$0(5);
            }
            if (mark2 == null) {
                EngineAuditService.$$$reportNull$$$0(6);
            }
            JdbcEngine.this.addStatement(mark2);
            if (data.getBasis().getOffsets() != null) {
                this.parameterizedAudit(data, mark2);
                return;
            }
            this.plainAudit(data.getBasis().getSql(), mark2);
        }

        @Override
        public void beforeSimpleStatement(@NotNull String sql, @NotNull SmartStatementMark mark2) {
            if (sql == null) {
                EngineAuditService.$$$reportNull$$$0(7);
            }
            if (mark2 == null) {
                EngineAuditService.$$$reportNull$$$0(8);
            }
            JdbcEngine.this.addStatement(mark2);
            this.plainAudit(sql, mark2);
        }

        private void plainAudit(@NotNull String sql, @NotNull SmartStatementMark mark2) {
            if (sql == null) {
                EngineAuditService.$$$reportNull$$$0(9);
            }
            if (mark2 == null) {
                EngineAuditService.$$$reportNull$$$0(10);
            }
            if (this.isSystemQuery(mark2)) {
                return;
            }
            DataRequest.Context context = JdbcEngine.this.getRequestContext();
            context.statementContext.push(new RawStatementContext(sql));
            JdbcEngine.this.getDataAuditor().beforeStatement(context);
        }

        private void parameterizedAudit(@NotNull ParameterizedStatementData data, @NotNull SmartStatementMark mark2) {
            if (data == null) {
                EngineAuditService.$$$reportNull$$$0(11);
            }
            if (mark2 == null) {
                EngineAuditService.$$$reportNull$$$0(12);
            }
            if (this.isSystemQuery(mark2)) {
                return;
            }
            DataRequest.Context context = JdbcEngine.this.getRequestContext();
            int[] offsets = Objects.requireNonNull(data.getBasis().getOffsets());
            List infos = ContainerUtil.map(data.getDecoration().getInParameters(), CallableStatementData.InParameter::getData);
            String sql = data.getBasis().getSql();
            context.statementContext.push(new PreparedStatementContext(new RowQueryData(infos, offsets, sql), JdbcEngine.this.myDbms));
            JdbcEngine.this.getDataAuditor().beforeStatement(context);
        }

        @Override
        public void message(@NotNull String message2) {
            DataRequest.Context context;
            if (message2 == null) {
                EngineAuditService.$$$reportNull$$$0(13);
            }
            if ((context = JdbcEngine.this.getRequestContextIfAny()) != null) {
                JdbcEngine.this.getDataAuditor().print(context, message2);
            }
        }

        @Override
        public void updateCount(int count2, @NotNull SmartStatementMark mark2) {
            if (mark2 == null) {
                EngineAuditService.$$$reportNull$$$0(14);
            }
            if (this.isSystemQuery(mark2)) {
                return;
            }
            JdbcEngine.this.getDataAuditor().updateCountReceived(JdbcEngine.this.getRequestContext(), count2);
        }

        @Override
        public void error(@NotNull String message2, @NotNull SmartStatementMark mark2) {
            if (message2 == null) {
                EngineAuditService.$$$reportNull$$$0(15);
            }
            if (mark2 == null) {
                EngineAuditService.$$$reportNull$$$0(16);
            }
            if (this.isSystemQuery(mark2)) {
                return;
            }
            JdbcEngine.this.getDataAuditor().error(JdbcEngine.this.getRequestContext(), message2, null);
        }

        @Override
        public void warning(@NotNull String message2, @NotNull SmartStatementMark mark2) {
            if (message2 == null) {
                EngineAuditService.$$$reportNull$$$0(17);
            }
            if (mark2 == null) {
                EngineAuditService.$$$reportNull$$$0(18);
            }
            if (this.isSystemQuery(mark2)) {
                return;
            }
            JdbcEngine.this.getDataAuditor().warn(JdbcEngine.this.getRequestContext(), message2);
        }

        @Override
        public void message(@NotNull String message2, @NotNull SmartStatementMark mark2) {
            if (message2 == null) {
                EngineAuditService.$$$reportNull$$$0(19);
            }
            if (mark2 == null) {
                EngineAuditService.$$$reportNull$$$0(20);
            }
            if (this.isSystemQuery(mark2)) {
                return;
            }
            JdbcEngine.this.getDataAuditor().print(JdbcEngine.this.getRequestContext(), message2);
        }

        @Override
        public void resultsProcessed(@NotNull SmartStatementMark mark2) {
            if (mark2 == null) {
                EngineAuditService.$$$reportNull$$$0(21);
            }
            if (this.isSystemQuery(mark2)) {
                return;
            }
            JdbcEngine.this.myConnectionWatcher.restart();
            DataRequest.Context context = JdbcEngine.this.getRequestContext();
            try {
                JdbcEngine.this.getDataAuditor().afterStatement(context);
            }
            finally {
                context.statementContext.pollFirst();
                JdbcEngine.this.removeStatement(mark2);
            }
        }

        private boolean isSystemQuery(@NotNull SmartStatementMark mark2) {
            if (mark2 == null) {
                EngineAuditService.$$$reportNull$$$0(22);
            }
            return JdbcEngine.this.mySystemQuery || mark2.getSource() == SmartStatements.Source.SYSTEM || SessionsUtil.isInternalDepartment(mark2.getDepartment());
        }

        @Override
        public void connected() {
        }

        @Override
        public void disconnected() {
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "message";
                    break;
                }
                case 2: 
                case 4: 
                case 6: 
                case 8: 
                case 10: 
                case 12: 
                case 14: 
                case 16: 
                case 18: 
                case 20: 
                case 21: 
                case 22: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "mark";
                    break;
                }
                case 3: 
                case 5: 
                case 11: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "data";
                    break;
                }
                case 7: 
                case 9: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "sql";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/database/console/JdbcEngine$EngineAuditService";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "error";
                    break;
                }
                case 1: 
                case 17: 
                case 18: {
                    objectArray = objectArray2;
                    objectArray2[2] = "warning";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "afterStatement";
                    break;
                }
                case 3: 
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[2] = "beforeCallableStatement";
                    break;
                }
                case 5: 
                case 6: {
                    objectArray = objectArray2;
                    objectArray2[2] = "beforeParameterizedStatement";
                    break;
                }
                case 7: 
                case 8: {
                    objectArray = objectArray2;
                    objectArray2[2] = "beforeSimpleStatement";
                    break;
                }
                case 9: 
                case 10: {
                    objectArray = objectArray2;
                    objectArray2[2] = "plainAudit";
                    break;
                }
                case 11: 
                case 12: {
                    objectArray = objectArray2;
                    objectArray2[2] = "parameterizedAudit";
                    break;
                }
                case 13: 
                case 19: 
                case 20: {
                    objectArray = objectArray2;
                    objectArray2[2] = "message";
                    break;
                }
                case 14: {
                    objectArray = objectArray2;
                    objectArray2[2] = "updateCount";
                    break;
                }
                case 21: {
                    objectArray = objectArray2;
                    objectArray2[2] = "resultsProcessed";
                    break;
                }
                case 22: {
                    objectArray = objectArray2;
                    objectArray2[2] = "isSystemQuery";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static interface AtomicOperation {
        public boolean shouldRequestSearchPath();

        public boolean perform(@NotNull DatabaseConnection var1, boolean var2) throws Exception;
    }

    private static interface Operation {
        public boolean perform(@NotNull DatabaseConnection var1) throws Exception;
    }

    private static class ParameterizedExecutor
    implements Executor {
        private final RowQueryData myData;

        ParameterizedExecutor(@NotNull RowQueryData data) {
            if (data == null) {
                ParameterizedExecutor.$$$reportNull$$$0(0);
            }
            this.myData = data;
        }

        @Override
        public void execute(@NotNull DatabaseConnection connection2, @NotNull Configuration configuration, @NotNull Consumer<ResultsProducer> consumer2) throws Exception {
            if (connection2 == null) {
                ParameterizedExecutor.$$$reportNull$$$0(1);
            }
            if (configuration == null) {
                ParameterizedExecutor.$$$reportNull$$$0(2);
            }
            if (consumer2 == null) {
                ParameterizedExecutor.$$$reportNull$$$0(3);
            }
            SmartStatements.poweredBy(connection2).parameterized(configuration).noisy().execute(this.myData.asParameterizedStatementData(), (ExecutionMode)StandardExecutionMode.QUERY, SmartStatementsUtil.consumer(consumer2));
        }

        @Override
        @NotNull
        public String getStatement() {
            String string = this.myData.getSql();
            if (string == null) {
                ParameterizedExecutor.$$$reportNull$$$0(4);
            }
            return string;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 4: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 4: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "data";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "connection";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "configuration";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "consumer";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/database/console/JdbcEngine$ParameterizedExecutor";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/database/console/JdbcEngine$ParameterizedExecutor";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getStatement";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "execute";
                    break;
                }
                case 4: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 4: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    private static class RegularExecutor
    implements Executor {
        private final DataRequest.QueryRequest myRequest;

        RegularExecutor(@NotNull DataRequest.QueryRequest request) {
            if (request == null) {
                RegularExecutor.$$$reportNull$$$0(0);
            }
            this.myRequest = request;
        }

        @Override
        public void execute(@NotNull DatabaseConnection connection2, @NotNull Configuration configuration, @NotNull Consumer<ResultsProducer> consumer2) throws SQLException {
            if (connection2 == null) {
                RegularExecutor.$$$reportNull$$$0(1);
            }
            if (configuration == null) {
                RegularExecutor.$$$reportNull$$$0(2);
            }
            if (consumer2 == null) {
                RegularExecutor.$$$reportNull$$$0(3);
            }
            boolean asQuery = this.myRequest instanceof ConsoleDataRequest && ((ConsoleDataRequest)this.myRequest).resultType instanceof SqlTableType;
            SmartStatements.poweredBy(connection2).simple(configuration.scrollable(RegularExecutor.isScrollable(this.myRequest.constraints))).noisy().execute(this.myRequest.query, (ExecutionMode)(asQuery ? StandardExecutionMode.QUERY : StandardExecutionMode.GENERIC), SmartStatementsUtil.consumer(consumer2));
        }

        @Override
        @NotNull
        public String getStatement() {
            String string = this.myRequest.query;
            if (string == null) {
                RegularExecutor.$$$reportNull$$$0(4);
            }
            return string;
        }

        private static boolean isScrollable(@NotNull DataRequest.Constraints constraints) {
            if (constraints == null) {
                RegularExecutor.$$$reportNull$$$0(5);
            }
            return constraints.absolutePosition != 0;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 4: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 4: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "request";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "connection";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "configuration";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "consumer";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/database/console/JdbcEngine$RegularExecutor";
                    break;
                }
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "constraints";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/database/console/JdbcEngine$RegularExecutor";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getStatement";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "execute";
                    break;
                }
                case 4: {
                    break;
                }
                case 5: {
                    objectArray = objectArray;
                    objectArray[2] = "isScrollable";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 4: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    private static class CallExecutor
    extends SimpleExecutor {
        private final List<CallableStatementData.SimpleOutParameter<?>> myOutParameters;
        private final TIntObjectHashMap<?> myInParameters;

        CallExecutor(@NotNull String statement, @NotNull List<CallableStatementData.SimpleOutParameter<?>> outParameters, @NotNull TIntObjectHashMap<?> inParameters) {
            if (statement == null) {
                CallExecutor.$$$reportNull$$$0(0);
            }
            if (outParameters == null) {
                CallExecutor.$$$reportNull$$$0(1);
            }
            if (inParameters == null) {
                CallExecutor.$$$reportNull$$$0(2);
            }
            super(statement);
            this.myOutParameters = outParameters;
            this.myInParameters = inParameters;
        }

        @Override
        public void execute(@NotNull DatabaseConnection connection2, @NotNull Configuration configuration, @NotNull Consumer<ResultsProducer> consumer2) throws Exception {
            if (connection2 == null) {
                CallExecutor.$$$reportNull$$$0(3);
            }
            if (configuration == null) {
                CallExecutor.$$$reportNull$$$0(4);
            }
            if (consumer2 == null) {
                CallExecutor.$$$reportNull$$$0(5);
            }
            StatementParameters parameters = new StatementParameters();
            for (CallableStatementData.SimpleOutParameter<?> outParameter : this.myOutParameters) {
                parameters = parameters.parameter(outParameter);
            }
            for (Object position : (Object)this.myInParameters.keys()) {
                Object parameter = this.myInParameters.get((int)position);
                parameters = parameters.obj((int)position, parameter);
            }
            if (this.myOutParameters.isEmpty()) {
                SmartStatements.poweredBy(connection2).parameterized(configuration).noisy().execute(parameters.asCallData(this.myStatement), SmartStatementsUtil.consumer(consumer2));
            } else {
                SmartStatements.poweredBy(connection2).call(configuration).noisy().execute(parameters.asCallData(this.myStatement), SmartStatementsUtil.consumer(consumer2));
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "statement";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "outParameters";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "inParameters";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "connection";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "configuration";
                    break;
                }
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "consumer";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/database/console/JdbcEngine$CallExecutor";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 3: 
                case 4: 
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[2] = "execute";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static class SimpleExecutor
    implements Executor {
        protected final String myStatement;

        SimpleExecutor(@NotNull String statement) {
            if (statement == null) {
                SimpleExecutor.$$$reportNull$$$0(0);
            }
            this.myStatement = statement;
        }

        @Override
        public void execute(@NotNull DatabaseConnection connection2, @NotNull Configuration configuration, @NotNull Consumer<ResultsProducer> consumer2) throws Exception {
            if (connection2 == null) {
                SimpleExecutor.$$$reportNull$$$0(1);
            }
            if (configuration == null) {
                SimpleExecutor.$$$reportNull$$$0(2);
            }
            if (consumer2 == null) {
                SimpleExecutor.$$$reportNull$$$0(3);
            }
            SmartStatements.poweredBy(connection2).simple(configuration).noisy().execute(this.myStatement, SmartStatementsUtil.consumer(consumer2));
        }

        @Override
        @NotNull
        public String getStatement() {
            String string = this.myStatement;
            if (string == null) {
                SimpleExecutor.$$$reportNull$$$0(4);
            }
            return string;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 4: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 4: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "statement";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "connection";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "configuration";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "consumer";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/database/console/JdbcEngine$SimpleExecutor";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/database/console/JdbcEngine$SimpleExecutor";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getStatement";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "execute";
                    break;
                }
                case 4: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 4: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    private static interface Executor {
        public void execute(@NotNull DatabaseConnection var1, @NotNull Configuration var2, @NotNull Consumer<ResultsProducer> var3) throws Exception;

        @NotNull
        public String getStatement();
    }

    private static class MyContext
    extends DataRequest.TxContext {
        private final JdbcEngine myEngine;
        final SearchPath startPath;
        final boolean startedTransaction;

        MyContext(@NotNull JdbcEngine engine, @NotNull DataRequest request, SearchPath startPath, boolean startedTransaction) {
            if (engine == null) {
                MyContext.$$$reportNull$$$0(0);
            }
            if (request == null) {
                MyContext.$$$reportNull$$$0(1);
            }
            super(engine, request, engine.myTxMarker);
            this.myEngine = engine;
            this.startPath = startPath;
            this.startedTransaction = startedTransaction;
        }

        @Override
        public void reportException(@NotNull Throwable th, Object parameter) {
            if (th == null) {
                MyContext.$$$reportNull$$$0(2);
            }
            LocalDataSource dataSource2 = this.myEngine.getDataSource();
            if (th instanceof ProcessCanceledException) {
                return;
            }
            String message2 = JdbcEngine.getErrorMessage(th, dataSource2);
            this.myEngine.getDataAuditor().error(this, message2, th instanceof EngineWarningException ? th : null);
        }

        @Override
        @Nullable
        public SearchPath getSearchPath() {
            return this.myEngine.getSearchPath();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "engine";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "request";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "th";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/database/console/JdbcEngine$MyContext";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "reportException";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    public static class UnsafeUpdateRolledBackException
    extends Exception {
        UnsafeUpdateRolledBackException(String message2) {
            super(message2);
        }
    }

    private static class LastPageHandler
    implements DataConsumer {
        private final DataConsumer delegate;
        private int resultSetIndex;
        private DataConsumer.Column[] columnInfos;
        private final RowsCyclicBuffer myBuffer;

        LastPageHandler(DataConsumer handler, int absolutePosition, int size) {
            this.delegate = handler;
            this.myBuffer = new RowsCyclicBuffer(Math.max(size, -absolutePosition - 1));
        }

        @Override
        public void setColumns(@NotNull DataRequest.Context context, int resultSetIndex, DataConsumer.Column[] columns, int firstRowNum) {
            if (context == null) {
                LastPageHandler.$$$reportNull$$$0(0);
            }
            this.resultSetIndex = resultSetIndex;
            this.columnInfos = columns;
        }

        @Override
        public void updateColumns(@NotNull DataRequest.Context context, @NotNull DataConsumer.Column[] columns) {
            if (context == null) {
                LastPageHandler.$$$reportNull$$$0(1);
            }
            if (columns == null) {
                LastPageHandler.$$$reportNull$$$0(2);
            }
            this.columnInfos = columns;
        }

        @Override
        public void addRows(@NotNull DataRequest.Context context, List<DataConsumer.Row> rows) {
            if (context == null) {
                LastPageHandler.$$$reportNull$$$0(3);
            }
            this.myBuffer.addRows(rows);
        }

        @Override
        public void afterLastRowAdded(@NotNull DataRequest.Context context, int total) {
            List<DataConsumer.Row> rows;
            if (context == null) {
                LastPageHandler.$$$reportNull$$$0(4);
            }
            if ((rows = this.myBuffer.getRows()).isEmpty()) {
                this.delegate.setColumns(context, this.resultSetIndex, this.columnInfos, 0);
                this.delegate.afterLastRowAdded(context, 0);
                return;
            }
            this.delegate.setColumns(context, this.resultSetIndex, this.columnInfos, rows.get((int)0).rowNum);
            this.delegate.addRows(context, rows);
            this.delegate.afterLastRowAdded(context, total);
        }

        public int getRowCount() {
            return this.myBuffer.getRows().size();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "context";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "columns";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/database/console/JdbcEngine$LastPageHandler";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "setColumns";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "updateColumns";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[2] = "addRows";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[2] = "afterLastRowAdded";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }

        private static class RowsCyclicBuffer {
            private final DataConsumer.Row[] myBuffer;
            private int myFirstIdx = 0;
            private int myLastIdx = -1;

            RowsCyclicBuffer(int bufferSize) {
                this.myBuffer = new DataConsumer.Row[bufferSize];
            }

            public void addRows(@NotNull Iterable<DataConsumer.Row> rows) {
                if (rows == null) {
                    RowsCyclicBuffer.$$$reportNull$$$0(0);
                }
                for (DataConsumer.Row row : rows) {
                    if (this.myLastIdx != -1 && this.nextIdx(this.myLastIdx) == this.myFirstIdx) {
                        this.myFirstIdx = this.nextIdx(this.myFirstIdx);
                    }
                    this.myLastIdx = this.nextIdx(this.myLastIdx);
                    this.myBuffer[this.myLastIdx] = row;
                }
            }

            @NotNull
            public List<DataConsumer.Row> getRows() {
                if (this.myLastIdx == -1) {
                    List list = ContainerUtil.emptyList();
                    if (list == null) {
                        RowsCyclicBuffer.$$$reportNull$$$0(1);
                    }
                    return list;
                }
                if (this.myFirstIdx == 0) {
                    List list = ContainerUtil.newArrayList((Object[])this.myBuffer, (int)0, (int)(this.myLastIdx + 1));
                    if (list == null) {
                        RowsCyclicBuffer.$$$reportNull$$$0(2);
                    }
                    return list;
                }
                ArrayList<DataConsumer.Row> rows = new ArrayList<DataConsumer.Row>(this.myBuffer.length);
                ImmutableList bufferAsList = ContainerUtil.immutableList((Object[])this.myBuffer);
                rows.addAll(bufferAsList.subList(this.myFirstIdx, this.myBuffer.length));
                rows.addAll(bufferAsList.subList(0, this.myLastIdx + 1));
                ArrayList<DataConsumer.Row> arrayList = rows;
                if (arrayList == null) {
                    RowsCyclicBuffer.$$$reportNull$$$0(3);
                }
                return arrayList;
            }

            private int nextIdx(int idx) {
                return (idx + 1) % this.myBuffer.length;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                RuntimeException runtimeException;
                Object[] objectArray;
                Object[] objectArray2;
                int n2;
                String string;
                switch (n) {
                    default: {
                        string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                        break;
                    }
                    case 1: 
                    case 2: 
                    case 3: {
                        string = "@NotNull method %s.%s must not return null";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        n2 = 3;
                        break;
                    }
                    case 1: 
                    case 2: 
                    case 3: {
                        n2 = 2;
                        break;
                    }
                }
                Object[] objectArray3 = new Object[n2];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "rows";
                        break;
                    }
                    case 1: 
                    case 2: 
                    case 3: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "com/intellij/database/console/JdbcEngine$LastPageHandler$RowsCyclicBuffer";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "com/intellij/database/console/JdbcEngine$LastPageHandler$RowsCyclicBuffer";
                        break;
                    }
                    case 1: 
                    case 2: 
                    case 3: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getRows";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray;
                        objectArray[2] = "addRows";
                        break;
                    }
                    case 1: 
                    case 2: 
                    case 3: {
                        break;
                    }
                }
                String string2 = String.format(string, objectArray);
                switch (n) {
                    default: {
                        runtimeException = new IllegalArgumentException(string2);
                        break;
                    }
                    case 1: 
                    case 2: 
                    case 3: {
                        runtimeException = new IllegalStateException(string2);
                        break;
                    }
                }
                throw runtimeException;
            }
        }
    }
}

