/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.console;

import com.intellij.database.DatabaseBundle;
import com.intellij.database.Dbms;
import com.intellij.database.dataSource.DataSourceStorage;
import com.intellij.database.dataSource.LocalDataSource;
import com.intellij.database.dialects.DatabaseDialectEx;
import com.intellij.database.dialects.DatabaseDialects;
import com.intellij.database.model.DasDataSource;
import com.intellij.database.model.DasObject;
import com.intellij.database.model.ObjectKind;
import com.intellij.database.model.basic.BasicModel;
import com.intellij.database.model.basic.BasicNamespace;
import com.intellij.database.model.meta.BasicMetaObject;
import com.intellij.database.script.ScriptModel;
import com.intellij.database.util.DbImplUtil;
import com.intellij.database.util.ObjectPath;
import com.intellij.database.util.ObjectPaths;
import com.intellij.database.util.QNameUtil;
import com.intellij.database.view.ui.DbSchemasSelector;
import com.intellij.database.view.ui.DbSchemasTree;
import com.intellij.database.view.ui.FilteringTree;
import com.intellij.icons.AllIcons;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.ToggleAction;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.PersistentStateComponent;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.components.State;
import com.intellij.openapi.components.Storage;
import com.intellij.openapi.progress.EmptyProgressIndicator;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.sql.psi.SqlPsiFacade;
import com.intellij.sql.psi.SqlUseDatabaseStatement;
import com.intellij.ui.CheckedTreeNode;
import com.intellij.ui.SeparatorFactory;
import com.intellij.ui.components.JBLabel;
import com.intellij.ui.treeStructure.Tree;
import com.intellij.util.Alarm;
import com.intellij.util.AlarmFactory;
import com.intellij.util.Consumer;
import com.intellij.util.Function;
import com.intellij.util.ObjectUtils;
import com.intellij.util.ThreeState;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.JBIterable;
import com.intellij.util.containers.JBTreeTraverser;
import com.intellij.util.containers.MultiMap;
import com.intellij.util.containers.TreeTraversal;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.UIUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.tree.TreePath;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ExecutionTargetDialog
extends DialogWrapper {
    private final Project myProject;
    private final ExecutionTargetEditor myEditor;
    private final JLabel myStateLabel;
    private final JLabel myWarningLabel;
    private final Alarm myUpdateAlarm;
    private final Consumer<List<Pair<LocalDataSource, ObjectPath>>> myConsumer;
    private ThreeState myHaveSchemaSwitches;

    public ExecutionTargetDialog(@NotNull Project project, @NotNull Function<Boolean, Iterable<LocalDataSource>> dsProvider, @NotNull Consumer<List<Pair<LocalDataSource, ObjectPath>>> consumer2) {
        if (project == null) {
            ExecutionTargetDialog.$$$reportNull$$$0(0);
        }
        if (dsProvider == null) {
            ExecutionTargetDialog.$$$reportNull$$$0(1);
        }
        if (consumer2 == null) {
            ExecutionTargetDialog.$$$reportNull$$$0(2);
        }
        super(project);
        this.myUpdateAlarm = AlarmFactory.getInstance().create();
        this.myHaveSchemaSwitches = ThreeState.NO;
        this.myConsumer = consumer2;
        this.setTitle(DatabaseBundle.message((String)"ExecutionTargetDialog.title", (Object[])new Object[0]));
        this.myProject = project;
        this.myStateLabel = new JBLabel();
        this.myWarningLabel = new JBLabel();
        this.myEditor = new ExecutionTargetEditor(project, dsProvider);
        this.myEditor.getSelectionModel().addNodeListener(new FilteringTree.SearchTreeModel.Listener<DbSchemasTree.MyNode>(){

            @Override
            public void beforeNodeChanged(DbSchemasTree.MyNode x) {
            }

            @Override
            public void nodeChanged(DbSchemasTree.MyNode x) {
                ExecutionTargetDialog.this.myUpdateAlarm.cancelAllRequests();
                ExecutionTargetDialog.this.myUpdateAlarm.addRequest(() -> ExecutionTargetDialog.this.updateLabels(), 0);
            }
        });
        this.loadState();
        this.init();
        this.updateLabels();
    }

    private DialogState getStateService() {
        return (DialogState)ServiceManager.getService((Project)this.myEditor.getProject(), DialogState.class);
    }

    @Nullable
    protected String getDimensionServiceKey() {
        return "ExecutionTargetDialog";
    }

    @Nullable
    public JComponent getPreferredFocusedComponent() {
        return this.myEditor.getTree();
    }

    protected void doOKAction() {
        ArrayList<Pair> targets2 = new ArrayList<Pair>();
        for (Pair<String, ObjectPath> target : this.myEditor.getTargets()) {
            DataSourceStorage storage = DataSourceStorage.getProjectStorage(this.myProject);
            LocalDataSource ds = storage.getDataSourceById((String)target.first);
            if (ds == null) continue;
            targets2.add(Pair.create((Object)ds, (Object)target.second));
        }
        if (!targets2.isEmpty()) {
            this.myConsumer.consume(targets2);
        }
        this.saveState();
        super.doOKAction();
    }

    public void doCancelAction() {
        this.saveState();
        super.doCancelAction();
    }

    public void saveState() {
        Element root2 = new Element("ExecutionTargetDialog");
        if (!this.myEditor.myFiltered) {
            root2.setAttribute("filtered", "false");
        }
        this.myEditor.saveState(root2);
        this.getStateService().element = root2;
    }

    public void loadState() {
        Element state = this.getStateService().element;
        if (state == null) {
            return;
        }
        this.myEditor.setFiltered(!"false".equals(state.getAttributeValue("filtered")));
        this.myEditor.loadState(state);
    }

    @Nullable
    protected JComponent createCenterPanel() {
        JPanel panel2 = new JPanel(new BorderLayout());
        panel2.add((Component)this.myEditor.getComponent(), "Center");
        JPanel southPanel = new JPanel(new BorderLayout());
        southPanel.add((Component)SeparatorFactory.createSeparator((String)DatabaseBundle.message((String)"ExecutionTargetDialog.target.separator", (Object[])new Object[0]), (JComponent)this.myStateLabel), "North");
        southPanel.add((Component)this.myStateLabel, "Center");
        JPanel warningPanel = (JPanel)JBUI.Borders.emptyTop((int)4).wrap((JComponent)JBUI.Panels.simplePanel((Component)this.myWarningLabel));
        southPanel.add((Component)warningPanel, "South");
        panel2.add((Component)southPanel, "South");
        panel2.setMinimumSize(new Dimension(300, 300));
        return panel2;
    }

    private void updateLabels() {
        StringBuilder builder = new StringBuilder();
        builder.append("<html>");
        JBTreeTraverser checked = JBTreeTraverser.from(n -> n.getChildNodes().filter(x -> x.isChecked()));
        JBIterable dataSources2 = this.myEditor.getSelectionModel().getRootObject().getChildNodes().filter(n -> n.isChecked());
        if (!dataSources2.isEmpty()) {
            for (DbSchemasTree.MyNode ds : dataSources2) {
                String name = ds.getName();
                builder.append("<b>").append(name == null ? null : StringUtil.escapeXmlEntities((String)name)).append(":</b> ");
                int offs = builder.length();
                DasDataSource dataSource2 = (DasDataSource)ObjectUtils.tryCast((Object)ds.getObject(), DasDataSource.class);
                ObjectKind kind = dataSource2 == null ? null : DbImplUtil.getDatabaseDialect(dataSource2.getDbms()).getSearchPathObjectKind();
                for (DbSchemasTree.MyNode leaf : ((JBTreeTraverser)checked.withRoot((Object)ds)).traverse(TreeTraversal.LEAVES_DFS)) {
                    Object obj;
                    if (offs != builder.length()) {
                        builder.append(", ");
                    }
                    if ((obj = leaf.getObject()) instanceof DasDataSource) {
                        builder.append("&lt;Default&gt;");
                        continue;
                    }
                    if (obj instanceof DasObject) {
                        DasObject o = (DasObject)obj;
                        builder.append(QNameUtil.getQualifiedName(o));
                        if (o.getKind() == kind) continue;
                        builder.append(".&lt;Default&gt;");
                        continue;
                    }
                    String leafName = leaf.getName();
                    builder.append(leafName == null ? null : StringUtil.escapeXmlEntities((String)leafName));
                }
                builder.append("<br>");
            }
            this.getOKAction().setEnabled(true);
        } else {
            builder.append("No target selected<br>");
            this.getOKAction().setEnabled(false);
        }
        if (this.myHaveSchemaSwitches != ThreeState.NO) {
            boolean pending = this.myHaveSchemaSwitches == ThreeState.UNSURE;
            this.myWarningLabel.setText("<html>" + (pending ? DatabaseBundle.message((String)"ExecutionTargetDialog.switch.check.pending", (Object[])new Object[0]) : DatabaseBundle.message((String)"ExecutionTargetDialog.switch.check.found", (Object[])new Object[0])) + "</html>");
            this.myWarningLabel.setIcon(pending ? AllIcons.General.BalloonInformation : AllIcons.General.BalloonWarning);
            this.myWarningLabel.setVisible(true);
        } else {
            this.myWarningLabel.setVisible(false);
        }
        builder.append("</html>");
        this.myStateLabel.setText(builder.toString());
    }

    public void setSchemaSwitchWarning(@NotNull ThreeState state) {
        if (state == null) {
            ExecutionTargetDialog.$$$reportNull$$$0(3);
        }
        this.myHaveSchemaSwitches = state;
        this.updateLabels();
    }

    public void checkFilesForSchemaSwitches(JBIterable<VirtualFile> files) {
        EmptyProgressIndicator indicator = new EmptyProgressIndicator();
        this.setSchemaSwitchWarning(ThreeState.UNSURE);
        Application application = ApplicationManager.getApplication();
        Disposer.register((Disposable)this.getDisposable(), () -> indicator.cancel());
        application.executeOnPooledThread(() -> ProgressManager.getInstance().runProcess(() -> {
            ThreeState haveSchemaSwitches = ThreeState.UNSURE;
            try {
                haveSchemaSwitches = ExecutionTargetDialog.haveSchemaSwitches(this.myProject, files, (ProgressIndicator)indicator);
            }
            finally {
                if (!indicator.isCanceled()) {
                    ThreeState finalHaveSchemaSwitches = haveSchemaSwitches;
                    UIUtil.invokeLaterIfNeeded(() -> {
                        if (!indicator.isCanceled()) {
                            this.setSchemaSwitchWarning(finalHaveSchemaSwitches);
                        }
                    });
                }
            }
        }, (ProgressIndicator)indicator));
    }

    private static ThreeState haveSchemaSwitches(@NotNull Project project, @NotNull JBIterable<VirtualFile> files, @NotNull ProgressIndicator indicator) {
        if (project == null) {
            ExecutionTargetDialog.$$$reportNull$$$0(4);
        }
        if (files == null) {
            ExecutionTargetDialog.$$$reportNull$$$0(5);
        }
        if (indicator == null) {
            ExecutionTargetDialog.$$$reportNull$$$0(6);
        }
        SqlPsiFacade facade = SqlPsiFacade.getInstance((Project)project);
        PsiManager psiManager = PsiManager.getInstance((Project)project);
        Ref result = Ref.create((Object)ThreeState.UNSURE);
        ProgressManager.getInstance().runInReadActionWithWriteActionPriority(() -> {
            for (VirtualFile vfile : files) {
                PsiFile file = psiManager.findFile(vfile);
                if (file == null) continue;
                ScriptModel model = facade.createScriptModel(file);
                try {
                    for (ScriptModel.StatementIt it2 : model.statements()) {
                        if (!(it2.object() instanceof SqlUseDatabaseStatement)) continue;
                        result.set((Object)ThreeState.YES);
                        return;
                    }
                }
                finally {
                    Disposer.dispose((Disposable)model);
                }
            }
            result.set((Object)ThreeState.NO);
        }, indicator);
        return (ThreeState)result.get();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dsProvider";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "consumer";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "state";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "files";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "indicator";
                break;
            }
        }
        objectArray2[1] = "com/intellij/database/console/ExecutionTargetDialog";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "setSchemaSwitchWarning";
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "haveSchemaSwitches";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    public static class ExecutionTargetEditor
    extends DbSchemasSelector {
        private final Function<Boolean, Iterable<LocalDataSource>> myDsSupplier;
        private boolean myFiltered;

        public ExecutionTargetEditor(@NotNull Project project, @NotNull Function<Boolean, Iterable<LocalDataSource>> dsSupplier) {
            if (project == null) {
                ExecutionTargetEditor.$$$reportNull$$$0(0);
            }
            if (dsSupplier == null) {
                ExecutionTargetEditor.$$$reportNull$$$0(1);
            }
            super(project);
            this.myFiltered = true;
            this.myDsSupplier = dsSupplier;
        }

        @NotNull
        public FilteringTree.SearchTreeModel<CheckedTreeNode, DbSchemasTree.MyNode> getSelectionModel() {
            FilteringTree.SearchTreeModel<CheckedTreeNode, DbSchemasTree.MyNode> searchTreeModel = this.myTree.getSearchModel();
            if (searchTreeModel == null) {
                ExecutionTargetEditor.$$$reportNull$$$0(2);
            }
            return searchTreeModel;
        }

        @Override
        @NotNull
        protected DefaultActionGroup getTreeActions() {
            DefaultActionGroup res = super.getTreeActions();
            res.add((AnAction)new ToggleAction(DatabaseBundle.message((String)"ExecutionTargetDialog.filter.text", (Object[])new Object[0]), DatabaseBundle.message((String)"ExecutionTargetDialog.filter.description", (Object[])new Object[0]), AllIcons.General.Filter){

                public boolean isSelected(@NotNull AnActionEvent e) {
                    if (e == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    return myFiltered;
                }

                public void setSelected(@NotNull AnActionEvent e, boolean state) {
                    if (e == null) {
                        1.$$$reportNull$$$0(1);
                    }
                    this.setFiltered(state);
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    Object[] objectArray;
                    Object[] objectArray2 = new Object[3];
                    objectArray2[0] = "e";
                    objectArray2[1] = "com/intellij/database/console/ExecutionTargetDialog$ExecutionTargetEditor$1";
                    switch (n) {
                        default: {
                            objectArray = objectArray2;
                            objectArray2[2] = "isSelected";
                            break;
                        }
                        case 1: {
                            objectArray = objectArray2;
                            objectArray2[2] = "setSelected";
                            break;
                        }
                    }
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
                }
            });
            DefaultActionGroup defaultActionGroup = res;
            if (defaultActionGroup == null) {
                ExecutionTargetEditor.$$$reportNull$$$0(3);
            }
            return defaultActionGroup;
        }

        @Override
        @NotNull
        protected DbSchemasSelector.TreeEditor createTree(@NotNull Project project) {
            if (project == null) {
                ExecutionTargetEditor.$$$reportNull$$$0(4);
            }
            DbSchemasTree.MyNode r = new DbSchemasTree.MyNode(null, null, null){

                @Override
                @NotNull
                public JBIterable<BasicMetaObject<?>> getWildcardMetas() {
                    JBIterable jBIterable = JBIterable.of(DbImplUtil.getMetaModel((Dbms)Dbms.UNKNOWN).root);
                    if (jBIterable == null) {
                        2.$$$reportNull$$$0(0);
                    }
                    return jBIterable;
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/console/ExecutionTargetDialog$ExecutionTargetEditor$2", "getWildcardMetas"));
                }
            };
            CheckedTreeNode node = DbSchemasTree.createNode(r);
            return new DbSchemasSelector.TreeEditor(project, (Tree)new DbSchemasTree(node), node){

                @Override
                protected boolean shouldExpand(BasicNamespace object) {
                    DatabaseDialectEx dialect;
                    BasicModel model = object.getModel();
                    DatabaseDialectEx databaseDialectEx = dialect = model == null ? null : DbImplUtil.getDatabaseDialect(model.getDbms());
                    if (dialect == null) {
                        dialect = DatabaseDialects.getGenericDialect();
                    }
                    return dialect.getSearchPathObjectKind() != object.getKind() && super.shouldExpand(object);
                }

                @Override
                @NotNull
                protected Iterable<? extends DasDataSource> getDataSources() {
                    Iterable iterable = (Iterable)myDsSupplier.fun((Object)(!myFiltered ? 1 : 0));
                    if (iterable == null) {
                        3.$$$reportNull$$$0(0);
                    }
                    return iterable;
                }

                @Override
                protected void createShadowStructure(@NotNull DbSchemasTree.MyNode root2) {
                    if (root2 == null) {
                        3.$$$reportNull$$$0(1);
                    }
                    this.cleanupUnselected(root2);
                }

                private void cleanupUnselected(@NotNull DbSchemasTree.MyNode p2) {
                    if (p2 == null) {
                        3.$$$reportNull$$$0(2);
                    }
                    List children2 = p2.getShadowChildren();
                    children2.removeIf(n -> !n.isChecked());
                    p2.setShadowChildren(children2);
                    p2.getChildNodes().forEach(n -> this.cleanupUnselected((DbSchemasTree.MyNode)n));
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    RuntimeException runtimeException;
                    Object[] objectArray;
                    Object[] objectArray2;
                    int n2;
                    String string;
                    switch (n) {
                        default: {
                            string = "@NotNull method %s.%s must not return null";
                            break;
                        }
                        case 1: 
                        case 2: {
                            string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                            break;
                        }
                    }
                    switch (n) {
                        default: {
                            n2 = 2;
                            break;
                        }
                        case 1: 
                        case 2: {
                            n2 = 3;
                            break;
                        }
                    }
                    Object[] objectArray3 = new Object[n2];
                    switch (n) {
                        default: {
                            objectArray2 = objectArray3;
                            objectArray3[0] = "com/intellij/database/console/ExecutionTargetDialog$ExecutionTargetEditor$3";
                            break;
                        }
                        case 1: {
                            objectArray2 = objectArray3;
                            objectArray3[0] = "root";
                            break;
                        }
                        case 2: {
                            objectArray2 = objectArray3;
                            objectArray3[0] = "p";
                            break;
                        }
                    }
                    switch (n) {
                        default: {
                            objectArray = objectArray2;
                            objectArray2[1] = "getDataSources";
                            break;
                        }
                        case 1: 
                        case 2: {
                            objectArray = objectArray2;
                            objectArray2[1] = "com/intellij/database/console/ExecutionTargetDialog$ExecutionTargetEditor$3";
                            break;
                        }
                    }
                    switch (n) {
                        default: {
                            break;
                        }
                        case 1: {
                            objectArray = objectArray;
                            objectArray[2] = "createShadowStructure";
                            break;
                        }
                        case 2: {
                            objectArray = objectArray;
                            objectArray[2] = "cleanupUnselected";
                            break;
                        }
                    }
                    String string2 = String.format(string, objectArray);
                    switch (n) {
                        default: {
                            runtimeException = new IllegalStateException(string2);
                            break;
                        }
                        case 1: 
                        case 2: {
                            runtimeException = new IllegalArgumentException(string2);
                            break;
                        }
                    }
                    throw runtimeException;
                }
            };
        }

        public void update() {
            this.myTree.update();
        }

        public void setFiltered(boolean filtered2) {
            if (this.myFiltered == filtered2) {
                return;
            }
            this.myFiltered = filtered2;
            this.myTree.update();
        }

        private void saveState(Element to) {
            this.saveNodes(to, "checked", (Condition<DbSchemasTree.MyNode>)((Condition)n -> n.isChecked()));
            this.saveNodes(to, "expanded", (Condition<DbSchemasTree.MyNode>)((Condition)n -> this.getTree().isExpanded(new TreePath(((CheckedTreeNode)this.myTree.getSearchModel().getNode((DbSchemasTree.MyNode)n)).getPath()))));
        }

        private void loadState(Element from) {
            this.myTree.update();
            this.loadNodes((DbSchemasTree.MyNode)this.myTree.getSearchModel().getRootObject(), from.getChild("checked"), (Consumer<DbSchemasTree.MyNode>)((Consumer)n -> n.setChecked(true)));
            this.loadNodes((DbSchemasTree.MyNode)this.myTree.getSearchModel().getRootObject(), from.getChild("expanded"), (Consumer<DbSchemasTree.MyNode>)((Consumer)n -> this.getTree().expandPath(new TreePath(((CheckedTreeNode)this.myTree.getSearchModel().getNode((DbSchemasTree.MyNode)n)).getPath()))));
        }

        private void saveNodes(Element to, String name, Condition<DbSchemasTree.MyNode> c2) {
            Element tgt = new Element(name);
            for (DbSchemasTree.MyNode node : this.myTree.getSearchModel().getChildren(this.myTree.getSearchModel().getRootObject())) {
                this.saveNodes(tgt, node, c2);
            }
            if (tgt.getContentSize() != 0) {
                to.addContent(tgt);
            }
        }

        private void loadNodes(DbSchemasTree.MyNode to, Element from, Consumer<DbSchemasTree.MyNode> c2) {
            if (from == null) {
                return;
            }
            HashMap<String, Element> map2 = new HashMap<String, Element>();
            for (Element element2 : from.getChildren()) {
                String key = element2.getAttributeValue("key");
                if (key == null) continue;
                map2.put(key, element2);
            }
            for (DbSchemasTree.MyNode node : this.myTree.getSearchModel().getChildren(to)) {
                Element element3 = (Element)map2.get(ExecutionTargetEditor.getKey(node.getObject()));
                if (element3 == null) continue;
                c2.consume((Object)node);
                this.loadNodes(node, element3, c2);
            }
        }

        private void saveNodes(Element to, @NotNull DbSchemasTree.MyNode node, Condition<DbSchemasTree.MyNode> c2) {
            if (node == null) {
                ExecutionTargetEditor.$$$reportNull$$$0(5);
            }
            if (!c2.value((Object)node)) {
                return;
            }
            Object obj = node.getObject();
            String key = ExecutionTargetEditor.getKey(obj);
            if (key == null) {
                return;
            }
            Element cur = new Element("node");
            to.addContent(cur);
            cur.setAttribute("key", key);
            for (DbSchemasTree.MyNode child : this.myTree.getSearchModel().getChildren(node)) {
                this.saveNodes(cur, child, c2);
            }
        }

        private static String getKey(Object obj) {
            String key = null;
            if (obj instanceof DasDataSource) {
                key = ((DasDataSource)obj).getUniqueId();
            } else if (obj instanceof DasObject) {
                key = ((DasObject)obj).getName();
            }
            return key;
        }

        public Project getProject() {
            return this.myTree.getProject();
        }

        public @NotNull List<Pair<String, @Nullable ObjectPath>> getTargets() {
            ArrayList<Pair<String, ObjectPath>> targets2 = new ArrayList<Pair<String, ObjectPath>>();
            JBTreeTraverser checked = JBTreeTraverser.from(n -> n.getChildNodes().filter(x -> x.isChecked()));
            JBIterable dataSources2 = this.getSelectionModel().getRootObject().getChildNodes().filter(n -> n.isChecked());
            if (!dataSources2.isEmpty()) {
                for (DbSchemasTree.MyNode ds : dataSources2) {
                    String dsId;
                    LocalDataSource dataSource2 = (LocalDataSource)ObjectUtils.tryCast((Object)ds.getObject(), LocalDataSource.class);
                    String string = dsId = dataSource2 == null ? (String)ObjectUtils.tryCast((Object)ds.getObject(), String.class) : dataSource2.getUniqueId();
                    if (dsId == null) continue;
                    for (DbSchemasTree.MyNode leaf : ((JBTreeTraverser)checked.withRoot((Object)ds)).traverse(TreeTraversal.LEAVES_DFS)) {
                        Pair pair = Pair.create((Object)dsId, (Object)ExecutionTargetEditor.pathOf(leaf));
                        targets2.add((Pair<String, ObjectPath>)pair);
                    }
                }
            }
            ArrayList<Pair<String, ObjectPath>> arrayList = targets2;
            if (arrayList == null) {
                ExecutionTargetEditor.$$$reportNull$$$0(6);
            }
            return arrayList;
        }

        @Nullable
        private static ObjectPath pathOf(@NotNull DbSchemasTree.MyNode node) {
            DasObject obj;
            if (node == null) {
                ExecutionTargetEditor.$$$reportNull$$$0(7);
            }
            if ((obj = (DasObject)ObjectUtils.tryCast((Object)node.getObject(), DasObject.class)) != null) {
                return ObjectPaths.of(obj);
            }
            DbSchemasTree.MyNode pn = (DbSchemasTree.MyNode)node.getParent();
            ObjectPath parent2 = pn == null || pn.getParent() == null ? null : ExecutionTargetEditor.pathOf(pn);
            ObjectKind kind = node.getKind();
            return kind == null ? null : ObjectPath.create((String)node.getName(), (ObjectKind)kind, (boolean)true, null, (ObjectPath)parent2);
        }

        public void setTargets(List<Pair<String, @Nullable ObjectPath>> targets2) {
            MultiMap grouped = MultiMap.createLinkedSet();
            for (Pair<String, ObjectPath> target : targets2) {
                grouped.putValue(target.first, target.second);
            }
            JBTreeTraverser tr = JBTreeTraverser.from(n -> n.getChildNodes());
            DbSchemasTree.MyNode root2 = this.getSelectionModel().getRootObject();
            for (DbSchemasTree.MyNode ds : root2.getChildNodes()) {
                LocalDataSource dataSource2 = (LocalDataSource)ObjectUtils.tryCast((Object)ds.getObject(), LocalDataSource.class);
                String id = dataSource2 == null ? (String)ObjectUtils.tryCast((Object)ds.getObject(), String.class) : dataSource2.getUniqueId();
                Collection paths = grouped.remove((Object)id);
                ds.setChecked(paths != null);
                if (paths == null) continue;
                JBIterable nodes2 = ((JBTreeTraverser)tr.withRoot((Object)ds)).preOrderDfsTraversal();
                for (DbSchemasTree.MyNode node : nodes2) {
                    if (node == ds) continue;
                    DasObject obj = (DasObject)ObjectUtils.tryCast((Object)node.getObject(), DasObject.class);
                    boolean checked = obj != null && paths.remove(ObjectPaths.of(obj));
                    node.setChecked(checked);
                    if (!checked) continue;
                    for (DbSchemasTree.MyNode n2 = node; n2 != null; n2 = (DbSchemasTree.MyNode)n2.getParent()) {
                        n2.setChecked(true);
                    }
                }
                for (ObjectPath path : paths) {
                    ExecutionTargetEditor.createShadow(ds, path);
                }
            }
            for (Map.Entry entry : grouped.entrySet()) {
                DbSchemasTree.MyNode node = new DbSchemasTree.MyNode((String)entry.getKey(), DbImplUtil.getMetaModel((Dbms)Dbms.UNKNOWN).root, entry.getKey());
                node.setChecked(true);
                for (ObjectPath path : (Collection)entry.getValue()) {
                    ExecutionTargetEditor.createShadow(node, path);
                }
                root2.setShadowChildren(ContainerUtil.append(root2.getShadowChildren(), (Object[])new DbSchemasTree.MyNode[]{node}));
            }
            this.update();
        }

        @NotNull
        private static DbSchemasTree.MyNode createShadow(@NotNull DbSchemasTree.MyNode ds, @Nullable ObjectPath path) {
            DbSchemasTree.MyNode node2;
            if (ds == null) {
                ExecutionTargetEditor.$$$reportNull$$$0(8);
            }
            if (path == null) {
                DbSchemasTree.MyNode myNode = ds;
                if (myNode == null) {
                    ExecutionTargetEditor.$$$reportNull$$$0(9);
                }
                return myNode;
            }
            DbSchemasTree.MyNode parent2 = ExecutionTargetEditor.createShadow(ds, path.parent);
            for (DbSchemasTree.MyNode node2 : parent2.getChildNodes()) {
                if (node2.getKind() != path.kind || !node2.getName().equals(path.name)) continue;
                node2.setChecked(true);
                DbSchemasTree.MyNode myNode = node2;
                if (myNode == null) {
                    ExecutionTargetEditor.$$$reportNull$$$0(10);
                }
                return myNode;
            }
            BasicMetaObject<?> child = parent2.findChild(path.kind);
            node2 = new DbSchemasTree.MyNode(path.name, child, path.name);
            node2.setChecked(true);
            parent2.setShadowChildren(ContainerUtil.append(parent2.getShadowChildren(), (Object[])new DbSchemasTree.MyNode[]{node2}));
            DbSchemasTree.MyNode myNode = node2;
            if (myNode == null) {
                ExecutionTargetEditor.$$$reportNull$$$0(11);
            }
            return myNode;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 2: 
                case 3: 
                case 6: 
                case 9: 
                case 10: 
                case 11: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 2: 
                case 3: 
                case 6: 
                case 9: 
                case 10: 
                case 11: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "dsSupplier";
                    break;
                }
                case 2: 
                case 3: 
                case 6: 
                case 9: 
                case 10: 
                case 11: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/database/console/ExecutionTargetDialog$ExecutionTargetEditor";
                    break;
                }
                case 5: 
                case 7: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "node";
                    break;
                }
                case 8: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "ds";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/database/console/ExecutionTargetDialog$ExecutionTargetEditor";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getSelectionModel";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getTreeActions";
                    break;
                }
                case 6: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getTargets";
                    break;
                }
                case 9: 
                case 10: 
                case 11: {
                    objectArray = objectArray2;
                    objectArray2[1] = "createShadow";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 2: 
                case 3: 
                case 6: 
                case 9: 
                case 10: 
                case 11: {
                    break;
                }
                case 4: {
                    objectArray = objectArray;
                    objectArray[2] = "createTree";
                    break;
                }
                case 5: {
                    objectArray = objectArray;
                    objectArray[2] = "saveNodes";
                    break;
                }
                case 7: {
                    objectArray = objectArray;
                    objectArray[2] = "pathOf";
                    break;
                }
                case 8: {
                    objectArray = objectArray;
                    objectArray[2] = "createShadow";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 2: 
                case 3: 
                case 6: 
                case 9: 
                case 10: 
                case 11: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    @State(name="ExecutionTargetDialog", storages={@Storage(value="$WORKSPACE_FILE$")})
    public static class DialogState
    implements PersistentStateComponent<Element> {
        public volatile Element element;

        @Nullable
        public Element getState() {
            return this.element == null ? null : this.element.clone();
        }

        public void loadState(@NotNull Element state) {
            if (state == null) {
                DialogState.$$$reportNull$$$0(0);
            }
            this.element = state.clone();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "state", "com/intellij/database/console/ExecutionTargetDialog$DialogState", "loadState"));
        }
    }
}

