/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.cli;

import com.intellij.database.cli.CliLexeme;
import com.intellij.database.cli.DbCliUtil;
import com.intellij.util.containers.ContainerUtil;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

public class CliContextDescriptor {
    private final Set<Object> mySet;
    private final List<CliLexeme> myLexemes;
    private final Operation myOperation;
    private final long myNoNamedCount;

    public CliContextDescriptor(@NotNull List<CliLexeme> lexemeList, @NotNull Operation operation) {
        if (lexemeList == null) {
            CliContextDescriptor.$$$reportNull$$$0(0);
        }
        if (operation == null) {
            CliContextDescriptor.$$$reportNull$$$0(1);
        }
        this.mySet = new HashSet<Object>();
        this.myOperation = operation;
        this.myLexemes = ContainerUtil.filter(lexemeList, CliLexeme::isArgument);
        this.myNoNamedCount = lexemeList.stream().filter(CliLexeme::isParameter).count();
    }

    public long getNoNamedCount() {
        return this.myNoNamedCount;
    }

    public boolean contains(@NotNull String[] strings) {
        if (strings == null) {
            CliContextDescriptor.$$$reportNull$$$0(2);
        }
        return ContainerUtil.find(this.myLexemes, DbCliUtil.lexemeFinder(strings)) != null;
    }

    public boolean contains(@NotNull String s) {
        if (s == null) {
            CliContextDescriptor.$$$reportNull$$$0(3);
        }
        return ContainerUtil.find(this.myLexemes, DbCliUtil.lexemeFinder(s)) != null;
    }

    public int getLexemeIndex(@NotNull String[] strings) {
        if (strings == null) {
            CliContextDescriptor.$$$reportNull$$$0(4);
        }
        int idx = Integer.MIN_VALUE;
        for (String string : strings) {
            int current = this.getLexemeIndex(string);
            idx = Math.max(idx, current);
        }
        return Math.max(idx, -1);
    }

    public int getLexemeIndex(@NotNull String s) {
        if (s == null) {
            CliContextDescriptor.$$$reportNull$$$0(5);
        }
        return ContainerUtil.lastIndexOf(this.myLexemes, DbCliUtil.lexemeFinder(s));
    }

    public boolean checkedOut(@NotNull Object object) {
        if (object == null) {
            CliContextDescriptor.$$$reportNull$$$0(6);
        }
        boolean result = this.mySet.contains(object);
        this.mySet.add(object);
        return result;
    }

    public boolean isComponentChanged() {
        return this.myOperation.isComponentChanged();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "lexemeList";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "operation";
                break;
            }
            case 2: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "strings";
                break;
            }
            case 3: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "s";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "object";
                break;
            }
        }
        objectArray2[1] = "com/intellij/database/cli/CliContextDescriptor";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "contains";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "getLexemeIndex";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "checkedOut";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    public static enum Operation {
        UNKNOWN(false),
        COMPONENT_CHANGED(true),
        TEXT_CHANGED(false);

        private final boolean myComponentChanged;

        private Operation(boolean changed) {
            this.myComponentChanged = changed;
        }

        public boolean isComponentChanged() {
            return this.myComponentChanged;
        }
    }
}

