/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.htmltools.codeInspection.htmlInspections;

import com.intellij.codeInspection.InspectionManager;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.codeInspection.htmlInspections.HtmlLocalInspectionTool;
import com.intellij.htmltools.HtmlToolsBundle;
import com.intellij.htmltools.codeInspection.htmlInspections.HtmlLabelsHolder;
import com.intellij.htmltools.codeInspection.htmlInspections.htmlAddLabelToForm.CreateLabelFromTextAction;
import com.intellij.htmltools.codeInspection.htmlInspections.htmlAddLabelToForm.CreateNewLabelAction;
import com.intellij.lang.injection.InjectedLanguageManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.html.HtmlTag;
import com.intellij.psi.impl.source.resolve.reference.impl.providers.IdRefReference;
import com.intellij.psi.xml.XmlAttribute;
import com.intellij.psi.xml.XmlFile;
import com.intellij.psi.xml.XmlTag;
import com.intellij.psi.xml.XmlText;
import com.intellij.psi.xml.XmlToken;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.xml.util.HtmlUtil;
import com.intellij.xml.util.XmlTagUtil;
import java.util.ArrayList;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class HtmlFormInputWithoutLabelInspection
extends HtmlLocalInspectionTool {
    private static final Set<String> ourNonlabelInputTypes = ContainerUtil.set((Object[])new String[]{"hidden", "file", "image", "reset", "submit", "button"});
    private static final Set<String> ourInputElements = ContainerUtil.set((Object[])new String[]{"input", "textarea", "select"});

    @NotNull
    public String getShortName() {
        return "HtmlFormInputWithoutLabel";
    }

    protected void checkTag(@NotNull XmlTag tag, @NotNull ProblemsHolder holder, boolean isOnTheFly) {
        if (tag == null) {
            HtmlFormInputWithoutLabelInspection.$$$reportNull$$$0(0);
        }
        if (holder == null) {
            HtmlFormInputWithoutLabelInspection.$$$reportNull$$$0(1);
        }
        if (!HtmlUtil.isHtmlTagContainingFile((PsiElement)tag)) {
            return;
        }
        String tagName = StringUtil.toLowerCase((String)tag.getName());
        if (ourInputElements.contains(tagName)) {
            PsiFile file;
            String attrValue;
            XmlAttribute type;
            if (tag.getAttribute("aria-label") != null || tag.getAttribute("title") != null) {
                return;
            }
            if ("input".equals(tagName) && (type = tag.getAttribute("type")) != null && (attrValue = type.getValue()) != null) {
                if (tag instanceof HtmlTag) {
                    attrValue = StringUtil.toLowerCase((String)attrValue);
                }
                if (ourNonlabelInputTypes.contains(attrValue)) {
                    return;
                }
            }
            if ((file = tag.getContainingFile()) instanceof XmlFile) {
                PsiElement parent;
                HtmlLabelsHolder labelsHolder = HtmlLabelsHolder.getInstance((XmlFile)file);
                boolean hasLabel = false;
                for (XmlAttribute attribute : tag.getAttributes()) {
                    String id;
                    if (!StringUtil.toLowerCase((String)attribute.getName()).equals("id") && !HtmlFormInputWithoutLabelInspection.isImplicitIdAttribute(attribute) || (id = attribute.getValue()) == null || !labelsHolder.hasForValue(id)) continue;
                    hasLabel = true;
                    break;
                }
                XmlTag child = tag;
                while (!hasLabel && (parent = child.getParent()) != null) {
                    if (parent instanceof XmlTag && "label".equals(StringUtil.toLowerCase((String)((XmlTag)parent).getName()))) {
                        boolean anotherLabel = false;
                        for (PsiElement element : parent.getChildren()) {
                            if (element == child) break;
                            if (!(element instanceof XmlTag) || !"label".equals(StringUtil.toLowerCase((String)((XmlTag)element).getName()))) continue;
                            anotherLabel = true;
                        }
                        hasLabel = !anotherLabel;
                    }
                    child = parent;
                }
                if (!hasLabel) {
                    HtmlFormInputWithoutLabelInspection.registerProblem(tag, holder);
                }
            }
        }
    }

    private static boolean isImplicitIdAttribute(@NotNull XmlAttribute attribute) {
        XmlTag parent;
        if (attribute == null) {
            HtmlFormInputWithoutLabelInspection.$$$reportNull$$$0(2);
        }
        if ((parent = attribute.getParent()) != null) {
            return attribute.equals(IdRefReference.getImplicitIdRefAttr((XmlTag)parent));
        }
        return false;
    }

    @Nullable
    private static Pair<ProblemDescriptor, ProblemsHolder> registerProblem(XmlTag tag, ProblemsHolder holder) {
        if (InjectedLanguageManager.getInstance((Project)tag.getProject()).getInjectionHost((PsiElement)tag) != null) {
            return null;
        }
        ArrayList<Object> fixes = new ArrayList<Object>();
        Pair<PsiElement, PsiElement> pair = HtmlFormInputWithoutLabelInspection.getNearestText((PsiElement)tag, new ForwardIterator());
        if (pair != null) {
            fixes.add(new CreateLabelFromTextAction("html.inspections.create.label.from.text.after.action", false, tag.getName()));
        }
        if ((pair = HtmlFormInputWithoutLabelInspection.getNearestText((PsiElement)tag, new BackwardIterator())) != null) {
            fixes.add(new CreateLabelFromTextAction("html.inspections.create.label.from.text.before.action", true, tag.getName()));
        }
        fixes.add(new CreateNewLabelAction(tag.getName()));
        XmlToken toRegister = XmlTagUtil.getStartTagNameElement((XmlTag)tag);
        assert (toRegister != null);
        InspectionManager manager = holder.getManager();
        ProblemDescriptor descriptor = manager.createProblemDescriptor((PsiElement)toRegister, (PsiElement)toRegister, HtmlToolsBundle.message("html.inspections.form.input.without.label", new Object[0]), ProblemHighlightType.GENERIC_ERROR_OR_WARNING, holder.isOnTheFly(), fixes.toArray(LocalQuickFix.EMPTY_ARRAY));
        holder.registerProblem(descriptor);
        return Pair.create((Object)descriptor, (Object)holder);
    }

    @Nullable
    public static Pair<PsiElement, PsiElement> getNearestText(PsiElement element, ElementIterator iterator) {
        if (!((element = iterator.getNext(element)) instanceof XmlText) || element.getChildren().length == 0) {
            return null;
        }
        element = iterator.getFirstChild(element);
        PsiElement first = null;
        PsiElement last = null;
        boolean textPassed = false;
        PsiElement current = element;
        while (current != null) {
            if (current instanceof PsiWhiteSpace && current.getText().contains("\n")) {
                if (textPassed) {
                    break;
                }
            } else if (!(current instanceof PsiComment)) {
                if (first == null) {
                    first = current;
                }
                last = current;
                textPassed = true;
            }
            current = iterator.getNext(current);
        }
        if (!textPassed) {
            return null;
        }
        return iterator.sortOrderedPair(first, last);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tag";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "holder";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "attribute";
                break;
            }
        }
        objectArray2[1] = "com/intellij/htmltools/codeInspection/htmlInspections/HtmlFormInputWithoutLabelInspection";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "checkTag";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "isImplicitIdAttribute";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    public static class BackwardIterator
    implements ElementIterator {
        @Override
        public PsiElement getNext(PsiElement element) {
            return element.getPrevSibling();
        }

        @Override
        public Pair<PsiElement, PsiElement> sortOrderedPair(@NotNull PsiElement left, @NotNull PsiElement right) {
            if (left == null) {
                BackwardIterator.$$$reportNull$$$0(0);
            }
            if (right == null) {
                BackwardIterator.$$$reportNull$$$0(1);
            }
            return Pair.create((Object)right, (Object)left);
        }

        @Override
        @Nullable
        public PsiElement getFirstChild(@NotNull PsiElement element) {
            if (element == null) {
                BackwardIterator.$$$reportNull$$$0(2);
            }
            return element.getLastChild();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "left";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "right";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "element";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/htmltools/codeInspection/htmlInspections/HtmlFormInputWithoutLabelInspection$BackwardIterator";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "sortOrderedPair";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "getFirstChild";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    public static class ForwardIterator
    implements ElementIterator {
        @Override
        public PsiElement getNext(PsiElement element) {
            return element.getNextSibling();
        }

        @Override
        public Pair<PsiElement, PsiElement> sortOrderedPair(@NotNull PsiElement left, @NotNull PsiElement right) {
            if (left == null) {
                ForwardIterator.$$$reportNull$$$0(0);
            }
            if (right == null) {
                ForwardIterator.$$$reportNull$$$0(1);
            }
            return Pair.create((Object)left, (Object)right);
        }

        @Override
        @Nullable
        public PsiElement getFirstChild(@NotNull PsiElement element) {
            if (element == null) {
                ForwardIterator.$$$reportNull$$$0(2);
            }
            return element.getFirstChild();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "left";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "right";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "element";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/htmltools/codeInspection/htmlInspections/HtmlFormInputWithoutLabelInspection$ForwardIterator";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "sortOrderedPair";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "getFirstChild";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static interface ElementIterator {
        @Nullable
        public PsiElement getNext(PsiElement var1);

        public Pair<PsiElement, PsiElement> sortOrderedPair(@NotNull PsiElement var1, @NotNull PsiElement var2);

        @Nullable
        public PsiElement getFirstChild(@NotNull PsiElement var1);
    }
}

