/*
 * Decompiled with CFR 0.152.
 */
package org.fest.swing.util;

import java.util.regex.Pattern;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.fest.swing.util.Patterns;
import org.fest.swing.util.Strings;
import org.fest.swing.util.TextMatcher;
import org.fest.util.Preconditions;

public class PatternTextMatcher
implements TextMatcher {
    private final Pattern[] patterns;

    public PatternTextMatcher(Pattern ... patterns) {
        this.patterns = (Pattern[])Preconditions.checkNotNullOrEmpty((Object[])patterns);
    }

    @Override
    public boolean isMatching(@Nullable String text) {
        for (Pattern pattern : this.patterns) {
            if (!Strings.match(pattern, text)) continue;
            return true;
        }
        return false;
    }

    @Override
    @Nonnull
    public String description() {
        return this.patterns.length == 1 ? "pattern" : "patterns";
    }

    @Override
    @Nonnull
    public String formattedValues() {
        if (this.patterns.length == 1) {
            return (String)Preconditions.checkNotNull((Object)org.fest.util.Strings.quote((String)this.patterns[0].pattern()));
        }
        return Patterns.format(this.patterns);
    }
}

