/*
 * Decompiled with CFR 0.152.
 */
package org.fest.swing.fixture;

import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.fest.assertions.Assertions;
import org.fest.assertions.ObjectAssert;
import org.fest.swing.core.KeyPressInfo;
import org.fest.swing.core.MouseButton;
import org.fest.swing.core.MouseClickInfo;
import org.fest.swing.core.Robot;
import org.fest.swing.driver.ComponentDriver;
import org.fest.swing.fixture.ColorFixture;
import org.fest.swing.fixture.FontFixture;
import org.fest.swing.fixture.MouseInputSimulationFixture;
import org.fest.swing.format.Formatting;
import org.fest.swing.query.ComponentEnabledQuery;
import org.fest.swing.timing.Timeout;
import org.fest.util.Preconditions;

public abstract class AbstractComponentFixture<S, C extends Component, D extends ComponentDriver>
implements MouseInputSimulationFixture<S> {
    protected static final String FONT_PROPERTY = "font";
    protected static final String BACKGROUND_PROPERTY = "background";
    protected static final String FOREGROUND_PROPERTY = "foreground";
    private final Robot robot;
    private final C target;
    private final S myself;
    private D driver;

    public AbstractComponentFixture(@Nonnull Class<S> selfType, @Nonnull Robot robot, @Nonnull Class<? extends C> type) {
        this(selfType, robot, AbstractComponentFixture.findTarget(robot, type));
    }

    @Nonnull
    private static <C extends Component> C findTarget(@Nonnull Robot robot, @Nonnull Class<? extends C> type) {
        Preconditions.checkNotNull((Object)robot);
        Preconditions.checkNotNull(type);
        return robot.finder().findByType(type, AbstractComponentFixture.requireShowing(robot));
    }

    public AbstractComponentFixture(@Nonnull Class<S> selfType, @Nonnull Robot robot, @Nullable String name, @Nonnull Class<? extends C> type) {
        this(selfType, robot, AbstractComponentFixture.findTarget(robot, name, type));
    }

    @Nonnull
    private static <C extends Component> C findTarget(@Nonnull Robot robot, @Nullable String name, @Nonnull Class<? extends C> type) {
        Preconditions.checkNotNull((Object)robot);
        Preconditions.checkNotNull(type);
        return robot.finder().findByName(name, type, AbstractComponentFixture.requireShowing(robot));
    }

    public AbstractComponentFixture(@Nonnull Class<S> selfType, @Nonnull Robot robot, @Nonnull C target) {
        this.myself = ((Class)Preconditions.checkNotNull(selfType)).cast(this);
        this.robot = (Robot)Preconditions.checkNotNull((Object)robot);
        this.target = (Component)Preconditions.checkNotNull(target);
        this.replaceDriverWith(this.createDriver(robot));
    }

    @Nonnull
    protected abstract D createDriver(@Nonnull Robot var1);

    @Nonnull
    protected final D driver() {
        return this.driver;
    }

    public final void replaceDriverWith(@Nonnull D driver) {
        this.driver = (ComponentDriver)Preconditions.checkNotNull(driver);
    }

    @Override
    @Nonnull
    public final S click() {
        ((ComponentDriver)this.driver).click(this.target());
        return this.myself();
    }

    @Override
    @Nonnull
    public final S click(@Nonnull MouseButton button) {
        ((ComponentDriver)this.driver).click(this.target(), button);
        return this.myself();
    }

    @Override
    @Nonnull
    public final S click(@Nonnull MouseClickInfo mouseClickInfo) {
        ((ComponentDriver)this.driver).click(this.target(), mouseClickInfo);
        return this.myself();
    }

    @Override
    @Nonnull
    public final S doubleClick() {
        ((ComponentDriver)this.driver).doubleClick(this.target());
        return this.myself();
    }

    @Override
    @Nonnull
    public final S rightClick() {
        ((ComponentDriver)this.driver).rightClick(this.target());
        return this.myself();
    }

    @Nonnull
    public final S focus() {
        ((ComponentDriver)this.driver).focus((Component)this.target());
        return this.myself();
    }

    @Nonnull
    public final S pressAndReleaseKey(@Nonnull KeyPressInfo keyPressInfo) {
        ((ComponentDriver)this.driver).pressAndReleaseKey(this.target(), keyPressInfo);
        return this.myself();
    }

    @Nonnull
    public final S pressAndReleaseKeys(int ... keyCodes) {
        ((ComponentDriver)this.driver).pressAndReleaseKeys(this.target(), keyCodes);
        return this.myself();
    }

    @Nonnull
    public final S pressKey(int keyCode) {
        ((ComponentDriver)this.driver).pressKey(this.target(), keyCode);
        return this.myself();
    }

    @Nonnull
    public final S releaseKey(int keyCode) {
        ((ComponentDriver)this.driver).releaseKey(this.target(), keyCode);
        return this.myself();
    }

    @Nonnull
    public final S requireFocused() {
        ((ComponentDriver)this.driver).requireFocused(this.target());
        return this.myself();
    }

    @Nonnull
    public final S requireEnabled() {
        ((ComponentDriver)this.driver).requireEnabled(this.target());
        return this.myself();
    }

    @Nonnull
    public final S requireEnabled(@Nonnull Timeout timeout) {
        ((ComponentDriver)this.driver).requireEnabled(this.target(), timeout);
        return this.myself();
    }

    @Nonnull
    public final S requireDisabled() {
        ((ComponentDriver)this.driver).requireDisabled(this.target());
        return this.myself();
    }

    @Nonnull
    public final S requireVisible() {
        ((ComponentDriver)this.driver).requireVisible(this.target());
        return this.myself();
    }

    @Nonnull
    public final S requireNotVisible() {
        ((ComponentDriver)this.driver).requireNotVisible(this.target());
        return this.myself();
    }

    protected boolean requireShowing() {
        return AbstractComponentFixture.requireShowing(this.robot());
    }

    private static boolean requireShowing(@Nonnull Robot robot) {
        return robot.settings().componentLookupScope().requireShowing();
    }

    @Nonnull
    public final FontFixture font() {
        Font font = ((ComponentDriver)this.driver).fontOf(this.target);
        return new FontFixture(font, ComponentDriver.propertyName(this.target(), FONT_PROPERTY));
    }

    @Nonnull
    public final ColorFixture background() {
        Color background = ((ComponentDriver)this.driver).backgroundOf(this.target);
        return new ColorFixture(background, ComponentDriver.propertyName(this.target(), BACKGROUND_PROPERTY));
    }

    @Nonnull
    public final ColorFixture foreground() {
        Color foreground = ((ComponentDriver)this.driver).foregroundOf(this.target);
        return new ColorFixture(foreground, ComponentDriver.propertyName(this.target(), FOREGROUND_PROPERTY));
    }

    public final boolean isEnabled() {
        return ComponentEnabledQuery.isEnabled(this.target());
    }

    @Nonnull
    public final <T extends C> C targetCastedTo(@Nonnull Class<T> type) {
        ((ObjectAssert)Assertions.assertThat(this.target).as(Formatting.format(this.target))).isInstanceOf(type);
        return (C)((Component)type.cast(this.target));
    }

    @Nonnull
    public final C target() {
        return this.target;
    }

    @Nonnull
    public final Robot robot() {
        return this.robot;
    }

    @Nonnull
    protected final S myself() {
        return this.myself;
    }
}

