/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.performancePlugin.commands;

import com.intellij.ide.plugins.DynamicPluginListener;
import com.intellij.ide.plugins.DynamicPlugins;
import com.intellij.ide.plugins.IdeaPluginDescriptor;
import com.intellij.ide.plugins.IdeaPluginDescriptorImpl;
import com.intellij.ide.plugins.PluginEnabler;
import com.intellij.ide.plugins.PluginManagerCore;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.extensions.PluginId;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.playback.PlaybackContext;
import com.intellij.openapi.ui.playback.commands.AbstractCommand;
import com.intellij.openapi.util.ActionCallback;
import com.intellij.util.messages.MessageBusConnection;
import com.jetbrains.performancePlugin.utils.ActionCallbackProfilerStopper;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.concurrency.Promise;
import org.jetbrains.concurrency.Promises;

public class EnablePluginCommand
extends AbstractCommand {
    public static final String PREFIX = "%enablePlugin";
    private final Project myProject;

    public EnablePluginCommand(@NotNull String text, int line, @NotNull Project project) {
        if (text == null) {
            EnablePluginCommand.$$$reportNull$$$0(0);
        }
        if (project == null) {
            EnablePluginCommand.$$$reportNull$$$0(1);
        }
        super(text, line);
        this.myProject = project;
    }

    protected Promise<Object> _execute(PlaybackContext context) {
        final ActionCallbackProfilerStopper actionCallback = new ActionCallbackProfilerStopper();
        String pluginId = this.getText().substring(PREFIX.length()).trim();
        IdeaPluginDescriptorImpl pluginDescriptor = PluginEnabler.loadFullDescriptor((IdeaPluginDescriptorImpl)((IdeaPluginDescriptorImpl)PluginManagerCore.getPlugin((PluginId)PluginId.getId((String)pluginId))));
        boolean wasEnabled = pluginDescriptor.isEnabled();
        pluginDescriptor.setEnabled(true);
        final MessageBusConnection appConnection = ApplicationManager.getApplication().getMessageBus().connect();
        appConnection.subscribe(DynamicPluginListener.TOPIC, (Object)new DynamicPluginListener(){

            public void pluginLoaded(@NotNull IdeaPluginDescriptor pluginDescriptor) {
                if (pluginDescriptor == null) {
                    1.$$$reportNull$$$0(0);
                }
                final MessageBusConnection projectConnection = EnablePluginCommand.this.myProject.getMessageBus().connect();
                projectConnection.subscribe(DumbService.DUMB_MODE, (Object)new DumbService.DumbModeListener(){

                    public void exitDumbMode() {
                        appConnection.disconnect();
                        projectConnection.disconnect();
                        actionCallback.setDone();
                    }
                });
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "pluginDescriptor", "com/jetbrains/performancePlugin/commands/EnablePluginCommand$1", "pluginLoaded"));
            }
        });
        ApplicationManager.getApplication().invokeLater(() -> DynamicPlugins.loadPlugin((IdeaPluginDescriptorImpl)pluginDescriptor, (!wasEnabled ? 1 : 0) != 0));
        return Promises.toPromise((ActionCallback)actionCallback);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "text";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "project";
                break;
            }
        }
        objectArray[1] = "com/jetbrains/performancePlugin/commands/EnablePluginCommand";
        objectArray[2] = "<init>";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

