/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.scss.references;

import com.google.common.collect.Lists;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementResolveResult;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiPolyVariantReferenceBase;
import com.intellij.psi.ResolveResult;
import com.intellij.psi.css.CssFunction;
import com.intellij.psi.css.impl.util.CssUtil;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.util.ArrayUtilRt;
import com.intellij.util.Processor;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.sass.extensions.SassExtension;
import org.jetbrains.plugins.sass.extensions.SassExtensionFunctionInfo;
import org.jetbrains.plugins.scss.SASSSCSSLangUtil;
import org.jetbrains.plugins.scss.psi.SassScssFunctionDeclaration;
import org.jetbrains.plugins.scss.psi.SassScssStylesheetFile;
import org.jetbrains.plugins.scss.psi.stubs.ScssFunctionsIndex;

public class SassScssFunctionReference
extends PsiPolyVariantReferenceBase<CssFunction> {
    public SassScssFunctionReference(CssFunction element) {
        super((PsiElement)element);
    }

    public ResolveResult @NotNull [] multiResolve(boolean incompleteCode) {
        if (!(((CssFunction)this.myElement).getContainingFile() instanceof SassScssStylesheetFile)) {
            if (ResolveResult.EMPTY_ARRAY == null) {
                SassScssFunctionReference.$$$reportNull$$$0(0);
            }
            return ResolveResult.EMPTY_ARRAY;
        }
        String functionName = ((CssFunction)this.myElement).getName();
        ResolveResult[] resolveResultArray = SassScssFunctionReference.resolveByName(functionName, this.myElement, incompleteCode);
        if (resolveResultArray == null) {
            SassScssFunctionReference.$$$reportNull$$$0(1);
        }
        return resolveResultArray;
    }

    public static ResolveResult[] resolveByName(@NotNull String functionName, @NotNull PsiElement context, boolean incompleteCode) {
        ResolveResult singleResult;
        if (functionName == null) {
            SassScssFunctionReference.$$$reportNull$$$0(2);
        }
        if (context == null) {
            SassScssFunctionReference.$$$reportNull$$$0(3);
        }
        Set importedFiles = CssUtil.getImportedFiles((PsiFile)context.getContainingFile(), (PsiElement)context, (boolean)false);
        LinkedList resultResolvedWithImports = Lists.newLinkedList();
        LinkedList resultResolvedByNameOnly = Lists.newLinkedList();
        GlobalSearchScope scope = SASSSCSSLangUtil.searchScopeWithSassStdlib(context);
        ScssFunctionsIndex.process(functionName, context.getProject(), scope, (Processor<? super SassScssFunctionDeclaration>)((Processor)declaration -> {
            if (SASSSCSSLangUtil.isVisibleDeclaration((PsiElement)declaration, context)) {
                boolean validResult = importedFiles.contains(declaration.getContainingFile().getVirtualFile());
                PsiElementResolveResult resolveResult = new PsiElementResolveResult((PsiElement)declaration, validResult);
                if (validResult) {
                    resultResolvedWithImports.add(resolveResult);
                } else {
                    resultResolvedByNameOnly.add(resolveResult);
                }
            }
            return true;
        }));
        LinkedList result = resultResolvedWithImports;
        if (result.isEmpty()) {
            result = resultResolvedByNameOnly;
        } else if (!incompleteCode && result.size() > 1 && (singleResult = SASSSCSSLangUtil.filterOverridedResults(result, context)) != null) {
            return new ResolveResult[]{singleResult};
        }
        if (result.isEmpty()) {
            Module module = ModuleUtilCore.findModuleForPsiElement((PsiElement)context);
            Collection<SassExtensionFunctionInfo> functions = SassExtension.findExtensionFunctionInfos(functionName, context, module);
            HashSet<PsiElement> psiFunctions = new HashSet<PsiElement>();
            for (SassExtensionFunctionInfo function : functions) {
                PsiElement declaration2 = function.getFunctionDeclaration();
                if (declaration2 == null) continue;
                psiFunctions.add(declaration2);
            }
            if (!psiFunctions.isEmpty()) {
                return PsiElementResolveResult.createResults(psiFunctions);
            }
            if (!functions.isEmpty()) {
                return new ResolveResult[]{new PsiElementResolveResult(context)};
            }
        }
        return result.toArray(ResolveResult.EMPTY_ARRAY);
    }

    public Object @NotNull [] getVariants() {
        if (ArrayUtilRt.EMPTY_OBJECT_ARRAY == null) {
            SassScssFunctionReference.$$$reportNull$$$0(4);
        }
        return ArrayUtilRt.EMPTY_OBJECT_ARRAY;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 2: 
            case 3: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 2: 
            case 3: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/scss/references/SassScssFunctionReference";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "functionName";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "multiResolve";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/scss/references/SassScssFunctionReference";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getVariants";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "resolveByName";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 2: 
            case 3: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

