/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.scss.annotator;

import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.css.util.CssPsiUtil;
import com.intellij.lang.ASTNode;
import com.intellij.lang.Language;
import com.intellij.lang.annotation.AnnotationBuilder;
import com.intellij.lang.annotation.AnnotationHolder;
import com.intellij.lang.annotation.Annotator;
import com.intellij.lang.annotation.HighlightSeverity;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiElement;
import com.intellij.psi.css.CssAtRule;
import com.intellij.psi.css.CssDeclaration;
import com.intellij.psi.css.CssRuleset;
import com.intellij.psi.css.CssRulesetList;
import com.intellij.psi.css.CssSelectorList;
import com.intellij.psi.css.impl.CssElementTypes;
import com.intellij.psi.css.inspections.CssInspectionsUtil;
import com.intellij.psi.util.PsiTreeUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.sass.SASSBundle;
import org.jetbrains.plugins.sass.SASSLanguage;
import org.jetbrains.plugins.sass.actions.DeleteRulesetQuickFix;
import org.jetbrains.plugins.sass.actions.EscapeColonInPropertyRulesetQuickFix;
import org.jetbrains.plugins.sass.highlighting.SassScssHighlightingColors;
import org.jetbrains.plugins.scss.SCSSLanguage;
import org.jetbrains.plugins.scss.psi.SCSSInterpolationImpl;
import org.jetbrains.plugins.scss.psi.SassScssControlDirective;
import org.jetbrains.plugins.scss.psi.SassScssInclude;
import org.jetbrains.plugins.scss.psi.SassScssPropertyRuleset;
import org.jetbrains.plugins.scss.psi.SassScssRuleset;
import org.jetbrains.plugins.scss.psi.SassScssStatement;
import org.jetbrains.plugins.scss.psi.SassScssVariableImpl;

public class SassScssAnnotator
implements Annotator {
    public void annotate(@NotNull PsiElement element, @NotNull AnnotationHolder holder) {
        Language stylesheetLanguage;
        if (element == null) {
            SassScssAnnotator.$$$reportNull$$$0(0);
        }
        if (holder == null) {
            SassScssAnnotator.$$$reportNull$$$0(1);
        }
        if ((stylesheetLanguage = CssPsiUtil.getStylesheetLanguage((PsiElement)element)) == SASSLanguage.INSTANCE || stylesheetLanguage == SCSSLanguage.INSTANCE) {
            if (PsiTreeUtil.getParentOfType((PsiElement)element, SassScssPropertyRuleset.class, (boolean)true) != null) {
                if (element instanceof SassScssControlDirective || element instanceof SassScssInclude || element instanceof SassScssPropertyRuleset) {
                    return;
                }
                if (element instanceof CssRuleset || element instanceof CssAtRule || element instanceof SassScssRuleset || element instanceof SassScssStatement) {
                    holder.newAnnotation(HighlightSeverity.ERROR, SASSBundle.message("annotator.property.illegal.nesting.error", new Object[0])).create();
                }
            } else if (element instanceof SassScssVariableImpl) {
                ASTNode parent;
                SCSSInterpolationImpl interpolation = (SCSSInterpolationImpl)PsiTreeUtil.getParentOfType((PsiElement)element, SCSSInterpolationImpl.class);
                if (interpolation != null && (parent = interpolation.getNode().getTreeParent()) != null && parent.getElementType() == CssElementTypes.CSS_EXPRESSION_PARAMETER) {
                    String description;
                    String string = description = ApplicationManager.getApplication().isUnitTestMode() ? SassScssHighlightingColors.VARIABLE.getExternalName() : null;
                    if (description == null) {
                        holder.newSilentAnnotation(HighlightSeverity.INFORMATION).textAttributes(SassScssHighlightingColors.VARIABLE).create();
                    } else {
                        holder.newAnnotation(HighlightSeverity.INFORMATION, description).textAttributes(SassScssHighlightingColors.VARIABLE).create();
                    }
                }
            } else if (stylesheetLanguage == SCSSLanguage.INSTANCE) {
                if (element instanceof PsiComment) {
                    CssInspectionsUtil.checkUnclosedComment((PsiComment)((PsiComment)element), (AnnotationHolder)holder);
                }
            } else if (stylesheetLanguage == SASSLanguage.INSTANCE) {
                CssSelectorList selectorList;
                if (element.getParent() instanceof CssRulesetList) {
                    if (element instanceof SassScssPropertyRuleset) {
                        CssDeclaration namespace = ((SassScssPropertyRuleset)element).getNamespaceDeclaration();
                        if (namespace != null) {
                            AnnotationBuilder builder = holder.newAnnotation(HighlightSeverity.ERROR, SASSBundle.message("annotator.property.top.level.properties.error", new Object[0])).range((PsiElement)namespace);
                            if (StringUtil.startsWithChar((CharSequence)element.getText(), (char)':')) {
                                builder = builder.withFix((IntentionAction)new EscapeColonInPropertyRulesetQuickFix((SassScssPropertyRuleset)element));
                            }
                            builder.create();
                        }
                    } else if (element instanceof CssDeclaration) {
                        holder.newAnnotation(HighlightSeverity.ERROR, SASSBundle.message("annotator.property.top.level.properties.error", new Object[0])).create();
                    }
                }
                if (element instanceof CssRuleset && ((CssRuleset)element).getBlock() == null && (selectorList = ((CssRuleset)element).getSelectorList()) != null) {
                    holder.newAnnotation(HighlightSeverity.WARNING, SASSBundle.message("annotator.selector.doesnt.have.properties.warning", new Object[0])).range((PsiElement)selectorList).withFix((IntentionAction)new DeleteRulesetQuickFix((CssRuleset)element)).create();
                }
            }
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "element";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "holder";
                break;
            }
        }
        objectArray[1] = "org/jetbrains/plugins/scss/annotator/SassScssAnnotator";
        objectArray[2] = "annotate";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

