/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.diff.impl.patch.apply;

import com.intellij.openapi.diff.impl.patch.apply.ApplyFilePatch;
import com.intellij.openapi.diff.impl.patch.apply.ApplyFilePatchBase;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Getter;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.changes.CommitContext;
import com.intellij.openapi.vcs.changes.shelf.ShelvedBinaryFile;
import com.intellij.openapi.vcs.changes.shelf.ShelvedBinaryFilePatch;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import java.io.File;
import java.io.IOException;

public class ApplyBinaryShelvedFilePatch
extends ApplyFilePatchBase<ShelvedBinaryFilePatch> {
    public ApplyBinaryShelvedFilePatch(ShelvedBinaryFilePatch patch) {
        super(patch);
    }

    @Override
    protected void applyCreate(Project project, VirtualFile newFile, CommitContext commitContext) throws IOException {
        this.applyChange(project, newFile, null, null);
    }

    @Override
    protected ApplyFilePatch.Result applyChange(Project project, VirtualFile fileToPatch, FilePath pathBeforeRename, Getter<? extends CharSequence> baseContents) throws IOException {
        ShelvedBinaryFile shelvedBinaryFile = ((ShelvedBinaryFilePatch)this.myPatch).getShelvedBinaryFile();
        if (shelvedBinaryFile.SHELVED_PATH == null) {
            fileToPatch.delete((Object)this);
        } else {
            File fromFile = new File(shelvedBinaryFile.SHELVED_PATH);
            File toFile = VfsUtilCore.virtualToIoFile((VirtualFile)fileToPatch);
            FileUtil.copyContent((File)fromFile, (File)toFile);
            VfsUtil.markDirty((boolean)false, (boolean)false, (VirtualFile[])new VirtualFile[]{fileToPatch});
        }
        return SUCCESS;
    }
}

