/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.plugins.reactnative;

import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.execution.configurations.PtyCommandLine;
import com.intellij.execution.process.OSProcessHandler;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.execution.ui.ConsoleView;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.terminal.TerminalExecutionConsole;
import com.intellij.util.io.BaseDataReader;
import com.intellij.util.io.BaseOutputReader;
import com.jetbrains.plugins.reactnative.ProcessRunnerFactory;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0003\u001a\u00020\u0004H\u0016J\u0018\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016J\u0010\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u0004H\u0016\u00a8\u0006\u000e"}, d2={"Lcom/jetbrains/plugins/reactnative/TerminalProcessRunnerFactory;", "Lcom/jetbrains/plugins/reactnative/ProcessRunnerFactory;", "()V", "createCommandLine", "Lcom/intellij/execution/configurations/GeneralCommandLine;", "createConsoleView", "Lcom/intellij/execution/ui/ConsoleView;", "project", "Lcom/intellij/openapi/project/Project;", "processHandler", "Lcom/intellij/execution/process/ProcessHandler;", "createProcessHandler", "Lcom/intellij/execution/process/OSProcessHandler;", "commandLine", "intellij.javascript.reactNativeDebugger"})
public final class TerminalProcessRunnerFactory
implements ProcessRunnerFactory {
    public static final TerminalProcessRunnerFactory INSTANCE;

    @Override
    @NotNull
    public GeneralCommandLine createCommandLine() {
        PtyCommandLine commandLine = new PtyCommandLine();
        if (!SystemInfo.isWindows) {
            Map map = commandLine.getEnvironment();
            Intrinsics.checkExpressionValueIsNotNull((Object)map, (String)"commandLine.environment");
            map.put("TERM", "xterm-256color");
        }
        return (GeneralCommandLine)commandLine;
    }

    @NotNull
    public OSProcessHandler createProcessHandler(@NotNull GeneralCommandLine commandLine) {
        Intrinsics.checkParameterIsNotNull((Object)commandLine, (String)"commandLine");
        return new OSProcessHandler(commandLine, commandLine){
            final /* synthetic */ GeneralCommandLine $commandLine;

            @NotNull
            protected BaseOutputReader.Options readerOptions() {
                return new BaseOutputReader.Options(){

                    @Nullable
                    public BaseDataReader.SleepingPolicy policy() {
                        return BaseDataReader.SleepingPolicy.BLOCKING;
                    }

                    public boolean splitToLines() {
                        return false;
                    }

                    public boolean withSeparators() {
                        return true;
                    }
                };
            }
            {
                this.$commandLine = $captured_local_variable$0;
                super($super_call_param$1);
            }
        };
    }

    @Override
    @NotNull
    public ConsoleView createConsoleView(@NotNull Project project, @NotNull ProcessHandler processHandler) {
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        Intrinsics.checkParameterIsNotNull((Object)processHandler, (String)"processHandler");
        return (ConsoleView)new TerminalExecutionConsole(project, processHandler);
    }

    private TerminalProcessRunnerFactory() {
    }

    static {
        TerminalProcessRunnerFactory terminalProcessRunnerFactory;
        INSTANCE = terminalProcessRunnerFactory = new TerminalProcessRunnerFactory();
    }
}

