/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.plugins.webDeployment.ui.config;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.NamedConfigurable;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ui.components.JBScrollPane;
import com.intellij.ui.components.JBTabbedPane;
import com.intellij.util.ui.UIUtil;
import com.jetbrains.plugins.webDeployment.WDBundle;
import com.jetbrains.plugins.webDeployment.config.AccessType;
import com.jetbrains.plugins.webDeployment.ui.WebServerConfigForm;
import com.jetbrains.plugins.webDeployment.ui.config.DeploymentConfigurableTab;
import com.jetbrains.plugins.webDeployment.ui.config.DeploymentConfigurableTabProvider;
import com.jetbrains.plugins.webDeployment.ui.config.SettingsDeployable;
import java.awt.BorderLayout;
import java.awt.Component;
import java.util.ArrayList;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.border.Border;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

abstract class DeploymentConfigurableForm
extends NamedConfigurable
implements Disposable,
DeploymentConfigurableTabProvider.ServerStateProvider {
    private final JBTabbedPane myTabbedPane;
    private final List<DeploymentConfigurableTab> myTabs = new ArrayList<DeploymentConfigurableTab>();
    private final SettingsDeployable myServer;
    @Nullable
    private final Project myProject;
    private boolean myComponentInitialized;

    DeploymentConfigurableForm(SettingsDeployable server, @Nullable Project project, Runnable runnable) {
        super(false, runnable);
        this.myServer = server;
        this.myProject = project;
        this.myTabbedPane = new JBTabbedPane();
        this.myTabbedPane.setTabComponentInsets(null);
    }

    void addTab(DeploymentConfigurableTab tab) {
        if (Disposer.isDisposed((Disposable)this)) {
            return;
        }
        this.myTabs.add(tab);
        JComponent component = tab.createComponent();
        this.myTabbedPane.addTab(tab.getTitle(), (Component)new TabWrapper(component, tab.getBorder()));
    }

    public Icon getIcon(boolean expanded) {
        WebServerConfigForm serverForm = this.getServerForm();
        return serverForm == null ? this.myServer.getIcon() : serverForm.getIcon(0);
    }

    public JComponent createOptionsPanel() {
        if (!this.myComponentInitialized) {
            this.myComponentInitialized = true;
            this.addTab(new ServerTab(this.myServer, this.myProject));
            this.setUpComponent();
            this.updateTabAvailability(this.myServer);
            this.addListener(new ChangeListener(){

                @Override
                public void stateChanged(ChangeEvent e) {
                    Object source = e.getSource();
                    if (!(source instanceof SettingsDeployable)) {
                        return;
                    }
                    DeploymentConfigurableForm.this.updateTabAvailability((SettingsDeployable)source);
                }
            }, this);
        }
        return this.myTabbedPane;
    }

    private void updateTabAvailability(SettingsDeployable source) {
        AccessType accessType = source.getAccessType();
        for (int i = 0; i < this.myTabs.size(); ++i) {
            boolean enabled = this.myTabs.get(i).isEnabled(accessType);
            this.myTabbedPane.setEnabledAt(i, enabled);
            this.myTabbedPane.getTabComponentAt(i).setEnabled(enabled);
        }
    }

    protected abstract void setUpComponent();

    public SettingsDeployable compute() {
        return this.getServerForm().getCurrentState();
    }

    @Override
    public void updateAuth(SettingsDeployable server) {
        this.getServerForm().updateAuth(server);
    }

    @Override
    public String getServerId() {
        return this.myServer.getId();
    }

    @Override
    public String getServerName() {
        return this.myServer.getName();
    }

    @Override
    public void addListener(final ChangeListener l, Disposable parentDisposable) {
        this.getServerForm().addListener(new WebServerConfigForm.Listener(){

            @Override
            public void changed(SettingsDeployable effective) {
                l.stateChanged(new ChangeEvent(effective));
            }
        }, parentDisposable);
    }

    void fireChanged() {
        this.getServerForm().fireChanged();
    }

    public boolean isModified() {
        for (DeploymentConfigurableTab tab : this.myTabs) {
            if (!tab.isModified()) continue;
            return true;
        }
        return false;
    }

    public void apply() throws ConfigurationException {
        this.applyTo(this.myServer, true);
    }

    void applyTo(SettingsDeployable server, boolean persistChanges) {
        for (DeploymentConfigurableTab tab : this.myTabs) {
            tab.applyTo(server, persistChanges);
        }
    }

    public void reset() {
        for (DeploymentConfigurableTab tab : this.myTabs) {
            tab.reset();
        }
    }

    public void dispose() {
    }

    public void disposeUIResources() {
        Disposer.dispose((Disposable)this);
        for (DeploymentConfigurableTab tab : this.myTabs) {
            tab.disposeUIResources();
        }
    }

    @Nullable
    private WebServerConfigForm getServerForm() {
        if (this.myTabs.isEmpty()) {
            return null;
        }
        return ((ServerTab)this.myTabs.get(0)).getForm();
    }

    public void setDisplayName(String name) {
    }

    public Object getEditableObject() {
        return this.myServer;
    }

    public String getBannerSlogan() {
        return this.myServer.getName();
    }

    @NotNull
    public String getDisplayName() {
        String string = StringUtil.notNullize((String)this.myServer.getName());
        if (string == null) {
            DeploymentConfigurableForm.$$$reportNull$$$0(0);
        }
        return string;
    }

    public String getHelpTopic() {
        return null;
    }

    void addTabChangeListener(ChangeListener l) {
        this.myTabbedPane.addChangeListener(l);
    }

    int getSelectedTabIndex() {
        return this.myTabbedPane.getSelectedIndex();
    }

    void setSelectedTabIndex(int tabIndex) {
        this.createOptionsPanel();
        if (this.myTabbedPane.isEnabledAt(tabIndex)) {
            this.myTabbedPane.setSelectedIndex(tabIndex);
        }
    }

    @Nullable
    JComponent getPreferredFocusedComponent(int tabIndex) {
        return this.myTabs.get(tabIndex).getPreferredFocusedComponent();
    }

    @NotNull
    static Border createConfigurableBorder() {
        Border border = BorderFactory.createEmptyBorder(UIUtil.PANEL_SMALL_INSETS.top + 5, UIUtil.PANEL_SMALL_INSETS.left + 5, UIUtil.PANEL_SMALL_INSETS.bottom + 5, UIUtil.PANEL_SMALL_INSETS.right + 5);
        if (border == null) {
            DeploymentConfigurableForm.$$$reportNull$$$0(1);
        }
        return border;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[2];
        objectArray2[0] = "com/jetbrains/plugins/webDeployment/ui/config/DeploymentConfigurableForm";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getDisplayName";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "createConfigurableBorder";
                break;
            }
        }
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
    }

    private static class ServerTab
    implements DeploymentConfigurableTab {
        @Nullable
        private final Project myProject;
        private final SettingsDeployable myServer;
        @Nullable
        private WebServerConfigForm myForm;

        private ServerTab(SettingsDeployable server, @Nullable Project project) {
            this.myServer = server;
            this.myProject = project;
        }

        @Override
        public String getTitle() {
            return WDBundle.message("deployment.configurable.tab.connection", new Object[0]);
        }

        @Override
        public int getWeight() {
            return 0;
        }

        @Override
        @NotNull
        public JComponent createComponent() {
            JComponent jComponent = this.getForm().createComponent();
            if (jComponent == null) {
                ServerTab.$$$reportNull$$$0(0);
            }
            return jComponent;
        }

        public boolean isModified() {
            return this.getForm().isModified();
        }

        public void apply() throws ConfigurationException {
            this.getForm().apply();
        }

        @Override
        public void applyTo(SettingsDeployable server, boolean persistChanges) {
            this.getForm().applyTo(server, persistChanges);
        }

        public void reset() {
            this.getForm().reset();
        }

        public void disposeUIResources() {
            this.getForm().disposeUIResources();
        }

        @NotNull
        WebServerConfigForm getForm() {
            if (this.myForm == null) {
                this.myForm = new WebServerConfigForm(this.myServer, this.myProject);
            }
            WebServerConfigForm webServerConfigForm = this.myForm;
            if (webServerConfigForm == null) {
                ServerTab.$$$reportNull$$$0(1);
            }
            return webServerConfigForm;
        }

        @Override
        @Nullable
        public JComponent getPreferredFocusedComponent() {
            return this.getForm().getPreferredFocusedComponent();
        }

        @Override
        @NotNull
        public Border getBorder() {
            Border border = DeploymentConfigurableForm.createConfigurableBorder();
            if (border == null) {
                ServerTab.$$$reportNull$$$0(2);
            }
            return border;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[2];
            objectArray2[0] = "com/jetbrains/plugins/webDeployment/ui/config/DeploymentConfigurableForm$ServerTab";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "createComponent";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getForm";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getBorder";
                    break;
                }
            }
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
        }
    }

    private static class TabWrapper
    extends JPanel {
        private TabWrapper(@NotNull JComponent component, @NotNull Border border) {
            if (component == null) {
                TabWrapper.$$$reportNull$$$0(0);
            }
            if (border == null) {
                TabWrapper.$$$reportNull$$$0(1);
            }
            super(new BorderLayout());
            this.setBorder(border);
            JBScrollPane scrollPane = new JBScrollPane((Component)component, 20, 30);
            scrollPane.setBorder(BorderFactory.createEmptyBorder());
            this.add((Component)scrollPane, "Center");
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "component";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "border";
                    break;
                }
            }
            objectArray[1] = "com/jetbrains/plugins/webDeployment/ui/config/DeploymentConfigurableForm$TabWrapper";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

