/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.plugins.webDeployment.connections;

import com.intellij.ssh.SshBackendLibrary;
import com.jetbrains.plugins.webDeployment.connections.PatchedSftpFileProvider;
import com.jetbrains.plugins.webDeployment.connections.SftpUtil;
import com.jetbrains.plugins.webDeployment.connections.platform.PlatformSftpFileProvider;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.util.Collection;
import java.util.function.Supplier;
import org.apache.commons.vfs2.Capability;
import org.apache.commons.vfs2.FileName;
import org.apache.commons.vfs2.FileObject;
import org.apache.commons.vfs2.FileSystem;
import org.apache.commons.vfs2.FileSystemConfigBuilder;
import org.apache.commons.vfs2.FileSystemException;
import org.apache.commons.vfs2.FileSystemOptions;
import org.apache.commons.vfs2.provider.AbstractFileProvider;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SftpFileProviderProxy
extends AbstractFileProvider {
    private final Object monitor = new Object();
    private AbstractFileProvider underlyingProvider;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @NotNull
    private AbstractFileProvider getOrCreateUnderlyingProvider() throws FileSystemException {
        AbstractFileProvider abstractFileProvider;
        Supplier<AbstractFileProvider> fileProviderSupplier;
        Class expectedClass;
        SshBackendLibrary library = SftpUtil.getSshBackendLibraryForWebDeployment();
        switch (library) {
            case JSCH: {
                expectedClass = PatchedSftpFileProvider.class;
                fileProviderSupplier = PatchedSftpFileProvider::new;
                break;
            }
            case SSHJ: {
                expectedClass = PlatformSftpFileProvider.class;
                fileProviderSupplier = PlatformSftpFileProvider::new;
                break;
            }
            default: {
                throw new IllegalStateException(library.name());
            }
        }
        AbstractFileProvider oldProvider = null;
        Object object = this.monitor;
        synchronized (object) {
            if (!expectedClass.isInstance(this.underlyingProvider)) {
                oldProvider = this.underlyingProvider;
                this.underlyingProvider = fileProviderSupplier.get();
                this.underlyingProvider.setLogger(this.getLogger());
                this.underlyingProvider.setContext(this.getContext());
                this.underlyingProvider.init();
            }
            abstractFileProvider = this.underlyingProvider;
        }
        AbstractFileProvider abstractFileProvider2 = abstractFileProvider;
        if (abstractFileProvider2 == null) {
            SftpFileProviderProxy.$$$reportNull$$$0(0);
        }
        return abstractFileProvider2;
        finally {
            if (oldProvider != null) {
                oldProvider.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    private AbstractFileProvider getUnderlyingProvider() {
        Object object = this.monitor;
        synchronized (object) {
            return this.underlyingProvider;
        }
    }

    public FileObject findFile(FileObject baseFile, String uri, FileSystemOptions fileSystemOptions) throws FileSystemException {
        return this.getOrCreateUnderlyingProvider().findFile(baseFile, uri, fileSystemOptions);
    }

    public FileObject createFileSystem(String scheme, FileObject file, FileSystemOptions fileSystemOptions) throws FileSystemException {
        return this.getOrCreateUnderlyingProvider().createFileSystem(scheme, file, fileSystemOptions);
    }

    public FileSystemConfigBuilder getConfigBuilder() {
        try {
            return this.getOrCreateUnderlyingProvider().getConfigBuilder();
        }
        catch (FileSystemException e) {
            throw new UncheckedIOException((IOException)((Object)e));
        }
    }

    public Collection<Capability> getCapabilities() {
        try {
            return this.getOrCreateUnderlyingProvider().getCapabilities();
        }
        catch (FileSystemException e) {
            throw new UncheckedIOException((IOException)((Object)e));
        }
    }

    public FileName parseUri(FileName root, String uri) throws FileSystemException {
        return this.getOrCreateUnderlyingProvider().parseUri(root, uri);
    }

    public FileName parseChildUri(FileName root, String uri) throws FileSystemException {
        return this.getOrCreateUnderlyingProvider().parseChildUri(root, uri);
    }

    public FileSystem findOrCreateFileSystem(String uri, FileSystemOptions fileSystemOptions, boolean onlyCached) throws FileSystemException {
        return this.getOrCreateUnderlyingProvider().findOrCreateFileSystem(uri, fileSystemOptions, onlyCached);
    }

    public void init() throws FileSystemException {
        this.getOrCreateUnderlyingProvider();
    }

    public void closeFileSystem(FileSystem filesystem) {
        AbstractFileProvider provider = this.getUnderlyingProvider();
        if (provider != null) {
            provider.closeFileSystem(filesystem);
        }
    }

    public boolean tryCloseFileSystem(FileSystem filesystem) {
        AbstractFileProvider provider = this.getUnderlyingProvider();
        if (provider != null) {
            return provider.tryCloseFileSystem(filesystem);
        }
        return true;
    }

    public void freeUnusedResources() {
        AbstractFileProvider provider = this.getUnderlyingProvider();
        if (provider != null) {
            provider.freeUnusedResources();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() {
        Object object = this.monitor;
        synchronized (object) {
            if (this.underlyingProvider != null) {
                this.underlyingProvider.close();
            }
            this.underlyingProvider = null;
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/plugins/webDeployment/connections/SftpFileProviderProxy", "getOrCreateUnderlyingProvider"));
    }
}

