/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ws.actions;

import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.fileTypes.StdFileTypes;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.xml.NanoXmlUtil;
import com.intellij.util.xml.XmlFileHeader;
import com.intellij.ws.actions.CreateRestClientAction;
import com.intellij.ws.rest.client.RESTClient;
import java.io.IOException;
import org.jetbrains.annotations.NotNull;

public class RunRequestAction
extends DumbAwareAction {
    public void actionPerformed(@NotNull AnActionEvent e) {
        if (e == null) {
            RunRequestAction.$$$reportNull$$$0(0);
        }
        Project project = e.getProject();
        VirtualFile vFile = (VirtualFile)e.getData(CommonDataKeys.VIRTUAL_FILE);
        if (project != null && vFile != null) {
            RESTClient client = CreateRestClientAction.openRestClient(project);
            client.importRequest(vFile);
        }
    }

    public void update(@NotNull AnActionEvent e) {
        if (e == null) {
            RunRequestAction.$$$reportNull$$$0(1);
        }
        VirtualFile[] files = (VirtualFile[])e.getData(CommonDataKeys.VIRTUAL_FILE_ARRAY);
        e.getPresentation().setEnabledAndVisible(RunRequestAction.isSingleRestClientRequest(files));
    }

    private static boolean isSingleRestClientRequest(VirtualFile[] files) {
        if (files == null || files.length != 1) {
            return false;
        }
        VirtualFile file = files[0];
        if (file.getFileType() != StdFileTypes.XML) {
            return false;
        }
        try {
            XmlFileHeader header = NanoXmlUtil.parseHeaderWithException((VirtualFile)file);
            return "RestClientRequest".equals(header.getRootTagLocalName());
        }
        catch (IOException e) {
            return false;
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        objectArray2[0] = "e";
        objectArray2[1] = "com/intellij/ws/actions/RunRequestAction";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "actionPerformed";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "update";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

