/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ws.actions;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.ui.ValidationInfo;
import com.intellij.ui.ScrollPaneFactory;
import com.intellij.util.ui.JBUI;
import com.intellij.ws.converters.curl.exceptions.CurlParseException;
import com.intellij.ws.converters.curl.parser.CurlParser;
import com.intellij.ws.rest.client.RestClientBundle;
import java.awt.Component;
import java.awt.Insets;
import javax.swing.JComponent;
import javax.swing.JTextArea;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class HttpClientConvertFromCurlDialog
extends DialogWrapper {
    private final JTextArea myCurlTextArea;

    protected HttpClientConvertFromCurlDialog(@NotNull Project project, @NotNull String initialText) {
        if (project == null) {
            HttpClientConvertFromCurlDialog.$$$reportNull$$$0(0);
        }
        if (initialText == null) {
            HttpClientConvertFromCurlDialog.$$$reportNull$$$0(1);
        }
        super(project);
        this.myCurlTextArea = new JTextArea(initialText, 10, 60);
        this.myCurlTextArea.setMargin((Insets)JBUI.insets((int)2));
        this.setOKButtonText(RestClientBundle.message("http.request.convert.curl.ui.ok.action", new Object[0]));
        this.setTitle(RestClientBundle.message("http.request.convert.curl.ui.title", new Object[0]));
        this.init();
    }

    @Nullable
    public JComponent getPreferredFocusedComponent() {
        return this.myCurlTextArea;
    }

    @NotNull
    protected String getDimensionServiceKey() {
        return "#com.intellij.ws.actions.HttpClientConvertFromCurlDialog";
    }

    @Nullable
    protected JComponent createCenterPanel() {
        return ScrollPaneFactory.createScrollPane((Component)this.myCurlTextArea);
    }

    @NotNull
    public String getCurlText() {
        String string = this.myCurlTextArea.getText().trim();
        if (string == null) {
            HttpClientConvertFromCurlDialog.$$$reportNull$$$0(2);
        }
        return string;
    }

    @Nullable
    protected ValidationInfo doValidate() {
        try {
            new CurlParser().parseToRestClientRequest(this.getCurlText());
            return null;
        }
        catch (CurlParseException e) {
            return new ValidationInfo(e.getMessage());
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "initialText";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/ws/actions/HttpClientConvertFromCurlDialog";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/ws/actions/HttpClientConvertFromCurlDialog";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getCurlText";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

