/*
 * Decompiled with CFR 0.152.
 */
package com.sixrr.inspectjs.validity;

import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.lang.javascript.DialectDetector;
import com.intellij.lang.javascript.DialectOptionHolder;
import com.intellij.lang.javascript.index.JSSymbolUtil;
import com.intellij.lang.javascript.psi.JSAssignmentExpression;
import com.intellij.lang.javascript.psi.JSBlockStatement;
import com.intellij.lang.javascript.psi.JSDefinitionExpression;
import com.intellij.lang.javascript.psi.JSExpression;
import com.intellij.lang.javascript.psi.JSFunction;
import com.intellij.lang.javascript.psi.JSFunctionExpression;
import com.intellij.lang.javascript.psi.JSFunctionProperty;
import com.intellij.lang.javascript.psi.JSNewExpression;
import com.intellij.lang.javascript.psi.JSRecursiveWalkingElementVisitor;
import com.intellij.lang.javascript.psi.JSReferenceExpression;
import com.intellij.lang.javascript.psi.JSReturnStatement;
import com.intellij.lang.javascript.psi.JSStatement;
import com.intellij.lang.javascript.psi.JSType;
import com.intellij.lang.javascript.psi.util.ControlFlowUtils;
import com.intellij.lang.javascript.validation.ValidateTypesUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.util.PsiTreeUtil;
import com.sixrr.inspectjs.BaseInspectionVisitor;
import com.sixrr.inspectjs.InspectionJSBundle;
import com.sixrr.inspectjs.JavaScriptInspection;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FunctionWithInconsistentReturnsJSInspectionBase
extends JavaScriptInspection {
    protected static boolean missingReturnStatementProblem(JSFunction function2) {
        return function2.getReturnType() != null && DialectDetector.isActionScript((PsiElement)function2);
    }

    private static boolean functionHasReturnValues(JSFunction function2) {
        ReturnValuesVisitor visitor = new ReturnValuesVisitor(function2);
        function2.acceptChildren((PsiElementVisitor)visitor);
        return visitor.hasReturnValues();
    }

    private static boolean functionHasValuelessReturns(@NotNull JSFunction function2) {
        if (function2 == null) {
            FunctionWithInconsistentReturnsJSInspectionBase.$$$reportNull$$$0(0);
        }
        if (function2.isGenerator()) {
            return false;
        }
        PsiElement lastChild = function2.getLastChild();
        if (lastChild instanceof JSBlockStatement && ControlFlowUtils.statementMayCompleteNormally((JSStatement)lastChild)) {
            return true;
        }
        ValuelessReturnVisitor visitor = new ValuelessReturnVisitor();
        function2.acceptChildren((PsiElementVisitor)visitor);
        return visitor.hasValuelessReturns();
    }

    public boolean isEnabledByDefault() {
        return true;
    }

    @Override
    @Nullable
    protected String buildErrorString(Object ... args) {
        JSFunction function2 = (JSFunction)PsiTreeUtil.getParentOfType((PsiElement)((PsiElement)args[0]), JSFunction.class);
        assert (function2 != null);
        if (FunctionWithInconsistentReturnsJSInspectionBase.missingReturnStatementProblem(function2)) {
            return InspectionJSBundle.message("missing.return.statement.error.string", new Object[0]);
        }
        if (FunctionWithInconsistentReturnsJSInspectionBase.functionHasIdentifier(function2)) {
            return InspectionJSBundle.message("function.has.inconsistent.return.points.error.string", new Object[0]);
        }
        return InspectionJSBundle.message("anonymous.function.has.inconsistent.return.points.error.string", new Object[0]);
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new Visitor();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "function", "com/sixrr/inspectjs/validity/FunctionWithInconsistentReturnsJSInspectionBase", "functionHasValuelessReturns"));
    }

    private static class ValuelessReturnVisitor
    extends JSRecursiveWalkingElementVisitor {
        private boolean hasValuelessReturns = false;

        ValuelessReturnVisitor() {
        }

        public void visitJSReturnStatement(JSReturnStatement statement) {
            super.visitJSReturnStatement(statement);
            if (statement.getExpression() == null) {
                this.hasValuelessReturns = true;
            }
        }

        public void visitJSFunctionDeclaration(JSFunction function2) {
        }

        public void visitJSFunctionExpression(JSFunctionExpression node) {
        }

        public boolean hasValuelessReturns() {
            return this.hasValuelessReturns;
        }
    }

    private static class ReturnValuesVisitor
    extends JSRecursiveWalkingElementVisitor {
        private final JSFunction function;
        private boolean hasReturnValues = false;

        ReturnValuesVisitor(JSFunction function2) {
            this.function = function2;
        }

        public void visitJSReturnStatement(JSReturnStatement statement) {
            super.visitJSReturnStatement(statement);
            JSExpression expression = statement.getExpression();
            if (expression != null) {
                JSExpression methodExpression;
                if (expression instanceof JSNewExpression && (methodExpression = ((JSNewExpression)expression).getMethodExpression()) instanceof JSReferenceExpression && ((JSReferenceExpression)methodExpression).resolve() == this.function) {
                    return;
                }
                this.hasReturnValues = true;
            }
        }

        public void visitJSFunctionDeclaration(JSFunction function2) {
        }

        public void visitJSFunctionExpression(JSFunctionExpression node) {
        }

        public void visitJSFunctionProperty(JSFunctionProperty functionProperty) {
        }

        public boolean hasReturnValues() {
            return this.hasReturnValues;
        }
    }

    private static class Visitor
    extends BaseInspectionVisitor {
        private Visitor() {
        }

        @Override
        protected ProblemHighlightType getProblemHighlightType(PsiElement location) {
            DialectOptionHolder dialect = DialectDetector.dialectOfElement(location);
            return dialect != null && dialect.isECMA4 ? ProblemHighlightType.GENERIC_ERROR : super.getProblemHighlightType(location);
        }

        @Override
        protected void registerFunctionError(JSFunction function2) {
            JSBlockStatement body;
            if (FunctionWithInconsistentReturnsJSInspectionBase.missingReturnStatementProblem(function2) && (body = function2.getBlock()) != null) {
                this.registerError(Visitor.findValidEditorLocation(body.getLastChild()));
                return;
            }
            super.registerFunctionError(function2);
        }

        public void visitJSFunctionDeclaration(JSFunction function2) {
            if (DialectDetector.isTypeScript((PsiElement)function2)) {
                return;
            }
            super.visitJSFunctionDeclaration(function2);
            if (Visitor.functionHasReturnsErrors(function2)) {
                this.registerFunctionError(function2);
            }
        }

        private static boolean functionHasReturnsErrors(JSFunction function2) {
            JSExpression qualifierQualifier;
            JSReferenceExpression referenceExpression;
            JSExpression qualifier;
            JSExpression expression;
            JSAssignmentExpression assignmentExpression;
            JSExpression lOperand;
            JSType type;
            JSType jSType = type = function2.hasExplicitlyDeclaredReturnType() ? function2.getReturnType() : null;
            if (type == null && !FunctionWithInconsistentReturnsJSInspectionBase.functionHasReturnValues(function2)) {
                return false;
            }
            if (type != null && ValidateTypesUtil.emptyReturnIsAcceptable(function2, type) || !FunctionWithInconsistentReturnsJSInspectionBase.functionHasValuelessReturns(function2)) {
                return false;
            }
            PsiElement parent = function2.getParent();
            return !(parent instanceof JSAssignmentExpression) || !((lOperand = (assignmentExpression = (JSAssignmentExpression)parent).getLOperand()) instanceof JSDefinitionExpression) || !((expression = ((JSDefinitionExpression)lOperand).getExpression()) instanceof JSReferenceExpression) || !((qualifier = (referenceExpression = (JSReferenceExpression)expression).getQualifier()) instanceof JSReferenceExpression) || !"prototype".equals(((JSReferenceExpression)qualifier).getReferencedName()) || !((qualifierQualifier = ((JSReferenceExpression)qualifier).getQualifier()) instanceof JSReferenceExpression) || !JSSymbolUtil.referencesInterface((JSReferenceExpression)qualifierQualifier);
        }

        public void visitJSFunctionExpression(JSFunctionExpression node) {
            super.visitJSFunctionExpression(node);
            if (Visitor.functionHasReturnsErrors((JSFunction)node)) {
                this.registerFunctionError((JSFunction)node);
            }
        }
    }
}

