/*
 * Decompiled with CFR 0.152.
 */
package com.sixrr.inspectjs.naming;

import com.intellij.lang.javascript.documentation.JSDocumentationUtils;
import com.intellij.lang.javascript.highlighting.JSFixFactory;
import com.intellij.lang.javascript.psi.JSFunction;
import com.intellij.lang.javascript.psi.ecmal4.JSClass;
import com.intellij.lang.javascript.psi.jsdoc.JSDocComment;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiNameIdentifierOwner;
import com.intellij.psi.util.PsiTreeUtil;
import com.sixrr.inspectjs.BaseInspectionVisitor;
import com.sixrr.inspectjs.InspectionJSBundle;
import com.sixrr.inspectjs.InspectionJSFix;
import com.sixrr.inspectjs.naming.ConventionInspection;
import org.jetbrains.annotations.NotNull;

public class JSClassNamingConventionInspection
extends ConventionInspection {
    @Override
    protected String getDefaultRegex() {
        return "[A-Z][a-zA-Z]*";
    }

    @Override
    protected int getDefaultMinLength() {
        return 4;
    }

    @Override
    protected int getDefaultMaxLength() {
        return 32;
    }

    @Override
    protected InspectionJSFix buildFix(PsiElement location) {
        return JSFixFactory.getInstance().renameFix();
    }

    @Override
    protected boolean buildQuickFixesOnlyForOnTheFlyErrors() {
        return true;
    }

    @Override
    public String buildErrorString(Object ... args) {
        boolean isClass = PsiTreeUtil.getParentOfType((PsiElement)((PsiElement)args[0]), (Class[])new Class[]{JSClass.class, JSFunction.class}) instanceof JSClass;
        String name = ((PsiElement)args[0]).getText();
        assert (name != null);
        if (name.length() < this.getMinLength()) {
            return InspectionJSBundle.message(isClass ? "class.name.is.too.short.error.string" : "constructor.name.is.too.short.error.string", name);
        }
        if (name.length() > this.getMaxLength()) {
            return InspectionJSBundle.message(isClass ? "class.name.is.too.long.error.string" : "constructor.name.is.too.long.error.string", name);
        }
        return InspectionJSBundle.message(isClass ? "class.name.doesnt.match.regex.error.string" : "constructor.name.doesnt.match.regex.error.string", name, this.getRegex());
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new Visitor();
    }

    private class Visitor
    extends BaseInspectionVisitor {
        private Visitor() {
        }

        public void visitJSFunctionDeclaration(@NotNull JSFunction function2) {
            JSDocComment docComment;
            if (function2 == null) {
                Visitor.$$$reportNull$$$0(0);
            }
            super.visitJSFunctionDeclaration(function2);
            if (JSClassNamingConventionInspection.this.isInvalidName((PsiNameIdentifierOwner)function2) && (docComment = JSDocumentationUtils.findOwnDocComment((PsiElement)function2)) != null && docComment.isClassExplicitly()) {
                this.registerFunctionError(function2);
            }
        }

        public void visitJSClass(JSClass aClass) {
            super.visitJSClass(aClass);
            if (JSClassNamingConventionInspection.this.isInvalidName((PsiNameIdentifierOwner)aClass)) {
                this.registerError(aClass.getNameIdentifier());
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "function", "com/sixrr/inspectjs/naming/JSClassNamingConventionInspection$Visitor", "visitJSFunctionDeclaration"));
        }
    }
}

