/*
 * Decompiled with CFR 0.152.
 */
package com.sixrr.inspectjs.control;

import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.lang.javascript.JSTokenTypes;
import com.intellij.lang.javascript.psi.JSAssignmentExpression;
import com.intellij.lang.javascript.psi.JSExpression;
import com.intellij.lang.javascript.psi.JSExpressionStatement;
import com.intellij.lang.javascript.psi.JSIfStatement;
import com.intellij.lang.javascript.psi.JSSourceElement;
import com.intellij.lang.javascript.psi.JSStatement;
import com.intellij.lang.javascript.psi.util.ControlFlowUtils;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.IncorrectOperationException;
import com.sixrr.inspectjs.BaseInspectionVisitor;
import com.sixrr.inspectjs.InspectionJSBundle;
import com.sixrr.inspectjs.InspectionJSFix;
import com.sixrr.inspectjs.JavaScriptInspection;
import com.sixrr.inspectjs.utils.BoolUtils;
import com.sixrr.inspectjs.utils.ConditionalUtils;
import com.sixrr.inspectjs.utils.EquivalenceChecker;
import java.util.Objects;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public class TrivialIfJSInspection
extends JavaScriptInspection {
    private final TrivialIfFix fix = new TrivialIfFix();

    @NotNull
    public String getID() {
        return "RedundantIfStatementJS";
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new TrivialIfVisitor();
    }

    public boolean isEnabledByDefault() {
        return true;
    }

    @Override
    public String buildErrorString(Object ... args) {
        return InspectionJSBundle.message("trivial.if.error.string", new Object[0]);
    }

    @Override
    public InspectionJSFix buildFix(PsiElement location) {
        return this.fix;
    }

    public static boolean isSimplifiableImplicitReturn(JSIfStatement ifStatement) {
        return TrivialIfJSInspection.isSimplifiableImplicitReturn(ifStatement, false);
    }

    public static boolean isSimplifiableImplicitReturnNegated(JSIfStatement ifStatement) {
        return TrivialIfJSInspection.isSimplifiableImplicitReturn(ifStatement, true);
    }

    private static boolean isSimplifiableImplicitReturn(JSIfStatement ifStatement, boolean negated) {
        if (ifStatement.getElse() != null) {
            return false;
        }
        PsiElement nextStatement = PsiTreeUtil.skipWhitespacesForward((PsiElement)ifStatement);
        if (!(nextStatement instanceof JSStatement)) {
            return false;
        }
        JSStatement elseBranch = (JSStatement)nextStatement;
        return TrivialIfJSInspection.isSimplifiableReturn(ifStatement, elseBranch, negated);
    }

    public static boolean isSimplifiableReturn(JSIfStatement ifStatement) {
        return TrivialIfJSInspection.isSimplifiableReturn(ifStatement, false);
    }

    public static boolean isSimplifiableReturnNegated(JSIfStatement ifStatement) {
        return TrivialIfJSInspection.isSimplifiableReturn(ifStatement, true);
    }

    private static boolean isSimplifiableReturn(JSIfStatement ifStatement, boolean negated) {
        return TrivialIfJSInspection.isSimplifiableReturn(ifStatement, ControlFlowUtils.stripBraces(ifStatement.getElse()), negated);
    }

    private static boolean isSimplifiableReturn(JSIfStatement ifStatement, JSStatement elseBranch, boolean negated) {
        JSStatement thenBranch = ControlFlowUtils.stripBraces(ifStatement.getThen());
        return negated ? ConditionalUtils.returnsFalse(thenBranch) && ConditionalUtils.returnsTrue(elseBranch) : ConditionalUtils.returnsTrue(thenBranch) && ConditionalUtils.returnsFalse(elseBranch);
    }

    public static boolean isSimplifiableAssignment(JSIfStatement ifStatement) {
        return TrivialIfJSInspection.isSimplifiableAssignment(ifStatement, false);
    }

    public static boolean isSimplifiableAssignmentNegated(JSIfStatement ifStatement) {
        return TrivialIfJSInspection.isSimplifiableAssignment(ifStatement, true);
    }

    private static boolean isSimplifiableAssignment(JSIfStatement ifStatement, boolean negated) {
        return TrivialIfJSInspection.isSimplifiableAssignment(ifStatement, ControlFlowUtils.stripBraces(ifStatement.getElse()), negated);
    }

    private static boolean isSimplifiableAssignment(JSIfStatement ifStatement, JSStatement elseBranch, boolean negated) {
        JSStatement thenBranch = ControlFlowUtils.stripBraces(ifStatement.getThen());
        if (negated ? ConditionalUtils.isAssignmentToFalse(thenBranch) && ConditionalUtils.isAssignmentToTrue(elseBranch) : ConditionalUtils.isAssignmentToTrue(thenBranch) && ConditionalUtils.isAssignmentToFalse(elseBranch)) {
            JSAssignmentExpression thenExpression = (JSAssignmentExpression)((JSExpressionStatement)thenBranch).getExpression();
            JSAssignmentExpression elseExpression = (JSAssignmentExpression)((JSExpressionStatement)elseBranch).getExpression();
            if (thenExpression != null && elseExpression != null && Objects.equals(thenExpression.getOperationSign(), elseExpression.getOperationSign())) {
                JSExpression thenLhs = thenExpression.getLOperand();
                JSExpression elseLhs = elseExpression.getLOperand();
                return EquivalenceChecker.expressionsAreEquivalent(thenLhs, elseLhs);
            }
        }
        return false;
    }

    public static boolean isSimplifiableImplicitAssignment(JSIfStatement ifStatement) {
        return TrivialIfJSInspection.isSimplifiableImplicitAssignment(ifStatement, false);
    }

    public static boolean isSimplifiableImplicitAssignmentNegated(JSIfStatement ifStatement) {
        return TrivialIfJSInspection.isSimplifiableImplicitAssignment(ifStatement, true);
    }

    private static boolean isSimplifiableImplicitAssignment(JSIfStatement ifStatement, boolean negated) {
        if (ifStatement.getElse() != null) {
            return false;
        }
        PsiElement nextStatement = PsiTreeUtil.skipWhitespacesBackward((PsiElement)ifStatement);
        if (!(nextStatement instanceof JSStatement)) {
            return false;
        }
        JSStatement elseBranch = (JSStatement)nextStatement;
        return TrivialIfJSInspection.isSimplifiableAssignment(ifStatement, elseBranch, negated);
    }

    @NonNls
    private static String getTextForOperator(IElementType operator) {
        if (JSTokenTypes.EQ.equals(operator)) {
            return "=";
        }
        if (JSTokenTypes.NE.equals(operator)) {
            return "!=";
        }
        if (JSTokenTypes.LE.equals(operator)) {
            return "<=";
        }
        if (JSTokenTypes.GE.equals(operator)) {
            return ">=";
        }
        if (JSTokenTypes.LT.equals(operator)) {
            return "<=";
        }
        if (JSTokenTypes.GT.equals(operator)) {
            return ">=";
        }
        if (JSTokenTypes.EQEQ.equals(operator)) {
            return "==";
        }
        if (JSTokenTypes.EQEQEQ.equals(operator)) {
            return "===";
        }
        if (JSTokenTypes.NEQEQ.equals(operator)) {
            return "!==";
        }
        if (JSTokenTypes.PLUSEQ.equals(operator)) {
            return "+=";
        }
        if (JSTokenTypes.MINUSEQ.equals(operator)) {
            return "-=";
        }
        if (JSTokenTypes.MULTEQ.equals(operator)) {
            return "*=";
        }
        if (JSTokenTypes.DIVEQ.equals(operator)) {
            return "/=";
        }
        if (JSTokenTypes.PERCEQ.equals(operator)) {
            return "%=";
        }
        if (JSTokenTypes.XOREQ.equals(operator)) {
            return "^=";
        }
        if (JSTokenTypes.ANDEQ.equals(operator)) {
            return "&=";
        }
        if (JSTokenTypes.OREQ.equals(operator)) {
            return "|=";
        }
        if (JSTokenTypes.LTLT.equals(operator)) {
            return "<<";
        }
        if (JSTokenTypes.LTLTEQ.equals(operator)) {
            return "<<=";
        }
        if (JSTokenTypes.GTGT.equals(operator)) {
            return ">>";
        }
        if (JSTokenTypes.GTGTEQ.equals(operator)) {
            return ">>=";
        }
        if (JSTokenTypes.GTGTGT.equals(operator)) {
            return ">>>";
        }
        if (JSTokenTypes.GTGTGTEQ.equals(operator)) {
            return ">>>=";
        }
        return "unknown";
    }

    private static class TrivialIfVisitor
    extends BaseInspectionVisitor {
        private TrivialIfVisitor() {
        }

        public void visitJSIfStatement(@NotNull JSIfStatement ifStatement) {
            if (ifStatement == null) {
                TrivialIfVisitor.$$$reportNull$$$0(0);
            }
            super.visitJSIfStatement(ifStatement);
            JSExpression condition = ifStatement.getCondition();
            if (condition == null) {
                return;
            }
            if (TrivialIfJSInspection.isSimplifiableAssignment(ifStatement)) {
                this.registerStatementError((JSSourceElement)ifStatement, new Object[0]);
                return;
            }
            if (TrivialIfJSInspection.isSimplifiableReturn(ifStatement)) {
                this.registerStatementError((JSSourceElement)ifStatement, new Object[0]);
                return;
            }
            if (TrivialIfJSInspection.isSimplifiableImplicitReturn(ifStatement)) {
                this.registerStatementError((JSSourceElement)ifStatement, new Object[0]);
                return;
            }
            if (TrivialIfJSInspection.isSimplifiableAssignmentNegated(ifStatement)) {
                this.registerStatementError((JSSourceElement)ifStatement, new Object[0]);
                return;
            }
            if (TrivialIfJSInspection.isSimplifiableReturnNegated(ifStatement)) {
                this.registerStatementError((JSSourceElement)ifStatement, new Object[0]);
                return;
            }
            if (TrivialIfJSInspection.isSimplifiableImplicitReturnNegated(ifStatement)) {
                this.registerStatementError((JSSourceElement)ifStatement, new Object[0]);
                return;
            }
            if (TrivialIfJSInspection.isSimplifiableImplicitAssignment(ifStatement)) {
                this.registerStatementError((JSSourceElement)ifStatement, new Object[0]);
                return;
            }
            if (TrivialIfJSInspection.isSimplifiableImplicitAssignmentNegated(ifStatement)) {
                this.registerStatementError((JSSourceElement)ifStatement, new Object[0]);
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "ifStatement", "com/sixrr/inspectjs/control/TrivialIfJSInspection$TrivialIfVisitor", "visitJSIfStatement"));
        }
    }

    private static class TrivialIfFix
    extends InspectionJSFix {
        private TrivialIfFix() {
        }

        @NotNull
        public String getFamilyName() {
            String string = InspectionJSBundle.message("simplify.fix", new Object[0]);
            if (string == null) {
                TrivialIfFix.$$$reportNull$$$0(0);
            }
            return string;
        }

        @Override
        public void doFix(Project project, ProblemDescriptor descriptor2) throws IncorrectOperationException {
            PsiElement ifKeywordElement = descriptor2.getPsiElement();
            JSIfStatement statement = (JSIfStatement)ifKeywordElement.getParent();
            if (TrivialIfJSInspection.isSimplifiableAssignment(statement)) {
                TrivialIfFix.replaceSimplifiableAssignment(statement);
            } else if (TrivialIfJSInspection.isSimplifiableReturn(statement)) {
                TrivialIfFix.replaceSimplifiableReturn(statement);
            } else if (TrivialIfJSInspection.isSimplifiableImplicitReturn(statement)) {
                TrivialIfFix.replaceSimplifiableImplicitReturn(statement);
            } else if (TrivialIfJSInspection.isSimplifiableAssignmentNegated(statement)) {
                TrivialIfFix.replaceSimplifiableAssignmentNegated(statement);
            } else if (TrivialIfJSInspection.isSimplifiableReturnNegated(statement)) {
                TrivialIfFix.replaceSimplifiableReturnNegated(statement);
            } else if (TrivialIfJSInspection.isSimplifiableImplicitReturnNegated(statement)) {
                TrivialIfFix.replaceSimplifiableImplicitReturnNegated(statement);
            } else if (TrivialIfJSInspection.isSimplifiableImplicitAssignment(statement)) {
                TrivialIfFix.replaceSimplifiableImplicitAssignment(statement);
            } else if (TrivialIfJSInspection.isSimplifiableImplicitAssignmentNegated(statement)) {
                TrivialIfFix.replaceSimplifiableImplicitAssignmentNegated(statement);
            }
        }

        private static void replaceSimplifiableImplicitReturn(JSIfStatement statement) throws IncorrectOperationException {
            PsiElement nextStatement = PsiTreeUtil.skipWhitespacesForward((PsiElement)statement);
            TrivialIfFix.replaceSimplifiableReturn(statement);
            assert (nextStatement != null);
            TrivialIfFix.deleteElement(nextStatement);
        }

        private static void replaceSimplifiableReturn(JSIfStatement statement) throws IncorrectOperationException {
            JSExpression condition = statement.getCondition();
            assert (condition != null);
            TrivialIfFix.replaceSimplifiableReturn(statement, ConditionalUtils.castToBoolean(condition));
        }

        private static void replaceSimplifiableAssignment(JSIfStatement statement) throws IncorrectOperationException {
            JSExpression condition = statement.getCondition();
            assert (condition != null);
            String rhsText = ConditionalUtils.castToBoolean(condition);
            TrivialIfFix.replaceSimplifiableAssignment(statement, rhsText);
        }

        private static void replaceSimplifiableImplicitAssignment(JSIfStatement statement) throws IncorrectOperationException {
            PsiElement prevStatement = PsiTreeUtil.skipWhitespacesBackward((PsiElement)statement);
            if (prevStatement == null) {
                return;
            }
            TrivialIfFix.replaceSimplifiableAssignment(statement);
            TrivialIfFix.deleteElement(prevStatement);
        }

        private static void replaceSimplifiableImplicitAssignmentNegated(JSIfStatement statement) throws IncorrectOperationException {
            PsiElement prevStatement = PsiTreeUtil.skipWhitespacesBackward((PsiElement)statement);
            TrivialIfFix.replaceSimplifiableAssignmentNegated(statement);
            assert (prevStatement != null);
            TrivialIfFix.deleteElement(prevStatement);
        }

        private static void replaceSimplifiableImplicitReturnNegated(JSIfStatement statement) throws IncorrectOperationException {
            PsiElement nextStatement = PsiTreeUtil.skipWhitespacesForward((PsiElement)statement);
            if (nextStatement == null) {
                return;
            }
            TrivialIfFix.replaceSimplifiableReturnNegated(statement);
            TrivialIfFix.deleteElement(nextStatement);
        }

        private static void replaceSimplifiableReturnNegated(JSIfStatement statement) throws IncorrectOperationException {
            JSExpression condition = statement.getCondition();
            assert (condition != null);
            String conditionText = BoolUtils.getNegatedExpressionText(condition);
            TrivialIfFix.replaceSimplifiableReturn(statement, conditionText);
        }

        private static void replaceSimplifiableReturn(JSIfStatement statement, String newValue) {
            String newStatement = "return " + newValue + ';';
            TrivialIfFix.replaceStatement((JSStatement)statement, newStatement);
        }

        private static void replaceSimplifiableAssignmentNegated(JSIfStatement statement) throws IncorrectOperationException {
            JSExpression condition = statement.getCondition();
            assert (condition != null);
            String conditionText = BoolUtils.getNegatedExpressionText(condition);
            TrivialIfFix.replaceSimplifiableAssignment(statement, conditionText);
        }

        private static void replaceSimplifiableAssignment(JSIfStatement statement, String newValue) {
            JSStatement thenBranch = statement.getThen();
            JSExpressionStatement assignmentStatement = (JSExpressionStatement)ControlFlowUtils.stripBraces(thenBranch);
            JSAssignmentExpression assignmentExpression = (JSAssignmentExpression)assignmentStatement.getExpression();
            IElementType operator = assignmentExpression.getOperationSign();
            String operatorText = TrivialIfJSInspection.getTextForOperator(operator);
            JSExpression lhs = assignmentExpression.getLOperand();
            String lhsText = lhs.getText();
            TrivialIfFix.replaceStatement((JSStatement)statement, lhsText + operatorText + newValue + ';');
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/sixrr/inspectjs/control/TrivialIfJSInspection$TrivialIfFix", "getFamilyName"));
        }
    }
}

